/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.mob;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.spell.SpellType;

public class EntityArrowMagic
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public float ATK = 0.0f;
    public ManaElements Elements = ManaElements.Magic;
    public WeaponType weapon = WeaponType.Magic;
    public SpellType spelltype = SpellType.Puncture;
    public int time = 0;
    public int type = 0;
    public float size = 1.0f;
    public Entity aimedTo;
    public boolean eventFX = false;
    public boolean isMagic = false;
    public int data1 = 0;
    public int data2 = 0;
    public int data3 = 0;
    public int hitType = 0;

    public EntityArrowMagic(World par1World) {
        super(par1World);
    }

    public EntityArrowMagic(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public EntityArrowMagic(World par1World, EntityLivingBase player, float atk, ManaElements elements, Entity aimed, boolean eventFX) {
        super(par1World, player);
        this.ATK = atk;
        this.Elements = elements;
        this.aimedTo = aimed;
        if (!par1World.field_72995_K) {
            this.type = par1World.field_73012_v.nextInt(3);
        }
        this.eventFX = eventFX;
    }

    public EntityArrowMagic setMagic() {
        this.isMagic = true;
        return this;
    }

    public float getBallSize() {
        return this.size;
    }

    public ManaElements GetElements() {
        return this.Elements;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.time;
        if (this.time > 199) {
            this.func_70106_y();
        }
        if (this.aimedTo != null && this.aimedTo.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            FXHelp.spawnParticle(this.field_70170_p, Particle.shining, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.aimedTo != null) {
            double x = this.aimedTo.field_70165_t - this.field_70165_t;
            double y = this.aimedTo.field_70163_u + (double)this.aimedTo.field_70131_O - 0.4 - this.field_70163_u;
            double z = this.aimedTo.field_70161_v - this.field_70161_v;
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            v = v.func_72432_b();
            double xM = v.field_72450_a;
            double yM = v.field_72448_b;
            double zM = v.field_72449_c;
            float desp = 0.1f;
            this.field_70159_w += xM * (double)desp;
            this.field_70181_x += yM * (double)desp;
            this.field_70179_y += zM * (double)desp;
            this.field_70181_x = yM > 0.0 ? Math.min(this.field_70181_x, yM * (double)desp) : Math.max(this.field_70181_x, yM * (double)(desp *= 40.0f));
            this.field_70159_w = xM > 0.0 ? Math.min(this.field_70159_w, xM * (double)desp) : Math.max(this.field_70159_w, xM * (double)desp);
            this.field_70179_y = zM > 0.0 ? Math.min(this.field_70179_y, zM * (double)desp) : Math.max(this.field_70179_y, zM * (double)desp);
        }
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public void func_70091_d(double p_70091_1_, double p_70091_3_, double p_70091_5_) {
        super.func_70091_d(p_70091_1_, p_70091_3_, p_70091_5_);
    }

    public void hit(EntityLivingBase entity) {
        switch (this.hitType) {
            case 1: {
                PotionEffectM3.addPotion(entity, PotionM3.potionMagicArrow, this.data1, 0);
                break;
            }
            case 3: {
                entity.func_70097_a((DamageSource)AttackType.getDamage((Entity)this.func_85052_h(), this.Elements, this.spelltype, this.weapon, this.eventFX, this.eventFX), this.ATK);
            }
        }
    }

    public void func_70184_a(MovingObjectPosition Target2) {
        if (Target2.field_72308_g != null && Target2.field_72308_g instanceof EntityLivingBase) {
            Target2.field_72308_g.func_70097_a((DamageSource)AttackType.getDamage((Entity)this.func_85052_h(), this.Elements, this.spelltype, this.weapon, this.eventFX, this.eventFX), this.ATK);
            this.hit((EntityLivingBase)Target2.field_72308_g);
        }
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("ManaElements", ManaElements.getElementsName(this.Elements));
        tag.func_74776_a("ElementsATK", this.ATK);
        tag.func_74776_a("BallSize", this.size);
        tag.func_74776_a("BallType", (float)this.type);
        tag.func_74776_a("BallTime", (float)this.time);
        super.func_70014_b(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.Elements = ManaElements.getElementsFromString(tag.func_74779_i("ManaElements"));
        this.ATK = tag.func_74760_g("ElementsATK");
        this.type = tag.func_74762_e("BallType");
        this.size = tag.func_74760_g("BallSize");
        this.time = tag.func_74762_e("BallTime");
        super.func_70037_a(tag);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.Elements != null ? ManaElements.getElementsID(this.Elements) : 0);
        data.writeFloat(this.size);
        data.writeShort(this.type);
    }

    public void readSpawnData(ByteBuf data) {
        this.Elements = ManaElements.getElementsFromID(data.readInt());
        this.size = data.readFloat();
        this.type = data.readShort();
    }
}

