/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.client.ClientPacketHandle;

public class MessageCommandPlayerData
implements IMessage,
IMessageHandler<MessageCommandPlayerData, IMessage> {
    public int ID;
    public NBTTagCompound tag;
    public String name;
    public boolean sendItems = false;
    public ItemStack[] items;

    public MessageCommandPlayerData() {
    }

    public MessageCommandPlayerData(int ID, NBTTagCompound tag, String name) {
        this.ID = ID;
        this.tag = tag;
        this.name = name;
    }

    public MessageCommandPlayerData(int ID, NBTTagCompound tag, String name, boolean sendItems, ItemStack ... items) {
        this.ID = ID;
        this.tag = tag;
        this.name = name;
        this.sendItems = sendItems;
        this.items = items;
    }

    public IMessage onMessage(MessageCommandPlayerData message, MessageContext ctx) {
        ClientPacketHandle.accept(message);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.ID = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.sendItems = buf.readBoolean();
        if (this.sendItems) {
            int size = buf.readInt();
            this.items = new ItemStack[size];
            for (int s = 0; s < size; ++s) {
                this.items[s] = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeBoolean(this.sendItems);
        if (this.sendItems && this.items != null) {
            buf.writeInt(this.items.length);
            for (int s = 0; s < this.items.length; ++s) {
                if (this.items[s] != null) {
                    ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.items[s]);
                    continue;
                }
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)new ItemStack(Items.field_151034_e));
            }
        }
    }
}

