/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.Icommodity;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.festival.FestivalCore;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft2;
import project.studio.manametalmod.items.ItemCoinSpecial;
import project.studio.manametalmod.mob.hell.MobPiglin;
import project.studio.manametalmod.npc.EntityNpc;
import project.studio.manametalmod.npc.NpcStoreType;
import project.studio.manametalmod.rpg.BossStore;
import project.studio.manametalmod.trade.TradeType;

public class MessageNpcBuy
implements IMessage,
IMessageHandler<MessageNpcBuy, IMessage> {
    private int butIndex;
    private int buyCount;
    private int type;
    private int targetID;

    public MessageNpcBuy() {
    }

    public MessageNpcBuy(int butIndex, int buyCount, TradeType type, int targetID) {
        this.butIndex = butIndex;
        this.buyCount = buyCount;
        this.type = type.ordinal();
        this.targetID = targetID;
    }

    public IMessage onMessage(MessageNpcBuy message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (M3Config.StoreCheckInventory && !MMM.InventoryPlayerHasSpace((EntityPlayer)player)) {
            MMM.addMessage((EntityPlayer)player, "MMM.inventoryisfull");
            return null;
        }
        ManaMetalModRoot root = MMM.getEntityNBT((EntityPlayer)player);
        if (message.butIndex > -1 && message.buyCount > 0) {
            switch (TradeType.values()[message.type]) {
                case NPCStore: {
                    this.handleNPCStore(player, root, message);
                    break;
                }
                case MoonStore: {
                    this.handleItemStore(player, root, message, FestivalCore.Items_Moon, FestivalCore.itemMoon);
                    break;
                }
                case NewYearStore: {
                    this.handleItemStore(player, root, message, FestivalCore.Items_Year, FestivalCore.itemIngots);
                    break;
                }
                case BOSSStore1: {
                    this.handleCoinStore(player, root, message, BossStore.Items1, ItemCoinSpecial.CoinTypes.Boss, false);
                    break;
                }
                case BOSSStore2: {
                    this.handleCoinStore(player, root, message, BossStore.Items2, ItemCoinSpecial.CoinTypes.Boss, false);
                    break;
                }
                case CardStore: {
                    this.handleCardStore(player, root, message, ManaMetalAPI.CardStoreList);
                    break;
                }
                case PiggStore: {
                    this.handlePiggStore(player, root, message);
                    break;
                }
                case MiningStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Mine_Store, ItemCoinSpecial.CoinTypes.Mine, true);
                    break;
                }
                case FarmerStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Farm_Store, ItemCoinSpecial.CoinTypes.Farm, true);
                    break;
                }
                case FishingStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Fish_Store, ItemCoinSpecial.CoinTypes.Fish, true);
                    break;
                }
                case BeekeepingStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Beekeeping_Store, ItemCoinSpecial.CoinTypes.Bee, true);
                    break;
                }
                case DragonStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Dragon_Store, ItemCoinSpecial.CoinTypes.Tree, true);
                    break;
                }
                case BrewingStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.brewing_Store, ItemCoinSpecial.CoinTypes.Potion, true);
                    break;
                }
                case CastingStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Forge_Store, ItemCoinSpecial.CoinTypes.Forging, true);
                    break;
                }
                case CookingStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Cooking_Store, ItemCoinSpecial.CoinTypes.Cooking, true);
                    break;
                }
                case GemCraftStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Gem_Store, ItemCoinSpecial.CoinTypes.Gem, true);
                    break;
                }
                case TailorStore: {
                    this.handleCoinStore(player, root, message, ManaMetalAPI.Textile_Store, ItemCoinSpecial.CoinTypes.Tailor, true);
                }
            }
        }
        return null;
    }

    public void handlePiggStore(EntityPlayerMP player, ManaMetalModRoot root, MessageNpcBuy message) {
        Entity entity = player.field_70170_p.func_73045_a(message.targetID);
        if (entity != null && MMM.isEntityInDistanceDimension((Entity)player, entity, 10) && entity instanceof MobPiglin) {
            int s;
            ArrayList<Icommodity> StoreItemsList = new ArrayList<Icommodity>(9);
            Random rand = new Random();
            rand.setSeed(((MobPiglin)entity).storeSeed);
            List<Icommodity> listold = MobPiglin.StoreItemsList;
            int oldsize = listold.size();
            int[] num = new int[5];
            int[] datas = new int[]{oldsize - 1, oldsize - 2, oldsize - 3, oldsize - 4, oldsize};
            for (s = 0; s < num.length; ++s) {
                int target;
                num[s] = target = rand.nextInt(datas[s]);
            }
            for (s = 0; s < num.length; ++s) {
                StoreItemsList.add(listold.get(num[s]));
            }
            if (message.butIndex < StoreItemsList.size()) {
                Icommodity need = (Icommodity)StoreItemsList.get(message.butIndex);
                int money = MMM.testPlayerItemsCountNoNBT((EntityPlayer)player, MMM.item(Items.field_151043_k));
                int usemoneys = need.getPrice() * message.buyCount;
                if (usemoneys > -1 && money >= usemoneys) {
                    MMM.clearItemsCountNoNBT(MMM.item(Items.field_151043_k), usemoneys, (EntityPlayer)player);
                    for (int s2 = 0; s2 < message.buyCount; ++s2) {
                        ItemStack stack = need.getItem().func_77946_l();
                        if (player.field_71071_by.func_70441_a(stack)) continue;
                        MMM.spawnItemToPlayer(stack, (EntityPlayer)player);
                    }
                }
            }
        }
    }

    public void handleCardStore(EntityPlayerMP player, ManaMetalModRoot root, MessageNpcBuy message, List<Icommodity> list) {
        if (message.butIndex < list.size()) {
            Icommodity need = list.get(message.butIndex);
            int money = root.battleCard.cardPoint;
            int usemoneys = need.getPrice() * message.buyCount;
            if (usemoneys > -1 && money >= usemoneys) {
                root.battleCard.addCardPoint(-usemoneys);
                for (int s = 0; s < message.buyCount; ++s) {
                    ItemStack stack = need.getItem().func_77946_l();
                    if (player.field_71071_by.func_70441_a(stack)) continue;
                    MMM.spawnItemToPlayer(stack, (EntityPlayer)player);
                }
            }
        }
    }

    public void handleItemStore(EntityPlayerMP player, ManaMetalModRoot root, MessageNpcBuy message, List<Icommodity> list, Object needitem) {
        if (message.butIndex < list.size()) {
            Icommodity need = list.get(message.butIndex);
            int money = MMM.testPlayerItemsCountNoNBT((EntityPlayer)player, MMM.item(needitem));
            int usemoneys = need.getPrice() * message.buyCount;
            if (usemoneys > -1 && money >= usemoneys) {
                MMM.clearItemsCountNoNBT(MMM.item(needitem), usemoneys, (EntityPlayer)player);
                for (int s = 0; s < message.buyCount; ++s) {
                    ItemStack stack = need.getItem().func_77946_l();
                    if (player.field_71071_by.func_70441_a(stack)) continue;
                    MMM.spawnItemToPlayer(stack, (EntityPlayer)player);
                }
            }
        }
    }

    public void handleCoinStore(EntityPlayerMP player, ManaMetalModRoot root, MessageNpcBuy message, List<Icommodity> list, ItemCoinSpecial.CoinTypes type, boolean canDiscount) {
        Icommodity need;
        int usemoneys;
        if (message.butIndex < list.size() && (usemoneys = (need = list.get(message.butIndex)).getPrice() * message.buyCount) > -1) {
            if (canDiscount && player.field_71071_by.func_146028_b(ItemCraft2.ProductionDiscount)) {
                usemoneys = (int)((float)usemoneys * 0.9f);
            }
            if (root.money.getMoneySpecial(type) >= usemoneys) {
                root.money.addMoneySpecial(-usemoneys, type);
                for (int s = 0; s < message.buyCount; ++s) {
                    ItemStack stack = need.getItem().func_77946_l();
                    if (player.field_71071_by.func_70441_a(stack)) continue;
                    MMM.spawnItemToPlayer(stack, (EntityPlayer)player);
                }
                player.field_71071_by.func_146026_a(ItemCraft2.ProductionDiscount);
            }
        }
    }

    public void handleNPCStore(EntityPlayerMP player, ManaMetalModRoot root, MessageNpcBuy message) {
        Entity entity = player.field_70170_p.func_73045_a(message.targetID);
        if (entity != null && MMM.isEntityInDistanceDimension((Entity)player, entity, 10) && entity instanceof EntityNpc) {
            Icommodity need;
            int usemoneys;
            ManaMetalModRoot rootnpc = MMM.getEntityNBT(entity);
            List<Icommodity> list = null;
            if (rootnpc.NPCData.custom_store) {
                list = rootnpc.NPCData.storesList;
            } else {
                Random rand = new Random();
                rand.setSeed(rootnpc.NPCData.store_seedV2);
                list = NpcStoreType.getItems(rootnpc.NPCData.type, rand);
            }
            if (list != null && message.butIndex < list.size() && (usemoneys = (need = list.get(message.butIndex)).getPrice() * message.buyCount) > -1) {
                if (player.field_71071_by.func_146028_b(ItemCraft2.NPCDiscount)) {
                    usemoneys = (int)((float)usemoneys * 0.9f);
                }
                if (root.money.getMoney() >= (long)usemoneys) {
                    root.money.addMoney(-usemoneys, MoneySourceType.BuyNPC);
                    for (int s = 0; s < message.buyCount; ++s) {
                        ItemStack stack = need.getItem().func_77946_l();
                        if (player.field_71071_by.func_70441_a(stack)) continue;
                        MMM.spawnItemToPlayer(stack, (EntityPlayer)player);
                    }
                    player.field_71071_by.func_146026_a(ItemCraft2.NPCDiscount);
                }
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.butIndex = buf.readInt();
        this.buyCount = buf.readInt();
        this.type = buf.readInt();
        this.targetID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.butIndex);
        buf.writeInt(this.buyCount);
        buf.writeInt(this.type);
        buf.writeInt(this.targetID);
    }
}

