/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.npc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.core.Icommodity;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.npc.IChat;
import project.studio.manametalmod.npc.NpcBattleCardLV;
import project.studio.manametalmod.npc.NpcFavorability;
import project.studio.manametalmod.npc.NpcGender;
import project.studio.manametalmod.npc.NpcRace;
import project.studio.manametalmod.npc.NpcStoreType;

public class NpcSuite {
    public List<IChat> npcChats;
    public List<Icommodity> storesList;
    public NpcGender gender;
    public NpcFavorability favorability;
    public int npcTexture;
    public String npcName;
    public NpcRace race;
    public NpcStoreType type;
    public NpcBattleCardLV cardLV;

    public NpcSuite(List<IChat> npcChats, List<Icommodity> storesList, NpcGender gender, NpcFavorability favorability, int npcTexture, String npcName, NpcRace race) {
        this.npcChats = npcChats;
        this.storesList = storesList;
        this.gender = gender;
        this.favorability = favorability;
        this.npcTexture = npcTexture;
        this.npcName = npcName;
        this.race = race;
        this.type = NpcStoreType.other1;
    }

    public NpcSuite(List<IChat> npcChats, List<Icommodity> storesList, NpcGender gender, NpcFavorability favorability, int npcTexture, String npcName, NpcRace race, NpcStoreType type) {
        this.npcChats = npcChats;
        this.storesList = storesList;
        this.gender = gender;
        this.favorability = favorability;
        this.npcTexture = npcTexture;
        this.npcName = npcName;
        this.race = race;
        this.type = type;
    }

    public NpcSuite() {
    }

    public boolean incomplete() {
        return !this.npcChats.isEmpty() && !this.storesList.isEmpty() && this.gender != null && this.npcName != null && this.npcName != null && this.race != null && this.favorability != null && this.favorability.typeHate != null && this.favorability.typeLike != null && this.favorability.gender != null;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        this.npcTexture = NBTHelp.getIntSafe("npcTexture", nbt, 0);
        this.npcName = nbt.func_74779_i("npcName");
        this.gender = NpcGender.getTypeFromID(nbt.func_74762_e("gender"));
        this.race = NpcRace.getTypeFromID(nbt.func_74762_e("race"));
        this.favorability.loadFromNBT(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("storesList", 10);
        this.storesList = new ArrayList<Icommodity>();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound items = nbttaglist.func_150305_b(i);
            Icommodity item = new Icommodity();
            item.loadFromNBT(items);
            this.storesList.add(item);
        }
        NBTTagList nbttaglist2 = nbt.func_150295_c("npcChats", 10);
        this.npcChats = new ArrayList<IChat>();
        for (int i = 0; i < nbttaglist2.func_74745_c(); ++i) {
            NBTTagCompound chatsitem = nbttaglist2.func_150305_b(i);
            IChat chat = new IChat();
            chat.loadFromNBT(chatsitem);
            this.npcChats.add(chat);
        }
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("npcTexture", this.npcTexture);
        nbt.func_74778_a("npcName", this.npcName);
        nbt.func_74768_a("gender", this.gender.getID());
        nbt.func_74768_a("race", this.race.getID());
        this.favorability.saveToNBT(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int z = 0; z < this.storesList.size(); ++z) {
            Icommodity item = this.storesList.get(z);
            NBTTagCompound items = new NBTTagCompound();
            item.saveToNBT(items);
            nbttaglist.func_74742_a((NBTBase)items);
        }
        nbt.func_74782_a("storesList", (NBTBase)nbttaglist);
        NBTTagList nbttaglistchat = new NBTTagList();
        for (int s = 0; s < this.npcChats.size(); ++s) {
            NBTTagCompound chats = new NBTTagCompound();
            this.npcChats.get(s).saveToNBT(chats);
            nbttaglistchat.func_74742_a((NBTBase)chats);
        }
        nbt.func_74782_a("npcChats", (NBTBase)nbttaglistchat);
    }
}

