/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import project.studio.manametalmod.world.core.MapGenNetherBridgeClone;

public class StructureNetherBridgePiecesClone {
    private static final PieceWeight[] primaryComponents = new PieceWeight[]{new PieceWeight(Straight.class, 30, 0, true), new PieceWeight(Crossing3.class, 10, 4), new PieceWeight(Crossing.class, 10, 4), new PieceWeight(Stairs.class, 10, 3), new PieceWeight(Throne.class, 5, 2), new PieceWeight(Entrance.class, 5, 1)};
    private static final PieceWeight[] secondaryComponents = new PieceWeight[]{new PieceWeight(Corridor5.class, 25, 0, true), new PieceWeight(Crossing2.class, 15, 5), new PieceWeight(Corridor2.class, 5, 10), new PieceWeight(Corridor.class, 5, 10), new PieceWeight(Corridor3.class, 10, 3, true), new PieceWeight(Corridor4.class, 7, 2), new PieceWeight(NetherStalkRoom.class, 5, 2)};

    public static void registerNetherFortressPieces() {
        MapGenNetherBridgeClone.addDungeonMap(Crossing3.class, "NeBCr");
        MapGenNetherBridgeClone.addDungeonMap(End.class, "NeBEF");
        MapGenNetherBridgeClone.addDungeonMap(Straight.class, "NeBS");
        MapGenNetherBridgeClone.addDungeonMap(Corridor3.class, "NeCCS");
        MapGenNetherBridgeClone.addDungeonMap(Corridor4.class, "NeCTB");
        MapGenNetherBridgeClone.addDungeonMap(Entrance.class, "NeCE");
        MapGenNetherBridgeClone.addDungeonMap(Crossing2.class, "NeSCSC");
        MapGenNetherBridgeClone.addDungeonMap(Corridor.class, "NeSCLT");
        MapGenNetherBridgeClone.addDungeonMap(Corridor5.class, "NeSC");
        MapGenNetherBridgeClone.addDungeonMap(Corridor2.class, "NeSCRT");
        MapGenNetherBridgeClone.addDungeonMap(NetherStalkRoom.class, "NeCSR");
        MapGenNetherBridgeClone.addDungeonMap(Throne.class, "NeMT");
        MapGenNetherBridgeClone.addDungeonMap(Crossing.class, "NeRC");
        MapGenNetherBridgeClone.addDungeonMap(Stairs.class, "NeSR");
        MapGenNetherBridgeClone.addDungeonMap(Start.class, "NeStart");
        MapGenStructureIO.func_143031_a(Crossing3.class, (String)"NeBCr");
        MapGenStructureIO.func_143031_a(End.class, (String)"NeBEF");
        MapGenStructureIO.func_143031_a(Straight.class, (String)"NeBS");
        MapGenStructureIO.func_143031_a(Corridor3.class, (String)"NeCCS");
        MapGenStructureIO.func_143031_a(Corridor4.class, (String)"NeCTB");
        MapGenStructureIO.func_143031_a(Entrance.class, (String)"NeCE");
        MapGenStructureIO.func_143031_a(Crossing2.class, (String)"NeSCSC");
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"NeSCLT");
        MapGenStructureIO.func_143031_a(Corridor5.class, (String)"NeSC");
        MapGenStructureIO.func_143031_a(Corridor2.class, (String)"NeSCRT");
        MapGenStructureIO.func_143031_a(NetherStalkRoom.class, (String)"NeCSR");
        MapGenStructureIO.func_143031_a(Throne.class, (String)"NeMT");
        MapGenStructureIO.func_143031_a(Crossing.class, (String)"NeRC");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"NeSR");
        MapGenStructureIO.func_143031_a(Start.class, (String)"NeStart");
    }

    private static Piece createNextComponentRandom(PieceWeight p_78738_0_, List p_78738_1_, Random p_78738_2_, int p_78738_3_, int p_78738_4_, int p_78738_5_, int p_78738_6_, int p_78738_7_) {
        Class oclass = p_78738_0_.weightClass;
        Piece object = null;
        if (oclass == Straight.class) {
            object = Straight.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Crossing3.class) {
            object = Crossing3.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Crossing.class) {
            object = Crossing.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Stairs.class) {
            object = Stairs.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Throne.class) {
            object = Throne.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Entrance.class) {
            object = Entrance.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Corridor5.class) {
            object = Corridor5.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Corridor2.class) {
            object = Corridor2.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Corridor.class) {
            object = Corridor.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Corridor3.class) {
            object = Corridor3.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Corridor4.class) {
            object = Corridor4.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == Crossing2.class) {
            object = Crossing2.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        } else if (oclass == NetherStalkRoom.class) {
            object = NetherStalkRoom.createValidComponent(p_78738_1_, p_78738_2_, p_78738_3_, p_78738_4_, p_78738_5_, p_78738_6_, p_78738_7_);
        }
        return object;
    }

    public static class Throne
    extends Piece {
        private boolean hasSpawner;

        public Throne() {
        }

        public Throne(int p_i2053_1_, Random p_i2053_2_, StructureBoundingBox p_i2053_3_, int p_i2053_4_) {
            super(p_i2053_1_);
            this.field_74885_f = p_i2053_4_;
            this.field_74887_e = p_i2053_3_;
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.hasSpawner = p_143011_1_.func_74767_n("Mob");
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Mob", this.hasSpawner);
        }

        public static Throne createValidComponent(List p_74975_0_, Random p_74975_1_, int p_74975_2_, int p_74975_3_, int p_74975_4_, int p_74975_5_, int p_74975_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74975_2_, (int)p_74975_3_, (int)p_74975_4_, (int)-2, (int)0, (int)0, (int)7, (int)8, (int)9, (int)p_74975_5_);
            return Throne.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74975_0_, (StructureBoundingBox)structureboundingbox) == null ? new Throne(p_74975_6_, p_74975_1_, structureboundingbox, p_74975_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int j;
            int i;
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 6, 7, 7, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 0, 0, 5, 1, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 2, 1, 5, 2, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 3, 2, 5, 3, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 4, 3, 5, 4, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 2, 0, 1, 4, 2, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 2, 0, 5, 4, 2, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 5, 2, 1, 5, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 5, 2, 5, 5, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 3, 0, 5, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 5, 3, 6, 5, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 5, 8, 5, 5, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 1, 6, 3, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 5, 6, 3, p_74875_3_);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 6, 3, 0, 6, 8, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 6, 3, 6, 6, 8, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 6, 8, 5, 7, 8, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 8, 8, 4, 8, 8, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            if (!this.hasSpawner) {
                int k;
                i = this.func_74862_a(5);
                j = this.func_74865_a(3, 5);
                if (p_74875_3_.func_78890_b(j, i, k = this.func_74873_b(3, 5))) {
                    this.hasSpawner = true;
                    p_74875_1_.func_147465_d(j, i, k, Blocks.field_150474_ac, 0, 2);
                    TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)p_74875_1_.func_147438_o(j, i, k);
                    if (tileentitymobspawner != null) {
                        tileentitymobspawner.func_145881_a().func_98272_a("Blaze");
                    }
                }
            }
            for (i = 0; i <= 6; ++i) {
                for (j = 0; j <= 6; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Straight
    extends Piece {
        public Straight() {
        }

        public Straight(int p_i2044_1_, Random p_i2044_2_, StructureBoundingBox p_i2044_3_, int p_i2044_4_) {
            super(p_i2044_1_);
            this.field_74885_f = p_i2044_4_;
            this.field_74887_e = p_i2044_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 1, 3, false);
        }

        public static Straight createValidComponent(List p_74983_0_, Random p_74983_1_, int p_74983_2_, int p_74983_3_, int p_74983_4_, int p_74983_5_, int p_74983_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74983_2_, (int)p_74983_3_, (int)p_74983_4_, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)19, (int)p_74983_5_);
            return Straight.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74983_0_, (StructureBoundingBox)structureboundingbox) == null ? new Straight(p_74983_6_, p_74983_1_, structureboundingbox, p_74983_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 0, 4, 4, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 5, 0, 3, 7, 18, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 0, 0, 5, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 5, 0, 4, 5, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 4, 2, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 13, 4, 2, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 4, 1, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 15, 4, 1, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, 18 - j, p_74875_3_);
                }
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 1, 1, 0, 4, 1, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 4, 0, 4, 4, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 14, 0, 4, 14, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 1, 17, 0, 4, 17, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 1, 1, 4, 4, 1, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 3, 4, 4, 4, 4, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 3, 14, 4, 4, 14, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 1, 17, 4, 4, 17, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            return true;
        }
    }

    public static class Start
    extends Crossing3 {
        public PieceWeight theNetherBridgePieceWeight;
        public List primaryWeights;
        public List secondaryWeights;
        public ArrayList field_74967_d = new ArrayList();

        public Start() {
        }

        public Start(Random p_i2059_1_, int p_i2059_2_, int p_i2059_3_) {
            super(p_i2059_1_, p_i2059_2_, p_i2059_3_);
            this.primaryWeights = new ArrayList();
            for (PieceWeight pieceweight : primaryComponents) {
                pieceweight.field_78827_c = 0;
                this.primaryWeights.add(pieceweight);
            }
            this.secondaryWeights = new ArrayList();
            for (PieceWeight pieceweight : secondaryComponents) {
                pieceweight.field_78827_c = 0;
                this.secondaryWeights.add(pieceweight);
            }
        }

        public NBTTagCompound func_143010_b() {
            if (MapGenNetherBridgeClone.getName(this) == null) {
                throw new RuntimeException("StructureComponent \"" + ((Object)((Object)this)).getClass().getName() + "\" missing ID Mapping, Modder see MapGenStructureIO");
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("id", MapGenNetherBridgeClone.getName(this));
            nbttagcompound.func_74782_a("BB", (NBTBase)this.field_74887_e.func_151535_h());
            nbttagcompound.func_74768_a("O", this.field_74885_f);
            nbttagcompound.func_74768_a("GD", this.field_74886_g);
            this.func_143012_a(nbttagcompound);
            return nbttagcompound;
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs() {
        }

        public Stairs(int p_i2058_1_, Random p_i2058_2_, StructureBoundingBox p_i2058_3_, int p_i2058_4_) {
            super(p_i2058_1_);
            this.field_74885_f = p_i2058_4_;
            this.field_74887_e = p_i2058_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentZ((Start)p_74861_1_, p_74861_2_, p_74861_3_, 6, 2, false);
        }

        public static Stairs createValidComponent(List p_74973_0_, Random p_74973_1_, int p_74973_2_, int p_74973_3_, int p_74973_4_, int p_74973_5_, int p_74973_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74973_2_, (int)p_74973_3_, (int)p_74973_4_, (int)-2, (int)0, (int)0, (int)7, (int)11, (int)7, (int)p_74973_5_);
            return Stairs.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74973_0_, (StructureBoundingBox)structureboundingbox) == null ? new Stairs(p_74973_6_, p_74973_1_, structureboundingbox, p_74973_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 6, 1, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 6, 10, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 1, 8, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 2, 0, 6, 8, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 1, 0, 8, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 2, 1, 6, 8, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 2, 6, 5, 8, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 2, 0, 5, 4, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 3, 2, 6, 5, 2, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 3, 4, 6, 5, 4, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, 5, 2, 5, p_74875_3_);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 5, 4, 3, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 3, 2, 5, 3, 4, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 2, 5, 2, 5, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 2, 5, 1, 6, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 7, 1, 5, 7, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 8, 2, 6, 8, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 6, 0, 4, 8, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 0, 4, 5, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    static class PieceWeight {
        public Class weightClass;
        public final int field_78826_b;
        public int field_78827_c;
        public int field_78824_d;
        public boolean field_78825_e;

        public PieceWeight(Class p_i2055_1_, int p_i2055_2_, int p_i2055_3_, boolean p_i2055_4_) {
            this.weightClass = p_i2055_1_;
            this.field_78826_b = p_i2055_2_;
            this.field_78824_d = p_i2055_3_;
            this.field_78825_e = p_i2055_4_;
        }

        public PieceWeight(Class p_i2056_1_, int p_i2056_2_, int p_i2056_3_) {
            this(p_i2056_1_, p_i2056_2_, p_i2056_3_, false);
        }

        public boolean func_78822_a(int p_78822_1_) {
            return this.field_78824_d == 0 || this.field_78827_c < this.field_78824_d;
        }

        public boolean func_78823_a() {
            return this.field_78824_d == 0 || this.field_78827_c < this.field_78824_d;
        }
    }

    static abstract class Piece
    extends StructureComponent {
        protected static final WeightedRandomChestContent[] field_111019_a = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 3, 5), new WeightedRandomChestContent(Items.field_151043_k, 0, 1, 5, 5), new WeightedRandomChestContent(Items.field_151043_k, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151010_B, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151171_ah, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151033_d, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151075_bm, 0, 3, 7, 5), new WeightedRandomChestContent(Items.field_151141_av, 0, 1, 1, 10), new WeightedRandomChestContent(Items.field_151136_bY, 0, 1, 1, 8), new WeightedRandomChestContent(Items.field_151138_bX, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151125_bZ, 0, 1, 1, 3)};

        public Piece() {
        }

        protected Piece(int p_i2054_1_) {
            super(p_i2054_1_);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
        }

        private int getTotalWeight(List p_74960_1_) {
            boolean flag = false;
            int i = 0;
            for (PieceWeight pieceweight : p_74960_1_) {
                if (pieceweight.field_78824_d > 0 && pieceweight.field_78827_c < pieceweight.field_78824_d) {
                    flag = true;
                }
                i += pieceweight.field_78826_b;
            }
            return flag ? i : -1;
        }

        private Piece getNextComponent(Start p_74959_1_, List p_74959_2_, List p_74959_3_, Random p_74959_4_, int p_74959_5_, int p_74959_6_, int p_74959_7_, int p_74959_8_, int p_74959_9_) {
            int j1 = this.getTotalWeight(p_74959_2_);
            boolean flag = j1 > 0 && p_74959_9_ <= 30;
            int k1 = 0;
            block0: while (k1 < 5 && flag) {
                ++k1;
                int l1 = p_74959_4_.nextInt(j1);
                for (PieceWeight pieceweight : p_74959_2_) {
                    if ((l1 -= pieceweight.field_78826_b) >= 0) continue;
                    if (!pieceweight.func_78822_a(p_74959_9_) || pieceweight == p_74959_1_.theNetherBridgePieceWeight && !pieceweight.field_78825_e) continue block0;
                    Piece piece = StructureNetherBridgePiecesClone.createNextComponentRandom(pieceweight, p_74959_3_, p_74959_4_, p_74959_5_, p_74959_6_, p_74959_7_, p_74959_8_, p_74959_9_);
                    if (piece == null) continue;
                    ++pieceweight.field_78827_c;
                    p_74959_1_.theNetherBridgePieceWeight = pieceweight;
                    if (!pieceweight.func_78823_a()) {
                        p_74959_2_.remove(pieceweight);
                    }
                    return piece;
                }
            }
            return End.func_74971_a(p_74959_3_, p_74959_4_, p_74959_5_, p_74959_6_, p_74959_7_, p_74959_8_, p_74959_9_);
        }

        private StructureComponent getNextComponent(Start p_74962_1_, List p_74962_2_, Random p_74962_3_, int p_74962_4_, int p_74962_5_, int p_74962_6_, int p_74962_7_, int p_74962_8_, boolean p_74962_9_) {
            if (Math.abs(p_74962_4_ - p_74962_1_.func_74874_b().field_78897_a) <= 112 && Math.abs(p_74962_6_ - p_74962_1_.func_74874_b().field_78896_c) <= 112) {
                Piece piece;
                List list1 = p_74962_1_.primaryWeights;
                if (p_74962_9_) {
                    list1 = p_74962_1_.secondaryWeights;
                }
                if ((piece = this.getNextComponent(p_74962_1_, list1, p_74962_2_, p_74962_3_, p_74962_4_, p_74962_5_, p_74962_6_, p_74962_7_, p_74962_8_ + 1)) != null) {
                    p_74962_2_.add(piece);
                    p_74962_1_.field_74967_d.add(piece);
                }
                return piece;
            }
            return End.func_74971_a(p_74962_2_, p_74962_3_, p_74962_4_, p_74962_5_, p_74962_6_, p_74962_7_, p_74962_8_);
        }

        protected StructureComponent getNextComponentNormal(Start p_74963_1_, List p_74963_2_, Random p_74963_3_, int p_74963_4_, int p_74963_5_, boolean p_74963_6_) {
            switch (this.field_74885_f) {
                case 0: {
                    return this.getNextComponent(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a + p_74963_4_, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78892_f + 1, this.field_74885_f, this.func_74877_c(), p_74963_6_);
                }
                case 1: {
                    return this.getNextComponent(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c + p_74963_4_, this.field_74885_f, this.func_74877_c(), p_74963_6_);
                }
                case 2: {
                    return this.getNextComponent(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78897_a + p_74963_4_, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c - 1, this.field_74885_f, this.func_74877_c(), p_74963_6_);
                }
                case 3: {
                    return this.getNextComponent(p_74963_1_, p_74963_2_, p_74963_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74963_5_, this.field_74887_e.field_78896_c + p_74963_4_, this.field_74885_f, this.func_74877_c(), p_74963_6_);
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentX(Start p_74961_1_, List p_74961_2_, Random p_74961_3_, int p_74961_4_, int p_74961_5_, boolean p_74961_6_) {
            switch (this.field_74885_f) {
                case 0: {
                    return this.getNextComponent(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c + p_74961_5_, 1, this.func_74877_c(), p_74961_6_);
                }
                case 1: {
                    return this.getNextComponent(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a + p_74961_5_, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c(), p_74961_6_);
                }
                case 2: {
                    return this.getNextComponent(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c + p_74961_5_, 1, this.func_74877_c(), p_74961_6_);
                }
                case 3: {
                    return this.getNextComponent(p_74961_1_, p_74961_2_, p_74961_3_, this.field_74887_e.field_78897_a + p_74961_5_, this.field_74887_e.field_78895_b + p_74961_4_, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c(), p_74961_6_);
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentZ(Start p_74965_1_, List p_74965_2_, Random p_74965_3_, int p_74965_4_, int p_74965_5_, boolean p_74965_6_) {
            switch (this.field_74885_f) {
                case 0: {
                    return this.getNextComponent(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78896_c + p_74965_5_, 3, this.func_74877_c(), p_74965_6_);
                }
                case 1: {
                    return this.getNextComponent(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78897_a + p_74965_5_, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c(), p_74965_6_);
                }
                case 2: {
                    return this.getNextComponent(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78896_c + p_74965_5_, 3, this.func_74877_c(), p_74965_6_);
                }
                case 3: {
                    return this.getNextComponent(p_74965_1_, p_74965_2_, p_74965_3_, this.field_74887_e.field_78897_a + p_74965_5_, this.field_74887_e.field_78895_b + p_74965_4_, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c(), p_74965_6_);
                }
            }
            return null;
        }

        protected static boolean isAboveGround(StructureBoundingBox p_74964_0_) {
            return p_74964_0_ != null && p_74964_0_.field_78895_b > 10;
        }
    }

    public static class NetherStalkRoom
    extends Piece {
        public NetherStalkRoom() {
        }

        public NetherStalkRoom(int p_i2052_1_, Random p_i2052_2_, StructureBoundingBox p_i2052_3_, int p_i2052_4_) {
            super(p_i2052_1_);
            this.field_74885_f = p_i2052_4_;
            this.field_74887_e = p_i2052_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 5, 3, true);
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 5, 11, true);
        }

        public static NetherStalkRoom createValidComponent(List p_74977_0_, Random p_74977_1_, int p_74977_2_, int p_74977_3_, int p_74977_4_, int p_74977_5_, int p_74977_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74977_2_, (int)p_74977_3_, (int)p_74977_4_, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (int)p_74977_5_);
            return NetherStalkRoom.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74977_0_, (StructureBoundingBox)structureboundingbox) == null ? new NetherStalkRoom(p_74977_6_, p_74977_1_, structureboundingbox, p_74977_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int i1;
            int l;
            int k;
            int j;
            int i;
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 0, 12, 4, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 0, 12, 13, 12, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 0, 1, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 11, 5, 0, 12, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 11, 4, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 5, 11, 10, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 9, 11, 7, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 0, 4, 12, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 5, 0, 10, 12, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 9, 0, 7, 12, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 11, 2, 10, 12, 10, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (i = 1; i <= 11; i += 2) {
                this.func_151549_a(p_74875_1_, p_74875_3_, i, 10, 0, i, 11, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, i, 10, 12, i, 11, 12, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 0, 10, i, 0, 11, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 12, 10, i, 12, 11, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, i, 13, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, i, 13, 12, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, 0, 13, i, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, 12, 13, i, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, i + 1, 13, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, i + 1, 13, 12, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, i + 1, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 12, 13, i + 1, p_74875_3_);
            }
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, 0, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, 12, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, 0, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 12, 13, 0, p_74875_3_);
            for (i = 3; i <= 9; i += 2) {
                this.func_151549_a(p_74875_1_, p_74875_3_, 1, 7, i, 1, 8, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 11, 7, i, 11, 8, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            }
            i = this.func_151555_a(Blocks.field_150370_cb, 3);
            for (j = 0; j <= 6; ++j) {
                k = j + 4;
                for (l = 5; l <= 7; ++l) {
                    this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, i, l, 5 + j, k, p_74875_3_);
                }
                if (k >= 5 && k <= 8) {
                    this.func_151549_a(p_74875_1_, p_74875_3_, 5, 5, k, 7, j + 4, k, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                } else if (k >= 9 && k <= 10) {
                    this.func_151549_a(p_74875_1_, p_74875_3_, 5, 8, k, 7, j + 4, k, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                }
                if (j < 1) continue;
                this.func_151549_a(p_74875_1_, p_74875_3_, 5, 6 + j, k, 7, 9 + j, k, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            for (j = 5; j <= 7; ++j) {
                this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, i, j, 12, 11, p_74875_3_);
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 6, 7, 5, 7, 7, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 6, 7, 7, 7, 7, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 13, 12, 7, 13, 12, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 2, 3, 5, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 9, 3, 5, 10, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 4, 2, 5, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 9, 5, 2, 10, 5, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 9, 5, 9, 10, 5, 10, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 10, 5, 4, 10, 5, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            j = this.func_151555_a(Blocks.field_150370_cb, 0);
            k = this.func_151555_a(Blocks.field_150370_cb, 1);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, k, 4, 5, 2, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, k, 4, 5, 3, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, k, 4, 5, 9, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, k, 4, 5, 10, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, j, 8, 5, 2, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, j, 8, 5, 3, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, j, 8, 5, 9, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, j, 8, 5, 10, p_74875_3_);
            this.func_151549_a(p_74875_1_, p_74875_3_, 3, 4, 4, 4, 4, 8, Blocks.field_150425_aM, Blocks.field_150425_aM, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 4, 4, 9, 4, 8, Blocks.field_150425_aM, Blocks.field_150425_aM, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 3, 5, 4, 4, 5, 8, Blocks.field_150388_bm, Blocks.field_150388_bm, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 5, 4, 9, 5, 8, Blocks.field_150388_bm, Blocks.field_150388_bm, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 0, 8, 2, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 4, 12, 2, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 0, 0, 8, 1, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 0, 9, 8, 1, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 4, 3, 1, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 9, 0, 4, 12, 1, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (l = 4; l <= 8; ++l) {
                for (i1 = 0; i1 <= 2; ++i1) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, l, -1, i1, p_74875_3_);
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, l, -1, 12 - i1, p_74875_3_);
                }
            }
            for (l = 0; l <= 2; ++l) {
                for (i1 = 4; i1 <= 8; ++i1) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, l, -1, i1, p_74875_3_);
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, 12 - l, -1, i1, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Entrance
    extends Piece {
        public Entrance() {
        }

        public Entrance(int p_i2047_1_, Random p_i2047_2_, StructureBoundingBox p_i2047_3_, int p_i2047_4_) {
            super(p_i2047_1_);
            this.field_74885_f = p_i2047_4_;
            this.field_74887_e = p_i2047_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 5, 3, true);
        }

        public static Entrance createValidComponent(List p_74984_0_, Random p_74984_1_, int p_74984_2_, int p_74984_3_, int p_74984_4_, int p_74984_5_, int p_74984_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74984_2_, (int)p_74984_3_, (int)p_74984_4_, (int)-5, (int)-3, (int)0, (int)13, (int)14, (int)13, (int)p_74984_5_);
            return Entrance.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74984_0_, (StructureBoundingBox)structureboundingbox) == null ? new Entrance(p_74984_6_, p_74984_1_, structureboundingbox, p_74984_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int j;
            int i;
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 0, 12, 4, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 0, 12, 13, 12, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 0, 1, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 11, 5, 0, 12, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 11, 4, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 5, 11, 10, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 9, 11, 7, 12, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 0, 4, 12, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 5, 0, 10, 12, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 9, 0, 7, 12, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 11, 2, 10, 12, 10, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 8, 0, 7, 8, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            for (i = 1; i <= 11; i += 2) {
                this.func_151549_a(p_74875_1_, p_74875_3_, i, 10, 0, i, 11, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, i, 10, 12, i, 11, 12, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 0, 10, i, 0, 11, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 12, 10, i, 12, 11, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, i, 13, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, i, 13, 12, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, 0, 13, i, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, 12, 13, i, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, i + 1, 13, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, i + 1, 13, 12, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, i + 1, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 12, 13, i + 1, p_74875_3_);
            }
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, 0, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, 12, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 0, 13, 0, p_74875_3_);
            this.func_151550_a(p_74875_1_, Blocks.field_150410_aZ, 0, 12, 13, 0, p_74875_3_);
            for (i = 3; i <= 9; i += 2) {
                this.func_151549_a(p_74875_1_, p_74875_3_, 1, 7, i, 1, 8, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 11, 7, i, 11, 8, i, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 0, 8, 2, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 4, 12, 2, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 0, 0, 8, 1, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 0, 9, 8, 1, 12, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 4, 3, 1, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 9, 0, 4, 12, 1, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (i = 4; i <= 8; ++i) {
                for (j = 0; j <= 2; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, 12 - j, p_74875_3_);
                }
            }
            for (i = 0; i <= 2; ++i) {
                for (j = 4; j <= 8; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, 12 - i, -1, j, p_74875_3_);
                }
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 5, 5, 7, 5, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 1, 6, 6, 4, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151550_a(p_74875_1_, Blocks.field_150371_ca, 0, 6, 0, 6, p_74875_3_);
            this.func_151550_a(p_74875_1_, (Block)Blocks.field_150356_k, 0, 6, 5, 6, p_74875_3_);
            i = this.func_74865_a(6, 6);
            j = this.func_74862_a(5);
            int k = this.func_74873_b(6, 6);
            if (p_74875_3_.func_78890_b(i, j, k)) {
                p_74875_1_.field_72999_e = true;
                Blocks.field_150356_k.func_149674_a(p_74875_1_, i, j, k, p_74875_2_);
                p_74875_1_.field_72999_e = false;
            }
            return true;
        }
    }

    public static class End
    extends Piece {
        private int fillSeed;

        public End() {
        }

        public End(int p_i2043_1_, Random p_i2043_2_, StructureBoundingBox p_i2043_3_, int p_i2043_4_) {
            super(p_i2043_1_);
            this.field_74885_f = p_i2043_4_;
            this.field_74887_e = p_i2043_3_;
            this.fillSeed = p_i2043_2_.nextInt();
        }

        public static End func_74971_a(List p_74971_0_, Random p_74971_1_, int p_74971_2_, int p_74971_3_, int p_74971_4_, int p_74971_5_, int p_74971_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74971_2_, (int)p_74971_3_, (int)p_74971_4_, (int)-1, (int)-3, (int)0, (int)5, (int)10, (int)8, (int)p_74971_5_);
            return End.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74971_0_, (StructureBoundingBox)structureboundingbox) == null ? new End(p_74971_6_, p_74971_1_, structureboundingbox, p_74971_5_) : null;
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.fillSeed = p_143011_1_.func_74762_e("Seed");
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("Seed", this.fillSeed);
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int k;
            int j;
            int i;
            Random random1 = new Random(this.fillSeed);
            for (i = 0; i <= 4; ++i) {
                for (j = 3; j <= 4; ++j) {
                    k = random1.nextInt(8);
                    this.func_151549_a(p_74875_1_, p_74875_3_, i, j, 0, i, j, k, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                }
            }
            i = random1.nextInt(8);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 0, 0, 5, i, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            i = random1.nextInt(8);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 5, 0, 4, 5, i, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (i = 0; i <= 4; ++i) {
                j = random1.nextInt(5);
                this.func_151549_a(p_74875_1_, p_74875_3_, i, 2, 0, i, 2, j, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            }
            for (i = 0; i <= 4; ++i) {
                for (j = 0; j <= 1; ++j) {
                    k = random1.nextInt(3);
                    this.func_151549_a(p_74875_1_, p_74875_3_, i, j, 0, i, j, k, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                }
            }
            return true;
        }
    }

    public static class Crossing3
    extends Piece {
        public Crossing3() {
        }

        public Crossing3(int p_i2041_1_, Random p_i2041_2_, StructureBoundingBox p_i2041_3_, int p_i2041_4_) {
            super(p_i2041_1_);
            this.field_74885_f = p_i2041_4_;
            this.field_74887_e = p_i2041_3_;
        }

        protected Crossing3(Random p_i2042_1_, int p_i2042_2_, int p_i2042_3_) {
            super(0);
            this.field_74885_f = p_i2042_1_.nextInt(4);
            switch (this.field_74885_f) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 8, 3, false);
            this.getNextComponentX((Start)p_74861_1_, p_74861_2_, p_74861_3_, 3, 8, false);
            this.getNextComponentZ((Start)p_74861_1_, p_74861_2_, p_74861_3_, 3, 8, false);
        }

        public static Crossing3 createValidComponent(List p_74966_0_, Random p_74966_1_, int p_74966_2_, int p_74966_3_, int p_74966_4_, int p_74966_5_, int p_74966_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74966_2_, (int)p_74966_3_, (int)p_74966_4_, (int)-8, (int)-3, (int)0, (int)19, (int)10, (int)19, (int)p_74966_5_);
            return Crossing3.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74966_0_, (StructureBoundingBox)structureboundingbox) == null ? new Crossing3(p_74966_6_, p_74966_1_, structureboundingbox, p_74966_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int j;
            int i;
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 3, 0, 11, 4, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 7, 18, 4, 11, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 5, 0, 10, 7, 18, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 8, 18, 7, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 5, 0, 7, 5, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 5, 11, 7, 5, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 11, 5, 0, 11, 5, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 11, 5, 11, 11, 5, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 7, 7, 5, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 11, 5, 7, 18, 5, 7, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 11, 7, 5, 11, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 11, 5, 11, 18, 5, 11, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 2, 0, 11, 2, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 2, 13, 11, 2, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 0, 0, 11, 1, 3, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 0, 15, 11, 1, 18, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (i = 7; i <= 11; ++i) {
                for (j = 0; j <= 2; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, 18 - j, p_74875_3_);
                }
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 7, 5, 2, 11, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 13, 2, 7, 18, 2, 11, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 7, 3, 1, 11, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 15, 0, 7, 18, 1, 11, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (i = 0; i <= 2; ++i) {
                for (j = 7; j <= 11; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, 18 - i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Crossing2
    extends Piece {
        public Crossing2() {
        }

        public Crossing2(int p_i2048_1_, Random p_i2048_2_, StructureBoundingBox p_i2048_3_, int p_i2048_4_) {
            super(p_i2048_1_);
            this.field_74885_f = p_i2048_4_;
            this.field_74887_e = p_i2048_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 1, 0, true);
            this.getNextComponentX((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, 1, true);
            this.getNextComponentZ((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, 1, true);
        }

        public static Crossing2 createValidComponent(List p_74979_0_, Random p_74979_1_, int p_74979_2_, int p_74979_3_, int p_74979_4_, int p_74979_5_, int p_74979_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74979_2_, (int)p_74979_3_, (int)p_74979_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (int)p_74979_5_);
            return Crossing2.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74979_0_, (StructureBoundingBox)structureboundingbox) == null ? new Crossing2(p_74979_6_, p_74979_1_, structureboundingbox, p_74979_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 4, 1, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 0, 5, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 0, 4, 5, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 4, 0, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 4, 4, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 6, 0, 4, 6, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Crossing
    extends Piece {
        public Crossing() {
        }

        public Crossing(int p_i2057_1_, Random p_i2057_2_, StructureBoundingBox p_i2057_3_, int p_i2057_4_) {
            super(p_i2057_1_);
            this.field_74885_f = p_i2057_4_;
            this.field_74887_e = p_i2057_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 2, 0, false);
            this.getNextComponentX((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, 2, false);
            this.getNextComponentZ((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, 2, false);
        }

        public static Crossing createValidComponent(List p_74974_0_, Random p_74974_1_, int p_74974_2_, int p_74974_3_, int p_74974_4_, int p_74974_5_, int p_74974_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74974_2_, (int)p_74974_3_, (int)p_74974_4_, (int)-2, (int)0, (int)0, (int)7, (int)9, (int)7, (int)p_74974_5_);
            return Crossing.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74974_0_, (StructureBoundingBox)structureboundingbox) == null ? new Crossing(p_74974_6_, p_74974_1_, structureboundingbox, p_74974_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 6, 1, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 6, 7, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 1, 6, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 6, 1, 6, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 2, 0, 6, 6, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 5, 2, 6, 6, 6, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 0, 6, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 5, 0, 6, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 2, 0, 6, 6, 1, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 2, 5, 6, 6, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 6, 0, 4, 6, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 0, 4, 5, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 6, 6, 4, 6, 6, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 2, 5, 6, 4, 5, 6, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 6, 2, 0, 6, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 2, 0, 5, 4, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 6, 2, 6, 6, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 5, 2, 6, 5, 4, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            for (int i = 0; i <= 6; ++i) {
                for (int j = 0; j <= 6; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor5
    extends Piece {
        public Corridor5() {
        }

        public Corridor5(int p_i2050_1_, Random p_i2050_2_, StructureBoundingBox p_i2050_3_, int p_i2050_4_) {
            super(p_i2050_1_);
            this.field_74885_f = p_i2050_4_;
            this.field_74887_e = p_i2050_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 1, 0, true);
        }

        public static Corridor5 createValidComponent(List p_74981_0_, Random p_74981_1_, int p_74981_2_, int p_74981_3_, int p_74981_4_, int p_74981_5_, int p_74981_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74981_2_, (int)p_74981_3_, (int)p_74981_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (int)p_74981_5_);
            return Corridor5.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74981_0_, (StructureBoundingBox)structureboundingbox) == null ? new Corridor5(p_74981_6_, p_74981_1_, structureboundingbox, p_74981_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 4, 1, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 0, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 0, 4, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 1, 0, 4, 1, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 3, 0, 4, 3, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 3, 1, 4, 4, 1, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 3, 3, 4, 4, 3, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 6, 0, 4, 6, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor4
    extends Piece {
        public Corridor4() {
        }

        public Corridor4(int p_i2046_1_, Random p_i2046_2_, StructureBoundingBox p_i2046_3_, int p_i2046_4_) {
            super(p_i2046_1_);
            this.field_74885_f = p_i2046_4_;
            this.field_74887_e = p_i2046_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            int b0 = 1;
            if (this.field_74885_f == 1 || this.field_74885_f == 2) {
                b0 = 5;
            }
            this.getNextComponentX((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, b0, p_74861_3_.nextInt(8) > 0);
            this.getNextComponentZ((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, b0, p_74861_3_.nextInt(8) > 0);
        }

        public static Corridor4 createValidComponent(List p_74985_0_, Random p_74985_1_, int p_74985_2_, int p_74985_3_, int p_74985_4_, int p_74985_5_, int p_74985_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74985_2_, (int)p_74985_3_, (int)p_74985_4_, (int)-3, (int)0, (int)0, (int)9, (int)7, (int)9, (int)p_74985_5_);
            return Corridor4.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74985_0_, (StructureBoundingBox)structureboundingbox) == null ? new Corridor4(p_74985_6_, p_74985_1_, structureboundingbox, p_74985_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 8, 1, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 8, 5, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 6, 0, 8, 6, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 2, 5, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 2, 0, 8, 5, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 3, 0, 1, 4, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 3, 0, 7, 4, 0, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 4, 8, 2, 8, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 1, 4, 2, 2, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 1, 4, 7, 2, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 8, 8, 3, 8, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 6, 0, 3, 7, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 3, 6, 8, 3, 7, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 4, 0, 5, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 8, 3, 4, 8, 5, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 3, 5, 2, 5, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 6, 3, 5, 7, 5, 5, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 4, 5, 1, 5, 5, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 7, 4, 5, 7, 5, 5, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, j, -1, i, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor3
    extends Piece {
        public Corridor3() {
        }

        public Corridor3(int p_i2045_1_, Random p_i2045_2_, StructureBoundingBox p_i2045_3_, int p_i2045_4_) {
            super(p_i2045_1_);
            this.field_74885_f = p_i2045_4_;
            this.field_74887_e = p_i2045_3_;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentNormal((Start)p_74861_1_, p_74861_2_, p_74861_3_, 1, 0, true);
        }

        public static Corridor3 createValidComponent(List p_74982_0_, Random p_74982_1_, int p_74982_2_, int p_74982_3_, int p_74982_4_, int p_74982_5_, int p_74982_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74982_2_, (int)p_74982_3_, (int)p_74982_4_, (int)-1, (int)-7, (int)0, (int)5, (int)14, (int)10, (int)p_74982_5_);
            return Corridor3.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74982_0_, (StructureBoundingBox)structureboundingbox) == null ? new Corridor3(p_74982_6_, p_74982_1_, structureboundingbox, p_74982_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int i = this.func_151555_a(Blocks.field_150370_cb, 2);
            for (int j = 0; j <= 9; ++j) {
                int k = Math.max(1, 7 - j);
                int l = Math.min(Math.max(k + 5, 14 - j), 13);
                int i1 = j;
                this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, j, 4, k, j, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 1, k + 1, j, 3, l - 1, j, Blocks.field_150350_a, Blocks.field_150350_a, false);
                if (j <= 6) {
                    this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, i, 1, k + 1, j, p_74875_3_);
                    this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, i, 2, k + 1, j, p_74875_3_);
                    this.func_151550_a(p_74875_1_, Blocks.field_150370_cb, i, 3, k + 1, j, p_74875_3_);
                }
                this.func_151549_a(p_74875_1_, p_74875_3_, 0, l, j, 4, l, j, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 0, k + 1, j, 0, l - 1, j, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, 4, k + 1, j, 4, l - 1, j, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
                if ((j & 1) == 0) {
                    this.func_151549_a(p_74875_1_, p_74875_3_, 0, k + 2, j, 0, k + 3, j, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                    this.func_151549_a(p_74875_1_, p_74875_3_, 4, k + 2, j, 4, k + 3, j, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
                }
                for (int j1 = 0; j1 <= 4; ++j1) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, j1, -1, i1, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor2
    extends Piece {
        private boolean field_111020_b;

        public Corridor2() {
        }

        public Corridor2(int p_i2051_1_, Random p_i2051_2_, StructureBoundingBox p_i2051_3_, int p_i2051_4_) {
            super(p_i2051_1_);
            this.field_74885_f = p_i2051_4_;
            this.field_74887_e = p_i2051_3_;
            this.field_111020_b = p_i2051_2_.nextInt(3) == 0;
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.field_111020_b = p_143011_1_.func_74767_n("Chest");
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Chest", this.field_111020_b);
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentZ((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, 1, true);
        }

        public static Corridor2 createValidComponent(List p_74980_0_, Random p_74980_1_, int p_74980_2_, int p_74980_3_, int p_74980_4_, int p_74980_5_, int p_74980_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74980_2_, (int)p_74980_3_, (int)p_74980_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (int)p_74980_5_);
            return Corridor2.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74980_0_, (StructureBoundingBox)structureboundingbox) == null ? new Corridor2(p_74980_6_, p_74980_1_, structureboundingbox, p_74980_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int j;
            int i;
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 4, 1, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 0, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 1, 0, 4, 1, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 3, 3, 0, 4, 3, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 0, 4, 5, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 2, 4, 4, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 3, 4, 1, 4, 4, Blocks.field_150410_aZ, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 3, 3, 4, 3, 4, 4, Blocks.field_150410_aZ, Blocks.field_150371_ca, false);
            if (this.field_111020_b) {
                int k;
                i = this.func_74862_a(2);
                j = this.func_74865_a(1, 3);
                if (p_74875_3_.func_78890_b(j, i, k = this.func_74873_b(1, 3))) {
                    this.field_111020_b = false;
                    this.func_74879_a(p_74875_1_, p_74875_3_, p_74875_2_, 1, 2, 3, field_111019_a, 2 + p_74875_2_.nextInt(4));
                }
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 6, 0, 4, 6, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (i = 0; i <= 4; ++i) {
                for (j = 0; j <= 4; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor
    extends Piece {
        private boolean field_111021_b;

        public Corridor() {
        }

        public Corridor(int p_i2049_1_, Random p_i2049_2_, StructureBoundingBox p_i2049_3_, int p_i2049_4_) {
            super(p_i2049_1_);
            this.field_74885_f = p_i2049_4_;
            this.field_74887_e = p_i2049_3_;
            this.field_111021_b = p_i2049_2_.nextInt(3) == 0;
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.field_111021_b = p_143011_1_.func_74767_n("Chest");
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Chest", this.field_111021_b);
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            this.getNextComponentX((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, 1, true);
        }

        public static Corridor createValidComponent(List p_74978_0_, Random p_74978_1_, int p_74978_2_, int p_74978_3_, int p_74978_4_, int p_74978_5_, int p_74978_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74978_2_, (int)p_74978_3_, (int)p_74978_4_, (int)-1, (int)0, (int)0, (int)5, (int)7, (int)5, (int)p_74978_5_);
            return Corridor.isAboveGround(structureboundingbox) && StructureComponent.func_74883_a((List)p_74978_0_, (StructureBoundingBox)structureboundingbox) == null ? new Corridor(p_74978_6_, p_74978_1_, structureboundingbox, p_74978_5_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int j;
            int i;
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 4, 1, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 2, 0, 4, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 3, 1, 4, 4, 1, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 4, 3, 3, 4, 4, 3, Blocks.field_150410_aZ, Blocks.field_150410_aZ, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 0, 0, 5, 0, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, 4, 3, 5, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 1, 3, 4, 1, 4, 4, Blocks.field_150410_aZ, Blocks.field_150371_ca, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 3, 3, 4, 3, 4, 4, Blocks.field_150410_aZ, Blocks.field_150371_ca, false);
            if (this.field_111021_b) {
                int k;
                i = this.func_74862_a(2);
                j = this.func_74865_a(3, 3);
                if (p_74875_3_.func_78890_b(j, i, k = this.func_74873_b(3, 3))) {
                    this.field_111021_b = false;
                    this.func_74879_a(p_74875_1_, p_74875_3_, p_74875_2_, 3, 2, 3, field_111019_a, 2 + p_74875_2_.nextInt(4));
                }
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 6, 0, 4, 6, 4, Blocks.field_150371_ca, Blocks.field_150371_ca, false);
            for (i = 0; i <= 4; ++i) {
                for (j = 0; j <= 4; ++j) {
                    this.func_151554_b(p_74875_1_, Blocks.field_150371_ca, 0, i, -1, j, p_74875_3_);
                }
            }
            return true;
        }
    }
}

