/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.archeology;

import java.util.List;
import java.util.Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.archeology.IArcheologyTool;
import project.studio.manametalmod.archeology.IArcheologyType;
import project.studio.manametalmod.archeology.TileEntityArcheology;
import project.studio.manametalmod.blocks.BlockBase;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.instance_dungeon.IDungeonBoss;

public class BlockArcheology
extends BlockBase
implements ITileEntityProvider {
    public BlockArcheology() {
        super(Material.field_151576_e, "BlockArcheology");
        this.func_149647_a(ManaMetalMod.tab_Archeology);
        this.func_149711_c(100.0f);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (!world.field_72995_K) {
            TileEntityArcheology tile = (TileEntityArcheology)world.func_147438_o(x, y, z);
            if (tile.obj != null && tile.digging) {
                ManaMetalModRoot root;
                List<Entity> list = MMM.findEntity(world, x, y, z, 10);
                if (!list.isEmpty()) {
                    for (int s = 0; s < list.size(); ++s) {
                        Entity entity = list.get(s);
                        if (!(entity instanceof IDungeonBoss) || !this.canEntityBeSeen(world, entity, x, y + 1, z)) continue;
                        MMM.addMessage(player, "MMM.info.BlockArcheology.monster.cant", entity.func_70005_c_());
                        return true;
                    }
                }
                if ((root = MMM.getEntityNBT(player)) != null && M3Config.SurvivalFactor && root.mana.getOxygen() < 2) {
                    MMM.addMessage(player, "MMM.info.BlockArcheology.power.cant");
                    return true;
                }
                player.openGui((Object)ManaMetalMod.instance, 270, world, x, y, z);
            }
        }
        return true;
    }

    public boolean canEntityBeSeen(World world, Entity target, int x, int y, int z) {
        return world.func_72933_a(Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)target.func_70047_e()), (double)target.field_70161_v), Vec3.func_72443_a((double)x, (double)y, (double)z)) == null;
    }

    public void func_149746_a(World world, int x, int y, int z, Entity target, float height) {
        if (!world.field_72995_K && target instanceof EntityPlayer && world.field_73012_v.nextFloat() < height - 0.5f) {
            MMM.breakBlock(world, x, y, z, false);
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        IArcheologyTool IAT;
        ItemStack item;
        super.func_149699_a(world, x, y, z, player);
        if (!world.field_72995_K && (item = player.func_71045_bC()) != null && item.func_77973_b() instanceof IArcheologyTool && (IAT = (IArcheologyTool)item.func_77973_b()).getType(item) == IArcheologyType.pickaxe) {
            TileEntityArcheology tile = (TileEntityArcheology)world.func_147438_o(x, y, z);
            if (tile.digging) {
                if (world.field_73012_v.nextInt(100) < 30) {
                    MMM.breakBlock(world, x, y, z, false);
                }
            } else if (world.field_73012_v.nextInt(100) < 20) {
                MMM.playSoundFromServer(player.field_70170_p, "random.successful_hit", (Entity)player, 1.0, 1.0, 4.0);
                tile.onDigging();
                tile.set();
                tile.update_data();
            }
            IAT.damageToolItem(item);
            if (IAT.getToolDamage(item) > IAT.maxToolUse(item)) {
                player.func_70669_a(item);
                MMM.destroyCurrentEquippedItem(player);
            }
        }
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.2f, 0.8f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void fx(World world, int x, int y, int z, Random random) {
        double d0 = (float)x - 0.5f + random.nextFloat();
        double d1 = (float)y + random.nextFloat() * 0.2f;
        double d2 = (float)z - 0.5f + random.nextFloat();
        FXHelp.spawnParticle(world, Particle.shining, 0.5 + d0, d1, 0.5 + d2, 0.0, 0.0, 0.0, -1.0f);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityArcheology();
    }
}

