/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.chess;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.chess.AIChessMove;
import project.studio.manametalmod.chess.AIMain;
import project.studio.manametalmod.chess.ChessCore;
import project.studio.manametalmod.chess.ChessPos;
import project.studio.manametalmod.chess.ChessType;
import project.studio.manametalmod.chess.TileEntityChessBase;
import project.studio.manametalmod.chess.TileEntityChessboard;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.instance_dungeon.MobDunageonHeroTemple;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;

public class TileEntityChessAI
extends TileEntity {
    public List<ChessPos> list = new ArrayList<ChessPos>();
    public boolean isBlacktime = false;
    public int time = 0;
    public NetworkRegistry.TargetPoint targetpoint = null;
    public int sourceX;
    public int sourceZ;
    public boolean boss = false;
    public boolean isAI = false;
    public AIMain ai;
    public boolean addchessAI = false;
    public int dowater = 5;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.sourceX = NBTHelp.getIntSafe("sourceX", nbt, 0);
        this.sourceZ = NBTHelp.getIntSafe("sourceZ", nbt, 0);
        this.boss = NBTHelp.getBooleanSafe("boss", nbt, false);
        this.isAI = NBTHelp.getBooleanSafe("isAI", nbt, false);
        this.dowater = NBTHelp.getIntSafe("dowater", nbt, 0);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("sourceX", this.sourceX);
        nbt.func_74768_a("sourceZ", this.sourceZ);
        nbt.func_74757_a("boss", this.boss);
        nbt.func_74757_a("isAI", this.isAI);
        nbt.func_74768_a("dowater", this.dowater);
    }

    public void rightClick(EntityPlayer player) {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
            this.addStick(player);
            this.spawn();
        }
    }

    public void addStick(EntityPlayer player) {
        ItemStack item = new ItemStack(ChessCore.itemchessstick);
        NBTTagCompound nbt = new NBTTagCompound();
        Pos pos = new Pos(this);
        pos.saveToNBT(nbt, 0);
        item.func_77982_d(nbt);
        MMM.addItemToPlayer(item, player);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.targetpoint == null) {
            this.targetpoint = new NetworkRegistry.TargetPoint(MMM.getDimensionID(this.func_145831_w()), (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 16.0);
        }
    }

    public void AIgo() {
        if (this.hasBlackChess()) {
            if (this.ai != null && this.ai.bQuit) {
                this.ai = null;
            }
            if (this.ai == null) {
                this.ai = new AIMain(this);
            }
            try {
                this.ai.aiCaller.go();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.hasBlackChess()) {
                    this.doRandomChessAI();
                }
                this.isAI = false;
            }
        }
    }

    public boolean doRandomChessAI() {
        List<int[]> move;
        ChessPos temp;
        do {
            temp = this.list.get(this.field_145850_b.field_73012_v.nextInt(this.list.size()));
        } while (!temp.isBlack || this.field_145850_b.field_73012_v.nextInt(100) >= temp.data || (move = TileEntityChessAI.getCanGoList(temp, this.list)) == null || move.isEmpty());
        int[] go = MMM.getRandomItemFromList(move);
        this.tryGoTo(go[0], go[1], temp.targetX, temp.targetZ, null);
        return true;
    }

    public boolean hasBlackChess() {
        for (int s = 0; s < this.list.size(); ++s) {
            ChessPos temp = this.list.get(s);
            if (!temp.isBlack) continue;
            return true;
        }
        return false;
    }

    private ChessPos getPieceAt(int x, int z) {
        for (int s = 0; s < this.list.size(); ++s) {
            ChessPos temp = this.list.get(s);
            if (temp.targetX != x || temp.targetZ != z) continue;
            return temp;
        }
        return null;
    }

    public static int getdistance(int x1, int y1, int x2, int y2) {
        int x = x2 - x1;
        int y = y2 - y1;
        double Distance_Result = Math.sqrt(x * x + y * y);
        return (int)(Distance_Result - 1.0);
    }

    public List<int[]> getValidMovess(ChessPos chesspos) {
        List<int[]> moves = TileEntityChessAI.getCanGoList(chesspos, this.list);
        return moves;
    }

    public boolean isKingInDanger(boolean isBlack, boolean impliedMove) {
        for (int s = 0; s < this.list.size(); ++s) {
            ChessPos chessPos = this.list.get(s);
        }
        return false;
    }

    public boolean canCaptureKing(boolean kingIsBlack) {
        for (int s = 0; s < this.list.size(); ++s) {
            ChessPos temp = this.list.get(s);
            if (temp.type != ChessType.King || temp.isBlack != kingIsBlack || !this.canGo(temp.targetX, temp.targetZ, temp)) continue;
            return true;
        }
        return false;
    }

    public void playerWon() {
        if (!this.field_145850_b.field_72995_K && MMM.getDimensionID(this.field_145850_b) == M3Config.WorldInstanceDungeonID) {
            List<EntityLivingBase> list = MMM.findLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0);
            for (int s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof MobDunageonHeroTemple)) continue;
                MobDunageonHeroTemple mob = (MobDunageonHeroTemple)list.get(s);
                if (mob.type != 2) continue;
                mob.drawTest(21);
            }
        }
    }

    public void AIWon() {
        if (MMM.getDimensionID(this.field_145850_b) == M3Config.WorldInstanceDungeonID && !this.field_145850_b.field_72995_K) {
            List<EntityLivingBase> list = MMM.findLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0);
            for (int s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof MobDunageonHeroTemple)) continue;
                MobDunageonHeroTemple mob = (MobDunageonHeroTemple)list.get(s);
                if (mob.type != 2) continue;
                mob.drawTest(20);
            }
        }
    }

    public void goEffect(int x, int z, int fromX, int fromZ, EntityPlayer player, ChessPos base) {
        ChessPos willdead = this.getPieceAt(x, z);
        if (willdead != null && willdead.type == ChessType.King) {
            if (willdead.isBlack) {
                this.playerWon();
            } else {
                this.AIWon();
            }
        }
        if (base.type == ChessType.Pawn && (z == 7 || z == 0)) {
            this.setblocks(x, z, ChessType.Queen, base.isBlack, false);
        } else {
            this.setblocks(x, z, base.type, base.isBlack, false);
        }
        this.setblocks(fromX, fromZ, null, true, true);
        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(13, (float)(this.field_145851_c + x - 3), (float)this.field_145848_d, (float)(this.field_145849_e + z + 3), this.field_145851_c + fromX - 3, this.field_145848_d, this.field_145849_e + fromZ + 3), this.targetpoint);
        MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":bow2", this.field_145851_c + x - 3, this.field_145848_d, this.field_145849_e + z + 3, 1.0, 1.0, 16.0);
    }

    public boolean tryGoTo(int x, int z, int fromX, int fromZ, EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            boolean starAI = false;
            for (int s = 0; s < this.list.size(); ++s) {
                ChessPos temp = this.list.get(s);
                if (temp.targetX != fromX || temp.targetZ != fromZ || !this.canGo(x, z, temp)) continue;
                this.goEffect(x, z, fromX, fromZ, player, temp);
                if (player == null) break;
                MMM.addMessageBase(player, "MMM.info.movechess " + MMM.getTranslateText("tile.BlcokChess." + temp.type.ordinal() + ".name"));
                this.isAI = true;
                this.time = 0;
                starAI = true;
                break;
            }
            this.reset();
            if (starAI) {
                this.AIgo();
            }
        }
        return true;
    }

    public static List<int[]> getCanGoList(ChessPos chesspos, List<ChessPos> list) {
        switch (chesspos.type) {
            case Bishop: {
                return TileEntityChessAI.getPossibleMovesBishop(chesspos, list);
            }
            case King: {
                return TileEntityChessAI.getPossibleMovesKing(chesspos, list);
            }
            case Kinight: {
                return TileEntityChessAI.getPossibleMovesKnight(chesspos, list);
            }
            case Pawn: {
                return TileEntityChessAI.getPossibleMovesPawn(chesspos, list);
            }
            case Queen: {
                return TileEntityChessAI.getPossibleMovesQueen(chesspos, list);
            }
            case Rook: {
                return TileEntityChessAI.getPossibleMovesRook(chesspos, list);
            }
        }
        return null;
    }

    public boolean canGo(int tX, int tZ, ChessPos pos) {
        if (pos == null || pos.type == null) {
            return false;
        }
        List<int[]> listgo = TileEntityChessAI.getCanGoList(pos, this.list);
        if (listgo == null) {
            return false;
        }
        for (int s = 0; s < listgo.size(); ++s) {
            if (listgo.get(s)[0] != tX || listgo.get(s)[1] != tZ) continue;
            return true;
        }
        return false;
    }

    public boolean doEatChessAI() {
        for (int s = 0; s < this.list.size(); ++s) {
            ChessPos temp = this.list.get(s);
            if (!temp.isBlack) continue;
        }
        return false;
    }

    public boolean checkKingSafeAI() {
        return false;
    }

    public boolean checkPawnToQueenAI() {
        return false;
    }

    public void reset() {
        this.list.clear();
        for (int dz = 0; dz < 8; ++dz) {
            for (int dx = 0; dx < 8; ++dx) {
                if (this.field_145850_b.func_147439_a(this.sourceX + dx, this.field_145848_d, this.sourceZ + dz) != ChessCore.BlcokChess) continue;
                TileEntityChessBase tile = (TileEntityChessBase)this.field_145850_b.func_147438_o(this.sourceX + dx, this.field_145848_d, this.sourceZ + dz);
                ChessType type = ChessType.getType(tile.func_145832_p());
                boolean isBlack = tile.func_145832_p() > 5;
                ChessPos temp = new ChessPos(dx, dz, type, isBlack, this.getAIprobability(type));
                this.list.add(temp);
            }
        }
    }

    public int getAIprobability(ChessType type) {
        if (type == null) {
            return 10;
        }
        switch (type) {
            case Pawn: {
                return 10;
            }
            case Kinight: {
                return 30;
            }
            case Bishop: {
                return 30;
            }
            case Rook: {
                return 50;
            }
            case King: {
                return 40;
            }
            case Queen: {
                return 90;
            }
        }
        return 10;
    }

    public void spawn() {
        this.list.clear();
        for (int dz = 0; dz < 8; ++dz) {
            for (int dx = 0; dx < 8; ++dx) {
                this.func_145831_w().func_147465_d(this.field_145851_c + dx - 3, this.field_145848_d, this.field_145849_e + dz + 3, Blocks.field_150350_a, 0, 2);
            }
        }
        this.setblockadd(0, 0, ChessType.Rook, false, 0);
        this.setblockadd(1, 0, ChessType.Kinight, false, 0);
        this.setblockadd(2, 0, ChessType.Bishop, false, 0);
        this.setblockadd(3, 0, ChessType.Queen, false, 0);
        this.setblockadd(4, 0, ChessType.King, false, 0);
        this.setblockadd(5, 0, ChessType.Bishop, false, 0);
        this.setblockadd(6, 0, ChessType.Kinight, false, 0);
        this.setblockadd(7, 0, ChessType.Rook, false, 0);
        this.setblockadd(0, 1, ChessType.Pawn, false, 0);
        this.setblockadd(1, 1, ChessType.Pawn, false, 0);
        this.setblockadd(2, 1, ChessType.Pawn, false, 0);
        this.setblockadd(3, 1, ChessType.Pawn, false, 0);
        this.setblockadd(4, 1, ChessType.Pawn, false, 0);
        this.setblockadd(5, 1, ChessType.Pawn, false, 0);
        this.setblockadd(6, 1, ChessType.Pawn, false, 0);
        this.setblockadd(7, 1, ChessType.Pawn, false, 0);
        this.setblockadd(0, 7, ChessType.Rook, true, 50);
        this.setblockadd(1, 7, ChessType.Kinight, true, 30);
        this.setblockadd(2, 7, ChessType.Bishop, true, 30);
        this.setblockadd(3, 7, ChessType.Queen, true, 90);
        this.setblockadd(4, 7, ChessType.King, true, 50);
        this.setblockadd(5, 7, ChessType.Bishop, true, 30);
        this.setblockadd(6, 7, ChessType.Kinight, true, 40);
        this.setblockadd(7, 7, ChessType.Rook, true, 50);
        this.setblockadd(0, 6, ChessType.Pawn, true, 10);
        this.setblockadd(1, 6, ChessType.Pawn, true, 10);
        this.setblockadd(2, 6, ChessType.Pawn, true, 10);
        this.setblockadd(3, 6, ChessType.Pawn, true, 10);
        this.setblockadd(4, 6, ChessType.Pawn, true, 10);
        this.setblockadd(5, 6, ChessType.Pawn, true, 10);
        this.setblockadd(6, 6, ChessType.Pawn, true, 10);
        this.setblockadd(7, 6, ChessType.Pawn, true, 10);
        int s = 0;
        for (int dz = 0; dz < 8; ++dz) {
            for (int dx = 0; dx < 8; ++dx) {
                this.func_145831_w().func_147465_d(this.field_145851_c + dx - 3, this.field_145848_d - 1, this.field_145849_e + dz + 3, (Block)ChessCore.BlockChessboard, s % 2, 2);
                this.func_145831_w().func_147455_a(this.field_145851_c + dx - 3, this.field_145848_d - 1, this.field_145849_e + dz + 3, (TileEntity)new TileEntityChessboard(dx, dz));
                ++s;
            }
            ++s;
        }
        this.sourceX = this.field_145851_c - 3;
        this.sourceZ = this.field_145849_e + 3;
    }

    public void setblockadd(int x, int z, ChessType type, boolean isBlack, int data) {
        this.setblocks(x, z, type, isBlack, false);
        ChessPos temp = new ChessPos(x, z, type, isBlack, data);
        this.list.add(temp);
    }

    public void setblocks(int x, int z, ChessType type, boolean isBlack, boolean air) {
        if (air) {
            this.func_145831_w().func_147468_f(this.field_145851_c + x - 3, this.field_145848_d, this.field_145849_e + z + 3);
        } else {
            this.func_145831_w().func_147465_d(this.field_145851_c + x - 3, this.field_145848_d, this.field_145849_e + z + 3, (Block)ChessCore.BlcokChess, ChessType.getTypeID(type, isBlack), 2);
            TileEntityChessBase tile = new TileEntityChessBase(x, z, isBlack);
            this.func_145831_w().func_147455_a(this.field_145851_c + x - 3, this.field_145848_d, this.field_145849_e + z + 3, (TileEntity)tile);
            tile.update_data();
        }
    }

    public static boolean has(int x, int z, List<ChessPos> list) {
        for (int s = 0; s < list.size(); ++s) {
            ChessPos temp = list.get(s);
            if (temp.targetX != x || temp.targetZ != z) continue;
            return true;
        }
        return false;
    }

    public static ChessPos get(int x, int z, List<ChessPos> list) {
        for (int s = 0; s < list.size(); ++s) {
            ChessPos temp = list.get(s);
            if (temp.targetX != x || temp.targetZ != z) continue;
            return temp;
        }
        return null;
    }

    public static List<int[]> getPossibleMovesKing(ChessPos pos, List<ChessPos> list) {
        ArrayList<int[]> moves = new ArrayList<int[]>();
        for (int dx = pos.targetX - 1; dx <= pos.targetX + 1; ++dx) {
            for (int dz = pos.targetZ - 1; dz <= pos.targetZ + 1; ++dz) {
                if (dx < 0 || dx >= 8 || dz < 0 || dz >= 8) continue;
                int[] move = new int[]{dx, dz};
                if (dx == pos.targetX && dz == pos.targetZ) continue;
                ChessPos cp = TileEntityChessAI.get(dx, dz, list);
                if (cp != null) {
                    if (pos.isBlack == cp.isBlack) continue;
                    moves.add(move);
                    continue;
                }
                moves.add(move);
            }
        }
        return moves;
    }

    public static List<int[]> getPossibleMovesQueen(ChessPos pos, List<ChessPos> list) {
        ChessPos cp;
        ChessPos cp2;
        ArrayList<int[]> moves = new ArrayList<int[]>();
        int dx = pos.targetX + 1;
        while (dx < 8) {
            cp2 = TileEntityChessAI.get(dx, pos.targetZ, list);
            if (cp2 != null) {
                if (pos.isBlack == cp2.isBlack) break;
                moves.add(new int[]{dx, pos.targetZ});
                break;
            }
            moves.add(new int[]{dx++, pos.targetZ});
        }
        dx = pos.targetX - 1;
        while (dx > -1) {
            cp2 = TileEntityChessAI.get(dx, pos.targetZ, list);
            if (cp2 != null) {
                if (pos.isBlack == cp2.isBlack) break;
                moves.add(new int[]{dx, pos.targetZ});
                break;
            }
            moves.add(new int[]{dx--, pos.targetZ});
        }
        int dz = pos.targetZ + 1;
        while (dz < 8) {
            cp2 = TileEntityChessAI.get(pos.targetX, dz, list);
            if (cp2 != null) {
                if (pos.isBlack == cp2.isBlack) break;
                moves.add(new int[]{pos.targetX, dz});
                break;
            }
            moves.add(new int[]{pos.targetX, dz++});
        }
        dz = pos.targetZ - 1;
        while (dz > -1) {
            cp2 = TileEntityChessAI.get(pos.targetX, dz, list);
            if (cp2 != null) {
                if (pos.isBlack == cp2.isBlack) break;
                moves.add(new int[]{pos.targetX, dz});
                break;
            }
            moves.add(new int[]{pos.targetX, dz--});
        }
        dx = pos.targetX + 1;
        int dz2 = pos.targetZ + 1;
        while (dx < 8 && dz2 < 8) {
            cp = TileEntityChessAI.get(dx, dz2, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz2});
                break;
            }
            moves.add(new int[]{dx++, dz2++});
        }
        dx = pos.targetX - 1;
        dz2 = pos.targetZ - 1;
        while (dx > -1 && dz2 > -1) {
            cp = TileEntityChessAI.get(dx, dz2, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz2});
                break;
            }
            moves.add(new int[]{dx--, dz2--});
        }
        dx = pos.targetX + 1;
        dz2 = pos.targetZ - 1;
        while (dx < 8 && dz2 > -1) {
            cp = TileEntityChessAI.get(dx, dz2, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz2});
                break;
            }
            moves.add(new int[]{dx++, dz2--});
        }
        dx = pos.targetX - 1;
        dz2 = pos.targetZ + 1;
        while (dx > -1 && dz2 < 8) {
            cp = TileEntityChessAI.get(dx, dz2, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz2});
                break;
            }
            moves.add(new int[]{dx--, dz2++});
        }
        return moves;
    }

    public static List<int[]> getPossibleMovesBishop(ChessPos pos, List<ChessPos> list) {
        ChessPos cp;
        ArrayList<int[]> moves = new ArrayList<int[]>();
        int dx = pos.targetX + 1;
        int dz = pos.targetZ + 1;
        while (dx < 8 && dz < 8) {
            cp = TileEntityChessAI.get(dx, dz, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz});
                break;
            }
            moves.add(new int[]{dx++, dz++});
        }
        dx = pos.targetX - 1;
        dz = pos.targetZ - 1;
        while (dx > -1 && dz > -1) {
            cp = TileEntityChessAI.get(dx, dz, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz});
                break;
            }
            moves.add(new int[]{dx--, dz--});
        }
        dx = pos.targetX + 1;
        dz = pos.targetZ - 1;
        while (dx < 8 && dz > -1) {
            cp = TileEntityChessAI.get(dx, dz, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz});
                break;
            }
            moves.add(new int[]{dx++, dz--});
        }
        dx = pos.targetX - 1;
        dz = pos.targetZ + 1;
        while (dx > -1 && dz < 8) {
            cp = TileEntityChessAI.get(dx, dz, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, dz});
                break;
            }
            moves.add(new int[]{dx--, dz++});
        }
        return moves;
    }

    public static List<int[]> getPossibleMovesKnight(ChessPos pos, List<ChessPos> list) {
        ArrayList<int[]> moves = new ArrayList<int[]>();
        for (int i = 0; i < 8; ++i) {
            int[][] move = new int[8][2];
            switch (i) {
                case 0: {
                    move[i][0] = pos.targetX + 2;
                    move[i][1] = pos.targetZ + 1;
                    break;
                }
                case 1: {
                    move[i][0] = pos.targetX + 2;
                    move[i][1] = pos.targetZ - 1;
                    break;
                }
                case 2: {
                    move[i][0] = pos.targetX - 2;
                    move[i][1] = pos.targetZ + 1;
                    break;
                }
                case 3: {
                    move[i][0] = pos.targetX - 2;
                    move[i][1] = pos.targetZ - 1;
                    break;
                }
                case 4: {
                    move[i][0] = pos.targetX + 1;
                    move[i][1] = pos.targetZ + 2;
                    break;
                }
                case 5: {
                    move[i][0] = pos.targetX - 1;
                    move[i][1] = pos.targetZ + 2;
                    break;
                }
                case 6: {
                    move[i][0] = pos.targetX + 1;
                    move[i][1] = pos.targetZ - 2;
                    break;
                }
                case 7: {
                    move[i][0] = pos.targetX - 1;
                    move[i][1] = pos.targetZ - 2;
                }
            }
            if (move[i][0] >= 8 || move[i][0] < 0 || move[i][1] >= 8 || move[i][1] < 0) continue;
            ChessPos cp = TileEntityChessAI.get(move[i][0], move[i][1], list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) continue;
                moves.add(move[i]);
                continue;
            }
            moves.add(move[i]);
        }
        return moves;
    }

    public static List<int[]> getPossibleMovesPawn(ChessPos pos, List<ChessPos> list) {
        ArrayList<int[]> moves = new ArrayList<int[]>();
        int[] move1 = new int[]{pos.targetX, pos.targetZ + (pos.isBlack ? -1 : 1)};
        if ((pos.targetZ == 1 && !pos.isBlack || pos.targetZ == 6 && pos.isBlack) && !TileEntityChessAI.has(pos.targetX, pos.targetZ + (pos.isBlack ? -2 : 2), list)) {
            moves.add(new int[]{pos.targetX, pos.targetZ + (pos.isBlack ? -2 : 2)});
        }
        if (!TileEntityChessAI.has(move1[0], move1[1], list)) {
            moves.add(move1);
        }
        if (TileEntityChessAI.has(pos.targetX + 1, pos.targetZ + (pos.isBlack ? -1 : 1), list)) {
            int[] move3 = new int[]{pos.targetX + 1, pos.targetZ + (pos.isBlack ? -1 : 1)};
            moves.add(move3);
        }
        if (TileEntityChessAI.has(pos.targetX - 1, pos.targetZ + (pos.isBlack ? -1 : 1), list)) {
            int[] move4 = new int[]{pos.targetX - 1, pos.targetZ + (pos.isBlack ? -1 : 1)};
            moves.add(move4);
        }
        return moves;
    }

    public static List<int[]> getPossibleMovesRook(ChessPos pos, List<ChessPos> list) {
        ChessPos cp;
        ArrayList<int[]> moves = new ArrayList<int[]>();
        int dx = pos.targetX + 1;
        while (dx < 8) {
            cp = TileEntityChessAI.get(dx, pos.targetZ, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, pos.targetZ});
                break;
            }
            moves.add(new int[]{dx++, pos.targetZ});
        }
        dx = pos.targetX - 1;
        while (dx > -1) {
            cp = TileEntityChessAI.get(dx, pos.targetZ, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{dx, pos.targetZ});
                break;
            }
            moves.add(new int[]{dx--, pos.targetZ});
        }
        int dz = pos.targetZ + 1;
        while (dz < 8) {
            cp = TileEntityChessAI.get(pos.targetX, dz, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{pos.targetX, dz});
                break;
            }
            moves.add(new int[]{pos.targetX, dz++});
        }
        dz = pos.targetZ - 1;
        while (dz > -1) {
            cp = TileEntityChessAI.get(pos.targetX, dz, list);
            if (cp != null) {
                if (pos.isBlack == cp.isBlack) break;
                moves.add(new int[]{pos.targetX, dz});
                break;
            }
            moves.add(new int[]{pos.targetX, dz--});
        }
        return moves;
    }

    public void executeMove(AIChessMove move) {
        ChessPos piece;
        this.isAI = false;
        if (this.field_145850_b.field_73012_v.nextInt(100) < this.dowater) {
            if (this.hasBlackChess()) {
                this.doRandomChessAI();
            }
            this.isAI = false;
            return;
        }
        if (move != null && (piece = TileEntityChessAI.get(move.from % 10, move.from / 10, this.list)) != null) {
            if (this.tryGoTo(move.to % 10, move.to / 10, piece.targetX, piece.targetZ, null)) {
                return;
            }
            if (this.hasBlackChess()) {
                this.doRandomChessAI();
            }
        }
        if (this.hasBlackChess()) {
            this.doRandomChessAI();
        }
    }
}

