/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.command;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import project.studio.manametalmod.command.CommandBaseM3;
import project.studio.manametalmod.command.M3CommandLevel;

public class CommandM3Fill
extends CommandBaseM3 {
    private static final int MAX_VOLUME = 99999;

    public String func_71517_b() {
        return "m3fill";
    }

    @Override
    public M3CommandLevel getCommandLevel() {
        return M3CommandLevel.OP;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 8) {
            this.error();
        } else {
            int meta;
            World world = sender.func_130014_f_();
            ChunkCoordinates base = sender.func_82114_b();
            int x1 = this.parseCoord(args[0], base.field_71574_a);
            int y1 = this.parseCoord(args[1], base.field_71572_b);
            int z1 = this.parseCoord(args[2], base.field_71573_c);
            int x2 = this.parseCoord(args[3], base.field_71574_a);
            int y2 = this.parseCoord(args[4], base.field_71572_b);
            int z2 = this.parseCoord(args[5], base.field_71573_c);
            int minX = Math.min(x1, x2);
            int maxX = Math.max(x1, x2);
            int minY = Math.min(y1, y2);
            int maxY = Math.max(y1, y2);
            int minZ = Math.min(z1, z2);
            int maxZ = Math.max(z1, z2);
            if (minY < 0 || maxY > 255) {
                throw new NumberInvalidException("y must be in 0~255", new Object[0]);
            }
            Block block = Block.func_149684_b((String)args[6]);
            if (block == null) {
                throw new NumberInvalidException("unknown block: " + args[6], new Object[0]);
            }
            try {
                meta = CommandM3Fill.func_71532_a((ICommandSender)sender, (String)args[7], (int)0, (int)15);
            }
            catch (Exception e) {
                throw new NumberInvalidException("metadata must be in 0~15", new Object[0]);
            }
            long volume = (long)(maxX - minX + 1) * (long)(maxY - minY + 1) * (long)(maxZ - minZ + 1);
            if (volume > 99999L) {
                throw new NumberInvalidException("fill range is too large: " + volume + "(max :  " + 99999 + ")", new Object[0]);
            }
            int placed = 0;
            int flags = 2;
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int x = minX; x <= maxX; ++x) {
                        if (!world.func_147465_d(x, y, z, block, meta, 2)) continue;
                        ++placed;
                    }
                }
            }
            world.func_147458_c(minX, minY, minZ, maxX, maxY, maxZ);
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.format("fill %d block : ( %d , %d , %d ) to ( %d , %d , %d )  block : %s : %d", placed, minX, minY, minZ, maxX, maxY, maxZ, args[6], meta)));
        }
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 7) {
            return CommandM3Fill.func_71531_a((String[])args, (Iterable)Block.field_149771_c.func_148742_b());
        }
        switch (args.length) {
            case 1: 
            case 4: {
                return this.getSeePosType("x", sender);
            }
            case 2: 
            case 5: {
                return this.getSeePosType("y", sender);
            }
            case 3: 
            case 6: {
                return this.getSeePosType("z", sender);
            }
        }
        return null;
    }
}

