/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core.export_utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.export_utils.EXUItemData;
import project.studio.manametalmod.core.export_utils.EXUItemList;
import project.studio.manametalmod.core.export_utils.EXURenderer;
import project.studio.manametalmod.core.export_utils.FBOHelper;
import project.studio.manametalmod.core.export_utils.ItemRenderM3;
import project.studio.manametalmod.fashion.ItemHeadFashion;
import project.studio.manametalmod.fashion.weapon.ItemFashionWeaponCore;

public class ExportUtilsM3 {
    public static ExportUtilsM3 INSTANCE = new ExportUtilsM3();
    private FBOHelper fboSmall;
    private FBOHelper fboLarge;
    private RenderItem itemRenderer = new RenderItem();
    private List<EXUItemData> itemDataList = new ArrayList<EXUItemData>();

    public ExportUtilsM3() {
        this.fboSmall = new FBOHelper(32);
        this.fboLarge = new FBOHelper(128);
    }

    public String getLocalizedName(ItemStack itemStack) {
        return itemStack.func_82833_r();
    }

    public String getType(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemBlock ? "Block" : "Item";
    }

    public String getSmallIcon(ItemStack itemStack) {
        return EXURenderer.getItemBase64(itemStack, this.fboSmall, this.itemRenderer);
    }

    public String getLargeIcon(ItemStack itemStack) {
        return EXURenderer.getItemBase64(itemStack, this.fboLarge, this.itemRenderer);
    }

    public String getItemOwner(ItemStack itemStack) {
        GameRegistry.UniqueIdentifier uniqueIdentity = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
        return uniqueIdentity == null ? "unnamed" : uniqueIdentity.modId;
    }

    public void exportMods() throws IOException {
        try {
            MMM.Logg("*************Export start*************");
            MMM.Logg("*************START update item list*************");
            EXUItemList.updateList();
            MMM.Logg("*************START Search Items*************");
            Minecraft minecraft = FMLClientHandler.instance().getClient();
            this.itemDataList.clear();
            ArrayList<String> modList = new ArrayList<String>();
            Language lang = minecraft.func_135016_M().func_135041_c();
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            for (ItemStack itemStack : EXUItemList.items) {
                if (itemStack == null || !this.getItemOwner(itemStack).equals("manametalmod")) continue;
                MMM.Logg("start ext " + itemStack.func_77977_a());
                String identifier = itemStack.func_77977_a() + "@" + itemStack.func_77960_j();
                if (ItemRenderM3.blacklist.contains(identifier)) continue;
                EXUItemData itemData = new EXUItemData(itemStack);
                this.itemDataList.add(itemData);
                if (modList.contains(this.getItemOwner(itemStack))) continue;
                modList.add(this.getItemOwner(itemStack));
            }
            minecraft.func_135016_M().func_135045_a(new Language("zh_TW", "TW", "TW", false));
            minecraft.field_71474_y.field_74363_ab = "zh_CN";
            minecraft.func_110436_a();
            minecraft.field_71474_y.func_74303_b();
            MMM.Logg("*************START make json*************");
            for (EXUItemData data : this.itemDataList) {
                MMM.Logg("make target" + data.getItemStack().func_82833_r());
                data.setName(this.getLocalizedName(data.getItemStack()));
                data.setCreativeName(this.getCreativeTabName(data));
                if (data.itemStack.func_77973_b() instanceof ItemHeadFashion) {
                    EXURenderer.renderItem(data.itemStack, this.fboLarge, data.itemStack.func_82833_r(), this.itemRenderer);
                }
                if (!(data.itemStack.func_77973_b() instanceof ItemFashionWeaponCore)) continue;
                EXURenderer.renderItem(data.itemStack, this.fboLarge, data.itemStack.func_82833_r(), this.itemRenderer);
            }
            minecraft.func_135016_M().func_135045_a(new Language("en_US", "US", "English", false));
            minecraft.field_71474_y.field_74363_ab = "en_US";
            minecraft.func_110436_a();
            minecraft.field_71466_p.func_78264_a(false);
            minecraft.field_71474_y.func_74303_b();
            MMM.Logg("*************START make json english name*************");
            for (EXUItemData data : this.itemDataList) {
                MMM.Logg("make target" + data.getItemStack().func_82833_r());
                data.setEnglishName(this.getLocalizedName(data.getItemStack()));
            }
            MMM.Logg("*************START out json file*************");
            for (String modid : modList) {
                File export = new File(minecraft.field_71412_D, String.format("export/" + modid + "_item.json", modid.replaceAll("[^A-Za-z0-9()\\[\\]]", "")));
                if (!export.getParentFile().exists()) {
                    export.getParentFile().mkdirs();
                }
                if (!export.exists()) {
                    export.createNewFile();
                }
                PrintWriter pw = new PrintWriter(export, "UTF-8");
                for (EXUItemData data : this.itemDataList) {
                    if (!modid.equals(this.getItemOwner(data.getItemStack()))) continue;
                    pw.println(gson.toJson((Object)data));
                }
                pw.close();
            }
            minecraft.func_135016_M().func_135045_a(lang);
            minecraft.field_71474_y.field_74363_ab = lang.func_135034_a();
            minecraft.func_110436_a();
            minecraft.field_71474_y.func_74303_b();
            MMM.Logg("*************Export over*************");
            MMM.addMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "MMM.info.expUls.over", this.itemDataList.size(), "manametalmod_item.json");
        }
        catch (Exception e) {
            e.printStackTrace();
            MMM.addMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "MMM.info.expUls.fail");
        }
    }

    private String getCreativeTabName(EXUItemData data) {
        if (data.getItemStack().func_77973_b().func_77640_w() != null) {
            return I18n.func_135052_a((String)data.getItemStack().func_77973_b().func_77640_w().func_78024_c(), (Object[])new Object[0]);
        }
        return "";
    }
}

