/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.feeddragon;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.DayResource;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.core.TileEntityUpdate;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.feeddragon.DragonAdventureTeamType;
import project.studio.manametalmod.feeddragon.DragonSkills;
import project.studio.manametalmod.feeddragon.FeedDragonCore;
import project.studio.manametalmod.feeddragon.MobDragonElements;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft2;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft8;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.produce.Produce;
import project.studio.manametalmod.produce.ProduceCore;
import project.studio.manametalmod.produce.farming.FarmCore;
import project.studio.manametalmod.produce.gemcraft.ItemAlchemyGem;

public class TileEntityDragonAdventureTeam
extends TileEntityUpdate
implements ISidedInventory {
    public static final int AdventureTime1 = 144000;
    public static final int AdventureTime2 = 288000;
    public static final int AdventureTime3 = 864000;
    public static final int AdventureTime4 = 1728000;
    public ItemStack[] items = new ItemStack[36];
    public int time = 0;
    public int point = 0;
    public int playerLV;
    public int power = 0;
    public String player_name = "missingNO";
    public DragonAdventureTeamType type = DragonAdventureTeamType.Remains;
    public boolean isOver = false;
    public boolean isStart = false;
    public NBTTagCompound[] dragon_data;
    public Pos[] dragon_pos;
    public int[] process = new int[5];
    public long lastWorldTime = 0L;
    public static final List<ItemStack> rewardBase = new ArrayList<ItemStack>();
    public static final List<ItemStack> rewardOres = new ArrayList<ItemStack>();

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        nbt.func_74768_a("time", this.time);
        nbt.func_74768_a("point", this.point);
        nbt.func_74768_a("playerLV", this.playerLV);
        nbt.func_74768_a("power", this.power);
        nbt.func_74768_a("type", this.type.ordinal());
        nbt.func_74778_a("player_name", this.player_name);
        nbt.func_74757_a("isOver", this.isOver);
        nbt.func_74757_a("isStart", this.isStart);
        nbt.func_74783_a("process", this.process);
        if (this.dragon_data != null) {
            NBTTagList list = new NBTTagList();
            for (int s = 0; s < this.dragon_data.length; ++s) {
                list.func_74742_a((NBTBase)this.dragon_data[s]);
            }
            nbt.func_74782_a("dragon_data", (NBTBase)list);
        }
        if (this.dragon_pos != null) {
            NBTTagList list = new NBTTagList();
            for (int s = 0; s < this.dragon_pos.length; ++s) {
                NBTTagCompound temp = new NBTTagCompound();
                this.dragon_pos[s].saveToNBT(temp);
                list.func_74742_a((NBTBase)temp);
            }
            nbt.func_74782_a("dragon_pos", (NBTBase)list);
        }
        nbt.func_74772_a("lastWorldTime", this.lastWorldTime);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        int s;
        NBTTagList list;
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = NBTHelp.getNBTTagListSafe("Items", nbt, 10, new NBTTagList());
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.length) continue;
            this.items[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.time = NBTHelp.getIntSafe("time", nbt, 0);
        this.point = NBTHelp.getIntSafe("point", nbt, 0);
        this.playerLV = NBTHelp.getIntSafe("playerLV", nbt, 0);
        this.power = NBTHelp.getIntSafe("power", nbt, 0);
        int typetemp = NBTHelp.getIntSafe("type", nbt, 0);
        this.type = typetemp < DragonAdventureTeamType.values().length ? DragonAdventureTeamType.values()[typetemp] : DragonAdventureTeamType.Remains;
        this.player_name = NBTHelp.getStringSafe("player_name", nbt, "missingNO");
        this.isOver = NBTHelp.getBooleanSafe("isOver", nbt, false);
        this.isStart = NBTHelp.getBooleanSafe("isStart", nbt, false);
        this.process = NBTHelp.getIntArraySafe("process", nbt, new int[5]);
        if (nbt.func_150297_b("dragon_data", 9)) {
            list = NBTHelp.getNBTTagListSafe("dragon_data", nbt, 10, new NBTTagList());
            this.dragon_data = new NBTTagCompound[list.func_74745_c()];
            for (s = 0; s < list.func_74745_c(); ++s) {
                this.dragon_data[s] = (NBTTagCompound)list.func_150305_b(s).func_74737_b();
            }
        }
        if (nbt.func_150297_b("dragon_pos", 9)) {
            list = NBTHelp.getNBTTagListSafe("dragon_pos", nbt, 10, new NBTTagList());
            this.dragon_pos = new Pos[list.func_74745_c()];
            for (s = 0; s < list.func_74745_c(); ++s) {
                Pos poss = new Pos();
                poss.readFromNBT(list.func_150305_b(s));
                this.dragon_pos[s] = poss.copy();
            }
        }
        this.lastWorldTime = NBTHelp.getLongSafe("lastWorldTime", nbt, 0L);
    }

    public void takeItem(EntityPlayer player, ManaMetalModRoot root) {
        for (int s = 0; s < this.items.length; ++s) {
            if (this.items[s] == null) continue;
            MMM.addItemToPlayer(this.items[s].func_77946_l(), player);
            this.items[s] = null;
        }
        this.isOver = false;
        this.isStart = false;
        this.update_data();
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        root.produce.addEXP(350, Produce.Dragon);
        root.carrer.setDayResource(DayResource.DragonAdventure, 1);
    }

    public void tryDone() {
        int s;
        if (!this.isStart || this.isOver || this.dragon_data == null || this.dragon_pos == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.isOver = true;
        this.isStart = false;
        this.process = new int[5];
        for (int s2 = 0; s2 < this.process.length; ++s2) {
            this.process[s2] = this.field_145850_b.field_73012_v.nextInt(20);
        }
        int size = this.power / 30;
        if (size >= this.items.length) {
            size = this.items.length - 1;
        }
        for (s = 0; s < size; ++s) {
            this.items[s] = this.getItems();
        }
        for (s = 0; s < this.dragon_data.length; ++s) {
            Entity entity;
            NBTTagCompound tag = this.dragon_data[s];
            if (tag == null || (entity = EntityList.func_75615_a((NBTTagCompound)tag, (World)this.field_145850_b)) == null) continue;
            entity.func_70020_e(tag);
            Pos temp = this.dragon_pos[s];
            entity.func_70080_a((double)temp.X, (double)temp.Y, (double)temp.Z, 0.0f, 0.0f);
            if (entity == null || this.field_145850_b.field_72995_K) continue;
            this.field_145850_b.func_72838_d(entity);
        }
        this.update_data();
    }

    public ItemStack getItems() {
        if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            switch (this.type) {
                case Forest: {
                    switch (this.field_145850_b.field_73012_v.nextInt(2)) {
                        case 0: {
                            return new ItemStack(ProduceCore.ItemHerbsS, 16 + this.field_145850_b.field_73012_v.nextInt(32), this.field_145850_b.field_73012_v.nextInt(32));
                        }
                        case 1: {
                            return new ItemStack(FarmCore.ItemItemMushroom2, 16 + this.field_145850_b.field_73012_v.nextInt(32), this.field_145850_b.field_73012_v.nextInt(16));
                        }
                    }
                    break;
                }
                case Frost: {
                    int data;
                    do {
                        data = this.field_145850_b.field_73012_v.nextInt(ManaMetalAPI.FishingList.size());
                    } while (ManaMetalAPI.FishingList.get((int)data).isFishBoss);
                    ItemStack fish = ManaMetalAPI.FishingList.get((int)data).fish.func_77946_l();
                    fish.field_77994_a = 3;
                    return fish;
                }
                case Magic: {
                    switch (this.field_145850_b.field_73012_v.nextInt(3)) {
                        case 0: {
                            return new ItemStack(ManaMetalMod.ingotMana, 16 + this.field_145850_b.field_73012_v.nextInt(32), 0);
                        }
                        case 1: {
                            return new ItemStack(ManaMetalMod.blockMana, 16 + this.field_145850_b.field_73012_v.nextInt(16), 0);
                        }
                        case 2: {
                            return new ItemStack(ItemCraft10.ItemMana, 20 + this.field_145850_b.field_73012_v.nextInt(20), 0);
                        }
                    }
                    break;
                }
                case Remains: {
                    switch (this.field_145850_b.field_73012_v.nextInt(3)) {
                        case 0: {
                            return MMM.getTrophyItems().func_77946_l();
                        }
                        case 1: 
                        case 2: {
                            return ChestGenHooks.getOneItem((String)"dungeonChest", (Random)this.field_145850_b.field_73012_v).func_77946_l();
                        }
                    }
                    break;
                }
                case Volcanic: {
                    switch (this.field_145850_b.field_73012_v.nextInt(3)) {
                        case 0: {
                            return ItemAlchemyGem.getItemFromNameLV(MMM.getRandomItemFromList(ItemAlchemyGem.OKingot), 7, 3);
                        }
                        case 1: {
                            return ItemAlchemyGem.getItemFromNameLV(MMM.getRandomItemFromList(ItemAlchemyGem.OKingot), 8, 1);
                        }
                        case 2: {
                            return MMM.getRandomItemFromList(rewardOres).func_77946_l();
                        }
                    }
                }
            }
        }
        return MMM.getRandomItemFromList(rewardBase).func_77946_l();
    }

    public void takeItemOK(EntityPlayer player) {
        this.isOver = false;
        this.isStart = false;
        for (int s = 0; s < this.items.length; ++s) {
            if (this.items[s] == null) continue;
            MMM.spawnItemToPlayer(this.field_145850_b, this.items[s].func_77946_l(), player);
            this.items[s] = null;
        }
        this.update_data();
    }

    public void doStart(int[] data, int temp, int time, EntityPlayer player) {
        DragonAdventureTeamType type;
        if (data == null || data.length > 5 || temp >= DragonAdventureTeamType.values().length || this.field_145850_b.field_72995_K) {
            return;
        }
        for (int s = 0; s < data.length; ++s) {
            Entity entity = this.field_145850_b.func_73045_a(data[s]);
            if (entity != null) continue;
            MMM.addMessage(player, "MMM.info.TileEntityDragonAdventureTeamFail");
            return;
        }
        this.type = type = DragonAdventureTeamType.values()[temp];
        this.dragon_data = new NBTTagCompound[data.length];
        this.dragon_pos = new Pos[data.length];
        this.playerLV = 1;
        this.power = 1;
        this.isOver = false;
        this.isStart = true;
        this.lastWorldTime = this.field_145850_b.func_82737_E();
        time = 3;
        ManaMetalModRoot root = MMM.getEntityNBT(player);
        if (root != null) {
            this.playerLV = root.carrer.getLv();
        }
        for (int s = 0; s < data.length; ++s) {
            Pos pos;
            Entity entity = this.field_145850_b.func_73045_a(data[s]);
            if (entity == null || !(entity instanceof MobDragonElements) || MMM.getBlockDistance((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) >= 64) continue;
            NBTTagCompound tag = new NBTTagCompound();
            MobDragonElements dragon = (MobDragonElements)entity;
            dragon.func_70039_c(tag);
            this.dragon_data[s] = tag;
            this.dragon_pos[s] = pos = new Pos((Entity)dragon);
            this.power += dragon.intimacy / 16;
            ManaMetalModRoot rootdragon = MMM.getEntityNBT((EntityLivingBase)dragon);
            this.power += rootdragon.ManaEntityData.getLV();
            if (dragon.hasSkill(DragonSkills.Explore)) {
                this.power += 5;
            }
            switch (type) {
                case Forest: {
                    if (rootdragon.ManaEntityData.Element != ManaElements.Ice && rootdragon.ManaEntityData.Element != ManaElements.Water) break;
                    this.power += 5;
                    break;
                }
                case Frost: {
                    if (rootdragon.ManaEntityData.Element != ManaElements.Grass && rootdragon.ManaEntityData.Element != ManaElements.Earthm) break;
                    this.power += 5;
                    break;
                }
                case Magic: {
                    if (rootdragon.ManaEntityData.Element != ManaElements.Magic && rootdragon.ManaEntityData.Element != ManaElements.Wind) break;
                    this.power += 5;
                    break;
                }
                case Remains: {
                    if (rootdragon.ManaEntityData.Element != ManaElements.Light && rootdragon.ManaEntityData.Element != ManaElements.Dark) break;
                    this.power += 5;
                    break;
                }
                case Volcanic: {
                    if (rootdragon.ManaEntityData.Element != ManaElements.Fire && rootdragon.ManaEntityData.Element != ManaElements.Thunder) break;
                    this.power += 5;
                }
            }
            dragon.func_70106_y();
        }
        switch (time) {
            case 0: {
                this.time = 144000;
                this.power = (int)((float)this.power * 1.0f);
                break;
            }
            case 1: {
                this.time = 288000;
                this.power = (int)((float)this.power * 2.0f);
                break;
            }
            case 2: {
                this.time = 864000;
                this.power = (int)((float)this.power * 3.0f);
                break;
            }
            case 3: {
                this.time = 1728000;
                this.power = (int)((float)this.power * 4.0f);
            }
        }
        if (root.produce.getLV(Produce.Dragon) >= 10) {
            this.power = (int)((float)this.power * 1.2f);
        } else if (root.produce.getLV(Produce.Dragon) >= 6) {
            this.power = (int)((float)this.power * 1.1f);
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
        this.update_data();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.items[p_70298_1_] != null) {
            if (this.items[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.items[p_70298_1_];
                this.items[p_70298_1_] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.items[p_70298_1_].field_77994_a == 0) {
                this.items[p_70298_1_] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] != null) {
            ItemStack itemstack = this.items[slot];
            this.items[slot] = null;
            return itemstack;
        }
        return null;
    }

    public int RendererItem() {
        return 0;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.items[slot] = item;
    }

    public String func_145825_b() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_70305_f() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int face) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int face) {
        return false;
    }

    static {
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotAdamantine"), 12, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotMithril"), 12, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotSoulSteel"), 12, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotMysteriousIron"), 12, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotHolyCopper"), 12, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotBiliha"), 10, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotYamagata"), 10, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotRosite"), 10, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotOrichalcum"), 10, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotTitan"), 10, 0));
        rewardOres.add(new ItemStack(GameRegistry.findItem((String)"manametalmod", (String)"ingotRainbowSteel"), 10, 0));
        rewardBase.add(new ItemStack(FeedDragonCore.ItemDragonAdventureTeams, 1, 0));
        rewardBase.add(new ItemStack(FeedDragonCore.ItemDragonAdventureTeams, 1, 1));
        rewardBase.add(new ItemStack(FeedDragonCore.ItemDragonAdventureTeams, 1, 2));
        rewardBase.add(new ItemStack(FeedDragonCore.ItemDragonAdventureTeams, 1, 3));
        rewardBase.add(new ItemStack(ManaMetalMod.SageofTheStone, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.TrueTimeHourglass, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.Antimatter, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.Neutron, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.PowerCrystal, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.UnlimitedRing, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.gemMagical, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.OutsiderJade, 2));
        rewardBase.add(new ItemStack(ManaMetalMod.EarthEssence, 2));
        rewardBase.add(new ItemStack(ItemCraft2.ancientExpBook, 2, 0));
        rewardBase.add(new ItemStack(ItemCraft2.DoubleEXPReel, 1, 0));
        rewardBase.add(new ItemStack(ItemCraft2.mysteriousBook1, 1, 0));
        rewardBase.add(new ItemStack(ItemCraft2.mysteriousBook2, 1, 0));
        rewardBase.add(new ItemStack(ItemCraft2.ItemDimensionCrystals, 2, 0));
        rewardBase.add(new ItemStack(ItemCraft2.Itemblack_ball, 3, 0));
        rewardBase.add(new ItemStack(ItemCraft2.mysteriousCoinBag, 5, 0));
        rewardBase.add(new ItemStack(ItemCraft2.mysteriousCoinBag, 3, 1));
        rewardBase.add(new ItemStack(ItemCraft2.mysteriousCoinBag, 2, 2));
        rewardBase.add(new ItemStack(ItemCraft2.mysteriousCoinBag, 1, 3));
        rewardBase.add(new ItemStack(ItemCraft8.ExpCrystal9, 1, 0));
        rewardBase.add(new ItemStack(ItemCraft8.ExpCrystal8, 2, 0));
        rewardBase.add(new ItemStack(ItemCraft8.ExpCrystal7, 4, 0));
        rewardBase.add(new ItemStack(ItemCraft8.ExpCrystal6, 8, 0));
        rewardBase.add(new ItemStack(ItemCraft10.StrengthenStone, 5));
        rewardBase.add(new ItemStack(ItemCraft10.StrengthenStone, 6));
        rewardBase.add(new ItemStack(ItemCraft10.StrengthenStone, 7));
        rewardBase.add(new ItemStack(ItemCraft10.StrengthenStone, 8));
        rewardBase.add(new ItemStack(ItemCraft10.ingotCopyA, 1));
        rewardBase.add(new ItemStack(ItemCraft10.ingotCopyA, 2));
        rewardBase.add(new ItemStack(ItemCraft2.ItemSPCs, 3, 0));
        rewardBase.add(new ItemStack(ItemCraft2.ItemSPCs, 2, 0));
        rewardBase.add(new ItemStack(ItemCraft2.ItemSPCs, 1, 0));
        rewardBase.add(new ItemStack(ItemCraft2.ItemSPCs, 1, 1));
    }
}

