/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.food_collection;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.entity.nbt.NbtBaubles;
import project.studio.manametalmod.food_collection.FoodCollectionItem;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;
import project.studio.manametalmod.produce.cuisine.ICuisine;

public class FoodCollection {
    public String player;
    public List<FoodCollectionItem> data;

    public FoodCollection(String player) {
        this.player = player;
        this.data = new ArrayList<FoodCollectionItem>();
    }

    public boolean add(ItemStack item, EntityPlayer player) {
        NBTTagCompound tag;
        FoodCollectionItem food = FoodCollection.get(item);
        if (food == null) {
            return false;
        }
        if (item.func_77973_b() instanceof ICuisine && item.func_77942_o() && (tag = item.func_77978_p()).func_150297_b("AlreadyEaten", 3) && tag.func_74771_c("AlreadyEaten") > 1) {
            return false;
        }
        int size = this.data.size();
        for (int s = 0; s < size; ++s) {
            FoodCollectionItem temp = this.data.get(s);
            if (!temp.itemID.equals(food.itemID) || temp.metadata != food.metadata) continue;
            if (temp.getUse() < temp.maxUse) {
                temp.setUse((short)(temp.getUse() + 1));
                this.addEffect(food, player);
                short count = (short)(temp.maxUse - temp.getUse());
                if (count > 0) {
                    MMM.addMessage(player, "MMM.info.FoodCollection", item.func_82833_r(), count);
                } else {
                    MMM.addMessage(player, "MMM.info.FoodCollectionNo", item.func_82833_r());
                }
                return true;
            }
            return false;
        }
        this.data.add(new FoodCollectionItem(food.itemID, food.metadata, food.maxUse).setUse((short)1));
        this.addEffect(food, player);
        if (food.maxUse > 1) {
            MMM.addMessage(player, "MMM.info.FoodCollection", item.func_82833_r(), food.maxUse - 1);
        } else {
            MMM.addMessage(player, "MMM.info.FoodCollectionNo", item.func_82833_r());
        }
        return true;
    }

    public void addEffect(FoodCollectionItem food, EntityPlayer player) {
        ManaMetalModRoot root = MMM.getEntityNBT(player);
        if (root != null && food.effect != null) {
            for (int s = 0; s < food.effect.length; ++s) {
                if (food.effect[s] == null) continue;
                NbtBaubles.apply(food.effect[s].getType(), root, food.effect[s].getValue(), player);
            }
        }
    }

    public void addEffect(FoodCollectionItem food, EntityPlayer player, ManaMetalModRoot root) {
        if (root != null && food.effect != null) {
            for (int s = 0; s < food.effect.length; ++s) {
                if (food.effect[s] == null) continue;
                NbtBaubles.apply(food.effect[s].getType(), root, food.effect[s].getValue(), player);
            }
        }
    }

    public static void info(ItemTooltipEvent event) {
        FoodCollectionItem fc = FoodCollection.get(event.itemStack);
        if (fc != null && fc.effect != null) {
            event.toolTip.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"FoodCollectionItem.info"));
            event.toolTip.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"FoodCollectionItem.info2") + fc.maxUse);
            EnumChatFormatting color = EnumChatFormatting.AQUA;
            String Modified = "+";
            DecimalFormat df1 = (DecimalFormat)NumberFormat.getPercentInstance();
            for (int s = 0; s < fc.effect.length; ++s) {
                if (fc.effect[s] == null) continue;
                float value = fc.effect[s].getValue();
                IMagicEffect.applyInfo(event.toolTip, fc.effect[s].getType(), color, value, Modified);
            }
        }
    }

    public static final FoodCollectionItem get(ItemStack item) {
        String nameItem = Item.field_150901_e.func_148750_c((Object)item.func_77973_b());
        int metadata = item.func_77960_j();
        int size = ManaMetalAPI.FoodCollectionItemList.size();
        for (int s = 0; s < size; ++s) {
            FoodCollectionItem temp = ManaMetalAPI.FoodCollectionItemList.get(s);
            if (!temp.itemID.equals(nameItem) || temp.metadata != metadata) continue;
            return temp;
        }
        return null;
    }

    public static void saveToNBT(NBTTagCompound tag, FoodCollection temp) {
        NBTTagList list = new NBTTagList();
        int size = temp.data.size();
        for (int s = 0; s < size; ++s) {
            FoodCollectionItem fc = temp.data.get(s);
            NBTTagCompound tagtemp = new NBTTagCompound();
            tagtemp.func_74778_a("itemID", fc.itemID);
            tagtemp.func_74777_a("metadata", fc.metadata);
            tagtemp.func_74777_a("maxUse", fc.maxUse);
            tagtemp.func_74777_a("use", fc.getUse());
            list.func_74742_a((NBTBase)tagtemp);
        }
        tag.func_74782_a("FoodCollectionList", (NBTBase)list);
    }

    public static FoodCollection readFromNBT(NBTTagCompound nbt, String name) {
        NBTTagList list = NBTHelp.getNBTTagListSafe("FoodCollectionList", nbt, 10, new NBTTagList());
        FoodCollection fc = new FoodCollection(name);
        int size = list.func_74745_c();
        for (int s = 0; s < size; ++s) {
            NBTTagCompound tag = list.func_150305_b(s);
            String itemID = NBTHelp.getStringSafe("itemID", tag, "null");
            short metadata = NBTHelp.getShortSafe("metadata", tag, (short)-1);
            short maxUse = NBTHelp.getShortSafe("maxUse", tag, (short)1);
            short use = NBTHelp.getShortSafe("use", tag, (short)0);
            if (itemID.equals("null") || metadata == -1) continue;
            fc.data.add(new FoodCollectionItem(itemID, metadata, maxUse).setUse(use));
        }
        return fc;
    }
}

