/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.items;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IEquipmentStrengthenItem;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.core.ItemType;
import project.studio.manametalmod.items.ItemBaseLore;
import project.studio.manametalmod.rpg.QuenchingJadeCore;
import project.studio.manametalmod.tileentity.TileEntityItemUseTable;

public class ItemESQuenchingJade
extends ItemBaseLore
implements IEquipmentStrengthenItem {
    public static final String key = "quenching_jade";

    public ItemESQuenchingJade(String Name2) {
        super(Name2);
    }

    @Override
    public boolean hasEffect(ItemStack item, int pass) {
        return item.func_77960_j() > 0;
    }

    @Override
    public boolean effect(ItemStack item, ItemStack weapon, EntityPlayer player, TileEntityItemUseTable tile) {
        ItemType itemtype = weapon.func_77973_b() instanceof ItemArmor ? ItemType.Armor : ItemType.Weapon;
        QuenchingJadeEffectType type = QuenchingJadeEffectType.None;
        for (int s = 0; s < 9999; ++s) {
            type = QuenchingJadeEffectType.values()[player.field_70170_p.field_73012_v.nextInt(QuenchingJadeEffectType.values().length)];
            if (type.type == itemtype && player.field_70170_p.field_73012_v.nextInt(100) < type.data && !type.legend || type.type == itemtype && player.field_70170_p.field_73012_v.nextInt(100) < type.data && type.legend && item.func_77960_j() > 0) break;
        }
        if (weapon.func_77942_o()) {
            NBTTagCompound nbt = weapon.field_77990_d;
            nbt.func_74768_a(key, type.ordinal());
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a(key, type.ordinal());
            weapon.func_77982_d(nbt);
        }
        player.field_70170_p.func_72956_a((Entity)player, "random.successful_hit", 1.0f, 1.0f);
        return true;
    }

    public static void lore(ItemStack item, List list, EntityPlayer player) {
        QuenchingJadeEffectType type = ItemESQuenchingJade.getType(item);
        if (type == null) {
            return;
        }
        NBTTagCompound tag = item.func_77978_p();
        StringBuilder text = new StringBuilder();
        AttackEffect data = new AttackEffect();
        if (item.func_77973_b() instanceof ItemArmor) {
            QuenchingJadeCore.doBeEffectAttackArmor(data, player, item);
        } else if (MMM.getItemIsWeapon(item)) {
            QuenchingJadeCore.doEffectAttack(data, item, player, true);
        }
        String lore = null;
        ItemESQuenchingJade.addText(text, "manaItem.magicDefense", data.defense, true, false);
        ItemESQuenchingJade.addText(text, "manaItem.avoid", data.avoid, true, false);
        ItemESQuenchingJade.addText(text, "manaItem.crit", data.crit, true, false);
        ItemESQuenchingJade.addText(text, "manaItem.penetrate", data.penetration_base, true, false);
        ItemESQuenchingJade.addText(text, "manaItem.attackMultiplier", data.attack, false, true);
        ItemESQuenchingJade.addText(text, "forge_effect.tool.speed", data.customize_speed, true, false);
        ItemESQuenchingJade.addText(text, "forge_effect.tool.exp", data.xp, true, false);
        ItemESQuenchingJade.addText(text, "manaItem.reduce_gravity", data.reduce_gravity, false, true);
        if (text.length() > 0) {
            String removed;
            lore = text.toString();
            if (lore.endsWith(removed = " , ")) {
                String result = lore.substring(0, lore.length() - removed.length());
                list.add(EnumChatFormatting.AQUA + result);
            } else {
                list.add(EnumChatFormatting.AQUA + lore);
            }
        }
    }

    public static final void addText(StringBuilder text, String key, float data, boolean isinteger, boolean percent) {
        if (data != 0.0f) {
            text.append(MMM.getTranslateText(key));
            if (data > 0.0f) {
                text.append("+");
            }
            if (isinteger) {
                text.append((int)data);
            } else if (percent) {
                text.append((int)(data * 100.0f));
                text.append("%");
            } else {
                text.append(data);
            }
            text.append(" , ");
        }
    }

    @Override
    public boolean canUse(ItemStack item, ItemStack weapon, EntityPlayer player, TileEntityItemUseTable tile) {
        return true;
    }

    public static final QuenchingJadeEffectType getType(ItemStack item) {
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(key, 3)) {
            return QuenchingJadeEffectType.values()[item.func_77978_p().func_74762_e(key)];
        }
        return null;
    }

    public static enum QuenchingJadeEffectType {
        WeaponBase1(60, ItemType.Weapon, false),
        WeaponBase2(60, ItemType.Weapon, false),
        WeaponBase3(60, ItemType.Weapon, false),
        WeaponBase4(60, ItemType.Weapon, false),
        WeaponBase5(60, ItemType.Weapon, false),
        WeaponRare1(30, ItemType.Weapon, false),
        WeaponRare2(30, ItemType.Weapon, false),
        WeaponRare3(30, ItemType.Weapon, false),
        WeaponRare4(30, ItemType.Weapon, false),
        WeaponRare5(30, ItemType.Weapon, false),
        WeaponEpic(10, ItemType.Weapon, false),
        ArmorBase1(60, ItemType.Armor, false),
        ArmorBase2(60, ItemType.Armor, false),
        ArmorBase3(60, ItemType.Armor, false),
        ArmorRare1(30, ItemType.Armor, false),
        ArmorRare2(30, ItemType.Armor, false),
        ArmorRare3(30, ItemType.Armor, false),
        ArmorEpic(10, ItemType.Armor, false),
        None(0, ItemType.Other, false),
        WeaponLegend1(3, ItemType.Weapon, true),
        WeaponLegend2(3, ItemType.Weapon, true),
        ArmorLegend1(3, ItemType.Armor, true),
        ArmorLegend2(3, ItemType.Armor, true);

        public int data;
        public ItemType type;
        public boolean legend;

        private QuenchingJadeEffectType(int data, ItemType type, boolean legend) {
            this.data = data;
            this.type = type;
            this.legend = legend;
        }
    }
}

