/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.skyadventure.Battleship;
import project.studio.manametalmod.skyadventure.ChallengeType;
import project.studio.manametalmod.skyadventure.SkyCard;
import project.studio.manametalmod.skyadventure.TileEntitySkyAdventure;

public class MessageSkyadventure
implements IMessage,
IMessageHandler<MessageSkyadventure, IMessage> {
    public int x;
    public int y;
    public int z;
    public int type;
    int card;

    public MessageSkyadventure() {
    }

    public MessageSkyadventure(int posX, int posY, int posZ, int type) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.type = type;
        this.card = 0;
    }

    public MessageSkyadventure(int posX, int posY, int posZ, int type, int card) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.type = type;
        this.card = card;
    }

    public IMessage onMessage(MessageSkyadventure message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ManaMetalModRoot root = MMM.getEntityNBT((EntityPlayer)player);
        if (root != null) {
            switch (message.type) {
                case 0: {
                    if (root.money.getMoney() >= 1000L) {
                        root.money.addMoney(-1000L, MoneySourceType.SkyAdventureConsume);
                        root.battleCard.repairShip();
                    }
                    return null;
                }
                case 1: {
                    if (this.canUP(root.battleCard.getData().boat, player, root)) {
                        this.clearItemUP(root.battleCard.getData().boat, player, root);
                        root.battleCard.updateShip();
                    }
                    return null;
                }
                case 2: {
                    if (root.money.getMoney() >= (long)Battleship.values()[message.x].getMoneyNeed()) {
                        root.money.addMoney(-Battleship.values()[message.x].getMoneyNeed(), MoneySourceType.SkyAdventureConsume);
                        root.battleCard.buyShip(Battleship.values()[message.x]);
                    }
                    return null;
                }
            }
            TileEntity tile = player.field_70170_p.func_147438_o(message.x, message.y, message.z);
            if (tile != null && tile instanceof TileEntitySkyAdventure) {
                TileEntitySkyAdventure tileentity = (TileEntitySkyAdventure)tile;
                switch (message.type) {
                    case 3: {
                        if (!tileentity.game.isStart && !tileentity.game.isPlayer((EntityPlayer)player) && tileentity.game.players.size() < 4 && tileentity.game.addPlayer((EntityPlayer)player)) {
                            tileentity.game.setsend();
                        }
                        return null;
                    }
                    case 4: {
                        if (!tileentity.game.isStart && tileentity.game.isPlayer((EntityPlayer)player)) {
                            tileentity.game.removePlayer((EntityPlayer)player);
                            tileentity.game.setsend();
                        }
                        return null;
                    }
                    case 5: {
                        if (!tileentity.game.isStart && tileentity.game.canStart()) {
                            tileentity.game.startGame();
                            tileentity.game.setsend();
                            tileentity.game.addMessagePlayer();
                        }
                        return null;
                    }
                    case 6: {
                        if (tileentity.game.isStart) {
                            SkyCard card;
                            if (!tileentity.game.landing) {
                                if (tileentity.game.playerCanUseCard((EntityPlayer)player)) {
                                    SkyCard card2 = root.battleCard.skycard[message.card];
                                    if (card2 != null) {
                                        tileentity.game.tryUseCardFromPlayer((EntityPlayer)player, card2);
                                    }
                                    root.battleCard.removeSkyCard(message.card);
                                }
                            } else if (tileentity.game.playerCanDropCard((EntityPlayer)player) && (card = root.battleCard.skycard[message.card]) != null) {
                                root.battleCard.removeSkyCard(message.card);
                            }
                        }
                        return null;
                    }
                    case 7: {
                        if (tileentity.game.isStart && tileentity.game.landing) {
                            tileentity.game.continueGame();
                        }
                        return null;
                    }
                    case 8: {
                        if (tileentity.game.isPlayer((EntityPlayer)player)) {
                            tileentity.game.removePlayer((EntityPlayer)player);
                        }
                        return null;
                    }
                    case 9: {
                        if (tileentity.game.isPlayer((EntityPlayer)player) && tileentity.game.playerCanUseCard((EntityPlayer)player) && tileentity.game.isStart && !tileentity.game.isOver) {
                            tileentity.game.ChangePlayer(false);
                            root.battleCard.addSkyCard(SkyCard.getRandomrCard(tileentity.game));
                        }
                        return null;
                    }
                    case 10: {
                        if (tileentity.game.isPlayer((EntityPlayer)player) && root.battleCard.addSkyCard(SkyCard.getRandomrCard(tileentity.game))) {
                            if (tileentity.game.Challenge == ChallengeType.None || tileentity.game.Challenge == ChallengeType.Treasure) {
                                tileentity.game.goNextChallenge();
                            } else {
                                --tileentity.game.damageTime;
                            }
                            tileentity.game.tryDamagePlayer();
                            tileentity.game.setGameInfo(player.func_70005_c_() + MMM.getTranslateText("player.pickcard"));
                        }
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public void clearItemUP(Battleship boat, EntityPlayerMP player, ManaMetalModRoot root) {
        int lv = root.battleCard.getData().boatLV;
        root.money.addMoney(-boat.getUpNeeds(lv)[0], MoneySourceType.SkyAdventureConsume);
        root.battleCard.addXP(-boat.getUpNeeds(lv)[1]);
    }

    public boolean canUP(Battleship boat, EntityPlayerMP player, ManaMetalModRoot root) {
        int lv = root.battleCard.getData().boatLV;
        return lv < 10 && root.money.getMoney() >= (long)boat.getUpNeeds(lv)[0] && root.battleCard.getData().exp >= boat.getUpNeeds(lv)[1];
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.type = buf.readInt();
        this.card = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.type);
        buf.writeInt(this.card);
    }
}

