/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.beekeeping;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.items.ItemBaseSub;
import project.studio.manametalmod.produce.beekeeping.BeeAttributes;
import project.studio.manametalmod.produce.beekeeping.BeeEffect;
import project.studio.manametalmod.produce.beekeeping.BeekeepingCore;

public class ItemBeeQueen
extends ItemBaseSub {
    public static final int maxLife = 250;
    @SideOnly(value=Side.CLIENT)
    public IIcon icons_overlay;

    public ItemBeeQueen() {
        super(BeekeepingCore.beeCount, "ItemBeeQueen", ManaMetalMod.tab_beekeep);
        this.func_77625_d(1);
        this.func_77637_a(ManaMetalMod.tab_beekeep);
    }

    @Override
    public String func_77653_i(ItemStack item) {
        if (item.func_77960_j() < BeekeepingCore.beelist.size()) {
            return MMM.getTranslateText("Bee_" + item.func_77960_j()) + MMM.getTranslateText("ItemBeeQueen.name");
        }
        return MMM.getTranslateText("Bee_unknow") + MMM.getTranslateText("ItemBeeQueen.name");
    }

    public static int getBeeAttributes(BeeAttributes type, ItemStack item) {
        return item.func_77942_o() ? NBTHelp.getIntSafe(type.toString(), item.func_77978_p(), 0) : 0;
    }

    public static boolean isEffect(BeeEffect effect, ItemStack item) {
        return item.func_77942_o() && MMM.isIntFromArray(NBTHelp.getIntArraySafe("BeeEffect", item.func_77978_p(), new int[0]), effect.ordinal());
    }

    public static void setBaseAttributes(ItemStack item, boolean anotherworld, boolean nightwalk, World world, int effectCount) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(BeeAttributes.health.toString(), 250 + world.field_73012_v.nextInt(251));
        tag.func_74768_a(BeeAttributes.attack.toString(), 5 + world.field_73012_v.nextInt(6));
        tag.func_74768_a(BeeAttributes.resistance.toString(), 100 + world.field_73012_v.nextInt(51));
        tag.func_74768_a(BeeAttributes.efficiency.toString(), 70 + world.field_73012_v.nextInt(51));
        tag.func_74768_a(BeeAttributes.produce.toString(), 1);
        tag.func_74768_a(BeeAttributes.mutation.toString(), world.field_73012_v.nextInt(11));
        tag.func_74768_a(BeeAttributes.pollination.toString(), 1 + world.field_73012_v.nextInt(3));
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        int size = BeeEffect.values().length;
        for (int s = 0; s < effectCount; ++s) {
            BeeEffect effect = BeeEffect.values()[world.field_73012_v.nextInt(size)];
            if (world.field_73012_v.nextInt(100) >= effect.data || list.contains(effect.ordinal())) continue;
            list.add(effect.ordinal());
        }
        if (anotherworld && !list.contains(BeeEffect.anotherworld.ordinal())) {
            list.add(BeeEffect.anotherworld.ordinal());
        }
        if (nightwalk && !list.contains(BeeEffect.nightwalk.ordinal())) {
            list.add(BeeEffect.nightwalk.ordinal());
        }
        int[] array = list.stream().mapToInt(Integer::intValue).toArray();
        tag.func_74783_a("BeeEffect", array);
        tag.func_74768_a("damage", 0);
        item.func_77982_d(tag);
    }

    public boolean showDurabilityBar(ItemStack item) {
        return item.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack item) {
        if (item.func_77942_o()) {
            NBTTagCompound tag = item.func_77978_p();
            double damage = NBTHelp.getIntSafe("damage", tag, 0);
            double maxLife = ItemBeeQueen.getBeeAttributes(BeeAttributes.health, item);
            return damage / maxLife;
        }
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean data) {
        if (item.func_77942_o()) {
            NBTTagCompound tag = item.func_77978_p();
            int damage = NBTHelp.getIntSafe("damage", tag, 0);
            int maxLife = ItemBeeQueen.getBeeAttributes(BeeAttributes.health, item);
            list.add(EnumChatFormatting.WHITE + MMM.getTranslateText("BeeAttributes.health") + (maxLife - damage) + " / " + maxLife);
            list.add(EnumChatFormatting.WHITE + MMM.getTranslateText("BeeAttributes.attack") + ItemBeeQueen.getBeeAttributes(BeeAttributes.attack, item) + "%");
            list.add(EnumChatFormatting.WHITE + MMM.getTranslateText("BeeAttributes.resistance") + ItemBeeQueen.getBeeAttributes(BeeAttributes.resistance, item));
            list.add(EnumChatFormatting.WHITE + MMM.getTranslateText("BeeAttributes.efficiency") + ItemBeeQueen.getBeeAttributes(BeeAttributes.efficiency, item) + "%");
            list.add(EnumChatFormatting.WHITE + MMM.getTranslateText("BeeAttributes.produce") + ItemBeeQueen.getBeeAttributes(BeeAttributes.produce, item));
            list.add(EnumChatFormatting.WHITE + MMM.getTranslateText("BeeAttributes.mutation") + ItemBeeQueen.getBeeAttributes(BeeAttributes.mutation, item) + "%");
            list.add(EnumChatFormatting.WHITE + MMM.getTranslateText("BeeAttributes.pollination") + ItemBeeQueen.getBeeAttributes(BeeAttributes.pollination, item));
            int[] array = NBTHelp.getIntArraySafe("BeeEffect", tag, new int[0]);
            for (int s = 0; s < array.length; ++s) {
                list.add(EnumChatFormatting.YELLOW + MMM.getTranslateText("BeeEffect." + (Object)((Object)BeeEffect.values()[array[s]])));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int id) {
        return id > 0 ? this.icons_overlay : this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.field_77791_bV = IIconRegister2.func_94245_a(MMM.getMODID() + ":ItemBeeQueen");
        this.icons_overlay = IIconRegister2.func_94245_a(MMM.getMODID() + ":ItemBeeQueen_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack item, int id) {
        if (id > 0 && item.func_77960_j() < BeekeepingCore.beelist.size()) {
            return BeekeepingCore.beelist.get((int)item.func_77960_j()).color;
        }
        return 0xFFFFFF;
    }

    public boolean hasEffect(ItemStack item, int pass) {
        switch (item.func_77960_j()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }
}

