/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.renderer.jsonblock;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.IIcon;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.renderer.jsonblock.BlockJsonModelBake;
import project.studio.manametalmod.renderer.jsonblock.IBlockJsonModel;
import project.studio.manametalmod.renderer.jsonblock.ModelJson;
import project.studio.manametalmod.renderer.jsonblock.RenderJsonBlockModel;
import project.studio.manametalmod.renderer.jsonblock.RenderRequest;

public class JsonBlock {
    public static int jsonID = 90000;
    public static final Map<String, IIcon> iconMap = new HashMap<String, IIcon>();
    public static final Map<String, String> iconNameMap = new HashMap<String, String>();
    public static List<RenderRequest> renderRequest = new ArrayList<RenderRequest>();
    public static final Map<IBlockJsonModel, Integer> IDMap = new HashMap<IBlockJsonModel, Integer>();
    public static final Gson gson = new Gson();

    public static final void register(IBlockJsonModel block, boolean randomRotation, boolean renderItem, boolean autoRotationY, int rotation, String ... name) {
        if (MMM.isCLIENT()) {
            int size = name.length;
            ModelJson[] models = new ModelJson[size];
            for (int s = 0; s < size; ++s) {
                MMM.Logg("register json block model : " + name[s]);
                try {
                    models[s] = (ModelJson)gson.fromJson((Reader)new InputStreamReader(JsonBlock.class.getResourceAsStream("/assets/" + MMM.getMODID() + "/textures/json/block/" + name[s] + ".json")), ModelJson.class);
                    if (models[s] == null || models[s].textures == null) continue;
                    models[s].textures.forEach((textureID, textureName) -> {
                        iconNameMap.put((String)textureID, textureName.replace("manametalmod:blocks/", ""));
                        MMM.Logg("register texture pool ID : " + textureID + " name : " + textureName);
                    });
                    continue;
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (JsonIOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            renderRequest.add(new RenderRequest(jsonID, name, models, autoRotationY, false, rotation, randomRotation, renderItem));
            IDMap.put(block, jsonID);
            ++jsonID;
        }
    }

    protected static final void registerJsonBlock(RenderRequest RR) {
        int size = RR.models.length;
        HashMap<String, IIcon> iconMapTemp = new HashMap<String, IIcon>();
        for (int s = 0; s < size; ++s) {
            ModelJson MJ = RR.models[s];
            if (MJ.textures == null) continue;
            MJ.textures.forEach((textureID, textureName) -> {
                if (iconMap.containsKey(textureID)) {
                    iconMapTemp.put((String)textureID, iconMap.get(textureID));
                } else {
                    MMM.Logg("can't find texture from pool ID : " + textureID + " name : " + textureName);
                }
            });
        }
        ArrayList[] quads = new ArrayList[size];
        for (int s = 0; s < size; ++s) {
            ArrayList<BlockJsonModelBake.BakedQuad> bakedQuadsTemp = new ArrayList<BlockJsonModelBake.BakedQuad>();
            for (ModelJson.Element e : RR.models[s].elements) {
                bakedQuadsTemp.addAll(BlockJsonModelBake.bakeElement(e, iconMapTemp));
            }
            quads[s] = bakedQuadsTemp;
        }
        RenderingRegistry.registerBlockHandler((int)RR.ID, (ISimpleBlockRenderingHandler)new RenderJsonBlockModel(quads, RR.ID, RR.autoRotationY, RR.autoOverlay, RR.rotation, RR.randomRotation, RR.renderItem));
    }

    public static final void event() {
        int size = renderRequest.size();
        for (int s = 0; s < size; ++s) {
            RenderRequest RR = renderRequest.get(s);
            JsonBlock.registerJsonBlock(RR);
        }
    }
}

