/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.rpg;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IWeaponScroll;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.battle.Tools;
import project.studio.manametalmod.battle.WeaponCore;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.core.Icommodity;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.item.customize.ItemCustomizeTools;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.produce.gemcraft.GemCraftCore;
import project.studio.manametalmod.produce.textile.TextileCore;

public final class ItemStrengthenHelp {
    public static final String nbtid = "weapon_strengthen";
    public static final int[] colors = new int[]{4697847, 12320793, 10945466, 15859598, 16762101, 7864197, 13526783, 0x404040, 16738816, 16711790, 2162815, 10829409, 0xA0A0A0, 34462, 5493146, 0xFFFA7F, 0xFFFF30};
    public static final int[] money = new int[]{49000, 434000, 1250000};

    public static int getWeaponAttack(ItemStack item) {
        int attack = (int)MMM.getWeaponDamage(item);
        float strengthen = (float)ItemStrengthenHelp.getWeaponAttackRoll(item) * ItemStrengthenHelp.getWeaponStrPower(item.func_77973_b());
        return (int)((float)attack + strengthen);
    }

    public static float getWeaponStrPower(Item item) {
        return 1.0f;
    }

    public static Quality getQuality(ItemStack item) {
        Quality data = null;
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10)) {
            data = Quality.values()[item.func_77978_p().func_74762_e("quality")];
        }
        return data;
    }

    public static void addSwordNBT(ItemStack item, Quality WeaponQuality) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("magic_jade1", 0);
        nbt.func_74768_a("magic_jade2", 0);
        nbt.func_74768_a("magic_jade3", 0);
        nbt.func_74768_a("max_star", 10);
        nbt.func_74768_a("star", 0);
        nbt.func_74768_a("max_roll", 15);
        nbt.func_74768_a("roll", 0);
        nbt.func_74768_a("attack", 0);
        nbt.func_74768_a("crit", 0);
        nbt.func_74768_a("quality", WeaponQuality.ordinal());
        nbt.func_74768_a("quality_count", 1);
        nbt.func_74768_a("fail_roll", 0);
        nbt.func_74768_a("WhiteGoldHammer", 0);
        nbt.func_74768_a("extra_attack", 0);
        if (item != null) {
            item.func_77983_a(nbtid, (NBTBase)nbt);
        }
    }

    public static void addSwordNBT(ItemStack item) {
        ItemStrengthenHelp.addSwordNBT(item, ItemStrengthenHelp.getItemQualitys(false, false));
    }

    public static void reWeapon(ItemStack item) {
        if (item.func_77942_o()) {
            NBTTagCompound nbt = item.func_77978_p().func_74775_l(nbtid);
            nbt.func_74768_a("max_star", 10);
            nbt.func_74768_a("star", 0);
            nbt.func_74768_a("max_roll", 15);
            nbt.func_74768_a("roll", 0);
            nbt.func_74768_a("attack", 0);
            nbt.func_74768_a("crit", 0);
            nbt.func_74768_a("fail_roll", 0);
            nbt.func_74768_a("WhiteGoldHammer", 0);
        }
    }

    public static int getStartNeedMoney(int count) {
        switch (count) {
            case 0: {
                return 10000;
            }
            case 1: {
                return 60000;
            }
            case 2: {
                return 120000;
            }
            case 3: {
                return 240000;
            }
            case 4: {
                return 350000;
            }
            case 5: {
                return 450000;
            }
            case 6: {
                return 1000000;
            }
            case 7: {
                return 2500000;
            }
            case 8: {
                return 5000000;
            }
            case 9: {
                return 10000000;
            }
            case 10: {
                return 20000000;
            }
            case 11: {
                return 25000000;
            }
            case 12: {
                return 50000000;
            }
            case 13: {
                return 75000000;
            }
            case 14: {
                return 90000000;
            }
        }
        return 0;
    }

    public static boolean hasTag(ItemStack item) {
        return item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10);
    }

    public static void changeQuality(ItemStack item, Quality WeaponQuality) {
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10)) {
            NBTTagCompound tag = item.func_77978_p().func_74775_l(nbtid);
            tag.func_74768_a("quality", WeaponQuality.ordinal());
        }
    }

    public static double getIWeaponScroll(int data, int count) {
        double ok = data;
        switch (count) {
            case 29: 
            case 30: {
                ok = (double)data * 0.5;
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                ok = (double)data * 0.55;
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                ok = (double)data * 0.6;
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                ok = (double)data * 0.65;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                ok = (double)data * 0.7;
                break;
            }
            case 12: {
                ok = (double)data * 0.75;
                break;
            }
            case 11: {
                ok = (double)data * 0.8;
                break;
            }
            case 10: {
                ok = (double)data * 0.85;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                ok = (double)data * 0.9;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                ok = (double)data * 0.95;
                break;
            }
        }
        if (M3Config.LongTermMode) {
            ok *= (double)0.8f;
        }
        if (M3Config.ForeverMode) {
            ok *= (double)0.6f;
        }
        if (ok <= 0.0) {
            ok = 1.0;
        }
        return ok;
    }

    public static int addScroll(ItemStack item, IWeaponScroll scroll, ItemStack reels, World world, EntityPlayer player) {
        NBTTagCompound tag = item.func_77978_p().func_74775_l(nbtid);
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10)) {
            boolean success;
            ManaMetalModRoot root;
            int[] data = scroll.get_data(reels, reels.func_77960_j());
            double power = ItemStrengthenHelp.getIWeaponScroll(data[0], tag.func_74762_e("roll"));
            if (player != null) {
                root = MMM.getEntityNBT(player);
                if (root != null) {
                    if (root.specialization.getEffect(45)) {
                        power += 2.0;
                    }
                    if (root.specialization.getEffect(54)) {
                        power += 2.0;
                    }
                    if (root.specialization.getEffect(63)) {
                        power += 2.0;
                    }
                }
                if (player.field_71071_by.func_146026_a(TextileCore.Dreamcatcher_0)) {
                    power += 10.0;
                }
                if (player.field_71071_by.func_146026_a(TextileCore.Dreamcatcher_1)) {
                    power += 20.0;
                }
            }
            if ((root = MMM.getEntityNBT(player)) != null) {
                power += power * (double)(root.carrer.craft - 1.0f);
            }
            boolean bl = success = (double)world.field_73012_v.nextInt(100) < power;
            if (success) {
                int roll = tag.func_74762_e("roll");
                if (roll < tag.func_74762_e("max_roll")) {
                    tag.func_74768_a("roll", roll + 1);
                    tag.func_74768_a("attack", tag.func_74762_e("attack") + data[1]);
                    tag.func_74768_a("crit", tag.func_74762_e("crit") + data[2]);
                    return 1;
                }
            } else {
                int damage = data[3];
                if (damage > 0 && world.field_73012_v.nextInt(100) < damage) {
                    tag.func_74768_a("roll", 0);
                    tag.func_74768_a("attack", 0);
                    tag.func_74768_a("crit", 0);
                    tag.func_74768_a("fail_roll", 0);
                    return 3;
                }
                int roll = tag.func_74762_e("roll");
                if (roll < tag.func_74762_e("max_roll")) {
                    tag.func_74768_a("roll", roll + 1);
                }
                tag.func_74768_a("fail_roll", NBTHelp.getIntSafe("fail_roll", tag, 0) + 1);
                return 2;
            }
        }
        return 2;
    }

    public static boolean canAddRoll(ItemStack item) {
        NBTTagCompound tag;
        int roll;
        return item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10) && (roll = (tag = item.func_77978_p().func_74775_l(nbtid)).func_74762_e("roll")) < tag.func_74762_e("max_roll");
    }

    public static int addItemStrengthenLore(ItemStack item, List<String> texts, String line) {
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10)) {
            boolean isArmor = item.func_77973_b() instanceof ItemArmor;
            NBTTagCompound tag = item.func_77978_p().func_74775_l(nbtid);
            texts.add(line);
            int roll = tag.func_74762_e("roll");
            int star = tag.func_74762_e("star");
            if (!isArmor) {
                texts.add("\ue008\ue018" + MMM.getTranslateText("item.weapon.effects.roll") + roll + " / " + tag.func_74762_e("max_roll"));
                texts.add("\ue008\ue014" + MMM.getTranslateText("item.weapon.effects.star") + star + " / " + tag.func_74762_e("max_star"));
            }
            if (!isArmor) {
                texts.add("\ue008\ue00d" + MMM.getTranslateText("item.weapon.effects.roll.quality") + ItemStrengthenHelp.getWeaponAttackQuality(item, MMM.getEquipmentNeedLV(item), tag.func_74762_e("quality")));
                texts.add("\ue008\ue018" + MMM.getTranslateText("item.weapon.effects.roll.attack") + tag.func_74762_e("attack"));
                texts.add(ItemStrengthenHelp.getmagic_jade(tag.func_74762_e("magic_jade1"), 1) + MMM.getTranslateText("item.weapon.effects.magic_jade1") + ItemStrengthenHelp.gemName(tag.func_74762_e("magic_jade1"), 1));
                texts.add(ItemStrengthenHelp.getmagic_jade(tag.func_74762_e("magic_jade2"), 2) + MMM.getTranslateText("item.weapon.effects.magic_jade2") + ItemStrengthenHelp.gemName(tag.func_74762_e("magic_jade2"), 2));
                texts.add(ItemStrengthenHelp.getmagic_jade(tag.func_74762_e("magic_jade3"), 3) + MMM.getTranslateText("item.weapon.effects.magic_jade3") + ItemStrengthenHelp.gemName(tag.func_74762_e("magic_jade3"), 3));
            }
            if (isArmor) {
                texts.add("\ue008\ue018" + MMM.getTranslateText("item.armor.effects.roll.quality") + tag.func_74762_e("quality") + "%");
            }
            if (roll > 0) {
                int fail_roll = 0;
                if (tag.func_150297_b("fail_roll", 3)) {
                    fail_roll = tag.func_74762_e("fail_roll");
                }
                texts.set(0, texts.get(0) + "(+" + (roll - fail_roll) + ")");
            }
            if (star > 0) {
                texts.set(0, texts.get(0) + ItemStrengthenHelp.getStar(tag, star));
            }
            if (!isArmor) {
                if (star > 0) {
                    texts.add(EnumChatFormatting.GOLD + "\ue008" + "\ue014" + MMM.getTranslateText("star_attack.data") + star * 10 + "%");
                }
                if (tag.func_150297_b("star_effect3", 3)) {
                    texts.add(EnumChatFormatting.GOLD + "\ue008" + "\ue014" + MMM.getTranslateText("star_effect3." + tag.func_74762_e("star_effect3")));
                }
                if (tag.func_150297_b("star_effect5", 3)) {
                    texts.add(EnumChatFormatting.GOLD + "\ue008" + "\ue014" + MMM.getTranslateText("star_effect5." + tag.func_74762_e("star_effect5")));
                }
                if (tag.func_150297_b("star_effect10", 3)) {
                    texts.add(EnumChatFormatting.GOLD + "\ue008" + "\ue014" + MMM.getTranslateText("star_effect10." + tag.func_74762_e("star_effect10")));
                }
            }
        }
        return ItemStrengthenHelp.getWeaponAttack(item);
    }

    public static final String gemName(int id, int type) {
        if (id != 0) {
            switch (type) {
                case 1: {
                    return new ItemStack(GemCraftCore.ItemMagicJadeRED, 1, id).func_82833_r();
                }
                case 2: {
                    return new ItemStack(GemCraftCore.ItemMagicJadeBLUE, 1, id).func_82833_r();
                }
                case 3: {
                    return new ItemStack(GemCraftCore.ItemMagicJadeYELLOW, 1, id).func_82833_r();
                }
            }
        }
        return MMM.getTranslateText("item.weapon.effects.magic_jade.null");
    }

    public static void getWeaponStarEvent(ItemStack item, AttackEffect data, EntityPlayer player, EntityLivingBase target, ManaMetalModRoot rootPlayer, ManaMetalModRoot rootTarget, DamageSource source, float damage, boolean cantrigger) {
        if (item == null) {
            return;
        }
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10)) {
            NBTTagCompound tag = item.func_77978_p().func_74775_l(nbtid);
            if (tag.func_150297_b("star", 3)) {
                float attackdata = 0.1f * (float)tag.func_74762_e("star");
                data.attack += attackdata;
            } else {
                return;
            }
            if (tag.func_150297_b("star_effect3", 3)) {
                switch (tag.func_74762_e("star_effect3")) {
                    case 1: {
                        data.crit += 8;
                        break;
                    }
                    case 2: {
                        data.attack_base += 16;
                        break;
                    }
                    case 3: {
                        ++data.penetration_base;
                    }
                }
            }
            if (tag.func_150297_b("star_effect5", 3)) {
                switch (tag.func_74762_e("star_effect5")) {
                    case 1: {
                        data.crit += 16;
                        break;
                    }
                    case 2: {
                        data.attack_base += 24;
                        break;
                    }
                    case 3: {
                        data.penetration_base += 3;
                    }
                }
            }
            if (tag.func_150297_b("star_effect10", 3)) {
                switch (tag.func_74762_e("star_effect10")) {
                    case 1: {
                        data.hp_blood += 0.1f;
                        break;
                    }
                    case 2: {
                        if (!(target instanceof IBossDisplayData)) break;
                        data.attack += 0.3f;
                        break;
                    }
                    case 3: {
                        data.penetration_base += 8;
                        break;
                    }
                    case 4: {
                        data.final_attack += 0.07f;
                        break;
                    }
                    case 5: {
                        data.attack_base += 64;
                    }
                }
            }
        }
    }

    public static int getWeaponAttackQuality(ItemStack item, int LV2, int quality) {
        return quality > 10 ? (quality / 4 + LV2 / 14) * quality : (1 + LV2 / 20) * quality;
    }

    public static int getWeaponAttackRoll(ItemStack item) {
        if (item == null) {
            return 0;
        }
        int attack = 0;
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(nbtid, 10)) {
            int id;
            NBTTagCompound tag = item.func_77978_p().func_74775_l(nbtid);
            attack += NBTHelp.getIntSafe("attack", tag, 0);
            int LV2 = MMM.getEquipmentNeedLV(item);
            int quality = NBTHelp.getIntSafe("quality", tag, 0);
            attack += ItemStrengthenHelp.getWeaponAttackQuality(item, LV2, quality);
            if (tag.func_150297_b("extra_attack", 3)) {
                attack += tag.func_74762_e("extra_attack");
            }
            if ((id = tag.func_74762_e("magic_jade2")) > 0) {
                attack = id < 50 ? (attack += id + 1) : (attack += id - 49);
            }
        }
        if (attack < 0) {
            attack = 0;
        }
        return attack;
    }

    public static String getStar(NBTTagCompound tag, int star) {
        StringBuilder sb = new StringBuilder();
        if (tag.func_150297_b("has_loveletter", 1)) {
            sb.append(EnumChatFormatting.WHITE);
            for (int s = 0; s < star; ++s) {
                sb.append("\ue003");
            }
        } else {
            for (int s = 0; s < star; ++s) {
                sb.append("\ue014");
            }
        }
        return sb.toString();
    }

    public static String getmagic_jade(int id, int type) {
        if (id != 0) {
            switch (type) {
                case 1: {
                    return "\ue008\ue01a";
                }
                case 2: {
                    return "\ue008\ue010";
                }
                case 3: {
                    return "\ue008\ue019";
                }
            }
        }
        return "\ue008\ue00f";
    }

    public static List<ItemStack> getItems(int type, int color, int extra_attack, String name) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Tools tools = ItemStrengthenHelp.getNpcWeapon(type);
        Quality Qualitys = ItemStrengthenHelp.getItemQualitys(false, false);
        ItemStack sword = ItemStrengthenHelp.getRenderWeaponColorName(tools.sword, color, extra_attack, name);
        ItemStack dagger = ItemStrengthenHelp.getRenderWeaponColorName(tools.dagger, color, extra_attack, name);
        ItemStack hammer = ItemStrengthenHelp.getRenderWeaponColorName(tools.hammer, color, extra_attack, name);
        ItemStack Bow = ItemStrengthenHelp.getRenderWeaponColorName(tools.Bow, color, extra_attack, name);
        ItemStack BlowingArrows = ItemStrengthenHelp.getRenderWeaponColorName(tools.BlowingArrows, color, extra_attack, name);
        ItemStack book = ItemStrengthenHelp.getRenderWeaponColorName(tools.book, color, extra_attack, name);
        ItemStack MagicWand = ItemStrengthenHelp.getRenderWeaponColorName(tools.MagicWand, color, extra_attack, name);
        ItemStack sickle = ItemStrengthenHelp.getRenderWeaponColorName(tools.sickle, color, extra_attack, name);
        ItemStack fan = ItemStrengthenHelp.getRenderWeaponColorName(tools.fan, color, extra_attack, name);
        ItemStack Katana = ItemStrengthenHelp.getRenderWeaponColorName(tools.Katana, color, extra_attack, name);
        ItemStack Javelin = ItemStrengthenHelp.getRenderWeaponColorName(tools.Javelin, color, extra_attack, name);
        ItemStack Shortcane = ItemStrengthenHelp.getRenderWeaponColorName(tools.Shortcane, color, extra_attack, name);
        list.add(sword);
        list.add(dagger);
        list.add(hammer);
        list.add(Bow);
        list.add(BlowingArrows);
        list.add(book);
        list.add(MagicWand);
        list.add(sickle);
        list.add(fan);
        list.add(Katana);
        list.add(Javelin);
        list.add(Shortcane);
        return list;
    }

    public static final ItemStack getRenderWeaponColorName(Item item, int color, int extra_attack, String name1) {
        ItemStack items = new ItemStack(item);
        ItemStrengthenHelp.addSwordNBT(items);
        items.func_77978_p().func_74768_a("CustomColor", color);
        items.func_77978_p().func_74775_l(nbtid).func_74768_a("extra_attack", extra_attack);
        items.func_151001_c(EnumChatFormatting.WHITE + name1 + items.func_82833_r());
        return items;
    }

    public static List<Icommodity> getItems(int type, Random rand) {
        ArrayList<Icommodity> list = new ArrayList<Icommodity>();
        Tools tools = ItemStrengthenHelp.getNpcWeapon(type);
        int color = colors[rand.nextInt(colors.length)];
        int emeLV = 1 + rand.nextInt(30);
        int moneys = money[type];
        int extra_attack = rand.nextInt(21);
        int name1 = rand.nextInt(51);
        int name2 = rand.nextInt(51);
        int final_money = (int)((float)moneys + (float)moneys * ((float)extra_attack * 0.1f));
        if (final_money > 1000000000) {
            final_money = 1000000000;
        }
        int special_power = rand.nextInt(10);
        Quality Qualitys = ItemStrengthenHelp.getItemQualitys(false, false);
        ItemStack sword = ItemStrengthenHelp.getRandomWeaponColor(tools.sword, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack dagger = ItemStrengthenHelp.getRandomWeaponColor(tools.dagger, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack hammer = ItemStrengthenHelp.getRandomWeaponColor(tools.hammer, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack Bow = ItemStrengthenHelp.getRandomWeaponColor(tools.Bow, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack BlowingArrows = ItemStrengthenHelp.getRandomWeaponColor(tools.BlowingArrows, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack book = ItemStrengthenHelp.getRandomWeaponColor(tools.book, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack MagicWand = ItemStrengthenHelp.getRandomWeaponColor(tools.MagicWand, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack sickle = ItemStrengthenHelp.getRandomWeaponColor(tools.sickle, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack fan = ItemStrengthenHelp.getRandomWeaponColor(tools.fan, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack Shortcane = ItemStrengthenHelp.getRandomWeaponColor(tools.Shortcane, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack Katana = ItemStrengthenHelp.getRandomWeaponColor(tools.Katana, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        ItemStack Javelin = ItemStrengthenHelp.getRandomWeaponColor(tools.Javelin, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand);
        list.add(new Icommodity(sword, final_money));
        list.add(new Icommodity(dagger, final_money));
        list.add(new Icommodity(hammer, final_money));
        list.add(new Icommodity(Bow, final_money));
        list.add(new Icommodity(BlowingArrows, final_money));
        list.add(new Icommodity(book, final_money));
        list.add(new Icommodity(MagicWand, final_money));
        list.add(new Icommodity(sickle, final_money));
        list.add(new Icommodity(fan, final_money));
        list.add(new Icommodity(Shortcane, final_money));
        list.add(new Icommodity(Katana, final_money));
        list.add(new Icommodity(Javelin, final_money));
        return list;
    }

    public static final ItemStack getRandomWeaponColor(Item item, int color, int emeLV, int extra_attack, int name1, int name2, Quality Qualitys, int special_power, Random rand) {
        ItemStack items = new ItemStack(item);
        ItemStrengthenHelp.addSwordNBT(items, Qualitys);
        items.func_77978_p().func_74768_a("CustomColor", color);
        EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)items, (int)emeLV);
        items.func_77978_p().func_74775_l(nbtid).func_74768_a("extra_attack", extra_attack);
        items.func_151001_c(EnumChatFormatting.WHITE + MMM.getTranslateText("npc.weapon.1." + name1) + MMM.getTranslateText("npc.weapon.2." + name2) + items.func_82833_r());
        ItemCustomizeTools.setIItemCustomizeTag(items, special_power);
        return items;
    }

    public static final Tools getNpcWeapon(int type) {
        if (type == 0) {
            return WeaponCore.NPCT1;
        }
        if (type == 1) {
            return WeaponCore.NPCT2;
        }
        if (type == 2) {
            return WeaponCore.NPCT3;
        }
        return WeaponCore.NPCT1;
    }

    public static final boolean darkPower(ItemStack item, EntityPlayer player, ManaMetalModRoot rootPlayer, AttackEffect data) {
        boolean isDarkPower = false;
        if (!PotionEffectM3.isPotion(rootPlayer, PotionM3.potionDake)) {
            int power;
            if (item.field_77990_d != null && item.field_77990_d.func_150297_b("darkPower", 3) && (power = item.field_77990_d.func_74762_e("darkPower")) > 0) {
                item.field_77990_d.func_74768_a("darkPower", power - 1);
                if (power <= 100) {
                    PotionEffectM3.addPotion(rootPlayer, PotionM3.potionDake, 600, 0);
                    isDarkPower = true;
                } else {
                    int LV2 = power / 100;
                    PotionEffectM3.addPotion(rootPlayer, PotionM3.potionDake, 600, LV2);
                    isDarkPower = true;
                }
            }
        } else {
            return true;
        }
        return isDarkPower;
    }

    public static Quality getItemQualitys(boolean has_black_ball, boolean has_gold_ball) {
        int rand = MMM.rand.nextInt(10000);
        if (rand < 1000) {
            return Quality.Sophisticated;
        }
        if (rand < 2000) {
            return Quality.Rare;
        }
        if (rand < 6000) {
            return Quality.Normal;
        }
        return Quality.Junk;
    }
}

