/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.seasontarget;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.seasontarget.SeasonTargetRewardItem;
import project.studio.manametalmod.seasontarget.SeasonTargetRewardList;

public class SeasonTargetReward {
    public static final Map<String, SeasonTargetRewardList> SeasonTargetRewardPool = new HashMap<String, SeasonTargetRewardList>();
    public static final String key = "SeasonTargetReward";
    public static final String keyList = "SeasonTargetRewardList";
    public static final String keyPlayerName = "SeasonTargetRewardPlayer";
    public static final int[] need = new int[]{0, 100, 500, 1000, 1500, 2000, 2500, 3000};

    public static int needGold(int pick) {
        if (pick < 1) {
            return 0;
        }
        if (pick < need.length) {
            return need[pick];
        }
        return need[need.length - 1];
    }

    public static int count(EntityPlayer player, ItemStack item) {
        SeasonTargetRewardList temp = SeasonTargetReward.get(player);
        int size = temp.list.size();
        for (int s = 0; s < size; ++s) {
            SeasonTargetRewardItem tempitem = temp.list.get(s);
            if (tempitem.item != item.func_77973_b() || tempitem.metadata != item.func_77960_j()) continue;
            return tempitem.pickCount;
        }
        return 0;
    }

    public static void pick(EntityPlayer player, ItemStack item) {
        SeasonTargetRewardList temp = SeasonTargetReward.get(player);
        int size = temp.list.size();
        for (int s = 0; s < size; ++s) {
            SeasonTargetRewardItem tempitem = temp.list.get(s);
            if (tempitem.item != item.func_77973_b() || tempitem.metadata != item.func_77960_j()) continue;
            ++tempitem.pickCount;
            return;
        }
        temp.list.add(new SeasonTargetRewardItem(item.func_77973_b(), item.field_77994_a, item.func_77960_j(), 1));
    }

    public static SeasonTargetRewardList get(EntityPlayer player) {
        String name = player.func_70005_c_();
        if (SeasonTargetRewardPool.containsKey(name)) {
            return SeasonTargetRewardPool.get(name);
        }
        SeasonTargetRewardList list = new SeasonTargetRewardList(name);
        SeasonTargetRewardPool.put(name, list);
        return list;
    }

    public static void load(WorldEvent.Load event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getSeasonTargetRewardData().func_150297_b(key, 9)) {
            SeasonTargetRewardPool.clear();
            NBTTagList list = MMM.getWorldData(event.world).getSeasonTargetRewardData().func_150295_c(key, 10);
            int size = list.func_74745_c();
            for (int s = 0; s < size; ++s) {
                NBTTagCompound tag = list.func_150305_b(s);
                String playername = tag.func_74779_i(keyPlayerName);
                SeasonTargetRewardPool.put(playername, SeasonTargetRewardList.readFromNBT(tag, playername));
                MMM.Logg("load Season Target Reward ", playername);
            }
        }
    }

    public static void save(WorldEvent.Save event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, SeasonTargetRewardList> entry : SeasonTargetRewardPool.entrySet()) {
                SeasonTargetRewardList temp = entry.getValue();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(keyPlayerName, entry.getKey());
                SeasonTargetRewardList.saveToNBT(tag, temp);
                list.func_74742_a((NBTBase)tag);
            }
            MMM.getWorldData(event.world).getSeasonTargetRewardData().func_74782_a(key, (NBTBase)list);
            MMM.getWorldData(event.world).func_76185_a();
        }
    }
}

