/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.skyadventure;

import project.studio.manametalmod.MMM;

public enum Battleship {
    None,
    Boat,
    PatrolBoat,
    Destroyer,
    Cruiser,
    Mainship,
    Super1,
    Super2;

    public static final int maxLV = 10;
    final String[] items = new String[]{"ingotCopper", "ingotIron", "ingotAluminum", "gunpowder", "gearIron", "plateIron"};

    public int[] getAttributes() {
        switch (this) {
            case Boat: {
                return new int[]{200, 1};
            }
            case PatrolBoat: {
                return new int[]{300, 2};
            }
            case Cruiser: {
                return new int[]{400, 3};
            }
            case Destroyer: {
                return new int[]{550, 4};
            }
            case Mainship: {
                return new int[]{700, 5};
            }
            case Super1: {
                return new int[]{950, 5};
            }
            case Super2: {
                return new int[]{1300, 5};
            }
        }
        return new int[]{0, 0};
    }

    public String names() {
        return MMM.getTranslateText("Battleship." + this.toString());
    }

    public String lores() {
        return MMM.getTranslateText("Battleship." + this.toString() + ".lore");
    }

    public int[] getUpNeeds(int LV2) {
        switch (this) {
            case Boat: {
                return new int[]{LV2 * 100, LV2 * 50};
            }
            case PatrolBoat: {
                return new int[]{LV2 * 1500, LV2 * 350};
            }
            case Cruiser: {
                return new int[]{LV2 * 15000, LV2 * 850};
            }
            case Destroyer: {
                return new int[]{LV2 * 250000, LV2 * 1800};
            }
            case Mainship: {
                return new int[]{LV2 * 2500000, LV2 * 2500};
            }
            case Super1: {
                return new int[]{LV2 * 3500000, LV2 * 3500};
            }
            case Super2: {
                return new int[]{LV2 * 4500000, LV2 * 4500};
            }
        }
        return null;
    }

    public String[] getUpNeedsOre() {
        return this.items;
    }

    public int getUPHP() {
        switch (this) {
            case Boat: {
                return 10;
            }
            case PatrolBoat: {
                return 15;
            }
            case Cruiser: {
                return 30;
            }
            case Destroyer: {
                return 40;
            }
            case Mainship: {
                return 50;
            }
            case Super1: {
                return 55;
            }
            case Super2: {
                return 60;
            }
        }
        return 0;
    }

    public int getMoneyNeed() {
        switch (this) {
            case Boat: {
                return 100;
            }
            case PatrolBoat: {
                return 10000;
            }
            case Destroyer: {
                return 50000;
            }
            case Cruiser: {
                return 3000000;
            }
            case Mainship: {
                return 10000000;
            }
            case Super1: {
                return 50000000;
            }
            case Super2: {
                return 350000000;
            }
        }
        return 0;
    }
}

