/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.soulinherit;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.instance_dungeon.IDungeonBoss;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.magic.magicItem.MagicItemType;
import project.studio.manametalmod.soulinherit.BlockTileEntitySoulInheritPower;
import project.studio.manametalmod.soulinherit.ISoulRemember;
import project.studio.manametalmod.soulinherit.ItemSoulEvolution;
import project.studio.manametalmod.soulinherit.ItemSoulRemember;
import project.studio.manametalmod.soulinherit.TileEntitySoulInheritPower;
import project.studio.manametalmod.world.thuliumempire.ThuliumEmpireCore;

public class SoulInheritPower {
    public static final int maxLV = 15;
    public static final int[] need = new int[15];
    public static final MagicItemType[] power_types = new MagicItemType[]{MagicItemType.attackMultiplier, MagicItemType.mixAttack, MagicItemType.MaxDamage, MagicItemType.penetrate, MagicItemType.FinalAttack, MagicItemType.magicDefense, MagicItemType.HP, MagicItemType.dropRate, MagicItemType.Insight, MagicItemType.Willpower};
    public static final float[] effects = new float[]{0.15f, 15.0f, 50000.0f, 1.0f, 0.01f, 30.0f, 1000.0f, 3.0f, 0.01f, 0.01f};
    public static final boolean[] effectstype = new boolean[]{true, false, false, false, true, false, false, false, true, true};
    public static final MagicItemType[] remember_types = new MagicItemType[]{MagicItemType.attackMultiplier, MagicItemType.magicDefense, MagicItemType.HP, MagicItemType.dropRate, MagicItemType.Insight, MagicItemType.Willpower, MagicItemType.craft};
    public static final float[] remember_effects = new float[]{0.02f, 5.0f, 500.0f, 1.0f, 0.01f, 0.01f, 0.01f};
    public static final Item ItemSoulRemembers;
    public static final Item ItemSoulEvolutions;
    public static final Block BlockTileEntitySoulInheritPowers;

    public static final void init() {
        GameRegistry.registerItem((Item)ItemSoulRemembers, (String)"ItemSoulRemembers");
        GameRegistry.registerItem((Item)ItemSoulEvolutions, (String)"ItemSoulEvolutions");
        GameRegistry.registerTileEntity(TileEntitySoulInheritPower.class, (String)"TileEntitySoulInheritPower");
        GameRegistry.registerBlock((Block)BlockTileEntitySoulInheritPowers, (String)"BlockTileEntitySoulInheritPowers");
        ManaMetalAPI.addAncientEmpireRecipeList(new ItemStack(BlockTileEntitySoulInheritPowers, 1), 3000, ThuliumEmpireCore.soul(10), ThuliumEmpireCore.dark(32), ThuliumEmpireCore.ingot(32), ThuliumEmpireCore.hs(10), new ItemStack(ThuliumEmpireCore.Soulstone.ingot, 16), new ItemStack(ThuliumEmpireCore.EvilFragments, 3));
    }

    public static ItemStack getItemSoulRemembers(IDungeonBoss mob, ManaElements eme) {
        int s;
        ItemStack item = new ItemStack(ItemSoulRemembers, 1, eme.ordinal());
        ISoulRemember soul = (ISoulRemember)item.func_77973_b();
        List<MagicItemType> list = SoulInheritPower.getRemember_types(mob);
        NBTTagList listEffect = new NBTTagList();
        int[] ids = new int[list.size()];
        float[] val = new float[list.size()];
        for (s = 0; s < val.length; ++s) {
            val[s] = remember_effects[s];
            ids[s] = remember_types[s].ordinal();
        }
        for (s = 0; s < val.length; ++s) {
            listEffect.func_74742_a((NBTBase)new NBTTagFloat(val[s]));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("listID", ids);
        tag.func_74782_a("listEffect", (NBTBase)listEffect);
        tag.func_74768_a("awakeningLVKey", 1);
        item.func_77982_d(tag);
        long code = soul.getCheckCode(item);
        item.func_77978_p().func_74772_a("checkcodebaseKey", code);
        return item;
    }

    public static long mobSeed(IDungeonBoss mob) {
        MMM.Logg("mob : " + mob.getClass().getSimpleName());
        MMM.Logg("type : " + mob.getType());
        MMM.Logg("code : " + mob.getClass().getSimpleName().hashCode());
        return mob.getClass().getSimpleName().hashCode();
    }

    public static List<MagicItemType> getRemember_types(IDungeonBoss mob) {
        MagicItemType[] data = new MagicItemType[3];
        Random random = new Random(SoulInheritPower.mobSeed(mob));
        ArrayList list = new ArrayList();
        Collections.addAll(list, remember_types);
        Collections.shuffle(list, random);
        List<MagicItemType> result = list.subList(0, 3);
        return result;
    }

    public static final boolean canAddPoint(int now, int point) {
        if (now >= 15) {
            return false;
        }
        return point >= now * 2;
    }

    public static final int getNeedPoint(int up, int old) {
        int temp = 0;
        for (int s = 0; s < up; ++s) {
            temp += need[old + s];
        }
        return temp;
    }

    public static AttackEffect attack(AttackEffect data, EntityPlayer player, EntityLivingBase target, DamageSource source, ManaMetalModRoot root_player, ManaMetalModRoot root_target) {
        return data;
    }

    public static AttackEffect beattack(AttackEffect data, EntityPlayer player, EntityLivingBase target, DamageSource source, ManaMetalModRoot root_player, ManaMetalModRoot root_target) {
        return data;
    }

    static {
        for (int s = 0; s < 15; ++s) {
            SoulInheritPower.need[s] = (s + 1) * 2;
        }
        ItemSoulRemembers = new ItemSoulRemember();
        ItemSoulEvolutions = new ItemSoulEvolution();
        BlockTileEntitySoulInheritPowers = new BlockTileEntitySoulInheritPower();
    }
}

