/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.blocks.BlockTileEntityEXPExtractor;
import project.studio.manametalmod.items.crafting.EXPExtractorRecipes;
import project.studio.manametalmod.magicenergy.IMagicEnergyUse;
import project.studio.manametalmod.magicenergy.MagicEnergy;

public class TileEntityEXPExtractor
extends TileEntity
implements ISidedInventory,
IMagicEnergyUse {
    private ItemStack[] inventory;
    private String customName;
    MagicEnergy energy;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    private int[] hopperInput = new int[]{1, 0};
    private int[] hopperOutput = new int[]{2};

    public int[] func_94128_d(int par1) {
        if (par1 == 0) {
            return this.hopperOutput;
        }
        return this.hopperInput;
    }

    public TileEntityEXPExtractor() {
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.energy = new MagicEnergy(0);
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.inventory[p_70301_1_];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.inventory[p_70298_1_] != null) {
            if (this.inventory[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.inventory[p_70298_1_];
                this.inventory[p_70298_1_] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.inventory[p_70298_1_].field_77994_a == 0) {
                this.inventory[p_70298_1_] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.inventory[p_70304_1_] != null) {
            ItemStack itemstack = this.inventory[p_70304_1_];
            this.inventory[p_70304_1_] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inventory[p_70299_1_] = p_70299_2_;
        if (p_70299_2_ != null && p_70299_2_.field_77994_a > this.func_70297_j_()) {
            p_70299_2_.field_77994_a = this.func_70297_j_();
        }
    }

    public void setInventoryName(String name) {
        if (name != null && !name.equals("")) {
            this.customName = name;
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.TileEntityEXPExtractor";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return p_94041_1_ == 2 ? false : (p_94041_1_ == 1 ? true : true);
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return this.func_94041_b(p_102007_1_, p_102007_2_);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return p_102008_3_ != 0 || p_102008_1_ != 1 || p_102008_2_.func_77973_b() == Items.field_151133_ar;
    }

    public static boolean isItemFuel(ItemStack item) {
        return TileEntityEXPExtractor.getItemBurnTime(item) > 0;
    }

    public static int getItemBurnTime(ItemStack items) {
        return MMM.getManaItemFuelTime(items);
    }

    public void func_145839_a(NBTTagCompound p_145839_1_) {
        super.func_145839_a(p_145839_1_);
        NBTTagList nbttaglist = p_145839_1_.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = p_145839_1_.func_74765_d("BurnTime");
        this.furnaceCookTime = p_145839_1_.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityEXPExtractor.getItemBurnTime(this.inventory[1]);
        if (p_145839_1_.func_150297_b("CustomName", 8)) {
            this.customName = p_145839_1_.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound p_145841_1_) {
        super.func_145841_b(p_145841_1_);
        p_145841_1_.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        p_145841_1_.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        p_145841_1_.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            p_145841_1_.func_74778_a("CustomName", this.customName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int p_145953_1_) {
        return this.furnaceCookTime * p_145953_1_ / 400;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 400;
        }
        return this.furnaceBurnTime * p_145955_1_ / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_145845_h() {
        if (this.energy.getEnergy() > 0 && this.inventory[0] != null && this.furnaceBurnTime < 400) {
            this.furnaceBurnTime += 4;
            this.energy.removeEnergy(1);
            BlockTileEntityEXPExtractor.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime != 0 || this.inventory[1] != null && this.inventory[0] != null) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityEXPExtractor.getItemBurnTime(this.inventory[1]);
                    if (this.furnaceBurnTime > 0) {
                        flag1 = true;
                        if (this.inventory[1] != null) {
                            --this.inventory[1].field_77994_a;
                            if (this.inventory[1].field_77994_a == 0) {
                                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 400) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                BlockTileEntityEXPExtractor.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = EXPExtractorRecipes.smelting().getSmeltingResult(this.inventory[0]);
            if (this.inventory[2] == null) {
                this.inventory[2] = itemstack.func_77946_l();
            } else if (this.inventory[2].func_77973_b() == itemstack.func_77973_b()) {
                this.inventory[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    private boolean canSmelt() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = EXPExtractorRecipes.smelting().getSmeltingResult(this.inventory[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventory[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.inventory[2].func_77976_d();
    }

    @Override
    public boolean needEnergy() {
        return this.energy.getEnergy() < this.getMaxEnergy();
    }

    @Override
    public void onImportEnergy() {
    }

    @Override
    public void addEnergy(MagicEnergy energy) {
    }

    @Override
    public int getMaxEnergy() {
        return 150;
    }

    @Override
    public MagicEnergy getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canImport() {
        return true;
    }
}

