/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IQualityPearl;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;

public class TileEntityQualityTable
extends TileEntity
implements ISidedInventory {
    public ItemStack[] items = new ItemStack[2];
    public int time = 0;
    public int white = 0;
    public boolean canstart = false;

    public void done() {
        this.time = 10;
        this.white = 10;
    }

    public static final int getChangeQualityMoney(TileEntityQualityTable tile, EntityPlayer player, ManaMetalModRoot root) {
        int weaponLV = 1;
        Quality nowQuality = TileEntityQualityTable.getQuality(tile.func_70301_a(1));
        float modifier = 1.0f;
        if (tile.func_70301_a(1) != null && (weaponLV = MMM.getEquipmentNeedLV(tile.func_70301_a(1))) <= 0) {
            weaponLV = 1;
        }
        if (tile.func_70301_a(0) != null && tile.func_70301_a(0).func_77973_b() instanceof IQualityPearl) {
            IQualityPearl QP = (IQualityPearl)tile.func_70301_a(0).func_77973_b();
            modifier = QP.getMoneyModifier(tile.func_70301_a(0), tile.func_70301_a(1), player, tile);
        }
        return (int)((double)(weaponLV * nowQuality.ordinal()) * (0.15 + (double)nowQuality.ordinal() * 0.125) * 7500.0 * (double)modifier);
    }

    public static final boolean canQuality(TileEntityQualityTable tile, EntityPlayer player, ManaMetalModRoot root) {
        Quality maxQuality = Quality.Epic;
        Quality nowQuality = TileEntityQualityTable.getQuality(tile.func_70301_a(1));
        if (tile.func_70301_a(0) != null && tile.func_70301_a(0).func_77973_b() instanceof IQualityPearl) {
            IQualityPearl QP = (IQualityPearl)tile.func_70301_a(0).func_77973_b();
            maxQuality = QP.getMaxQuality(tile.func_70301_a(0), tile.func_70301_a(1), player, tile);
        }
        return nowQuality != Quality.Unknown && nowQuality.ordinal() < maxQuality.ordinal() && nowQuality.ordinal() < Quality.Unknown.ordinal() - 1;
    }

    public static Quality getQuality(ItemStack item) {
        Quality data = Quality.Junk;
        if (item.func_77942_o() && item.func_77978_p().func_150297_b("weapon_strengthen", 10)) {
            data = Quality.values()[item.func_77978_p().func_74775_l("weapon_strengthen").func_74762_e("quality")];
        }
        return data;
    }

    public static float success(Quality quality) {
        switch (quality) {
            case Unknown: {
                return 0.0f;
            }
            case Junk: {
                return 1.0f;
            }
            case Normal: {
                return 1.0f;
            }
            case Rare: {
                return 0.8f;
            }
            case Sophisticated: {
                return 0.7f;
            }
            case VeryRare: {
                return 0.5f;
            }
            case Excellent: {
                return 0.4f;
            }
            case Epic: {
                return 0.3f;
            }
            case Ancient: {
                return 0.2f;
            }
            case Myth: {
                return 0.1f;
            }
            case Legend: {
                return 0.05f;
            }
            case Holy: {
                return 0.025f;
            }
            case Super: {
                return 0.01f;
            }
            case Create: {
                return 0.01f;
            }
            case Evil: {
                return 0.01f;
            }
            case Chaos: {
                return 0.01f;
            }
            case Peerless: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int id, int data) {
        if (this.items[id] != null) {
            if (this.items[id].field_77994_a <= data) {
                ItemStack itemstack = this.items[id];
                this.items[id] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[id].func_77979_a(data);
            if (this.items[id].field_77994_a == 0) {
                this.items[id] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] != null) {
            ItemStack itemstack = this.items[slot];
            this.items[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.items[slot] = item;
    }

    public String func_145825_b() {
        return "TileEntityQualityTab";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public int[] func_94128_d(int data) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int face) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int face) {
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.length) continue;
            this.items[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.time = NBTHelp.getIntSafe("time", tag, 0);
        this.canstart = NBTHelp.getBooleanSafe("CanStart", tag, false);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        tag.func_74768_a("time", this.time);
        tag.func_74757_a("CanStart", this.canstart);
    }

    public void func_145845_h() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.time > 0) {
                --this.time;
            }
            if (this.white > 0) {
                --this.white;
            }
        }
    }
}

