/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.biome;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;

public class BiomePineForest
extends BiomeGenBase {
    public static Block log = GameRegistry.findBlock((String)MMM.getMODID(), (String)"wood_log_pinetree");
    public static Block leave = GameRegistry.findBlock((String)MMM.getMODID(), (String)"wood_leave_pinetree");

    public BiomePineForest(int ID) {
        super(ID);
        this.func_76735_a("Pine Forest");
        this.field_76752_A = Blocks.field_150349_c;
        this.field_76753_B = Blocks.field_150346_d;
        this.field_76750_F = 0.5f;
        this.field_76751_G = 0.0f;
        this.field_76760_I.field_76832_z = 6;
        this.field_76760_I.field_76802_A = 10;
        this.field_76760_I.field_76803_B = 8;
        this.field_76765_S = false;
        this.addFlowers();
    }

    public void addFlowers() {
        int s;
        this.flowers.clear();
        for (s = 0; s < 16; ++s) {
            this.flowers.add(new BiomeGenBase.FlowerEntry(ItemCraft10.Flowers, s, 10));
        }
        for (s = 0; s < 9; ++s) {
            this.flowers.add(new BiomeGenBase.FlowerEntry((Block)Blocks.field_150328_O, s, 10));
        }
        this.flowers.add(new BiomeGenBase.FlowerEntry((Block)Blocks.field_150327_N, 0, 10));
    }

    public void func_76728_a(World world, Random random, int ChunkX, int ChunkZ) {
        for (int s = 0; s < 5; ++s) {
            int x = ChunkX + random.nextInt(16) + 8;
            int z = ChunkZ + random.nextInt(16) + 8;
            BiomePineForest.spawnTree(world, x, world.func_72976_f(x, z), z, random);
        }
        super.func_76728_a(world, random, ChunkX, ChunkZ);
    }

    public static void spawnTree(World world, int x, int y, int z, Random rand) {
        int dz;
        int s;
        int dz2;
        int dx;
        Block block = world.func_147439_a(x, y - 1, z);
        boolean canPush = block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
        int logHight = rand.nextInt(6) + 3;
        if (!canPush) {
            return;
        }
        for (int dy = 0; dy < 27 + logHight; ++dy) {
            for (dx = -1; dx < 2; ++dx) {
                for (dz2 = -1; dz2 < 2; ++dz2) {
                    if (MMM.isReplaceBlock(world, x + dx, y + dy, z + dz2)) continue;
                    return;
                }
            }
        }
        for (s = 0; s < 9; ++s) {
            for (dx = -2; dx < 3; ++dx) {
                for (dz2 = -1; dz2 < 2; ++dz2) {
                    world.func_147465_d(x + dx, y + logHight + s * 2, z + dz2, leave, 0, 2);
                }
            }
            for (dx = -1; dx < 2; ++dx) {
                for (dz2 = -2; dz2 < 3; ++dz2) {
                    world.func_147465_d(x + dx, y + logHight + s * 2, z + dz2, leave, 0, 2);
                }
            }
            for (dx = -1; dx < 2; ++dx) {
                world.func_147465_d(x + dx, y + logHight + s * 2 + 1, z, leave, 0, 2);
            }
            for (dz = -1; dz < 2; ++dz) {
                world.func_147465_d(x, y + logHight + s * 2 + 1, z + dz, leave, 0, 2);
            }
        }
        for (s = 0; s < 2; ++s) {
            for (dx = -1; dx < 2; ++dx) {
                world.func_147465_d(x + dx, y + logHight + 18 + s * 2, z, leave, 0, 2);
            }
            for (dz = -1; dz < 2; ++dz) {
                world.func_147465_d(x, y + logHight + 18 + s * 2, z + dz, leave, 0, 2);
            }
        }
        for (int dx2 = -1; dx2 < 2; ++dx2) {
            world.func_147465_d(x + dx2, y + logHight + 23, z, leave, 0, 2);
        }
        for (int dz3 = -1; dz3 < 2; ++dz3) {
            world.func_147465_d(x, y + logHight + 23, z + dz3, leave, 0, 2);
        }
        for (s = 0; s < 2; ++s) {
            for (dx = -1; dx < 2; ++dx) {
                for (dz2 = -1; dz2 < 2; ++dz2) {
                    world.func_147465_d(x + dx, y + logHight + 19 + s * 2, z + dz2, leave, 0, 2);
                }
            }
        }
        for (s = 0; s < 23 + logHight; ++s) {
            world.func_147465_d(x, y + s, z, log, 0, 2);
        }
    }

    public int getModdedBiomeGrassColor(int original) {
        return 19461;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBiomeGrassColor() {
        return 19461;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBiomeFoliageColor() {
        return 19461;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float par1) {
        return 3726847;
    }
}

