/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockReed;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.FishingHooks;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.IQuantitativeRS;
import project.studio.manametalmod.blocks.BlockTreeFruit;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.AutoCrystal;
import project.studio.manametalmod.core.FakePlayerFactoryM3;
import project.studio.manametalmod.core.FakePlayerM3;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.items.ItemToolWandBlock;
import project.studio.manametalmod.mob.EntityFishHookFake;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.produce.brewing.IBlockHerb;
import project.studio.manametalmod.produce.farming.BlockCocoaM3;
import project.studio.manametalmod.produce.farming.BlockGrape;
import project.studio.manametalmod.produce.farming.BlockMushroomCropM3;
import project.studio.manametalmod.produce.farming.FarmCore;
import project.studio.manametalmod.tileentity.TileEntityCrystalZ;
import project.studio.manametalmod.world.thuliumempire.BlockAncientEmpireHerbsSeed;
import project.studio.manametalmod.world.thuliumempire.ThuliumEmpireCore;

public class AutoCrystalEffect {
    public static final void tree(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!AutoCrystal.can_effect(tile, time, random, world)) {
            return;
        }
        List<EntityItem> list = MMM.findEntityItem(tile, tile.range);
        if (list.size() > 6) {
            if (world.field_72995_K) {
                for (int s = 0; s < 6; ++s) {
                    FXHelp.spawnParticle(tile.func_145831_w(), Particle.smoke, (float)tile.field_145851_c + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145848_d + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145849_e + tile.func_145831_w().field_73012_v.nextFloat());
                }
            }
            return;
        }
        int sx = 0;
        int sy = 0;
        int sz = 0;
        for (int y = -tile.range; y < tile.range + 1; ++y) {
            for (int x = -tile.range; x < tile.range + 1; ++x) {
                for (int z = -tile.range; z < tile.range + 1; ++z) {
                    sx = tile.field_145851_c + x;
                    sy = tile.field_145848_d + y;
                    sz = tile.field_145849_e + z;
                    Block blocklog = world.func_147439_a(sx, sy, sz);
                    if (!(blocklog instanceof BlockLog) && !blocklog.isWood((IBlockAccess)world, sx, sy, sz) && !(blocklog instanceof BlockLeaves) && blocklog.func_149688_o() != Material.field_151584_j) continue;
                    if (!world.field_72995_K) {
                        MMM.breakBlockCheck(world, sx, sy, sz, true);
                        tile.getEnergy().removeEnergy(4);
                    } else {
                        tile.fxLine(world, Particle.crit, (double)sx + 0.5, (double)sy + 0.5, (double)sz + 0.5, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                    }
                    return;
                }
            }
        }
    }

    public static final void setblock(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!AutoCrystal.can_effect(tile, time, random, world) || tile.getEnergy().getEnergy() < 5) {
            return;
        }
        if (tile.temp != null) {
            Block targetblock = tile.getBottomBlock(2);
            if (targetblock != Blocks.field_150350_a) {
                int rangesize = tile.range + 1;
                int sx = 0;
                int sy = 0;
                int sz = 0;
                for (int y = -tile.range; y < rangesize; ++y) {
                    for (int x = -tile.range; x < rangesize; ++x) {
                        for (int z = -tile.range; z < rangesize; ++z) {
                            sx = tile.field_145851_c + x;
                            sy = tile.field_145848_d + y;
                            sz = tile.field_145849_e + z;
                            if (world.func_147439_a(sx, sy, sz) != targetblock || world.func_72805_g(sx, sy, sz) != tile.getBottomBlockMetadata(2) || world.func_147439_a(sx, sy + 1, sz) != Blocks.field_150350_a) continue;
                            Block block = Block.func_149634_a((Item)tile.temp.func_77973_b());
                            if (block != Blocks.field_150350_a && !(block instanceof IQuantitativeRS)) {
                                if (!world.field_72995_K) {
                                    world.func_72926_e(2001, sx, sy + 1, sz, Block.func_149682_b((Block)block) + (tile.temp.func_77960_j() << 12));
                                    world.func_147465_d(sx, sy + 1, sz, block, tile.temp.func_77960_j(), 2);
                                    tile.getEnergy().removeEnergy(5);
                                    --tile.temp.field_77994_a;
                                    if (tile.temp.field_77994_a <= 0) {
                                        tile.temp = null;
                                        return;
                                    }
                                } else {
                                    tile.fxLine(world, Particle.crit, (float)sx + 0.5f, (float)sy + 1.5f, (float)sz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                                    return;
                                }
                            }
                            return;
                        }
                    }
                }
            }
        } else {
            tile.temp = MMM.tryExtractItemFrom(tile.getTarget(), null, null, false, 0);
            return;
        }
    }

    public static final void moveblock(TileEntityCrystalZ tile, int time, Random random, World world) {
        Block block;
        if (!AutoCrystal.can_effect(tile, time, random, world) || tile.getEnergy().getEnergy() < 20) {
            return;
        }
        if (tile.hasPosTarget && tile.posSource != null && tile.posTarget != null && !tile.isSourceEqualTarget() && world.func_147439_a(tile.posSource[0], tile.posSource[1], tile.posSource[2]) != Blocks.field_150350_a && world.func_147439_a(tile.posTarget[0], tile.posTarget[1], tile.posTarget[2]) == Blocks.field_150350_a && !((block = world.func_147439_a(tile.posSource[0], tile.posSource[1], tile.posSource[2])) instanceof IQuantitativeRS) && block.func_149712_f(world, tile.posSource[0], tile.posSource[1], tile.posSource[2]) >= 0.0f && block.getHarvestLevel(world.func_72805_g(tile.posSource[0], tile.posSource[1], tile.posSource[2])) < 4 && MMM.getBlockDistance(tile.posSource[0], tile.posSource[1], tile.posSource[2], tile.posTarget[0], tile.posTarget[1], tile.posTarget[2]) < 51 && ItemToolWandBlock.canWandEdit(block, world, tile.posSource[0], tile.posSource[1], tile.posSource[2])) {
            Block blocktarget;
            if (tile.target != null && tile.target.func_77973_b() instanceof ItemBlock && ((blocktarget = Block.func_149634_a((Item)tile.target.func_77973_b())) != block || tile.target.func_77960_j() != world.func_72805_g(tile.posSource[0], tile.posSource[1], tile.posSource[2]))) {
                return;
            }
            TileEntity tiles = world.func_147438_o(tile.posSource[0], tile.posSource[1], tile.posSource[2]);
            NBTTagCompound tag = new NBTTagCompound();
            world.func_147465_d(tile.posTarget[0], tile.posTarget[1], tile.posTarget[2], block, world.func_72805_g(tile.posSource[0], tile.posSource[1], tile.posSource[2]), 2);
            if (tiles != null) {
                tiles.func_145841_b(tag);
                TileEntity tilestarget = world.func_147438_o(tile.posTarget[0], tile.posTarget[1], tile.posTarget[2]);
                tag.func_74768_a("x", tile.posTarget[0]);
                tag.func_74768_a("y", tile.posTarget[1]);
                tag.func_74768_a("z", tile.posTarget[2]);
                if (tilestarget != null) {
                    tilestarget.func_145839_a(tag);
                }
                world.func_147475_p(tile.posSource[0], tile.posSource[1], tile.posSource[2]);
            }
            world.func_147465_d(tile.posSource[0], tile.posSource[1], tile.posSource[2], Blocks.field_150350_a, 0, 2);
            tile.getEnergy().removeEnergy(20);
        }
    }

    public static final void collectitem(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!world.field_72995_K) {
            if (!AutoCrystal.can_effect(tile, time, random, world) || !tile.open) {
                return;
            }
            if (tile.getEnergy().getEnergy() > 1 && tile.hasTargetIInventory()) {
                List<EntityItem> items = MMM.findEntityItem(tile, tile.range);
                boolean success = false;
                int beforeSize = 0;
                int size = items.size();
                for (int s = 0; s < size; ++s) {
                    EntityItem entityitem = items.get(s);
                    if (entityitem.func_92059_d() == null || entityitem.func_92059_d().field_77994_a <= 0 || entityitem.func_145798_i() != null || entityitem.field_70128_L) continue;
                    ItemStack item = entityitem.func_92059_d();
                    beforeSize = item.field_77994_a;
                    if (tile.target != null && !MMM.isFoodEqual(tile.target, item) && !MMM.isItemStackEqual(tile.target, item)) continue;
                    success = false;
                    item = MMM.tryInsertItemTo(tile.getTarget(), item, null);
                    if (item == null || item.field_77994_a <= 0) {
                        entityitem.func_70106_y();
                        success = true;
                    } else if (item.field_77994_a < beforeSize) {
                        success = true;
                    }
                    if (!success) continue;
                    if (!entityitem.field_70128_L) {
                        entityitem.func_92058_a(item);
                    }
                    tile.getEnergy().removeEnergy(2);
                    if (M3Config.AutoCrystalEffec) {
                        if (tile.targetpoint == null) {
                            tile.targetpoint = new NetworkRegistry.TargetPoint(MMM.getDimensionID(world), (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, 16.0);
                        }
                        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(1, entityitem.field_70165_t, entityitem.field_70163_u, entityitem.field_70161_v, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e), tile.targetpoint);
                    }
                    return;
                }
            }
        }
    }

    public static final void breakblock(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!AutoCrystal.can_effect(tile, time, random, world)) {
            return;
        }
        List<EntityItem> list = MMM.findEntityItem(tile, tile.range);
        if (list.size() > 12) {
            if (world.field_72995_K) {
                for (int s = 0; s < 6; ++s) {
                    FXHelp.spawnParticle(tile.func_145831_w(), Particle.smoke, (float)tile.field_145851_c + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145848_d + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145849_e + tile.func_145831_w().field_73012_v.nextFloat());
                }
            }
            return;
        }
        if (tile.getEnergy().getEnergy() < 2) {
            return;
        }
        Block target = tile.getBottomBlock(1);
        if (target != Blocks.field_150350_a) {
            int dx = 0;
            int dy = 0;
            int dz = 0;
            int rangesize = tile.range + 1;
            for (int y = -tile.range; y < rangesize; ++y) {
                for (int x = -tile.range; x < rangesize; ++x) {
                    for (int z = -tile.range; z < rangesize; ++z) {
                        if (world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) != target || world.func_72805_g(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) != tile.getBottomBlockMetadata(1)) continue;
                        for (int slayer = 0; slayer < tile.layer; ++slayer) {
                            dx = tile.field_145851_c + x;
                            dy = tile.field_145848_d + y + 1 + slayer;
                            dz = tile.field_145849_e + z;
                            Block targetBlock = world.func_147439_a(dx, dy, dz);
                            if (tile.target == null && targetBlock != ItemCraft10.BlockTileEntityCrystalZs6 && targetBlock.func_149712_f(world, dx, dy, dz) >= 0.0f && targetBlock != Blocks.field_150350_a && targetBlock.getHarvestLevel(world.func_72805_g(dx, dy, dz)) < 4) {
                                if (!world.field_72995_K) {
                                    MMM.breakBlockCheck(world, dx, dy, dz, true);
                                    tile.getEnergy().removeEnergy(2);
                                    return;
                                }
                                tile.fxLine(world, Particle.crit, (double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                                return;
                            }
                            if (tile.target == null || !(tile.target.func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)tile.target.func_77973_b()) != targetBlock || tile.target.func_77960_j() != world.func_72805_g(dx, dy, dz) || targetBlock == ItemCraft10.BlockTileEntityCrystalZs6 || !(targetBlock.func_149712_f(world, dx, dy, dz) >= 0.0f) || targetBlock == Blocks.field_150350_a || targetBlock.getHarvestLevel(world.func_72805_g(dx, dy, dz)) >= 4) continue;
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                                return;
                            }
                            tile.fxLine(world, Particle.crit, (double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                            return;
                        }
                    }
                }
            }
        }
    }

    public static final void farm(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!AutoCrystal.can_effect(tile, time, random, world)) {
            return;
        }
        List<EntityItem> list = MMM.findEntityItem(tile, tile.range);
        if (list.size() > 6) {
            if (world.field_72995_K) {
                for (int s = 0; s < 6; ++s) {
                    FXHelp.spawnParticle(tile.func_145831_w(), Particle.smoke, (float)tile.field_145851_c + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145848_d + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145849_e + tile.func_145831_w().field_73012_v.nextFloat());
                }
            }
            return;
        }
        if (tile.getEnergy().getEnergy() < 2) {
            return;
        }
        if (tile.target != null) {
            int dx = 0;
            int dy = 0;
            int dz = 0;
            int rangesize = tile.range + 1;
            for (int y = -tile.range; y < rangesize; ++y) {
                for (int x = -tile.range; x < rangesize; ++x) {
                    for (int z = -tile.range; z < rangesize; ++z) {
                        IBlockHerb herb;
                        Object tree;
                        dx = tile.field_145851_c + x;
                        dy = tile.field_145848_d + y + 1;
                        dz = tile.field_145849_e + z;
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockCrops && world.func_72805_g(dx, dy, dz) >= 7 && MMM.isItemStackEqualNoNBT(new ItemStack((tree = (BlockCrops)world.func_147439_a(dx, dy, dz)).func_149650_a(world.func_72805_g(dx, dy, dz), tile.func_145831_w().field_73012_v, 0)), tile.target)) {
                            if (!world.field_72995_K) {
                                Block targetBlock = world.func_147439_a(dx, dy, dz);
                                world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                                targetBlock.func_149697_b(world, dx, dy, dz, world.func_72805_g(dx, dy, dz), 0);
                                world.func_72921_c(dx, dy, dz, 0, 2);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockMushroomCropM3 && world.func_72805_g(dx, dy, dz) >= 10) {
                            BlockMushroomCropM3 crop = (BlockMushroomCropM3)world.func_147439_a(dx, dy, dz);
                            if (tile.target.func_77973_b() == crop.Crop) {
                                if (!world.field_72995_K) {
                                    Block targetBlock = world.func_147439_a(dx, dy, dz);
                                    world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                                    targetBlock.func_149697_b(world, dx, dy, dz, world.func_72805_g(dx, dy, dz), 0);
                                    world.func_72921_c(dx, dy, dz, 0, 2);
                                    tile.getEnergy().removeEnergy(2);
                                } else {
                                    tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                                }
                                return;
                            }
                        }
                        if (tile.target.func_77973_b() == Items.field_151120_aE && world.func_147439_a(dx, dy, dz) instanceof BlockReed && world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) instanceof BlockReed) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (tile.target.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150434_aF) && world.func_147439_a(dx, dy, dz) instanceof BlockCactus && world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) instanceof BlockCactus) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if ((tile.target.func_77973_b() == Items.field_151100_aR || tile.target.func_77973_b() == Item.func_150898_a((Block)FarmCore.BlockCocoaM3s)) && world.func_147439_a(dx, dy, dz) instanceof BlockCocoa) {
                            Block targetBlock = world.func_147439_a(dx, dy, dz);
                            int id = world.func_72805_g(dx, dy, dz);
                            int breakif = -1;
                            switch (id) {
                                case 8: {
                                    breakif = 0;
                                    break;
                                }
                                case 9: {
                                    breakif = 1;
                                    break;
                                }
                                case 10: {
                                    breakif = 2;
                                    break;
                                }
                                case 11: {
                                    breakif = 7;
                                }
                            }
                            if (breakif != -1) {
                                if (!world.field_72995_K) {
                                    ItemStack item = new ItemStack(Items.field_151100_aR, 2, 3);
                                    if (targetBlock instanceof BlockCocoaM3) {
                                        item = new ItemStack(FarmCore.BlockCocoaM3s, 2, 0);
                                    }
                                    MMM.spawnItemInWorld(world, item, (double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5);
                                    world.func_72921_c(dx, dy, dz, breakif, 2);
                                    world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                                    tile.getEnergy().removeEnergy(2);
                                } else {
                                    tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                                }
                                return;
                            }
                        }
                        if (tile.target.func_77973_b() == Items.field_151127_ba && world.func_147439_a(dx, dy, dz) == Blocks.field_150440_ba) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (tile.target.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK) && world.func_147439_a(dx, dy, dz) == Blocks.field_150423_aK) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if ((tile.target.func_77973_b() == FarmCore.Grape || tile.target.func_77973_b() == FarmCore.GrapeGold) && world.func_147439_a(dx, dy, dz) instanceof BlockGrape) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockTreeFruit && MMM.isItemStackEqualNoNBT(tile.target, ((BlockTreeFruit)((Object)(tree = (BlockTreeFruit)world.func_147439_a(dx, dy, dz)))).getBerry()) && world.func_72805_g(dx, dy, dz) >= 5) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof IBlockHerb && MMM.isItemStackEqualNoNBT((herb = (IBlockHerb)world.func_147439_a(dx, dy, dz)).getDropItem(world, dx, dy, dz), tile.target) && herb.canReward(world, dx, dy, dz)) {
                            if (!world.field_72995_K) {
                                Block targetBlock = world.func_147439_a(dx, dy, dz);
                                ItemStack item = herb.getDropItem(world, dx, dy, dz);
                                MMM.spawnItemInWorld(world, item, (double)(tile.field_145851_c + x) + 0.5, (double)(tile.field_145848_d + y + 1), (double)(tile.field_145849_e + z) + 0.5);
                                herb.onReward(world, dx, dy, dz);
                                world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (!(world.func_147439_a(dx, dy, dz) instanceof BlockAncientEmpireHerbsSeed) || world.func_72805_g(dx, dy, dz) < 5) continue;
                        BlockAncientEmpireHerbsSeed herd = (BlockAncientEmpireHerbsSeed)world.func_147439_a(dx, dy, dz);
                        if (!MMM.isItemStackEqualNoNBT(new ItemStack(ThuliumEmpireCore.ItemHerbsAncientEmpires, 1, world.func_72805_g(dx, dy, dz) - 5), tile.target)) continue;
                        if (!world.field_72995_K) {
                            Block targetBlock = world.func_147439_a(dx, dy, dz);
                            world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                            targetBlock.func_149697_b(world, dx, dy, dz, world.func_72805_g(dx, dy, dz), 0);
                            world.func_72921_c(dx, dy, dz, world.func_72805_g(dx, dy, dz) - 5, 2);
                            tile.getEnergy().removeEnergy(2);
                        } else {
                            tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                        }
                        return;
                    }
                }
            }
        } else {
            int dx = 0;
            int dy = 0;
            int dz = 0;
            int rangesize = tile.range + 1;
            for (int y = -tile.range; y < rangesize; ++y) {
                for (int x = -tile.range; x < rangesize; ++x) {
                    for (int z = -tile.range; z < rangesize; ++z) {
                        IBlockHerb herb;
                        Block targetBlock;
                        dx = tile.field_145851_c + x;
                        dy = tile.field_145848_d + y + 1;
                        dz = tile.field_145849_e + z;
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockCrops && world.func_72805_g(dx, dy, dz) >= 7) {
                            if (!world.field_72995_K) {
                                targetBlock = world.func_147439_a(dx, dy, dz);
                                world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                                targetBlock.func_149697_b(world, dx, dy, dz, world.func_72805_g(dx, dy, dz), 0);
                                world.func_72921_c(dx, dy, dz, 0, 2);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockMushroomCropM3 && world.func_72805_g(dx, dy, dz) >= 10) {
                            BlockMushroomCropM3 crop = (BlockMushroomCropM3)world.func_147439_a(dx, dy, dz);
                            if (!world.field_72995_K) {
                                Block targetBlock2 = world.func_147439_a(dx, dy, dz);
                                world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock2) + (world.func_72805_g(dx, dy, dz) << 12));
                                targetBlock2.func_149697_b(world, dx, dy, dz, world.func_72805_g(dx, dy, dz), 0);
                                world.func_72921_c(dx, dy, dz, 0, 2);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockReed && world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) instanceof BlockReed) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockCactus && world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) instanceof BlockCactus) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockCocoa) {
                            targetBlock = world.func_147439_a(dx, dy, dz);
                            int id = world.func_72805_g(dx, dy, dz);
                            int breakif = -1;
                            switch (id) {
                                case 8: {
                                    breakif = 0;
                                    break;
                                }
                                case 9: {
                                    breakif = 1;
                                    break;
                                }
                                case 10: {
                                    breakif = 2;
                                    break;
                                }
                                case 11: {
                                    breakif = 7;
                                }
                            }
                            if (breakif != -1) {
                                if (!world.field_72995_K) {
                                    ItemStack item = new ItemStack(Items.field_151100_aR, 2, 3);
                                    if (targetBlock instanceof BlockCocoaM3) {
                                        item = new ItemStack(FarmCore.BlockCocoaM3s, 2, 0);
                                    }
                                    MMM.spawnItemInWorld(world, item, (double)(tile.field_145851_c + x) + 0.5, (double)(tile.field_145848_d + y + 1) + 0.5, (double)(tile.field_145849_e + z) + 0.5);
                                    world.func_72921_c(dx, dy, dz, breakif, 2);
                                    world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                                    tile.getEnergy().removeEnergy(2);
                                } else {
                                    tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                                }
                                return;
                            }
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockMelon || world.func_147439_a(dx, dy, dz) == Blocks.field_150423_aK || world.func_147439_a(dx, dy, dz) instanceof BlockGrape) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof BlockTreeFruit && world.func_72805_g(dx, dy, dz) >= 5) {
                            if (!world.field_72995_K) {
                                MMM.breakBlockCheck(world, dx, dy, dz, true);
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (world.func_147439_a(dx, dy, dz) instanceof IBlockHerb && (herb = (IBlockHerb)world.func_147439_a(dx, dy, dz)).canReward(world, dx, dy, dz)) {
                            if (!world.field_72995_K) {
                                Block targetBlock3 = world.func_147439_a(dx, dy, dz);
                                ItemStack item = herb.getDropItem(world, dx, dy, dz);
                                MMM.spawnItemInWorld(world, item, (double)(tile.field_145851_c + x) + 0.5, (double)(tile.field_145848_d + y + 1), (double)(tile.field_145849_e + z) + 0.5);
                                herb.onReward(world, dx, dy, dz);
                                world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock3) + (world.func_72805_g(dx, dy, dz) << 12));
                                tile.getEnergy().removeEnergy(2);
                            } else {
                                tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                            }
                            return;
                        }
                        if (!(world.func_147439_a(dx, dy, dz) instanceof BlockAncientEmpireHerbsSeed) || world.func_72805_g(dx, dy, dz) < 5) continue;
                        if (!world.field_72995_K) {
                            targetBlock = world.func_147439_a(dx, dy, dz);
                            world.func_72926_e(2001, dx, dy, dz, Block.func_149682_b((Block)targetBlock) + (world.func_72805_g(dx, dy, dz) << 12));
                            targetBlock.func_149697_b(world, dx, dy, dz, world.func_72805_g(dx, dy, dz), 0);
                            world.func_72921_c(dx, dy, dz, world.func_72805_g(dx, dy, dz) - 5, 2);
                            tile.getEnergy().removeEnergy(2);
                        } else {
                            tile.fxLine(world, Particle.manaFire, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, (float)tile.field_145851_c + 0.5f, (float)tile.field_145848_d + 0.5f, (float)tile.field_145849_e + 0.5f);
                        }
                        return;
                    }
                }
            }
        }
    }

    public static final void fishing(TileEntityCrystalZ tile, int time, Random random, World world) {
        List<EntityItem> list;
        if (!AutoCrystal.can_effect(tile, time, random, world)) {
            return;
        }
        if (tile.fishtime > 0) {
            --tile.fishtime;
            return;
        }
        if (tile.getEnergy().getEnergy() < 10) {
            return;
        }
        if (tile.fishtime <= 0 && tile.fishtime != -1) {
            ItemStack fish = FishingHooks.getRandomFishable((Random)world.field_73012_v, (float)world.field_73012_v.nextFloat());
            MMM.spawnItemInWorld(world, fish, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5);
            tile.fishtime = -1;
        }
        if ((list = MMM.findEntityItem(tile, tile.range)).size() > 6) {
            if (world.field_72995_K) {
                for (int s = 0; s < 6; ++s) {
                    FXHelp.spawnParticle(tile.func_145831_w(), Particle.smoke, (float)tile.field_145851_c + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145848_d + tile.func_145831_w().field_73012_v.nextFloat(), (float)tile.field_145849_e + tile.func_145831_w().field_73012_v.nextFloat());
                }
            }
            return;
        }
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                int timefish;
                if (world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d - 1, tile.field_145849_e + z).func_149688_o() != Material.field_151586_h) continue;
                tile.fishtime = timefish = 30 + world.field_73012_v.nextInt(20);
                float xpos = (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 7.0f;
                float zpos = (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) / 7.0f;
                EntityFishHookFake fish = new EntityFishHookFake(world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile, timefish * 20);
                fish.func_70080_a((double)(tile.field_145851_c + x) + 0.5 + (double)xpos, (double)tile.field_145848_d + 0.15, (double)(tile.field_145849_e + z) + 0.5 + (double)zpos, 0.0f, 0.0f);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)fish);
                }
                tile.getEnergy().removeEnergy(10);
                return;
            }
        }
    }

    public static final void move_item(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!world.field_72995_K) {
            if (!AutoCrystal.can_effect(tile, time, random, world)) {
                return;
            }
            if (tile.hasPosTarget && tile.posSource != null && tile.posTarget != null && !tile.isSourceEqualTarget()) {
                int d1 = MMM.getBlockDistance(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.posSource[0], tile.posSource[1], tile.posSource[2]);
                int d2 = MMM.getBlockDistance(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.posTarget[0], tile.posTarget[1], tile.posTarget[2]);
                if (d1 < 50 && d2 < 50) {
                    TileEntity tilesd1 = world.func_147438_o(tile.posSource[0], tile.posSource[1], tile.posSource[2]);
                    TileEntity tilesd2 = world.func_147438_o(tile.posTarget[0], tile.posTarget[1], tile.posTarget[2]);
                    if (tilesd1 != null && tilesd1 instanceof IInventory && tilesd2 != null && tilesd2 instanceof IInventory && AutoCrystal.canEffect(tilesd1) && AutoCrystal.canEffect(tilesd2)) {
                        IInventory items1 = (IInventory)tilesd1;
                        IInventory items2 = (IInventory)tilesd2;
                        if (tile.temp == null) {
                            tile.temp = MMM.tryExtractItemFrom(items1, tile.target, null, false, 0);
                            if (tile.temp != null) {
                                tile.getEnergy().removeEnergy(1);
                            }
                        }
                        if (tile.temp != null) {
                            tile.temp = MMM.tryInsertItemTo(items2, tile.temp, null);
                        }
                    }
                }
            }
        }
    }

    public static final void use_item(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!AutoCrystal.can_effect(tile, time, random, world) || !M3Config.ItemUseAutoCrystal || tile.getEnergy().getEnergy() < 2) {
            return;
        }
        if (tile.gamedata == null) {
            Pos pos = new Pos(tile);
            tile.gamedata = new GameProfile(UUID.nameUUIDFromBytes(pos.toString().getBytes(Charsets.UTF_8)), pos.toString());
            return;
        }
        if (tile.temp != null && tile.gamedata != null) {
            FakePlayerM3 player;
            Block target = tile.getBottomBlock(2);
            if (target != Blocks.field_150350_a && (player = FakePlayerFactoryM3.get((WorldServer)tile.func_145831_w(), tile.gamedata)) != null) {
                player.func_70062_b(0, tile.temp);
                if (((EntityPlayerMP)player).field_71134_c != null) {
                    for (int y = -tile.range; y < tile.range + 1; ++y) {
                        for (int x = -tile.range; x < tile.range + 1; ++x) {
                            for (int z = -tile.range; z < tile.range + 1; ++z) {
                                if (x == 0 && y == -2 && z == 0 || world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) != target || world.func_72805_g(tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z) != tile.getBottomBlockMetadata(2) || tile.temp == null || !((EntityPlayerMP)player).field_71134_c.func_73078_a((EntityPlayer)player, world, tile.temp, tile.field_145851_c + x, tile.field_145848_d + y, tile.field_145849_e + z, 1, 0.0f, 0.0f, 0.0f)) continue;
                                tile.getEnergy().removeEnergy(2);
                                if (tile.temp.field_77994_a <= 0) {
                                    tile.temp = null;
                                }
                                if (player.func_71045_bC() == null) {
                                    tile.temp = null;
                                }
                                return;
                            }
                        }
                    }
                }
            }
        } else {
            tile.temp = MMM.tryExtractItemFrom(tile.getTarget(), null, null, false, 0);
            return;
        }
    }
}

