/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.Coin;

public class CoinConverter {
    public static final List<Coin> COINS = new ArrayList<Coin>();

    public static ItemStack[] get(int input) {
        Map<Item, Integer> map = CoinConverter.convert(input);
        ItemStack[] data = new ItemStack[map.size()];
        int index = 0;
        for (Map.Entry<Item, Integer> entry : map.entrySet()) {
            data[index] = new ItemStack(entry.getKey(), entry.getValue().intValue());
            ++index;
        }
        return data;
    }

    public static Map<Item, Integer> convert(int amount) {
        LinkedHashMap<Item, Integer> result = new LinkedHashMap<Item, Integer>();
        for (Coin coin : COINS) {
            int count = amount / coin.value;
            if (count <= 0) continue;
            result.put(coin.item, count);
            amount -= count * coin.value;
        }
        return result;
    }

    static {
        COINS.add(new Coin(ManaMetalMod.Coin9, 387420489));
        COINS.add(new Coin(ManaMetalMod.Coin8, 43046721));
        COINS.add(new Coin(ManaMetalMod.Coin7, 4782969));
        COINS.add(new Coin(ManaMetalMod.Coin6, 531441));
        COINS.add(new Coin(ManaMetalMod.Coin5, 59049));
        COINS.add(new Coin(ManaMetalMod.Coin4, 6561));
        COINS.add(new Coin(ManaMetalMod.Coin3, 729));
        COINS.add(new Coin(ManaMetalMod.Coin2, 81));
        COINS.add(new Coin(ManaMetalMod.Coin1, 9));
        COINS.add(new Coin(ManaMetalMod.Coin0, 1));
    }
}

