/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.EntityArrowBase;
import project.studio.manametalmod.mob.EntityBullet;
import project.studio.manametalmod.mob.EntityMagicBallGravity;
import project.studio.manametalmod.mob.EntityMagicBallNew;
import project.studio.manametalmod.mob.EntitySpear;

public class ProjectileHelp {
    public static void doBallAttackV3(World world, EntityLivingBase shooter, EntityLivingBase target, float speed, ManaElements manaElements, int balltype, int damage, float ballSize, int spaceTextureID) {
        Vec3 targetMotion;
        Vec3 targetPos;
        Vec3 shooterPos = Vec3.func_72443_a((double)shooter.field_70165_t, (double)(shooter.field_70163_u + (double)shooter.func_70047_e()), (double)shooter.field_70161_v);
        Vec3 intercept = ProjectileHelp.predictInterceptPoint(shooterPos, targetPos = Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)target.field_70131_O / 2.0), (double)target.field_70161_v), targetMotion = Vec3.func_72443_a((double)target.field_70159_w, (double)target.field_70181_x, (double)target.field_70179_y), speed);
        Vec3 aimPoint = intercept != null ? intercept : targetPos;
        double dx = aimPoint.field_72450_a - shooterPos.field_72450_a;
        double dy = aimPoint.field_72448_b - shooterPos.field_72448_b;
        double dz = aimPoint.field_72449_c - shooterPos.field_72449_c;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double vx = dx / distance * (double)speed;
        double vy = dy / distance * (double)speed;
        double vz = dz / distance * (double)speed;
        EntityMagicBallNew ball = new EntityMagicBallNew(shooter.field_70170_p, shooter, damage, manaElements, balltype, null);
        ball.func_70107_b(shooterPos.field_72450_a, shooterPos.field_72448_b, shooterPos.field_72449_c);
        ball.field_70159_w = vx;
        ball.field_70181_x = vy;
        ball.field_70179_y = vz;
        ball.needFixedVector = false;
        world.func_72838_d((Entity)ball);
    }

    public static Vec3 predictInterceptPoint(Vec3 shooterPos, Vec3 targetPos, Vec3 targetMotion, double projectileSpeed) {
        double t2;
        double c;
        Vec3 toTarget = targetPos.func_72444_a(shooterPos);
        double a = targetMotion.func_72430_b(targetMotion) - projectileSpeed * projectileSpeed;
        double b = 2.0 * toTarget.func_72430_b(targetMotion);
        double discriminant = b * b - 4.0 * a * (c = toTarget.func_72430_b(toTarget));
        if (discriminant < 0.0) {
            return null;
        }
        double sqrtDisc = Math.sqrt(discriminant);
        double t1 = (-b - sqrtDisc) / (2.0 * a);
        double t = Math.min(t1, t2 = (-b + sqrtDisc) / (2.0 * a));
        if (t < 0.0) {
            t = Math.max(t1, t2);
        }
        if (t < 0.0) {
            return null;
        }
        return targetPos.func_72441_c(targetMotion.field_72450_a * t, targetMotion.field_72448_b * t, targetMotion.field_72449_c * t);
    }

    public static void doBallAttackV2(World world, EntityLivingBase shooter, EntityLivingBase target, float speed, ManaElements manaElements, int balltype, int damage, float ballSize, int spaceTextureID, boolean needFixedVector) {
        EntityMagicBallNew ball = new EntityMagicBallNew(shooter.field_70170_p, shooter, damage, manaElements, balltype, null);
        ball.setSize(ballSize);
        ball.setSpaceTextureID(spaceTextureID);
        ball.needFixedVector = needFixedVector;
        double startX = shooter.field_70165_t;
        double startY = shooter.field_70163_u + (double)shooter.func_70047_e();
        double startZ = shooter.field_70161_v;
        double targetX = target.field_70165_t;
        double targetY = target.field_70163_u + (double)target.field_70131_O / 2.0;
        double targetZ = target.field_70161_v;
        double dx = targetX - startX;
        double dy = targetY - startY;
        double dz = targetZ - startZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        ball.func_70186_c(dx, dy, dz, speed, 1.0f);
        world.func_72838_d((Entity)ball);
    }

    public static final void doBallAttackGravity(EntityLivingBase soure, EntityLivingBase target, float damage, int type, float size) {
        EntityMagicBallGravity ball = new EntityMagicBallGravity(soure.field_70170_p, soure, damage, type, size);
        if (!soure.field_70170_p.field_72995_K) {
            ball.field_70125_A -= -20.0f;
            double d0 = target.field_70165_t + target.field_70159_w - soure.field_70165_t;
            double d1 = target.field_70163_u - 0.5 - soure.field_70163_u;
            double d2 = target.field_70161_v + target.field_70179_y - soure.field_70161_v;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            ball.func_70186_c(d0, d1, d2, 0.75f, 1.0f);
            soure.field_70170_p.func_72838_d((Entity)ball);
        }
        soure.field_70170_p.func_72956_a((Entity)soure, ManaElements.getElementsSounds(ManaElements.Dark), 1.0f, (soure.field_70170_p.field_73012_v.nextFloat() - soure.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
    }

    public static final void doBallAttack(EntityLivingBase soure, EntityLivingBase target, int damage, ManaElements Elements, int type) {
        EntityMagicBallNew ball = new EntityMagicBallNew(soure.field_70170_p, soure, damage, Elements, type, null);
        if (!soure.field_70170_p.field_72995_K) {
            ball.field_70125_A -= -20.0f;
            double d0 = target.field_70165_t + target.field_70159_w - soure.field_70165_t;
            double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - soure.field_70163_u;
            double d2 = target.field_70161_v + target.field_70179_y - soure.field_70161_v;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            ball.func_70186_c(d0, d1, d2, 0.75f, 1.0f);
            soure.field_70170_p.func_72838_d((Entity)ball);
        }
        soure.field_70170_p.func_72956_a((Entity)soure, ManaElements.getElementsSounds(Elements), 1.0f, (soure.field_70170_p.field_73012_v.nextFloat() - soure.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
    }

    public static final void doBallAttackTrack(EntityLivingBase soure, EntityLivingBase target, int damage, ManaElements Elements, int type) {
        EntityMagicBallNew ball = new EntityMagicBallNew(soure.field_70170_p, soure, damage, Elements, type, (Entity)target);
        if (!soure.field_70170_p.field_72995_K) {
            soure.field_70170_p.func_72838_d((Entity)ball);
        }
        soure.field_70170_p.func_72956_a((Entity)soure, ManaElements.getElementsSounds(Elements), 1.0f, (soure.field_70170_p.field_73012_v.nextFloat() - soure.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
    }

    public static final void doBallAttackGun(EntityLivingBase soure, EntityLivingBase target, int arrowDamage, ManaElements Elements, float speed, float size) {
        EntityBullet ball = new EntityBullet(soure.field_70170_p, soure, arrowDamage, 200, 0.0f, 0.0f, size);
        if (!soure.field_70170_p.field_72995_K) {
            ball.field_70125_A -= -20.0f;
            double d0 = target.field_70165_t + target.field_70159_w - soure.field_70165_t;
            double d1 = target.field_70163_u - (double)(target.field_70131_O * 0.5f) - soure.field_70163_u;
            double d2 = target.field_70161_v + target.field_70179_y - soure.field_70161_v;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            ball.func_70186_c(d0, d1, d2, 1.0f, 1.0f);
            ball.field_70159_w *= (double)speed;
            ball.field_70181_x *= (double)speed;
            ball.field_70179_y *= (double)speed;
            soure.field_70170_p.func_72838_d((Entity)ball);
        }
    }

    public static final void doSpearAttack(EntityLivingBase soure, EntityLivingBase target, float arrowDamage, boolean hitPlayer) {
        double targetdist = soure.func_70092_e(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v);
        EntitySpear arrow = new EntitySpear(soure.field_70170_p, soure, 0.0f);
        arrow.canHitPlayer = hitPlayer;
        arrow.func_70107_b(soure.field_70165_t, soure.field_70163_u + (double)soure.func_70047_e(), soure.field_70161_v);
        if (!soure.field_70170_p.field_72995_K) {
            float accuracy = 1.0f;
            arrow.func_70243_d(true);
            float dist = MathHelper.func_76129_c((float)((float)targetdist));
            double mx = target.field_70159_w;
            double mz = target.field_70179_y;
            double distFactor = (mx * mx + mz * mz) * 100.0 * (double)dist;
            double arrowMotionX = target.field_70165_t - soure.field_70165_t + target.field_70159_w * distFactor;
            double arrowMotionZ = target.field_70161_v - soure.field_70161_v + target.field_70179_y * distFactor;
            double arrowMotionY = target.field_70163_u + (double)target.func_70047_e() - arrow.field_70163_u + (double)dist * 0.2;
            float hFact = 1.0f;
            if (dist > 14.0f) {
                hFact = 1.0f + dist * 0.025f;
            }
            if (dist > 50.0f) {
                arrowMotionY += (double)(dist * 0.11f);
            } else if (dist > 25.0f) {
                arrowMotionY += (double)(dist * 0.07f);
            }
            arrow.func_70186_c(arrowMotionX, arrowMotionY, arrowMotionZ, 1.0f, accuracy);
            arrow.func_70239_b(arrowDamage);
            arrow.field_70159_w *= (double)Math.max(1.0f, hFact);
            arrow.field_70179_y *= (double)Math.max(1.0f, hFact);
            arrow.field_70181_x *= (double)Math.max(1.0f, hFact);
            soure.field_70170_p.func_72838_d((Entity)arrow);
            soure.field_70170_p.func_72956_a((Entity)soure, "random.bow", 1.0f, 1.0f / (soure.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public static final void doArrowAttack(EntityLivingBase soure, EntityLivingBase target, float arrowDamage, boolean hitPlayer, boolean canpick, int arrow_hit_type, int offset) {
        double targetdist = soure.func_70092_e(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v);
        EntityArrowBase arrow = new EntityArrowBase(soure.field_70170_p, soure, 0.0f, new ItemStack(Items.field_151032_g), offset);
        arrow.arrow_hit_type = arrow_hit_type;
        arrow.func_70107_b(soure.field_70165_t, soure.field_70163_u + (double)soure.func_70047_e(), soure.field_70161_v);
        arrow.canHitPlayer = hitPlayer;
        if (!soure.field_70170_p.field_72995_K) {
            float accuracy = 1.0f;
            arrow.func_70243_d(true);
            float dist = MathHelper.func_76129_c((float)((float)targetdist));
            double mx = target.field_70159_w;
            double mz = target.field_70179_y;
            double distFactor = (mx * mx + mz * mz) * 100.0 * (double)dist;
            double arrowMotionX = target.field_70165_t - soure.field_70165_t + target.field_70159_w * distFactor;
            double arrowMotionZ = target.field_70161_v - soure.field_70161_v + target.field_70179_y * distFactor;
            double arrowMotionY = target.field_70163_u + (double)target.func_70047_e() - arrow.field_70163_u + (double)dist * 0.2;
            float hFact = 1.0f;
            if (dist > 14.0f) {
                hFact = 1.0f + dist * 0.025f;
            }
            if (dist > 50.0f) {
                arrowMotionY += (double)(dist * 0.11f);
            } else if (dist > 25.0f) {
                arrowMotionY += (double)(dist * 0.07f);
            }
            arrow.func_70186_c(arrowMotionX, arrowMotionY, arrowMotionZ, 1.0f, accuracy);
            arrow.func_70239_b(arrowDamage);
            arrow.field_70159_w *= (double)Math.max(1.0f, hFact);
            arrow.field_70179_y *= (double)Math.max(1.0f, hFact);
            arrow.field_70181_x *= (double)Math.max(1.0f, hFact);
            if (!canpick) {
                arrow.field_70251_a = 2;
            }
            soure.field_70170_p.func_72838_d((Entity)arrow);
            soure.field_70170_p.func_72956_a((Entity)soure, "random.bow", 1.0f, 1.0f / (soure.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public static final void doArrowAttack(TileEntity soure, EntityLivingBase target, float arrowDamage) {
        double targetdist = soure.func_145835_a(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v);
        EntityArrow arrow = new EntityArrow(soure.func_145831_w(), (double)soure.field_145851_c + 0.5, (double)soure.field_145848_d + 1.5, (double)soure.field_145849_e + 0.5);
        arrow.func_70107_b((double)soure.field_145851_c + 0.5, (double)soure.field_145848_d + 1.5, (double)soure.field_145849_e + 0.5);
        if (!soure.func_145831_w().field_72995_K) {
            float accuracy = 1.0f;
            arrow.func_70243_d(true);
            float dist = MathHelper.func_76129_c((float)((float)targetdist));
            double mx = target.field_70159_w;
            double mz = target.field_70179_y;
            double distFactor = (mx * mx + mz * mz) * 100.0 * (double)dist;
            double arrowMotionX = target.field_70165_t - (double)soure.field_145851_c + target.field_70159_w * distFactor;
            double arrowMotionZ = target.field_70161_v - (double)soure.field_145849_e + target.field_70179_y * distFactor;
            double arrowMotionY = target.field_70163_u + (double)target.func_70047_e() - arrow.field_70163_u + (double)dist * 0.2;
            float hFact = 1.0f;
            if (dist > 14.0f) {
                hFact = 1.0f + dist * 0.025f;
            }
            if (dist > 50.0f) {
                arrowMotionY += (double)(dist * 0.11f);
            } else if (dist > 25.0f) {
                arrowMotionY += (double)(dist * 0.07f);
            }
            arrow.func_70186_c(arrowMotionX, arrowMotionY, arrowMotionZ, 1.0f, accuracy);
            arrow.func_70239_b((double)arrowDamage);
            arrow.field_70159_w *= (double)Math.max(1.0f, hFact);
            arrow.field_70179_y *= (double)Math.max(1.0f, hFact);
            arrow.field_70181_x *= (double)Math.max(1.0f, hFact);
            soure.func_145831_w().func_72838_d((Entity)arrow);
        }
    }
}

