/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.dark_magic;

import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.dark_magic.IDarkEnergyUse;

public class DarkEnergy {
    public int Energy;

    public DarkEnergy(int energy) {
        this.Energy = energy;
    }

    public DarkEnergy(DarkEnergy energy) {
        this.Energy = energy.getEnergy();
    }

    public int getEnergy() {
        return this.Energy;
    }

    public void removeEnergy(int value) {
        this.Energy -= value;
    }

    public void addEnergy(int value) {
        this.Energy += value;
    }

    public boolean isEmpty() {
        return this.getEnergy() == 0;
    }

    public void setEnergy(int value) {
        this.Energy = value;
    }

    public void moveEnergy(DarkEnergy energy, IDarkEnergyUse target, int value) {
        if (energy.getEnergy() > 0) {
            if (value + target.getEnergy().getEnergy() > target.getMaxEnergy()) {
                value = target.getMaxEnergy() - target.getEnergy().getEnergy();
            }
            if (value > energy.getEnergy()) {
                value = energy.getEnergy();
            }
            this.Energy += value;
            energy.removeEnergy(value);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.setEnergy(NBTHelp.getIntSafe("DarkEnergy", nbt, 0));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("DarkEnergy", this.getEnergy());
    }

    public boolean equals(Object obj) {
        return obj instanceof DarkEnergy && ((DarkEnergy)obj).getEnergy() == this.getEnergy();
    }

    public String toString() {
        return "DarkEnergy:" + this.getEnergy();
    }
}

