/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.defensive_tower;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.defensive_tower.DefensiveTowerType;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.magicenergy.IMagicEnergyUse;
import project.studio.manametalmod.magicenergy.MagicEnergy;
import project.studio.manametalmod.spell.EntityGrassMan;

public class TileEntityDefensiveTower
extends TileEntity
implements IMagicEnergyUse,
ISidedInventory {
    public int rangeUpdate = 0;
    public int attackUpdate = 0;
    public int saveUp = 0;
    public int speedUP = 0;
    public ItemStack[] items = new ItemStack[5];
    public int time = 0;
    public DefensiveTowerType type = DefensiveTowerType.Crystal;
    public int speed_attack = 10;
    public boolean attackMob = true;
    public boolean attackAnimal = false;
    public boolean attackPlayer = false;
    public String owner = "MissingNO";
    public boolean isUpdate = false;
    public MagicEnergy MagicEnergys = new MagicEnergy(0);

    public TileEntityDefensiveTower() {
        this.type = DefensiveTowerType.Crystal;
        this.speed_attack = this.type.getSpeed();
    }

    public TileEntityDefensiveTower(DefensiveTowerType type) {
        this.type = type;
        this.speed_attack = this.type.getSpeed();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.rangeUpdate = NBTHelp.getIntSafe("rangeUpdate", nbt, 0);
        this.attackUpdate = NBTHelp.getIntSafe("attackUpdate", nbt, 0);
        this.time = NBTHelp.getIntSafe("time", nbt, 0);
        this.type = DefensiveTowerType.values()[NBTHelp.getIntSafe("type", nbt, 0)];
        this.attackMob = NBTHelp.getBooleanSafe("attackMob", nbt, true);
        this.attackAnimal = NBTHelp.getBooleanSafe("attackAnimal", nbt, false);
        this.attackPlayer = NBTHelp.getBooleanSafe("attackPlayer", nbt, false);
        this.owner = NBTHelp.getStringSafe("owner", nbt, "MissingNO");
        this.speed_attack = NBTHelp.getIntSafe("speed_attack", nbt, this.type.getSpeed());
        this.speedUP = NBTHelp.getIntSafe("speedUP", nbt, 0);
        this.saveUp = NBTHelp.getIntSafe("saveUp", nbt, 0);
        NBTTagList nbttaglist = NBTHelp.getNBTTagListSafe("Items", nbt, 10, new NBTTagList());
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.length) continue;
            this.items[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.MagicEnergys.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("rangeUpdate", this.rangeUpdate);
        nbt.func_74768_a("attackUpdate", this.attackUpdate);
        nbt.func_74768_a("time", this.time);
        nbt.func_74768_a("type", this.type.ordinal());
        nbt.func_74757_a("attackMob", this.attackMob);
        nbt.func_74757_a("attackAnimal", this.attackAnimal);
        nbt.func_74757_a("attackPlayer", this.attackPlayer);
        nbt.func_74778_a("owner", this.owner);
        nbt.func_74768_a("speed_attack", this.speed_attack);
        nbt.func_74768_a("speedUP", this.speedUP);
        nbt.func_74768_a("saveUp", this.saveUp);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        this.MagicEnergys.writeToNBT(nbt);
    }

    public boolean canEntityBeSeen(Entity target) {
        return this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.5)), Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)target.func_70047_e()), (double)target.field_70161_v)) == null;
    }

    public boolean canAttack(EntityLivingBase target) {
        if (this.canEntityBeSeen((Entity)target)) {
            if (target instanceof EntityGrassMan) {
                return false;
            }
            if (target instanceof EntityMob || target instanceof IMob || target instanceof IBossDisplayData) {
                return this.attackMob;
            }
            if (target instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)target;
                return this.attackPlayer && !player.func_70005_c_().equals(this.owner);
            }
            if (target instanceof EntityAnimal || target instanceof IAnimals) {
                return this.attackAnimal;
            }
        }
        return false;
    }

    public EntityLivingBase getCloseEntityCanAttack(List<EntityLivingBase> list, Pos target) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int close = 999999999;
        int id = -1;
        for (int s = 0; s < list.size(); ++s) {
            if (!this.canAttack(list.get(s))) continue;
            Pos closepos = new Pos((Entity)list.get(s));
            int dist = MMM.getBlockDistance(closepos.X, closepos.Y, closepos.Z, target.X, target.Y, target.Z);
            if (dist >= close) continue;
            dist = close;
            id = s;
        }
        if (id != -1) {
            return list.get(id);
        }
        return null;
    }

    public float getAttack() {
        return this.type.getAttack() + this.type.getAttack() * this.attackUpdate;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145845_h() {
        if (!this.isUpdate) {
            this.isUpdate = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.getEnergy().getEnergy() > 0) {
            try {
                ++this.time;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.time >= this.speed_attack) {
                this.time = 0;
                List<EntityLivingBase> list = MMM.findEntityLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.type.getRange() + this.rangeUpdate * 2);
                if (!list.isEmpty()) {
                    this.type.update(list, this);
                }
            }
        }
    }

    public void renovePower(int power) {
        float save = 1.0f - 0.1f * (float)this.saveUp;
        if ((power = (int)((float)power * save)) < 1) {
            power = 1;
        }
        this.MagicEnergys.removeEnergy(power);
    }

    @Override
    public boolean needEnergy() {
        return this.MagicEnergys.getEnergy() < this.getMaxEnergy();
    }

    @Override
    public void onImportEnergy() {
    }

    @Override
    public void addEnergy(MagicEnergy energy) {
    }

    @Override
    public int getMaxEnergy() {
        return 300;
    }

    @Override
    public MagicEnergy getEnergy() {
        return this.MagicEnergys;
    }

    @Override
    public boolean canImport() {
        return true;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.items[p_70298_1_] != null) {
            if (this.items[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.items[p_70298_1_];
                this.items[p_70298_1_] = null;
                return itemstack;
            }
            ItemStack itemstack = this.items[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.items[p_70298_1_].field_77994_a == 0) {
                this.items[p_70298_1_] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.items[slot] != null) {
            ItemStack itemstack = this.items[slot];
            this.items[slot] = null;
            return itemstack;
        }
        return null;
    }

    public int RendererItem() {
        return 0;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.items[slot] = item;
    }

    public String func_145825_b() {
        return "TileEntityDefensiveTower";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int face) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack item, int face) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.setSubItem();
    }

    public void func_70305_f() {
        this.setSubItem();
    }

    public int getAttackSpeed() {
        float save = 1.0f - 0.1f * (float)this.speedUP;
        int speed = this.type.getSpeed();
        if ((speed = (int)((float)speed * save)) < 5) {
            speed = 5;
        }
        return speed;
    }

    public void setSubItem() {
        this.attackUpdate = 0;
        this.rangeUpdate = 0;
        this.saveUp = 0;
        this.speedUP = 0;
        block5: for (int s = 0; s < this.items.length; ++s) {
            if (this.items[s] == null || this.items[s].func_77973_b() != ItemCraft10.ItemPowercrystalUP) continue;
            switch (this.items[s].func_77960_j()) {
                case 0: {
                    ++this.speedUP;
                    continue block5;
                }
                case 1: {
                    ++this.attackUpdate;
                    ++this.rangeUpdate;
                    continue block5;
                }
                case 2: {
                    ++this.saveUp;
                }
            }
        }
        this.speed_attack = this.getAttackSpeed();
    }
}

