/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.dungeon;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;

public class WorldSpawnDungeonBase {
    public static void spawnBaseDungeon(World world, int x, int y, int z, Block wall, Block decoration, int count, int size, int high, int plate) {
        Random rand = world.field_73012_v;
        if (plate % 2 == 0) {
            return;
        }
        byte[] pos = new byte[plate * plate];
        int central = (plate * plate - 1) / 2;
        pos[central] = 1;
        int outo = central;
        WorldSpawnDungeonBase.spawnRoomBase(world, x, y, z, wall, decoration, size, high);
        block6: for (int s = 0; s < count; ++s) {
            for (int r = 0; r < 32; ++r) {
                boolean spawnRoom = false;
                switch (rand.nextInt(4)) {
                    case 0: {
                        if (outo + 1 >= pos.length || (outo + 1) % plate == 0 || pos[outo + 1] != 0) break;
                        pos[outo + 1] = 1;
                        spawnRoom = true;
                        int[] off = WorldSpawnDungeonBase.getOffXZ(central, ++outo, plate, size);
                        byte roomType = WorldSpawnDungeonBase.spawnRandomRoom(world, x + off[0], y, z + off[1], wall, decoration, size, high, false);
                        WorldSpawnDungeonBase.updateRooms(outo, roomType, x + off[0], y, z + off[1], pos, wall, decoration, size, high, plate);
                        break;
                    }
                    case 1: {
                        if (outo - 1 <= 0 || outo % 9 == 0 || pos[outo - 1] != 0) break;
                        pos[outo - 1] = 1;
                        spawnRoom = true;
                        int[] off = WorldSpawnDungeonBase.getOffXZ(central, --outo, plate, size);
                        byte roomType = WorldSpawnDungeonBase.spawnRandomRoom(world, x + off[0], y, z + off[1], wall, decoration, size, high, false);
                        WorldSpawnDungeonBase.updateRooms(outo, roomType, x + off[0], y, z + off[1], pos, wall, decoration, size, high, plate);
                        break;
                    }
                    case 2: {
                        if (outo + plate >= pos.length || pos[outo + plate] != 0) break;
                        pos[outo + plate] = 1;
                        spawnRoom = true;
                        int[] off = WorldSpawnDungeonBase.getOffXZ(central, outo += plate, plate, size);
                        byte roomType = WorldSpawnDungeonBase.spawnRandomRoom(world, x + off[0], y, z + off[1], wall, decoration, size, high, true);
                        WorldSpawnDungeonBase.updateRooms(outo, roomType, x + off[0], y, z + off[1], pos, wall, decoration, size, high, plate);
                        break;
                    }
                    case 3: {
                        if (outo - plate <= 0 || pos[outo - plate] != 0) break;
                        pos[outo - plate] = 1;
                        spawnRoom = true;
                        int[] off = WorldSpawnDungeonBase.getOffXZ(central, outo -= plate, plate, size);
                        byte roomType = WorldSpawnDungeonBase.spawnRandomRoom(world, x + off[0], y, z + off[1], wall, decoration, size, high, true);
                        WorldSpawnDungeonBase.updateRooms(outo, roomType, x + off[0], y, z + off[1], pos, wall, decoration, size, high, plate);
                    }
                }
                if (spawnRoom) continue block6;
            }
        }
    }

    public static void updateRoomsFor(int id, byte type, int x, int y, int z, byte[] pos, Block wall, Block decoration, int size, int high, int plate) {
        block8: for (int s = 0; s < 4; ++s) {
            switch (s) {
                case 0: {
                    if (id + 1 >= pos.length || (id + 1) % plate == 0) continue block8;
                    switch (pos[id + 1]) {
                        default: 
                    }
                    continue block8;
                }
                case 1: {
                    if (id - 1 <= 0) continue block8;
                    continue block8;
                }
                case 2: {
                    if (id + plate >= pos.length) continue block8;
                    continue block8;
                }
                case 3: {
                    if (id - plate <= 0) continue block8;
                }
            }
        }
    }

    public static void updateRooms(int id, byte type, int x, int y, int z, byte[] pos, Block wall, Block decoration, int size, int high, int plate) {
        switch (type) {
            case 1: {
                MMM.Logg("\u5699\u8ac7\u4f57\u856d\u5699\u8acb\u585a\u856d", id, x, z);
                return;
            }
            case 2: {
                MMM.Logg("\u5699\u8ac7\u4f57\u856d\u5699\u8e1d\u856d\u5699\u78d0", id, x, z);
                WorldSpawnDungeonBase.updateRoomsFor(id, type, x, y, z, pos, wall, decoration, size, high, plate);
                return;
            }
            case 3: {
                MMM.Logg("\u5699\u8ac7\u4f57\u856d\u5699\u8e1d\u856d\u5699\u78d0", id, x, z);
                WorldSpawnDungeonBase.updateRoomsFor(id, type, x, y, z, pos, wall, decoration, size, high, plate);
                return;
            }
        }
    }

    public static String getTypeName(byte id) {
        switch (id) {
            case 1: {
                return "room";
            }
            case 2: {
                return "CorridorX";
            }
            case 3: {
                return "CorridorZ";
            }
        }
        return "null";
    }

    public static int[] getOffXZ(int central, int outo, int plate, int size) {
        if (central == outo) {
            return new int[]{0, 0};
        }
        int[] pos = new int[]{0, 0};
        int dx = (outo - central) % plate;
        int dz = outo / plate;
        int average = plate / 2;
        pos[0] = dx > average ? (plate - dx) * -size : (dx < average ? size * dx : 0);
        pos[1] = dz > average ? (dz - average) * -size : (dz < average ? size * (dz - average) : 0);
        return pos;
    }

    public static void spawnRoomBase(World world, int x, int y, int z, Block wall, Block decoration, int size, int high) {
        WorldSpawnDungeonBase.spawnBlock(world, wall, size, high - 2, x, y + 1, z);
        WorldSpawnDungeonBase.spawnBlock(world, decoration, size, 1, x, y, z);
        WorldSpawnDungeonBase.spawnBlock(world, decoration, size, 1, x, y + (high - 1), z);
        WorldSpawnDungeonBase.spawnBlock(world, Blocks.field_150350_a, size - 2, high - 2, x + 1, y + 1, z + 1);
        int piss = size - 3;
        WorldSpawnDungeonBase.spawnBlock(world, decoration, 1, high, x + 2, y, z + 2);
        WorldSpawnDungeonBase.spawnBlock(world, decoration, 1, high, x + 2, y, z + piss);
        WorldSpawnDungeonBase.spawnBlock(world, decoration, 1, high, x + piss, y, z + 2);
        WorldSpawnDungeonBase.spawnBlock(world, decoration, 1, high, x + piss, y, z + piss);
        int door = size / 2 - 1;
        WorldSpawnDungeonBase.spawnBlock(world, Blocks.field_150350_a, 3, size, 4, x + door, y + 1, z);
        WorldSpawnDungeonBase.spawnBlock(world, Blocks.field_150350_a, size, 3, 4, x, y + 1, z + door);
    }

    public static void spawnRoomCorridor(World world, int x, int y, int z, Block wall, Block decoration, int size, int high, boolean type, int add) {
        int ds = add / 2;
        if (type) {
            WorldSpawnDungeonBase.spawnBlock(world, wall, size - 2 - add, size, high - 2, x + 1 + ds, y + 1, z);
            WorldSpawnDungeonBase.spawnBlock(world, decoration, size - 2 - add, size, 1, x + 1 + ds, y, z);
            WorldSpawnDungeonBase.spawnBlock(world, decoration, size - 2 - add, size, 1, x + 1 + ds, y + (high - 1), z);
            WorldSpawnDungeonBase.spawnBlock(world, Blocks.field_150350_a, size - 4 - add, size, high - 2, x + 2 + ds, y + 1, z);
        } else {
            WorldSpawnDungeonBase.spawnBlock(world, wall, size, size - 2 - add, high - 2, x, y + 1, z + 1 + ds);
            WorldSpawnDungeonBase.spawnBlock(world, decoration, size, size - 2 - add, 1, x, y, z + 1 + ds);
            WorldSpawnDungeonBase.spawnBlock(world, decoration, size, size - 2 - add, 1, x, y + (high - 1), z + 1 + ds);
            WorldSpawnDungeonBase.spawnBlock(world, Blocks.field_150350_a, size, size - 4 - add, high - 2, x, y + 1, z + 2 + ds);
        }
    }

    public static void spawnBlock(World world, Block block, int size, int high, int x, int y, int z) {
        for (int dy = 0; dy < high; ++dy) {
            for (int dx = 0; dx < size; ++dx) {
                for (int dz = 0; dz < size; ++dz) {
                    world.func_147465_d(x + dx, y + dy, z + dz, block, 0, 2);
                }
            }
        }
    }

    public static void spawnBlock(World world, Block block, int sizeX, int sizeZ, int high, int x, int y, int z) {
        for (int dy = 0; dy < high; ++dy) {
            for (int dx = 0; dx < sizeX; ++dx) {
                for (int dz = 0; dz < sizeZ; ++dz) {
                    world.func_147465_d(x + dx, y + dy, z + dz, block, 0, 2);
                }
            }
        }
    }

    public static byte spawnRandomRoom(World world, int x, int y, int z, Block wall, Block decoration, int size, int high, boolean type) {
        if (world.field_73012_v.nextInt(100) > 50) {
            WorldSpawnDungeonBase.spawnRoomBase(world, x, y, z, wall, decoration, size, high);
            return 1;
        }
        switch (world.field_73012_v.nextInt(2)) {
            case 0: {
                WorldSpawnDungeonBase.spawnRoomCorridor(world, x, y, z, wall, decoration, size, high, type, 2);
                return 2;
            }
            case 1: {
                WorldSpawnDungeonBase.spawnRoomCorridor(world, x, y, z, wall, decoration, size, high, type, 2);
                return 3;
            }
        }
        return -1;
    }
}

