/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.entity.nbt;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import project.studio.manametalmod.card.BattleCard;
import project.studio.manametalmod.card.IManaBattleCards;
import project.studio.manametalmod.core.EntityNBTBaseM3;
import project.studio.manametalmod.core.Location;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.skyadventure.Battleship;
import project.studio.manametalmod.skyadventure.BattleshipData;
import project.studio.manametalmod.skyadventure.SkyCard;
import tw.pearki.mcmod.muya.common.SendType;

public class NbtBattleCard
extends EntityNBTBaseM3
implements IInventory {
    protected final ManaMetalModRoot obj;
    public static final int maxSkyCard = 8;
    public ItemStack[] inventory;
    private BattleshipData data;
    public SkyCard[] skycard = new SkyCard[8];
    public int cardLV = 1;
    private int cardXP = 0;
    public int cardPoint = 0;
    public static final int cardMaxLV = 20;
    public boolean isInSky = false;
    public Location LocationSky = new Location();

    public static int getLVNeedXP(int LV2) {
        return (int)((double)(100 * LV2) * 1.25);
    }

    public void send2() {
        if (this.entity instanceof EntityPlayerMP) {
            this.SendTo((EntityPlayerMP)this.entity);
        }
    }

    public void addCardPoint(int point) {
        this.cardPoint += point;
        this.send2();
    }

    public void addCardXP(int xp) {
        this.setCardXP(this.getCardXP() + xp);
        if (this.cardLV < 20) {
            while (this.getCardXP() >= NbtBattleCard.getLVNeedXP(this.cardLV)) {
                if (this.cardLV >= 20) continue;
                this.setCardXP(this.getCardXP() - NbtBattleCard.getLVNeedXP(this.cardLV));
                ++this.cardLV;
                EntityPlayer player = (EntityPlayer)this.entity;
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("MMM.info.onPlayerLVUPCard", new Object[0]));
            }
        }
        this.send2();
    }

    public NbtBattleCard(ManaMetalModRoot obj) {
        this.obj = obj;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.data = new BattleshipData((EntityPlayer)this.entity);
    }

    public Class<? extends EntityLivingBase> AddChildCondition() {
        return EntityPlayer.class;
    }

    public boolean addSkyCard(SkyCard card) {
        for (int s = 0; s < 8; ++s) {
            if (this.skycard[s] != null) continue;
            this.skycard[s] = card;
            this.send2();
            return true;
        }
        return false;
    }

    public void removeSkyCard(int id) {
        this.skycard[id] = null;
        this.send2();
    }

    public void removeSkyCardAll() {
        this.skycard = new SkyCard[8];
        this.send2();
    }

    public boolean testCard(int lv) {
        ItemStack[] card1 = this.getCard();
        int maxSize = BattleCard.getCardMaxSizeLV(lv);
        int size = 0;
        for (int z = 0; z < card1.length; ++z) {
            if (card1[z] != null && card1[z].func_77973_b() instanceof IManaBattleCards) {
                IManaBattleCards cards = (IManaBattleCards)card1[z].func_77973_b();
                size += cards.getSize(card1[z]);
                continue;
            }
            return false;
        }
        ItemStack[] card2 = this.getCardStack();
        for (int z = 0; z < card2.length; ++z) {
            if (card2[z] != null && card2[z].func_77973_b() instanceof IManaBattleCards) {
                IManaBattleCards cards = (IManaBattleCards)card2[z].func_77973_b();
                size += cards.getSize(card2[z]);
                continue;
            }
            return false;
        }
        return size <= maxSize;
    }

    public ItemStack[] getCard() {
        ItemStack[] item = new ItemStack[5];
        for (int s = 0; s < 5; ++s) {
            if (this.func_70301_a(40 + s) == null) continue;
            item[s] = this.func_70301_a(40 + s).func_77946_l();
        }
        return item;
    }

    public ItemStack[] getCardStack() {
        ItemStack[] item = new ItemStack[10];
        for (int s = 0; s < 10; ++s) {
            if (this.func_70301_a(30 + s) == null) continue;
            item[s] = this.func_70301_a(30 + s).func_77946_l();
        }
        return item;
    }

    public void LoadNBT(NBTTagCompound nbt) {
        this.isInSky = NBTHelp.getBooleanSafe("isInSky", nbt, false);
        if (this.LocationSky.canReadFromNBT(nbt)) {
            this.LocationSky.readFromNBT(nbt);
        }
        this.cardLV = nbt.func_74762_e("cardLV");
        this.setCardXP(nbt.func_74762_e("cardXP"));
        this.cardPoint = nbt.func_74762_e("cardPoint");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.getData().loadNBTData(nbt);
        this.skycard = new SkyCard[8];
        for (int s = 0; s < this.skycard.length; ++s) {
            if (!nbt.func_150297_b("skycard_" + s, 3)) continue;
            this.skycard[s] = SkyCard.values()[nbt.func_74762_e("skycard_" + s)];
        }
    }

    @Override
    public void SaveNBT(SendType type, NBTTagCompound nbt) {
        nbt.func_74757_a("isInSky", this.isInSky);
        this.LocationSky.saveToNBT(nbt);
        nbt.func_74768_a("cardLV", this.cardLV);
        nbt.func_74768_a("cardXP", this.getCardXP());
        nbt.func_74768_a("cardPoint", this.cardPoint);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        for (int s = 0; s < this.skycard.length; ++s) {
            if (this.skycard[s] == null) continue;
            nbt.func_74768_a("skycard_" + s, this.skycard[s].ordinal());
        }
        this.getData().saveNBTData(nbt);
    }

    public void Update() {
    }

    public int func_70302_i_() {
        return 50;
    }

    public void clearAllItems() {
        for (int d = 0; d < this.func_70302_i_(); ++d) {
            this.inventory[d] = null;
        }
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.inventory[p_70301_1_];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.inventory[p_70298_1_] != null) {
            if (this.inventory[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.inventory[p_70298_1_];
                this.inventory[p_70298_1_] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.inventory[p_70298_1_].field_77994_a == 0) {
                this.inventory[p_70298_1_] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.inventory[p_70304_1_] != null) {
            ItemStack itemstack = this.inventory[p_70304_1_];
            this.inventory[p_70304_1_] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inventory[p_70299_1_] = p_70299_2_;
        if (p_70299_2_ != null && p_70299_2_.field_77994_a > this.func_70297_j_()) {
            p_70299_2_.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "container.Card";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack p_94041_2_) {
        return true;
    }

    public BattleshipData getData() {
        return this.data;
    }

    public void addXP(int xp) {
        this.getData().exp += xp;
        this.send2();
    }

    public void repairShip() {
        this.getData().heal = this.getData().healMax;
        this.send2();
    }

    public void buyShip(Battleship ship) {
        this.getData().boat = ship;
        this.getData().heal = ship.getAttributes()[0];
        this.getData().healMax = ship.getAttributes()[0];
        this.getData().boatLV = 1;
        this.send2();
    }

    public void updateShip() {
        BattleshipData data = this.getData();
        if (data.boatLV < 10) {
            ++data.boatLV;
            data.heal += data.boat.getUPHP();
            data.healMax += data.boat.getUPHP();
            this.send2();
        }
    }

    public void setData(BattleshipData data) {
        this.data = data;
        this.send2();
    }

    public int getCardXP() {
        return this.cardXP;
    }

    public void setCardXP(int cardXP) {
        this.cardXP = cardXP;
    }

    protected void Init() {
    }
}

