/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.achievement.ManaMetalModAchievement;
import project.studio.manametalmod.api.IBlockUnbreakable;
import project.studio.manametalmod.api.ICoins;
import project.studio.manametalmod.auction.Auction;
import project.studio.manametalmod.bosssummon.BossSummonCore;
import project.studio.manametalmod.card.UseWeaponResult;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.FakePlayerFactoryM3;
import project.studio.manametalmod.core.GameDifficult;
import project.studio.manametalmod.core.Location;
import project.studio.manametalmod.core.MachineRestriction;
import project.studio.manametalmod.core.OreNameItemStack;
import project.studio.manametalmod.core.PickItem;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.damagesystem.DamageType;
import project.studio.manametalmod.entity.EntityItemM3;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.fashion.FasgionBlockType;
import project.studio.manametalmod.food_collection.FoodCollectionCore;
import project.studio.manametalmod.furniture.FurnitureCore;
import project.studio.manametalmod.instance_dungeon.BlockInstanceDungeonPortal;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft2;
import project.studio.manametalmod.items.ItemCoinSpecial;
import project.studio.manametalmod.items.ItemToolBackpackBase;
import project.studio.manametalmod.items.ItemToolOp;
import project.studio.manametalmod.items.ItemToolPickaxeBedrock;
import project.studio.manametalmod.items.ItemTrophy;
import project.studio.manametalmod.magic.magicItem.MagicItemCore;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.MessagePlayerMessage;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.newmc.NewMinecraftCore;
import project.studio.manametalmod.optool.OpToolCore;
import project.studio.manametalmod.optool.PlayerBlockAction;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.produce.cuisine.ICuisine;
import project.studio.manametalmod.produce.farming.FarmCore;
import project.studio.manametalmod.produce.fishing.FishingCore;
import project.studio.manametalmod.produce.fishing.ItemToolFistIngRod;
import project.studio.manametalmod.produce.textile.ItemToolBlackBackpack;
import project.studio.manametalmod.produce.textile.RecipesBackpackDyes;
import project.studio.manametalmod.produce.textile.TextileCore;
import project.studio.manametalmod.seasontarget.SeasonTargetReward;
import project.studio.manametalmod.soulinherit.SoulInheritCore;
import project.studio.manametalmod.spell.ISummoner;
import project.studio.manametalmod.statistics.PlayerStatisticsCore;
import project.studio.manametalmod.target.Target;
import project.studio.manametalmod.target.TargetTrigger;
import project.studio.manametalmod.team.Team;
import project.studio.manametalmod.tileentity.TileEntityIngot;
import project.studio.manametalmod.tileentity.TileEntityManaMetalInjection;
import project.studio.manametalmod.tileentity.TileEntityPowerCrystalOther;
import project.studio.manametalmod.treasurehunt.ItemHeavyTreasure;
import project.studio.manametalmod.utils.TreeCore;
import project.studio.manametalmod.watergame.BlockWaterGame;
import project.studio.manametalmod.world.generate.WorldGenDungeon;
import project.studio.manametalmod.world.generate.WorldGenDungeonDoor;

public class EventMana {
    public static final String[] tpcommands = new String[]{"tp", "home", "spawn", "back", "sethome", "tpa", "tpl", "tphere", "m3tp", "wtp", "m3goto"};

    @SubscribeEvent
    public void WorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            WorldGenDungeon.serverStart(event);
            WorldGenDungeonDoor.serverStart(event);
            Auction.serverStart(event);
            MachineRestriction.serverStart(event);
            GameDifficult.read(event);
            Team.load(event);
            Target.load(event);
            SoulInheritCore.load(event);
            FoodCollectionCore.load(event);
            SeasonTargetReward.load(event);
            PlayerStatisticsCore.load(event);
        }
    }

    @SubscribeEvent
    public void WorldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K) {
            WorldGenDungeon.serverStop(event);
            WorldGenDungeonDoor.serverStop(event);
            Auction.serverStop(event);
            MachineRestriction.serverStop(event);
            GameDifficult.save(event);
            Team.save(event);
            Target.save(event);
            SoulInheritCore.save(event);
            FoodCollectionCore.save(event);
            SeasonTargetReward.save(event);
            PlayerStatisticsCore.save(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionUnload(WorldEvent.Unload event) {
        if (event.world instanceof WorldServer) {
            FakePlayerFactoryM3.unloadWorld((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void command(CommandEvent event) {
        if (event.sender instanceof EntityPlayer) {
            String command;
            EntityPlayer player = (EntityPlayer)event.sender;
            if (!player.field_70170_p.field_72995_K && MMM.getDimensionID(player.field_70170_p) == M3Config.WorldInstanceDungeonID && (command = event.command.func_71517_b()) != null && MMM.isStringStartFromArray(tpcommands, command)) {
                MMM.addMessage(player, "MMM.info.tp.dungeon");
                BlockInstanceDungeonPortal.clearDungeonlimitedItem(player);
            }
        }
    }

    @SubscribeEvent
    public void player_dropWeapon(ItemTossEvent event) {
        if (!M3Config.PreventDropWeapons || event.entityItem == null || event.entityItem.func_92059_d() == null || event.entityItem.field_70128_L) {
            return;
        }
        if (event.player == null || event.isCanceled()) {
            return;
        }
        if (MMM.getItemIsWeapon(event.entityItem.func_92059_d())) {
            ItemStack weapon = event.entityItem.func_92059_d().func_77946_l();
            event.setCanceled(true);
            MMM.addItemToPlayer(weapon, event.player);
        }
    }

    @SubscribeEvent
    public void player_dropItem(ItemTossEvent event) {
        if (event.entityItem == null || event.entityItem.func_92059_d() == null) {
            return;
        }
        if (!event.entityItem.field_70170_p.field_72995_K) {
            if (event.entityItem.func_92059_d().func_77973_b() instanceof ItemHeavyTreasure && event.entityItem.field_70170_p.field_73012_v.nextInt(2) == 0) {
                event.entityItem.func_70106_y();
            }
            if (event.entityItem.func_92059_d().func_77973_b() == ItemCraft10.ItemAstridWeaponCannonball || event.entityItem.func_92059_d().func_77973_b() == ItemCraft10.ItemAstridWeaponSpear) {
                event.entityItem.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void CoalMinecartInteract(MinecartInteractEvent event) {
        ItemStack item;
        if (event.player == null || event.minecart == null) {
            return;
        }
        if (event.minecart instanceof EntityMinecartFurnace && (item = event.player.func_71045_bC()) != null && item.func_77973_b() == ManaMetalMod.ManaCoal) {
            try {
                ReflectionHelper.setPrivateValue(EntityMinecartFurnace.class, (Object)((EntityMinecartFurnace)event.minecart), (Object)28000, (String[])new String[]{"fuel", "field_94110_c"});
                MMM.removePlayerCurrentItem(event.player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void EntityEnteringChunk(EntityJoinWorldEvent event) {
        if (event.isCanceled() || event.entity == null || event.entity.field_70128_L || event.entity instanceof EntityPlayer) {
            return;
        }
        if (event.entity instanceof INpc || event.entity instanceof IBossDisplayData || event.entity instanceof ISummoner || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!M3Config.UseResistanceCrystal) {
            return;
        }
        if (event.entity instanceof EntityMob || event.entity instanceof IMob) {
            try {
                Chunk Chunks = event.entity.field_70170_p.func_72938_d((int)event.entity.field_70165_t, (int)event.entity.field_70161_v);
                if (Chunks != null) {
                    for (Object key : Chunks.field_150816_i.keySet()) {
                        if (!(Chunks.field_150816_i.get(key) instanceof TileEntityPowerCrystalOther)) continue;
                        TileEntityPowerCrystalOther tile = (TileEntityPowerCrystalOther)Chunks.field_150816_i.get(key);
                        if (tile.type != 12) continue;
                        if (tile.hasEMEandRemove(tile.useMana)) {
                            event.setCanceled(true);
                        }
                        return;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void PlayerInteractEventEvent(PlayerInteractEvent event) {
        ItemStack item;
        ItemStack stack;
        if (event.entityPlayer instanceof FakePlayer) {
            return;
        }
        if (MMM.playerCanUseWeapon(event.entityPlayer) == UseWeaponResult.fail) {
            MMM.addMessage(event.entityPlayer, "MMM.info.playerCantUseWeapon");
            return;
        }
        if (PotionEffectM3.isPotion((EntityLivingBase)event.entityPlayer, PotionM3.potionPlayerDef) && !MMM.isPlayerCreativeMode(event.entityPlayer)) {
            event.setCanceled(true);
            return;
        }
        if (MMM.isPlayerCreativeMode(event.entityPlayer) && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && (stack = event.entityPlayer.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemFood) {
            event.entityPlayer.func_71008_a(stack, stack.func_77973_b().func_77626_a(stack));
            return;
        }
        if (M3Config.PreventBackpackCopyItem && !event.entityPlayer.field_70170_p.field_72995_K && (stack = event.entityPlayer.func_71045_bC()) != null && ManaMetalAPI.backpackAntiCheatingList.contains(stack.func_77973_b()) && stack.field_77994_a > 1) {
            stack.field_77994_a = 1;
            MMM.warningM3Player(event.entityPlayer, "try open " + stack.func_82833_r() + " stackSize > 1!");
            return;
        }
        if (M3Config.PreventIllegalDungeonItem && !event.entityPlayer.field_70170_p.field_72995_K && MMM.getDimensionID(event.world) == M3Config.WorldInstanceDungeonID && event.entityPlayer.func_71045_bC() != null && !MMM.isItemCanUseInDungeon(event.entityPlayer.func_71045_bC(), event.entityPlayer)) {
            event.setCanceled(true);
            event.entityPlayer.func_71034_by();
            return;
        }
        if (M3Config.UseShearsWool && !event.entityPlayer.field_70170_p.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (item = event.entityPlayer.func_71045_bC()) != null && item.func_77973_b() == TextileCore.shears_wool && event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150325_L) {
            MMM.spawnItemToPlayer(new ItemStack(TextileCore.ItemTextiles, 1, 9), event.entityPlayer);
            event.entityPlayer.field_70170_p.func_147468_f(event.x, event.y, event.z);
            event.entityPlayer.field_70170_p.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), "mob.sheep.shear", 1.0f, 1.0f + MMM.floatRandom(2.0f));
            event.setCanceled(true);
            return;
        }
        if (M3Config.UseIngotStack && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (item = event.entityPlayer.func_71045_bC()) != null && MMM.getItemIsIngot(item) && MMM.getDimensionID(event.entityPlayer.field_70170_p) != M3Config.WorldAncientEmpireID && event.face == 1 && event.entityPlayer.func_70093_af() && !event.world.field_72995_K && event.world.func_147437_c(event.x, event.y + 1, event.z)) {
            event.world.func_147465_d(event.x, event.y + 1, event.z, ItemCraft10.ManaIngotE, 0, 2);
            if (event.world.func_147438_o(event.x, event.y + 1, event.z) instanceof TileEntityIngot) {
                TileEntityIngot tile = (TileEntityIngot)event.world.func_147438_o(event.x, event.y + 1, event.z);
                tile.func_70299_a(0, new ItemStack(item.func_77973_b(), 1, item.func_77960_j()));
                if (item.field_77994_a == 1) {
                    event.entityPlayer.func_71028_bD();
                } else {
                    --item.field_77994_a;
                }
                event.setCanceled(true);
            }
        }
        if (M3Config.UseRawhide && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (item = event.entityPlayer.func_71045_bC()) != null && item.func_77973_b() == Items.field_151116_aA && event.face == 1 && event.entityPlayer.func_70093_af() && !event.world.field_72995_K && event.world.func_147437_c(event.x, event.y + 1, event.z)) {
            event.world.func_147465_d(event.x, event.y + 1, event.z, TextileCore.BlockRawhides, 0, 2);
            MMM.removePlayerCurrentItem(event.entityPlayer);
            event.setCanceled(true);
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer.func_70093_af() && (stack = event.entityPlayer.func_71045_bC()) != null && stack.func_77973_b() == Item.func_150898_a((Block)FurnitureCore.BlockContainerPlaceholder) && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            NBTTagCompound tag = new NBTTagCompound();
            Pos pos = new Pos(event.x, event.y, event.z);
            pos.saveToNBT(tag);
            stack.func_77982_d(tag);
            MMM.addMessage(event.entityPlayer, "MMM.info.setPlaceholderBlock", new ItemStack(event.world.func_147439_a(event.x, event.y, event.z), 1, event.world.func_72805_g(event.x, event.y, event.z)).func_82833_r());
            event.setCanceled(true);
            return;
        }
        if (M3Config.UseHoeWaterFarmland && !event.entityPlayer.field_70170_p.field_72995_K && event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (stack = event.entityPlayer.func_71045_bC()) != null && (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150349_c || event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150346_d) && stack != null && stack.func_77973_b() instanceof ItemHoe) {
            event.entityPlayer.field_70170_p.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), Blocks.field_150346_d.field_149762_H.func_150498_e(), (Blocks.field_150346_d.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150346_d.field_149762_H.func_150494_d() * 0.8f);
            event.entityPlayer.field_70170_p.func_147465_d(event.x, event.y, event.z, FarmCore.farmwater, 0, 2);
            event.setCanceled(true);
            event.entityPlayer.func_71038_i();
            return;
        }
        if (M3Config.UseStrippedLog && !event.entityPlayer.field_70170_p.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (stack = event.entityPlayer.func_71045_bC()) != null) {
            if (stack.func_77973_b() instanceof ItemSpade) {
                if (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) instanceof BlockGrass || event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150346_d) {
                    event.entityPlayer.field_70170_p.func_147449_b(event.x, event.y, event.z, NewMinecraftCore.BlockGrassPaths);
                    event.entityPlayer.field_70170_p.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), "manametalmod:item.flatten", 1.0f, 1.0f + MMM.floatRandom(2.0f));
                    event.entityPlayer.func_71038_i();
                }
                return;
            }
            if (stack.func_77973_b() instanceof ItemAxe) {
                if (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150364_r) {
                    int data = event.entityPlayer.field_70170_p.func_72805_g(event.x, event.y, event.z);
                    event.entityPlayer.field_70170_p.func_147465_d(event.x, event.y, event.z, NewMinecraftCore.BlockLogMC1, data, 2);
                    event.entityPlayer.field_70170_p.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), "manametalmod:item.strip", 1.0f, 1.0f + MMM.floatRandom(2.0f));
                    event.entityPlayer.func_71038_i();
                } else if (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150363_s) {
                    int data = event.entityPlayer.field_70170_p.func_72805_g(event.x, event.y, event.z);
                    event.entityPlayer.field_70170_p.func_147465_d(event.x, event.y, event.z, NewMinecraftCore.BlockLogMC2, data, 2);
                    event.entityPlayer.field_70170_p.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), "manametalmod:item.strip", 1.0f, 1.0f + MMM.floatRandom(2.0f));
                    event.entityPlayer.func_71038_i();
                } else if (TreeCore.treeBreakMap.containsKey(event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z))) {
                    int data = event.entityPlayer.field_70170_p.func_72805_g(event.x, event.y, event.z);
                    event.entityPlayer.field_70170_p.func_147465_d(event.x, event.y, event.z, TreeCore.treeBreakMap.get(event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z)), data, 2);
                    event.entityPlayer.field_70170_p.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), "manametalmod:item.strip", 1.0f, 1.0f + MMM.floatRandom(2.0f));
                    event.entityPlayer.func_71038_i();
                }
                return;
            }
        }
        if (M3Config.BreakBedrock && !event.entityPlayer.field_70170_p.field_72995_K && event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            stack = event.entityPlayer.func_71045_bC();
            if (stack == null) {
                return;
            }
            if (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150357_h && stack != null && stack.func_77973_b() instanceof ItemToolPickaxeBedrock) {
                stack.func_77973_b().onBlockStartBreak(stack, event.x, event.y, event.z, event.entityPlayer);
            }
            if (stack != null && stack.field_77994_a <= 0) {
                event.entityPlayer.func_71028_bD();
            }
        }
        if (M3Config.MakeMud && !event.entityPlayer.field_70170_p.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (stack = event.entityPlayer.func_71045_bC()) != null && stack.func_77973_b() == Items.field_151068_bn && stack.func_77960_j() == 0 && event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == Blocks.field_150346_d) {
            MMM.removePlayerCurrentItem(event.entityPlayer);
            MMM.addItemToPlayer(Items.field_151069_bo, event.entityPlayer);
            event.entityPlayer.field_70170_p.func_147465_d(event.x, event.y, event.z, NewMinecraftCore.mud, 0, 2);
        }
    }

    public boolean isOcean(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_150575_M || biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76776_l) {
            return true;
        }
        if (biome instanceof BiomeGenOcean || biome instanceof BiomeGenBeach) {
            return true;
        }
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void breakblockEvent(BlockEvent.BreakEvent event) {
        IBlockUnbreakable ibun;
        if (event.getPlayer() instanceof FakePlayer || ItemToolOp.breakBlock(event.getPlayer().field_70170_p, event.getPlayer(), event.x, event.y, event.z, event.block, event.blockMetadata)) {
            return;
        }
        if (M3Config.MachineRestriction && !MachineRestriction.doBreakEvent(event)) {
            event.setCanceled(true);
            return;
        }
        if (MMM.getDimensionID(event.world) == M3Config.WorldInstanceDungeonID || MMM.getDimensionID(event.world) == M3Config.WorldFutureID) {
            if (!MMM.isPlayerCreativeMode(event.getPlayer())) {
                event.setCanceled(true);
            }
            return;
        }
        if (event.getPlayer() != null && !MMM.isPlayerCreativeMode(event.getPlayer()) && (PotionEffectM3.isPotion((EntityLivingBase)event.getPlayer(), PotionM3.potionDestroy) || PotionEffectM3.isPotion((EntityLivingBase)event.getPlayer(), PotionM3.potionPlayerDef))) {
            event.setCanceled(true);
            return;
        }
        TargetTrigger.onBreakBlock(event.getPlayer(), event.block, event.blockMetadata);
        if (!event.world.field_72995_K) {
            ManaMetalModRoot root = MMM.getEntityNBT(event.getPlayer());
            if (root.fashion.func_70301_a(17) != null) {
                PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(57, (float)event.x, (float)event.y, (float)event.z, root.fashion.func_70301_a(17).func_77960_j(), 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(event.world), (double)event.x, (double)event.y, (double)event.z, 16.0));
            }
        }
        if (M3Config.RecordPlayerBlockAction) {
            PlayerBlockAction data = new PlayerBlockAction();
            data.player_name = event.getPlayer().func_70005_c_();
            data.block_name = event.block.func_149732_F();
            data.pos = new Location(event.x, event.y, event.z, MMM.getDimensionID(event.world));
            data.PlayerActionType = 0;
            data.time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            OpToolCore.playerActionList.add(data);
        }
        if (M3Config.ProtectItemContainer) {
            IInventory items1;
            TileEntity tile;
            if (event.block == FishingCore.BlockTileEntityFishBoxs) {
                return;
            }
            if (!MMM.isPlayerCreativeMode(event.getPlayer()) && event.block instanceof ITileEntityProvider && (tile = event.world.func_147438_o(event.x, event.y, event.z)) != null && tile instanceof IInventory && (items1 = (IInventory)tile).func_70302_i_() > 19) {
                for (int s = 0; s < items1.func_70302_i_(); ++s) {
                    if (items1.func_70301_a(s) == null) continue;
                    event.setCanceled(true);
                    if (!event.world.field_72995_K) {
                        MMM.addMessage(event.getPlayer(), "MMM.info.Protect_Item_container");
                    }
                    return;
                }
            }
        }
        if (!M3Config.ProtectSpecialBlock) {
            return;
        }
        if (!MMM.isPlayerCreativeMode(event.getPlayer()) && event.getPlayer().field_70170_p.func_147439_a(event.x, event.y, event.z) instanceof IBlockUnbreakable && !(ibun = (IBlockUnbreakable)event.getPlayer().field_70170_p.func_147439_a(event.x, event.y, event.z)).canBreak(event.world, event.x, event.y, event.z, event.getPlayer())) {
            if (!event.world.field_72995_K) {
                MMM.addMessage(event.getPlayer(), "MMM.info.IBlockUnbreakable");
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void pickitems(EntityItemPickupEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            if (event.entityPlayer instanceof FakePlayer || event.item == null || event.item.func_92059_d() == null) {
                return;
            }
            EntityPlayer player = event.entityPlayer;
            if (event.item instanceof EntityItemM3 && PickItem.pickTeamItem(event, player)) {
                return;
            }
            TargetTrigger.onPickItem(player, event.item.func_92059_d().func_77946_l());
            if (ItemToolBlackBackpack.destroy(event, player)) {
                return;
            }
            if (event.item.func_92059_d().func_77973_b() instanceof ICoins || event.item.func_92059_d().func_77973_b() instanceof ItemCoinSpecial) {
                PickItem.pickCoint(event, player);
                return;
            }
            if (event.item.func_92059_d().func_77973_b() == ManaMetalMod.dustMana || event.item.func_92059_d().func_77973_b() == ItemCraft10.ItemMana) {
                PickItem.pickMana(event, player);
                return;
            }
            if (event.item.func_92059_d().func_77973_b() == Items.field_151126_ay) {
                PickItem.pickSnow(event, player);
                return;
            }
            if (event.item.func_92059_d().func_77973_b() == ItemCraft2.ItemSPCs) {
                PickItem.pickSouls(event, player);
                return;
            }
            if (event.item.func_92059_d().func_77973_b() instanceof ItemTrophy) {
                PickItem.pickTrophy(event, player);
                return;
            }
            if (event.item.func_92059_d().func_77973_b() == BossSummonCore.bossItemM) {
                PickItem.pickBossItem(event, player);
                return;
            }
            if (event.item.func_92059_d().func_77973_b() == ItemCraft10.ItemWolfSummons) {
                PickItem.pickItemWolfSummon(event, player);
            }
            PickItem.pickOres(event, player);
        }
    }

    @SubscribeEvent
    public void craftItem(PlayerEvent.ItemCraftedEvent event) {
        if (event.player instanceof FakePlayer) {
            return;
        }
        if (event.crafting != null) {
            if (!event.player.field_70170_p.field_72995_K) {
                TargetTrigger.onCraftTable(event.player, event.crafting.func_77946_l());
            }
            if (ManaMetalModAchievement.AchievementItem.containsKey(event.crafting.func_77973_b())) {
                event.player.func_71029_a((StatBase)ManaMetalModAchievement.AchievementItem.get(event.crafting.func_77973_b()));
                return;
            }
            if (event.craftMatrix instanceof TileEntityManaMetalInjection) {
                return;
            }
            if (!event.player.field_70170_p.field_72995_K && event.crafting.func_77973_b() == MagicItemCore.MagicItem) {
                PacketHandlerMana.INSTANCE.sendToAll((IMessage)new MessagePlayerMessage(14, "123", event.crafting.func_77946_l(), event.player.func_70005_c_()));
            }
            if (event.crafting.func_77973_b() instanceof ItemToolFistIngRod) {
                this.getFishItemForPlayer(event.player, event.craftMatrix);
            }
            if (event.crafting.func_77973_b() instanceof ItemToolBackpackBase) {
                this.getBackItemForPlayer(event.player, event.craftMatrix);
            }
        }
    }

    public void getBackItemForPlayer(EntityPlayer player, IInventory items) {
        int s;
        for (s = 0; s < items.func_70302_i_(); ++s) {
            ItemStack item = items.func_70301_a(s);
            if (item == null || item.func_77973_b() != TextileCore.Itempatch && RecipesBackpackDyes.getDyeColor(item) == -1) continue;
            return;
        }
        for (s = 0; s < items.func_70302_i_(); ++s) {
            NBTTagCompound nbt;
            if (items.func_70301_a(s) == null || !(items.func_70301_a(s).func_77973_b() instanceof ItemToolBackpackBase) || !items.func_70301_a(s).func_77942_o() || !(nbt = items.func_70301_a(s).func_77978_p()).func_150297_b("Items", 9)) continue;
            NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                ItemStack itemtemp = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                MMM.addItemToPlayer(itemtemp.func_77946_l(), player);
            }
        }
    }

    public void getFishItemForPlayer(EntityPlayer player, IInventory items) {
        for (int s = 0; s < items.func_70302_i_(); ++s) {
            NBTTagCompound nbt;
            if (items.func_70301_a(s) == null || !(items.func_70301_a(s).func_77973_b() instanceof ItemToolFistIngRod) || !items.func_70301_a(s).func_77942_o() || !(nbt = items.func_70301_a(s).func_77978_p()).func_150297_b("Items", 9)) continue;
            NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound tempnbt = nbttaglist.func_150305_b(i);
                ItemStack itemsfish = ItemStack.func_77949_a((NBTTagCompound)tempnbt);
                MMM.addItemToPlayer(itemsfish.func_77946_l(), player);
            }
        }
    }

    @SubscribeEvent
    public void fireItem(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof FakePlayer) {
            return;
        }
        if (event.smelting != null) {
            TargetTrigger.onFurnace(event.player, event.smelting.func_77946_l());
        }
    }

    @SubscribeEvent
    public void useItemOver(PlayerUseItemEvent.Finish event) {
        block35: {
            ManaMetalModRoot root;
            block36: {
                NBTTagCompound tag;
                if (event.entityPlayer instanceof FakePlayer) {
                    return;
                }
                if (event.item == null || event.entityPlayer == null) break block35;
                TargetTrigger.onUseItemOver(event.entityPlayer, event.item.func_77946_l());
                FoodCollectionCore.add(event.item.func_77946_l(), event.entityPlayer);
                root = MMM.getEntityNBT(event.entityPlayer);
                if (root == null) break block35;
                if (ManaMetalAPI.ItemMoistureList.containsKey(event.item.func_77973_b())) {
                    root.mana.setWater(root.mana.getWater() + ManaMetalAPI.ItemMoistureList.get(event.item.func_77973_b()));
                    root.mana.dehydration = true;
                } else if (event.item.func_77973_b().func_77661_b(event.item) == EnumAction.drink) {
                    root.mana.setWater(root.mana.getWater() + 300);
                    root.mana.dehydration = true;
                }
                if (ManaMetalAPI.ItemFatigueBadList.containsKey(event.item.func_77973_b())) {
                    root.mana.addFatigue(ManaMetalAPI.ItemFatigueBadList.get(event.item.func_77973_b()));
                }
                if (!(event.item.func_77973_b() instanceof ItemFood)) break block35;
                int power = ((ItemFood)event.item.func_77973_b()).func_150905_g(event.item);
                if (power > 20) {
                    power = 20;
                }
                root.mana.eadSameFood = MMM.isItemStackEqualNoNBT(root.mana.eatFoodTemp, event.item) ? ++root.mana.eadSameFood : 0;
                root.mana.eatFoodTemp = event.item.func_77946_l();
                if (event.item.func_77942_o() && event.item.func_77978_p().func_150297_b("foodData", 10)) {
                    float foodTimeMax;
                    float foodTime;
                    float foodFinal;
                    tag = event.item.func_77978_p().func_74775_l("foodData");
                    if (tag.func_74767_n("foodSalted")) {
                        event.entityPlayer.func_71024_bL().func_75122_a(1, 0.5f);
                    }
                    if (tag.func_74767_n("hasHoney")) {
                        power *= 2;
                        PotionEffectM3.addPotion((EntityLivingBase)event.entityPlayer, PotionM3.potionHoney, 600, 0);
                    }
                    if (M3Config.FoodRot && M3Config.UseDamageSystem && (foodFinal = (foodTime = (float)tag.func_74762_e("foodTime")) / (foodTimeMax = (float)tag.func_74762_e("foodTimeMax"))) > 0.8f) {
                        if (!event.entityPlayer.field_70170_p.field_72995_K) {
                            MMM.addMessage(event.entityPlayer, "MMM.info.foodroot", event.item);
                        }
                        if (foodFinal > event.entityPlayer.field_70170_p.field_73012_v.nextFloat()) {
                            root.carrer.addDamageTypeMessage(event.entityPlayer, DamageType.Foodpoisoning);
                        }
                    }
                }
                root.mana.foodSaturationLevel = event.entityPlayer.func_71024_bL().func_75115_e() > 0.0f ? (int)event.entityPlayer.func_71024_bL().func_75115_e() : 0;
                if (event.item.func_77973_b() == Items.field_151078_bh || event.item.func_77973_b() == Items.field_151070_bp || event.item.func_77973_b() == Items.field_151170_bI) {
                    power = 0;
                }
                if (root.mana.eadSameFood > 10 && M3Config.TiredofEatingtheSameFood) {
                    if (!event.entityPlayer.field_70170_p.field_72995_K) {
                        MMM.addMessage(event.entityPlayer, "MMM.info.eatsometimefoodtomany.1", event.item.func_82833_r());
                    }
                } else if (root.mana.eadSameFood > 5 && M3Config.TiredofEatingtheSameFood) {
                    if (!event.entityPlayer.field_70170_p.field_72995_K) {
                        MMM.addMessage(event.entityPlayer, "MMM.info.eatsometimefoodtomany.0", event.item.func_82833_r());
                    }
                } else {
                    root.mana.addOxygen(power);
                }
                if (!M3Config.UseBalancedDietSystem) break block35;
                if (!(event.item.func_77973_b() instanceof ICuisine)) break block36;
                if (!event.item.func_77942_o()) break block35;
                tag = event.item.func_77978_p();
                if (tag.func_150297_b("listAllmeatraw", 3)) {
                    root.carrer.addFood(1, tag.func_74762_e("listAllmeatraw"));
                }
                if (tag.func_150297_b("listAllfishraw", 3)) {
                    root.carrer.addFood(1, tag.func_74762_e("listAllfishraw"));
                }
                if (tag.func_150297_b("listAllegg", 3)) {
                    root.carrer.addFood(1, tag.func_74762_e("listAllegg"));
                }
                if (tag.func_150297_b("listAllfruit", 3)) {
                    root.carrer.addFood(3, tag.func_74762_e("listAllfruit"));
                }
                if (tag.func_150297_b("listAllgrain", 3)) {
                    root.carrer.addFood(0, tag.func_74762_e("listAllgrain"));
                }
                if (tag.func_150297_b("listAllveggie", 3)) {
                    root.carrer.addFood(2, tag.func_74762_e("listAllveggie"));
                }
                if (tag.func_150297_b("listAllmushroom", 3)) {
                    root.carrer.addFood(2, tag.func_74762_e("listAllmushroom"));
                }
                if (!tag.func_150297_b("listAllmilk", 3)) break block35;
                root.carrer.addFood(4, tag.func_74762_e("listAllmilk"));
                break block35;
            }
            List<String> list = this.getFoodIngredient(event.item);
            if (list != null) {
                int size = list.size();
                for (int s = 0; s < size; ++s) {
                    if (list.get(s) == null) continue;
                    if (list.get(s).equals("listAllmeatraw")) {
                        root.carrer.addFood(1);
                    }
                    if (list.get(s).equals("listAllfishraw")) {
                        root.carrer.addFood(1);
                    }
                    if (list.get(s).equals("listAllegg")) {
                        root.carrer.addFood(1);
                    }
                    if (list.get(s).equals("listAllfruit")) {
                        root.carrer.addFood(3);
                    }
                    if (list.get(s).equals("listAllgrain")) {
                        root.carrer.addFood(0);
                    }
                    if (list.get(s).equals("listAllveggie")) {
                        root.carrer.addFood(2);
                    }
                    if (list.get(s).equals("listAllmushroom")) {
                        root.carrer.addFood(2);
                    }
                    if (!list.get(s).equals("listAllmilk")) continue;
                    root.carrer.addFood(4);
                }
            }
        }
    }

    public List<String> getFoodIngredient(ItemStack item) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            OreNameItemStack[] mitem;
            IRecipe recipe;
            String[] namesoure;
            ItemStack cook;
            String[] name = MMM.getItemOreDictionaryName(item);
            if (name != null) {
                for (int s = 0; s < name.length; ++s) {
                    if (name[s] == null) continue;
                    list.add(name[s]);
                }
            }
            if ((cook = MMM.findFurnaceRecipes(item)) != null && (namesoure = MMM.getItemOreDictionaryName(cook)) != null) {
                for (int z = 0; z < namesoure.length; ++z) {
                    list.add(namesoure[z]);
                }
            }
            if ((recipe = MMM.findRecipeOne(item)) != null && (mitem = MMM.getRecipeInputsOrename(recipe)) != null) {
                for (int s = 0; s < mitem.length; ++s) {
                    ItemStack soure;
                    String[] namesoure2;
                    if (mitem[s] == null || mitem[s].item == null || (namesoure2 = MMM.getItemOreDictionaryName(soure = mitem[s].item)) == null) continue;
                    for (int z = 0; z < namesoure2.length; ++z) {
                        list.add(namesoure2[z]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @SubscribeEvent
    public void useBlock(BlockEvent.PlaceEvent event) {
        ManaMetalModRoot root;
        if (event.player == null || event.block == null || event.player instanceof FakePlayer) {
            return;
        }
        if (M3Config.MachineRestriction && !MachineRestriction.doPlaceEvent(event)) {
            event.setCanceled(true);
            return;
        }
        if (M3Config.RecordPlayerBlockAction) {
            PlayerBlockAction data = new PlayerBlockAction();
            data.player_name = event.player.func_70005_c_();
            data.block_name = event.block.func_149732_F();
            data.pos = new Location(event.x, event.y, event.z, MMM.getDimensionID(event.world));
            data.PlayerActionType = 1;
            data.time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            OpToolCore.playerActionList.add(data);
        }
        if (MMM.getDimensionID(event.world) == M3Config.WorldInstanceDungeonID) {
            if (!MMM.isPlayerCreativeMode(event.player) && !(event.block instanceof BlockWaterGame)) {
                event.setCanceled(true);
            }
            return;
        }
        if (PotionEffectM3.isPotion((EntityLivingBase)event.player, PotionM3.potionDestroy) && !MMM.isPlayerCreativeMode(event.player)) {
            event.setCanceled(true);
            return;
        }
        if (!event.player.func_70093_af() && (root = MMM.getEntityNBT(event.player)) != null && !root.fashion.list.isEmpty()) {
            for (int s = 0; s < root.fashion.list.size(); ++s) {
                FasgionBlockType type = root.fashion.list.get(s);
                if (type.oldBlock() == null || type.oldBlock() != event.block) continue;
                Block block = type.getBlock();
                if (!event.world.func_147465_d(event.x, event.y, event.z, block, type.getData(event.player, event.blockMetadata), 2)) break;
                block.func_149689_a(event.world, event.x, event.y, event.z, (EntityLivingBase)event.player, event.player.func_71045_bC());
                break;
            }
        }
        TargetTrigger.onUseBlock(event.player, event.block, event.blockMetadata);
    }

    public int onTorchPlaced(World world, int dx, int dy, int dz, int side, float fx, float fy, float fz, int data) {
        int j1 = data;
        if (side == 1 && this.isSave(world, dx, dy - 1, dz)) {
            j1 = 5;
        }
        if (side == 2 && world.isSideSolid(dx, dy, dz + 1, ForgeDirection.NORTH, true)) {
            j1 = 4;
        }
        if (side == 3 && world.isSideSolid(dx, dy, dz - 1, ForgeDirection.SOUTH, true)) {
            j1 = 3;
        }
        if (side == 4 && world.isSideSolid(dx + 1, dy, dz, ForgeDirection.WEST, true)) {
            j1 = 2;
        }
        if (side == 5 && world.isSideSolid(dx - 1, dy, dz, ForgeDirection.EAST, true)) {
            j1 = 1;
        }
        return j1;
    }

    private boolean isSave(World world, int dx, int dy, int dz) {
        if (World.func_147466_a((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) {
            return true;
        }
        Block block = world.func_147439_a(dx, dy, dz);
        return block.canPlaceTorchOnTop(world, dx, dy, dz);
    }
}

