/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.fx.raytracebeam;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.Particle;

public class EntityRaytraceBeam
extends Entity
implements IEntityAdditionalSpawnData,
IProjectile {
    public int shooterID;
    public double beamlength;
    public double distance;
    public EntityLivingBase shooter;
    public int time = 100;

    public EntityRaytraceBeam(World worldObj) {
        super(worldObj);
        this.distance = 0.0;
        this.field_70158_ak = true;
        if (worldObj.field_72995_K) {
            // empty if block
        }
    }

    public EntityRaytraceBeam(World world, EntityLivingBase player, float spread, float speed) {
        this(world, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70759_as, player.field_70125_A, spread, speed);
        this.shooter = player;
        this.shooterID = player.func_145782_y();
    }

    public EntityRaytraceBeam(World par2World, double posX, double posY, double posZ, float yaw, float pitch, float spread, float speed) {
        super(par2World);
        this.field_70178_ae = true;
        this.shooter = null;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(posX, posY, posZ, yaw + (float)((double)spread - 2.0 * Math.random() * (double)spread) * 40.0f, pitch + (float)((double)spread - 2.0 * Math.random() * (double)spread) * 40.0f);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        Vec3 motion = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
        motion.func_72432_b();
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        this.field_70159_w *= (double)speed;
        this.field_70181_x *= (double)speed;
        this.field_70179_y *= (double)speed;
    }

    public void func_70186_c(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        float f2 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_3_ * p_70186_3_ + p_70186_5_ * p_70186_5_));
        p_70186_1_ /= (double)f2;
        p_70186_3_ /= (double)f2;
        p_70186_5_ /= (double)f2;
        this.field_70159_w = p_70186_1_ *= (double)p_70186_7_;
        this.field_70181_x = p_70186_3_ *= (double)p_70186_7_;
        this.field_70179_y = p_70186_5_ *= (double)p_70186_7_;
        float f3 = MathHelper.func_76133_a((double)(p_70186_1_ * p_70186_1_ + p_70186_5_ * p_70186_5_));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(p_70186_1_, p_70186_5_) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(p_70186_3_, f3) * 180.0 / Math.PI);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public Vec3 getFPOffset() {
        return Vec3.func_72443_a((double)0.0, (double)-0.08, (double)0.12);
    }

    public float get3PYOffset() {
        return 0.0f;
    }

    public static void rotateAroundZ(Vec3 vec, double angle) {
        double dc = Math.cos(angle);
        double ds = Math.sin(angle);
        double d0 = vec.field_72450_a * dc + vec.field_72448_b * ds;
        double d1 = vec.field_72448_b * dc - vec.field_72450_a * ds;
        double d2 = vec.field_72449_c;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    public static void rotateAroundY(Vec3 vec, double angle) {
        double dc = Math.cos(angle);
        double ds = Math.sin(angle);
        double d0 = vec.field_72450_a * dc + vec.field_72449_c * ds;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c * dc - vec.field_72450_a * ds;
        vec.field_72450_a = d0;
        vec.field_72448_b = d1;
        vec.field_72449_c = d2;
    }

    public static MovingObjectPosition traceVector(World world, Vec3 src, Vec3 direction, double distance, int steps, Entity ent, EntityLivingBase shooter) {
        direction = direction.func_72432_b();
        for (int i = 0; i < steps; ++i) {
            double maxZ;
            double minZ;
            double maxY;
            double minY;
            double maxX;
            double minX;
            Vec3 src2 = Vec3.func_72443_a((double)src.field_72450_a, (double)src.field_72448_b, (double)src.field_72449_c);
            Vec3 dst = src.func_72441_c(direction.field_72450_a * distance, direction.field_72448_b * distance, direction.field_72449_c * distance);
            Vec3 dst2 = Vec3.func_72443_a((double)dst.field_72450_a, (double)dst.field_72448_b, (double)dst.field_72449_c);
            MovingObjectPosition movingobjectposition = world.func_147447_a(src, dst, false, true, false);
            Entity entity = null;
            if (src2.field_72450_a < dst2.field_72450_a) {
                minX = src2.field_72450_a;
                maxX = dst2.field_72450_a;
            } else {
                maxX = src2.field_72450_a;
                minX = dst2.field_72450_a;
            }
            if (src2.field_72448_b < dst2.field_72448_b) {
                minY = src2.field_72448_b;
                maxY = dst2.field_72448_b;
            } else {
                maxY = src2.field_72448_b;
                minY = dst2.field_72448_b;
            }
            if (src2.field_72449_c < dst2.field_72449_c) {
                minZ = src2.field_72449_c;
                maxZ = dst2.field_72449_c;
            } else {
                maxZ = src2.field_72449_c;
                minZ = dst2.field_72449_c;
            }
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b(1.0, 1.0, 1.0);
            List list = world.func_72839_b(ent, box);
            double d0 = 0.0;
            MovingObjectPosition mop = null;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1.field_70128_L || entity1 == shooter || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(src2, dst2)) == null || !((d1 = src2.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                mop = movingobjectposition1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity, mop.field_72307_f);
            }
            if (movingobjectposition != null) {
                return movingobjectposition;
            }
            src = Vec3.func_72443_a((double)dst.field_72450_a, (double)dst.field_72448_b, (double)dst.field_72449_c);
        }
        return null;
    }

    public void onImpact(MovingObjectPosition mop) {
        if (mop.field_72308_g != null) {
            // empty if block
        }
    }

    public void func_70071_h_() {
        Vec3 vec3;
        double dy;
        double dz;
        double dx;
        double targetX = 0.0;
        double targetY = 0.0;
        double targetZ = 0.0;
        float f = 100.0f;
        if (this.shooter == null) {
            this.shooter = (EntityLivingBase)this.field_70170_p.func_73045_a(this.shooterID);
        }
        if (this.shooter != null) {
            dx = -MathHelper.func_76126_a((float)(this.shooter.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dz = MathHelper.func_76134_b((float)(this.shooter.field_70759_as / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dy = -MathHelper.func_76126_a((float)(this.shooter.field_70125_A / 180.0f * (float)Math.PI)) * f;
            this.field_70165_t = this.shooter.field_70165_t;
            this.field_70163_u = this.shooter.field_70163_u;
            this.field_70161_v = this.shooter.field_70161_v;
            if (ManaMetalMod.proxy.isClientPlayerAndIn1stPerson(this.shooter)) {
                Vec3 offset = this.getFPOffset();
                EntityRaytraceBeam.rotateAroundZ(offset, (double)this.shooter.field_70125_A * (Math.PI / 180));
                EntityRaytraceBeam.rotateAroundY(offset, (-90.0 - (double)this.shooter.field_70759_as) * (Math.PI / 180));
                this.field_70165_t += offset.field_72450_a;
                this.field_70163_u += offset.field_72448_b;
                this.field_70161_v += offset.field_72449_c;
            } else {
                this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
                this.field_70163_u += (double)this.shooter.func_70047_e() - (double)0.1f;
                this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.shooter.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            }
            vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            this.field_70125_A = this.shooter.field_70125_A;
            this.field_70177_z = this.shooter.field_70759_as;
        } else {
            dx = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dz = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            dy = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        }
        Vec3 vec31 = Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
        vec31.func_72432_b();
        MovingObjectPosition movingobjectposition = EntityRaytraceBeam.traceVector(this.field_70170_p, vec3, vec31, 12.0, 4, this, this.shooter);
        if (movingobjectposition != null) {
            switch (movingobjectposition.field_72313_a) {
                case BLOCK: {
                    targetX = movingobjectposition.field_72307_f.field_72450_a;
                    targetY = movingobjectposition.field_72307_f.field_72448_b;
                    targetZ = movingobjectposition.field_72307_f.field_72449_c;
                    break;
                }
                case ENTITY: {
                    targetX = movingobjectposition.field_72307_f.field_72450_a;
                    targetY = movingobjectposition.field_72307_f.field_72448_b;
                    targetZ = movingobjectposition.field_72307_f.field_72449_c;
                    if (this.field_70170_p.field_72995_K) break;
                    this.distance = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72438_d(movingobjectposition.field_72307_f);
                    this.onImpact(movingobjectposition);
                    this.field_70128_L = false;
                    break;
                }
                case MISS: {
                    targetX = dx;
                    targetY = dy;
                    targetZ = dz;
                }
            }
        } else {
            targetX = dx;
            targetY = dy;
            targetZ = dz;
        }
        if (this.field_70170_p.field_72995_K) {
            float px = this.field_70146_Z.nextFloat() * 0.33f;
            float py = this.field_70146_Z.nextFloat() * 0.33f;
            float pz = this.field_70146_Z.nextFloat() * 0.33f;
            FXHelp.spawnParticle(this.field_70170_p, Particle.fire, targetX, targetY, targetZ, px, py, pz, 1.75f, true);
        }
        Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        this.beamlength = pos.func_72438_d(Vec3.func_72443_a((double)targetX, (double)targetY, (double)targetZ));
        --this.time;
        if (this.time <= 0) {
            this.func_70106_y();
        }
    }

    protected double getDistanceTravelled() {
        return this.distance;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.shooter != null) {
            buffer.writeInt(this.shooter.func_145782_y());
        } else {
            buffer.writeInt(0);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.shooterID = additionalData.readInt();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }
}

