/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.instance_dungeon;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.custom.CustomDungeon;
import project.studio.manametalmod.instance_dungeon.custom.CustomDungeonCore;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft5;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft9;
import project.studio.manametalmod.produce.cuisine.CuisineCore;
import project.studio.manametalmod.produce.farming.FarmCore;

public enum InstanceDungeonType {
    FireDungeon,
    WaterDungeon,
    GrassDungeon,
    IceDungeon,
    SkullDungeon,
    Pyramid,
    TheLostTemple,
    FeatherSnakeTemple,
    RoseTallTower,
    Stronghold,
    SkyTower,
    TheHeroTemple,
    SnakeLibrary,
    Mechanism,
    EarthDungeon,
    TheGodTemple,
    WolfPalace,
    LightDungeon,
    DuckVillage,
    SteelFortress,
    DarkDungeon,
    SandDungeon,
    BlackCastle,
    DragonDoor,
    GiantMaze,
    WhiteDragonTemple,
    FourSeasonsTemple,
    DistortSpaceTime,
    ThunderTemple,
    WindTemple,
    SkyGarden,
    PurgatoryDragonPalace,
    WhiteStonePalace,
    TrialTower,
    IllusoryTower,
    AncientCity,
    RoseGarden,
    Custom;

    public static final InstanceDungeonType[] dungeons;

    public int spawnType() {
        return 0;
    }

    public ItemStack getSacrificeItem(IDungeonDifficult difficult, String customname) {
        CustomDungeon CD;
        if (this == Custom && customname != null && (CD = CustomDungeonCore.get(customname)) != null) {
            return CD.keyItem[difficult.ordinal()].toItemStack();
        }
        if (this == RoseGarden && difficult.ordinal() > 1) {
            return null;
        }
        if (this == DragonDoor && difficult == IDungeonDifficult.HELL) {
            return null;
        }
        switch (difficult) {
            case EASY: {
                return new ItemStack(InstanceDungeonCore.ItemKeyDungeon, 1, 0);
            }
            case NORMAL: {
                return new ItemStack(InstanceDungeonCore.ItemKeyDungeon, 1, 1);
            }
            case HARD: {
                return new ItemStack(InstanceDungeonCore.ItemKeyDungeon, 1, 2);
            }
            case HELL: {
                return new ItemStack(InstanceDungeonCore.ItemKeyDungeon, 1, 3);
            }
        }
        return null;
    }

    public boolean isBossDungeon() {
        switch (this) {
            case RoseGarden: 
            case TrialTower: 
            case BlackCastle: 
            case DragonDoor: 
            case RoseTallTower: 
            case SkyTower: {
                return true;
            }
        }
        return false;
    }

    public ItemStack getRepairItem() {
        switch (this) {
            case DuckVillage: {
                return new ItemStack(CuisineCore.itemmeats_cook, 1, 8);
            }
            case EarthDungeon: {
                return MMM.item(ManaMetalMod.Neutron);
            }
            case FeatherSnakeTemple: {
                return MMM.item(Items.field_151008_G);
            }
            case FireDungeon: {
                return MMM.item(Items.field_151065_br);
            }
            case GrassDungeon: {
                return new ItemStack((Block)Blocks.field_150329_H, 1, 1);
            }
            case IceDungeon: {
                return MMM.item(Blocks.field_150432_aD);
            }
            case LightDungeon: {
                return MMM.item(ItemCraft10.LightScrap.gem);
            }
            case Mechanism: {
                return MMM.item(ManaMetalMod.ironGear);
            }
            case Pyramid: {
                return MMM.item(Items.field_151043_k);
            }
            case RoseTallTower: {
                return MMM.item(Blocks.field_150328_O);
            }
            case SkullDungeon: {
                return MMM.item(Items.field_151103_aS);
            }
            case SkyTower: {
                return MMM.item(ItemCraft10.BlockCloudSkys);
            }
            case SnakeLibrary: {
                return MMM.item(Items.field_151122_aG);
            }
            case SteelFortress: {
                return new ItemStack(Blocks.field_150483_bI);
            }
            case Stronghold: {
                return MMM.item(ManaMetalMod.ingotBloodMetal);
            }
            case TheGodTemple: {
                return MMM.item(ManaMetalMod.SageofTheStone);
            }
            case TheHeroTemple: {
                return new ItemStack(Items.field_151153_ao, 1, 1);
            }
            case TheLostTemple: {
                return MMM.item(Items.field_151073_bk);
            }
            case WaterDungeon: {
                return MMM.item(new ItemStack(Items.field_151100_aR, 1, 4));
            }
            case WolfPalace: {
                return MMM.item(new ItemStack((Item)FarmCore.Pineapple));
            }
            case DarkDungeon: {
                return MMM.item(ManaMetalMod.ingotDark);
            }
            case SandDungeon: {
                return MMM.item(Blocks.field_150354_m);
            }
            case BlackCastle: {
                return MMM.item(ItemCraft10.DarkScrap);
            }
            case DragonDoor: {
                return new ItemStack(ItemCraft5.ManaDragonCrystal.ingot);
            }
            case GiantMaze: {
                return new ItemStack(Blocks.field_150417_aV);
            }
            case WhiteDragonTemple: {
                return new ItemStack(ManaMetalMod.ingotPlatinum);
            }
            case FourSeasonsTemple: {
                return new ItemStack(Items.field_151156_bN);
            }
            case WhiteStonePalace: {
                return new ItemStack(ItemCraft9.WhiteStone1);
            }
            case TrialTower: {
                return new ItemStack(Blocks.field_150371_ca);
            }
            case RoseGarden: {
                return new ItemStack((Block)Blocks.field_150398_cm, 1, 4);
            }
        }
        return new ItemStack(Blocks.field_150483_bI);
    }

    public Pos getPosOffset(String customname) {
        CustomDungeon CD;
        if (this == Custom && customname != null && (CD = CustomDungeonCore.get(customname)) != null) {
            return new Pos(CD.offset[0], CD.offset[1], CD.offset[2]);
        }
        switch (this) {
            case DarkDungeon: {
                return new Pos(93, 24, 7);
            }
            case WolfPalace: {
                return new Pos(72, 37, 3);
            }
            case SteelFortress: {
                return new Pos(79, 3, 7);
            }
            case DuckVillage: {
                return new Pos(69, 10, 127);
            }
            case LightDungeon: {
                return new Pos(60, 29, 4);
            }
            case SkyTower: {
                return new Pos(39, 16, 9);
            }
            case Stronghold: {
                return new Pos(77, 2, 8);
            }
            case TheHeroTemple: {
                return new Pos(63, 7, 19);
            }
            case SkullDungeon: {
                return new Pos(5, 55, 11);
            }
            case Pyramid: {
                return new Pos(4, 4, 50);
            }
            case WaterDungeon: {
                return new Pos(18, 2, 6);
            }
            case FireDungeon: {
                return new Pos(83, 24, 91);
            }
            case GrassDungeon: {
                return new Pos(5, 1, 48);
            }
            case IceDungeon: {
                return new Pos(5, 1, 41);
            }
            case TheLostTemple: {
                return new Pos(7, 1, 49);
            }
            case FeatherSnakeTemple: {
                return new Pos(5, 15, 47);
            }
            case RoseTallTower: {
                return new Pos(34, 31, 34);
            }
            case SnakeLibrary: {
                return new Pos(3, 4, 34);
            }
            case Mechanism: {
                return new Pos(19, 5, 67);
            }
            case EarthDungeon: {
                return new Pos(20, 5, 5);
            }
            case TheGodTemple: {
                return new Pos(11, 11, 7);
            }
            case SandDungeon: {
                return new Pos(5, 3, 32);
            }
            case BlackCastle: {
                return new Pos(55, 1, 53);
            }
            case DragonDoor: {
                return new Pos(42, 10, 203);
            }
            case GiantMaze: {
                return new Pos(70, 1, 10);
            }
            case WhiteDragonTemple: {
                return new Pos(57, 1, 5);
            }
            case FourSeasonsTemple: {
                return new Pos(86, 3, 14);
            }
            case WhiteStonePalace: {
                return new Pos(70, 1, 3);
            }
            case TrialTower: {
                return new Pos(43, 17, 4);
            }
            case RoseGarden: {
                return new Pos(61, 3, 124);
            }
        }
        return null;
    }

    public int getNeedDefense() {
        return 0;
    }

    public int getNeedLV(String customname) {
        CustomDungeon CD;
        if (this == Custom && customname != null && (CD = CustomDungeonCore.get(customname)) != null) {
            return CD.needLV;
        }
        switch (this) {
            case WolfPalace: {
                return 80;
            }
            case SteelFortress: {
                return 105;
            }
            case DuckVillage: {
                return 75;
            }
            case LightDungeon: {
                return 60;
            }
            case DarkDungeon: {
                return 65;
            }
            case SkyTower: {
                return 60;
            }
            case Stronghold: {
                return 55;
            }
            case TheHeroTemple: {
                return 100;
            }
            case SkullDungeon: {
                return 30;
            }
            case Pyramid: {
                return 35;
            }
            case TheLostTemple: {
                return 40;
            }
            case WaterDungeon: {
                return 10;
            }
            case FireDungeon: {
                return 5;
            }
            case GrassDungeon: {
                return 15;
            }
            case IceDungeon: {
                return 20;
            }
            case FeatherSnakeTemple: {
                return 45;
            }
            case RoseTallTower: {
                return 50;
            }
            case SnakeLibrary: {
                return 85;
            }
            case Mechanism: {
                return 80;
            }
            case EarthDungeon: {
                return 70;
            }
            case TheGodTemple: {
                return 90;
            }
            case SandDungeon: {
                return 25;
            }
            case BlackCastle: {
                return 95;
            }
            case GiantMaze: {
                return 105;
            }
            case WhiteDragonTemple: {
                return 110;
            }
            case FourSeasonsTemple: {
                return 115;
            }
            case WhiteStonePalace: {
                return 120;
            }
            case TrialTower: {
                return 120;
            }
            case RoseGarden: {
                return 125;
            }
            case DragonDoor: {
                return 120;
            }
        }
        return 1;
    }

    static {
        dungeons = InstanceDungeonType.values();
    }
}

