/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ChestGenHooks;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.api.Quality;
import project.studio.manametalmod.battle.WeaponCore;
import project.studio.manametalmod.core.CareerCore;
import project.studio.manametalmod.core.CoinConverter;
import project.studio.manametalmod.core.WeightedItemStack;
import project.studio.manametalmod.enchantmentskey.EnchantmentsKeyEffect;
import project.studio.manametalmod.enchantmentskey.EnchantmentsKeyEffectType;
import project.studio.manametalmod.instance_dungeon.BlockTileEntityMetalDungeonChest;
import project.studio.manametalmod.instance_dungeon.DungeonChestType;
import project.studio.manametalmod.instance_dungeon.IDungeonDifficult;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.instance_dungeon.ItemDungeonKeyOpen;
import project.studio.manametalmod.instance_dungeon.TileEntityDungeonChest;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft2;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft3;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft4;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft8;
import project.studio.manametalmod.items.ItemWhiteTicket;
import project.studio.manametalmod.items.career_consume.ItemToolArrow;
import project.studio.manametalmod.loot.DungeonChestTypeLoot;
import project.studio.manametalmod.magic.book.ItemMagicScroll;
import project.studio.manametalmod.magic.book.MagicBookEffect;
import project.studio.manametalmod.magic.book.MagicBookType;
import project.studio.manametalmod.produce.ProduceCore;
import project.studio.manametalmod.produce.casting.CastingCore;
import project.studio.manametalmod.produce.cuisine.CuisineCore;
import project.studio.manametalmod.produce.gemcraft.GemCraftCore;
import project.studio.manametalmod.produce.gemcraft.MagicJadeRed;
import project.studio.manametalmod.produce.gemcraft.TileEntityGemIdentification;
import project.studio.manametalmod.produce.textile.TextileCore;
import project.studio.manametalmod.rpg.ItemStrengthenHelp;

public class DungeonChestLoot {
    public static final int[] countIncrease = new int[]{130, 100, 70, 40};
    public static final List<DungeonChestTypeLoot> baseType = new ArrayList<DungeonChestTypeLoot>();
    public static final List<DungeonChestTypeLoot> preciousType = new ArrayList<DungeonChestTypeLoot>();

    public static DungeonChestType getChestType(InstanceDungeonType type, IDungeonDifficult diff, Random rand, EnchantmentsKeyEffect keyeffect, boolean precious, int needLV) {
        boolean useKeyEffect = false;
        if (keyeffect != null) {
            float data = keyeffect.getEffect(EnchantmentsKeyEffectType.extraChestSpawn);
            if (rand.nextFloat() < data) {
                useKeyEffect = true;
            }
        }
        for (int s = 0; s < 9999; ++s) {
            DungeonChestTypeLoot loot = MMM.getRandomItemFromList(precious ? preciousType : baseType);
            if (rand.nextInt(100) >= (useKeyEffect ? loot.dataKeyeffect : loot.data) || needLV < loot.needLV) continue;
            return loot.type;
        }
        return DungeonChestType.Bamboo;
    }

    public static final void loot(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, DungeonChestType box, Random rand, float coefficient, String customname, EnchantmentsKeyEffect keyeffect) {
        int needLV = type.getNeedLV(customname);
        int max = 12;
        int count = Math.min(3 + diff.ordinal() + (int)((float)needLV * 0.1f), max);
        int coin = (int)((float)(needLV * needLV * (diff.ordinal() + 1)) * (2.0f - rand.nextFloat()) * coefficient);
        BlockTileEntityMetalDungeonChest block = (BlockTileEntityMetalDungeonChest)DungeonChestLoot.getBlock(box);
        if (block.lock > 0) {
            boolean bl = tileentity.lock = rand.nextInt(100) < block.lock;
        }
        if (keyeffect != null) {
            float data = keyeffect.getEffect(EnchantmentsKeyEffectType.extraChestReward);
            if (rand.nextFloat() < data) {
                count += rand.nextInt(3);
                coin = (int)((float)coin * 1.3f);
            }
        }
        switch (box) {
            case Bamboo: {
                DungeonChestLoot.lootBamboo(tileentity, type, diff, rand, count, needLV);
                break;
            }
            case Wood: {
                DungeonChestLoot.lootWood(tileentity, type, diff, rand, count, needLV);
                break;
            }
            case Sturdy: {
                DungeonChestLoot.lootSturdy(tileentity, type, diff, rand, count, needLV);
                break;
            }
            case Heavy: {
                DungeonChestLoot.lootHeavy(tileentity, type, diff, rand, count, needLV);
                break;
            }
            case Weapon: {
                DungeonChestLoot.lootWeapon(tileentity, type, diff, rand, count, needLV);
                break;
            }
            case Quartz: {
                DungeonChestLoot.lootQuartz(tileentity, type, diff, rand, count, needLV);
                break;
            }
            case Copper: {
                DungeonChestLoot.lootCopper(tileentity, type, diff, rand, count, needLV);
                DungeonChestLoot.putCoin(tileentity, coin > 0 ? CoinConverter.get(coin * 1) : null);
                break;
            }
            case Silver: {
                DungeonChestLoot.lootSilver(tileentity, type, diff, rand, count + 1, needLV);
                DungeonChestLoot.putCoin(tileentity, coin > 0 ? CoinConverter.get(coin * 2) : null);
                break;
            }
            case Gold: {
                DungeonChestLoot.lootGold(tileentity, type, diff, rand, count + 2, needLV);
                DungeonChestLoot.putCoin(tileentity, coin > 0 ? CoinConverter.get(coin * 3) : null);
                break;
            }
            case Diamond: {
                DungeonChestLoot.lootDiamond(tileentity, type, diff, rand, count + 3, needLV);
                DungeonChestLoot.putCoin(tileentity, coin > 0 ? CoinConverter.get(coin * 10) : null);
                break;
            }
            case WhiteGold: {
                DungeonChestLoot.lootWhiteGold(tileentity, type, diff, rand, count + 5, needLV);
                DungeonChestLoot.putCoin(tileentity, coin > 0 ? CoinConverter.get(coin * 15) : null);
            }
        }
    }

    public static final void lootWhiteGold(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        int data = rand.nextInt(100);
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 5) {
                item = ItemDungeonKeyOpen.getEnchantmentsKey(new ItemStack(InstanceDungeonCore.ItemKeyDungeon, 1, 3), rand);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 10) {
                item = MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT2, 100, 9999);
                DungeonChestLoot.addItemSize(item, type, rand, needLV);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 40) {
                tileentity.func_70299_a(s, new ItemStack((Item)InstanceDungeonCore.ItemHeavyTreasure, 1, rand.nextInt(Math.min(100, needLV))));
                continue;
            }
            item = rand.nextBoolean() ? MMM.getTrophyItemsLV2() : MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT3, 100, 9999);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootDiamond(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        int data = rand.nextInt(100);
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 3) {
                item = ItemDungeonKeyOpen.getEnchantmentsKey(new ItemStack(InstanceDungeonCore.ItemKeyDungeon, 1, 3), rand);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 12) {
                item = MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT3, 100, 9999);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 30) {
                item = MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT2, 100, 9999);
                DungeonChestLoot.addItemSize(item, type, rand, needLV);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 60) {
                tileentity.func_70299_a(s, new ItemStack((Item)InstanceDungeonCore.ItemHeavyTreasure, 1, rand.nextInt(Math.min(100, needLV))));
                continue;
            }
            item = rand.nextBoolean() ? MMM.getTrophyItemsLV2() : MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT2, 100, 9999);
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootGold(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        int data = rand.nextInt(100);
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 15 && needLV > 70) {
                item = rand.nextBoolean() ? MMM.getTrophyItemsLV2() : MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT2, 100, 9999);
                DungeonChestLoot.addItemSize(item, type, rand, needLV);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 30) {
                tileentity.func_70299_a(s, new ItemStack((Item)InstanceDungeonCore.ItemHeavyTreasure, 1, rand.nextInt(Math.min(100, needLV))));
                continue;
            }
            item = rand.nextBoolean() ? MMM.getTrophyItems() : MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT1, 100, 9999);
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootSilver(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        int data = rand.nextInt(100);
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 5 && needLV > 70) {
                item = rand.nextBoolean() ? MMM.getTrophyItemsLV2() : MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT2, 100, 9999);
                DungeonChestLoot.addItemSize(item, type, rand, needLV);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 20) {
                tileentity.func_70299_a(s, new ItemStack((Item)InstanceDungeonCore.ItemHeavyTreasure, 1, rand.nextInt(Math.min(100, needLV))));
                continue;
            }
            item = rand.nextBoolean() ? MMM.getTrophyItems() : MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT1, 100, 9999);
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootCopper(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        int data = rand.nextInt(100);
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 10) {
                tileentity.func_70299_a(s, new ItemStack((Item)InstanceDungeonCore.ItemHeavyTreasure, 1, rand.nextInt(Math.min(100, needLV))));
                continue;
            }
            item = rand.nextBoolean() ? MMM.getTrophyItems() : MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsPreciousT1, 100, 9999);
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootQuartz(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        int data = rand.nextInt(100);
        int maxLV = 45;
        boolean LV2 = false;
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 20) {
                item = new ItemStack(ItemCraft3.ItemNewHPwaterE, rand.nextInt(10) + 1, 0);
                item.func_77964_b(Math.min(maxLV, rand.nextInt((int)((float)needLV * 0.4f))));
                DungeonChestLoot.addItemSize(item, type, rand, needLV);
                tileentity.func_70299_a(s, item);
                continue;
            }
            item = MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsQuartz, 100, 9999);
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootWeapon(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        int data = rand.nextInt(100);
        int LV2 = 0;
        if (needLV >= 70) {
            LV2 = 2;
        } else if (needLV >= 50) {
            LV2 = 1;
        }
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 20) {
                Item tool = WeaponCore.get(CareerCore.values()[rand.nextInt(CareerCore.values().length - 1)], ItemStrengthenHelp.getNpcWeapon(LV2));
                int color = ItemStrengthenHelp.colors[rand.nextInt(ItemStrengthenHelp.colors.length)];
                int emeLV = 1 + rand.nextInt(30);
                int extra_attack = rand.nextInt(21);
                int name1 = rand.nextInt(51);
                int name2 = rand.nextInt(51);
                int special_power = rand.nextInt(10);
                Quality Qualitys = ItemStrengthenHelp.getItemQualitys(false, false);
                tileentity.func_70299_a(s, ItemStrengthenHelp.getRandomWeaponColor(tool, color, emeLV, extra_attack, name1, name2, Qualitys, special_power, rand));
                continue;
            }
            tileentity.func_70299_a(s, MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsWeapon, 100, 9999));
        }
    }

    public static final void lootHeavy(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        int maxeffect = 1;
        for (int s = 0; s < countIncrease.length; ++s) {
            if (needLV < countIncrease[s]) continue;
            maxeffect += countIncrease.length - s;
            break;
        }
        int data = rand.nextInt(100);
        int gem = 0;
        for (int s = 0; s < count; ++s) {
            data = rand.nextInt(100);
            if (data < 15) {
                item = new ItemStack(GemCraftCore.ItemArmorGems, 1, rand.nextInt(4));
                TileEntityGemIdentification.addGemEffects(item, rand, maxeffect);
                tileentity.func_70299_a(s, item);
                continue;
            }
            if (data < 30) {
                gem = rand.nextInt(MagicJadeRed.values().length) * 3;
                tileentity.func_70299_a(s, new ItemStack(GemCraftCore.ItemMagicJadeRED, 1, gem));
                continue;
            }
            tileentity.func_70299_a(s, MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsHeavy, 100, 9999));
        }
    }

    public static final void lootSturdy(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        for (int s = 0; s < count; ++s) {
            if (rand.nextInt(100) < 20) {
                tileentity.func_70299_a(s, DungeonChestLoot.getRandomMagicScoll(diff, needLV, rand));
                continue;
            }
            item = MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsSturdy, 100, 9999);
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootWood(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        for (int s = 0; s < count; ++s) {
            item = MMM.getWeightedItemStack(ManaMetalAPI.DungeonItemsWood, 100, 9999);
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static final void lootBamboo(TileEntityDungeonChest tileentity, InstanceDungeonType type, IDungeonDifficult diff, Random rand, int count, int needLV) {
        ItemStack item = null;
        for (int s = 0; s < count; ++s) {
            item = rand.nextBoolean() ? (needLV >= 70 && rand.nextInt(7) == 0 ? MMM.getTrophyItemsLV2() : MMM.getTrophyItems()) : ChestGenHooks.getOneItem((String)"dungeonChest", (Random)rand).func_77946_l();
            DungeonChestLoot.addItemSize(item, type, rand, needLV);
            tileentity.func_70299_a(s, item);
        }
    }

    public static ItemStack getRandomMagicScoll(IDungeonDifficult diff, int LV2, Random rand) {
        int power = 4 * (diff.ordinal() + 1);
        MagicBookEffect mbe = null;
        int data = 0;
        int max = ItemMagicScroll.list.size();
        for (int s = 0; s < 9999; ++s) {
            data = rand.nextInt(max);
            mbe = ItemMagicScroll.list.get(data);
            if (ItemMagicScroll.list.get((int)data).needLV > LV2 || mbe.type == MagicBookType.Legend || mbe.type == MagicBookType.Myth) continue;
            if (rand.nextInt(100) < power) {
                ItemStack item = new ItemStack(ItemCraft10.SkillBookMagicBase1, 1, data);
                NBTTagCompound tag = new NBTTagCompound();
                switch (rand.nextInt(3)) {
                    case 0: {
                        tag.func_74776_a("ExtraEffect", MMM.randomFloatBetween(rand, 0.1f, 0.5f));
                        break;
                    }
                    case 1: {
                        tag.func_74776_a("ExtraSpeed", MMM.randomFloatBetween(rand, 0.05f, 0.2f));
                        break;
                    }
                    case 2: {
                        tag.func_74776_a("ExtraEffect", MMM.randomFloatBetween(rand, 0.1f, 0.3f));
                        tag.func_74776_a("ExtraSpeed", MMM.randomFloatBetween(rand, 0.05f, 0.1f));
                    }
                }
                item.func_77982_d(tag);
                return item;
            }
            return new ItemStack(ItemCraft10.SkillBookMagicBase1, 1, data);
        }
        return new ItemStack(ItemCraft10.SkillBookMagicBase1, 1, 0);
    }

    public static void addItemSize(ItemStack item, InstanceDungeonType type, Random rand, int needLV) {
        if (item.func_77976_d() > 1) {
            int add;
            int max = 0;
            for (int s = 0; s < countIncrease.length; ++s) {
                if (needLV < countIncrease[s]) continue;
                max = countIncrease.length - s;
                break;
            }
            if (max > 0 && (add = rand.nextInt(max + 1)) > 0 && item.field_77994_a + add < item.func_77976_d()) {
                item.field_77994_a += add;
            }
        }
    }

    public static void putCoin(TileEntityDungeonChest tileentity, ItemStack[] coins) {
        if (coins != null && coins.length > 0) {
            int index = 0;
            for (int s = 0; s < tileentity.func_70302_i_(); ++s) {
                if (tileentity.func_70301_a(s) != null) continue;
                tileentity.func_70299_a(s, coins[index]);
                if (++index < coins.length) continue;
                return;
            }
        }
    }

    public static Block getBlock(DungeonChestType type) {
        switch (type) {
            case Bamboo: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsBamboo;
            }
            case Copper: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsCopper;
            }
            case Diamond: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsDiamond;
            }
            case Gold: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsGold;
            }
            case Heavy: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsHeavy;
            }
            case Quartz: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsQuartz;
            }
            case Silver: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsSilver;
            }
            case Sturdy: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsSturdy;
            }
            case Weapon: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsWeapon;
            }
            case WhiteGold: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsWhiteGold;
            }
            case Wood: {
                return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsWood;
            }
        }
        return InstanceDungeonCore.BlockTileEntityMetalDungeonChestsBamboo;
    }

    static {
        baseType.add(new DungeonChestTypeLoot(DungeonChestType.Bamboo, 25, 1, 10));
        baseType.add(new DungeonChestTypeLoot(DungeonChestType.Wood, 25, 1, 10));
        baseType.add(new DungeonChestTypeLoot(DungeonChestType.Sturdy, 10, 1, 20));
        baseType.add(new DungeonChestTypeLoot(DungeonChestType.Heavy, 10, 1, 20));
        baseType.add(new DungeonChestTypeLoot(DungeonChestType.Weapon, 10, 1, 20));
        baseType.add(new DungeonChestTypeLoot(DungeonChestType.Quartz, 10, 1, 20));
        preciousType.add(new DungeonChestTypeLoot(DungeonChestType.Copper, 50, 1, 30));
        preciousType.add(new DungeonChestTypeLoot(DungeonChestType.Silver, 30, 1, 30));
        preciousType.add(new DungeonChestTypeLoot(DungeonChestType.Gold, 15, 1, 20));
        preciousType.add(new DungeonChestTypeLoot(DungeonChestType.Diamond, 5, 90, 8));
        preciousType.add(new DungeonChestTypeLoot(DungeonChestType.WhiteGold, 3, 110, 5));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(CuisineCore.ItemItemCuisine3Reps, 1, 0, 25, 0, 9));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(ManaMetalMod.DarkMatter, 1, 4, 50));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(ManaMetalMod.SageofTheStone, 1, 2, 25));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(ManaMetalMod.gemMagical, 1, 0, 10));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(ManaMetalMod.ingotCopper, 1, 5, 50));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(Items.field_151042_j, 1, 5, 50));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(ManaMetalMod.ingotLead, 1, 5, 50));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(ManaMetalMod.dustMana, 1, 32, 60));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(Items.field_151079_bi, 1, 5, 15));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(Items.field_151156_bN, 1, 0, 15));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(Items.field_151072_bj, 1, 5, 15));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 3, 40));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 3, 50));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 0, 15, 1));
        ManaMetalAPI.DungeonItemsWood.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 2, 30, 1));
        ManaMetalAPI.DungeonItemsSturdy.add(new WeightedItemStack(ItemCraft10.SwordRoll, 1, 0, 15, 0, 14));
        ManaMetalAPI.DungeonItemsSturdy.add(new WeightedItemStack(ItemCraft10.ItemRandomReel, 1, 0, 50));
        ManaMetalAPI.DungeonItemsSturdy.add(new WeightedItemStack(ItemCraft10.testItemBagRoll, 1, 0, 50));
        ManaMetalAPI.DungeonItemsSturdy.add(new WeightedItemStack(ItemCraft10.ItemHomeReels, 1, 3, 10));
        ManaMetalAPI.DungeonItemsSturdy.add(new WeightedItemStack(CastingCore.ItemCastingBook, 1, 0, 3, 0, 3));
        ManaMetalAPI.DungeonItemsSturdy.add(new WeightedItemStack(InstanceDungeonCore.ItemFailWeaponReel, 1, 0, 5));
        ManaMetalAPI.DungeonItemsHeavy.add(new WeightedItemStack(ItemCraft2.QuenchingJade, 1, 0, 10));
        ManaMetalAPI.DungeonItemsHeavy.add(new WeightedItemStack(GemCraftCore.ItemMagicJadeUnknowns, 1, 0, 10, 0));
        ManaMetalAPI.DungeonItemsHeavy.add(new WeightedItemStack(GemCraftCore.ItemMagicJadeUnknowns, 1, 0, 10, 1));
        ManaMetalAPI.DungeonItemsHeavy.add(new WeightedItemStack(GemCraftCore.ItemMagicJadeUnknowns, 1, 0, 10, 2));
        ManaMetalAPI.DungeonItemsHeavy.add(new WeightedItemStack(Items.field_151045_i, 1, 5, 25));
        ManaMetalAPI.DungeonItemsHeavy.add(new WeightedItemStack(Items.field_151166_bC, 1, 5, 25));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemCraft10.ItemSpell, 1, 5, 40, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemCraft10.ItemCraeerFeature, 1, 3, 25));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft10.ExcellentArrow), 1, 0, 6));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow1), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow2), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow3), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow4), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow5), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow6), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow7), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow8), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrow9), 1, 0, 3));
        ManaMetalAPI.DungeonItemsWeapon.add(new WeightedItemStack(ItemToolArrow.getCraftResult(ItemCraft4.EMagicArrowA), 1, 0, 3));
        ManaMetalAPI.DungeonItemsQuartz.add(new WeightedItemStack(TextileCore.ItemBandages, 1, 8, 100));
        ManaMetalAPI.DungeonItemsQuartz.add(new WeightedItemStack(ProduceCore.ItemMedical, 1, 3, 75, 0, 13));
        ManaMetalAPI.DungeonItemsQuartz.add(new WeightedItemStack(ProduceCore.ItemMedical, 1, 0, 5, 26));
        ManaMetalAPI.DungeonItemsQuartz.add(new WeightedItemStack(ProduceCore.ItemMedical, 1, 0, 3, 0, 9, 14));
        ManaMetalAPI.DungeonItemsQuartz.add(new WeightedItemStack(CuisineCore.ItemFoodDrop, 1, 3, 25, 0, 13));
        ManaMetalAPI.DungeonItemsQuartz.add(new WeightedItemStack(ItemCraft3.ItemNewHPPillE, 1, 3, 10, 0, 9));
        ManaMetalAPI.DungeonItemsQuartz.add(new WeightedItemStack(ItemCraft3.ItemNewManaWaterE, 1, 10, 50, 4));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(ProduceCore.ItemMedical, 1, 0, 10, 13));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(ItemCraft2.QuenchingJade, 1, 5, 10));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 0, 10, 1));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(InstanceDungeonCore.ItemDungeonChestKey, 1, 0, 5, 6));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(InstanceDungeonCore.ItemDungeonChestKey, 1, 0, 3, 7));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(ItemCraft10.ArtifactDast, 1, 5, 15));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(ItemCraft10.ArtifactNugget, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(ItemCraft8.ExpBook1, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(ItemCraft2.SilversmithHammer, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT1.add(new WeightedItemStack(ItemCraft2.GoldenCraftsmanHammer, 1, 0, 5));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ItemCraft2.IntermediateExpBook, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ProduceCore.ItemMedical, 1, 0, 10, 13));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ItemCraft2.GoldenPearl, 1, 5, 15));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ItemCraft2.PlatinumPearl, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ItemCraft2.ItemBagBossCoins, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ItemCraft2.ProductionDiscount, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ItemCraft2.NPCDiscount, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(ItemCraft2.ItemDimensionCrystals, 1, 0, 10));
        ManaMetalAPI.DungeonItemsPreciousT2.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 0, 5, 7));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ProduceCore.ItemMedical, 1, 0, 20, 13));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ProduceCore.ItemMedical, 1, 0, 3, 23));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.RainbowPearl, 1, 3, 15));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.HolySoulPearl, 1, 0, 15));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.GoldenDagger, 1, 0, 10));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.ItemGoldenBeetle, 1, 3, 15));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.ItemClover, 1, 3, 15));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.ItemBingoPassCard, 1, 0, 10));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.ItemUltimateSoulGem, 1, 0, 3));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemWhiteTicket.getAncientStone(30), 1, 0, 3));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemWhiteTicket.getAncientStone(20), 1, 0, 3));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.Worldfruit, 1, 0, 2));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(InstanceDungeonCore.ItemDungeonChestKey, 1, 0, 5, 8));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(InstanceDungeonCore.ItemDungeonChestKey, 1, 0, 5, 9));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 0, 5, 8));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(InstanceDungeonCore.ItemUnlocks, 1, 3, 5, 7));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(InstanceDungeonCore.ItemKeyDungeonUnidentifieds, 1, 0, 5, 3));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.LeafOfLife, 1, 0, 4));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.HeartOfTheEmerald, 1, 0, 4));
        ManaMetalAPI.DungeonItemsPreciousT3.add(new WeightedItemStack(ItemCraft2.OriginGoldenSword, 1, 0, 4));
    }
}

