/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.magic.book;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.api.IFriendly;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.EntityRuneSpell;
import project.studio.manametalmod.spell.SpellType;

public enum MagicSpell {
    ManaAreaBoss,
    ManaAreaPlayer;


    public void doManaAreaBoss(World world, EntityRuneSpell rune, EntityLivingBase owner, int time) {
        double dist = (float)time / 10.0f;
        AxisAlignedBB var3 = rune.field_70121_D.func_72314_b(dist, 0.1, dist);
        List list = rune.field_70170_p.func_72872_a(EntityLivingBase.class, var3);
        for (Entity e : list) {
            if (!(e instanceof EntityLivingBase) || e == owner || (int)e.func_70032_d((Entity)rune) != time / 10 || !e.field_70122_E || rune.field_70170_p.field_72995_K) continue;
            e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)owner), rune.damage);
        }
        double x = Math.sin((float)time / 10.0f);
        double z = Math.cos((float)time / 10.0f);
        double step = 0.39269908169872414;
        if (world.field_72995_K) {
            for (int i = 0; i < 16; ++i) {
                x = Math.sin((double)((float)time / 10.0f) + step * (double)i) * (double)((float)time / 10.0f);
                z = Math.cos((double)((float)time / 10.0f) + step * (double)i) * (double)((float)time / 10.0f);
                FXHelp.spawnParticle(world, Particle.flame, rune.field_70165_t + x, rune.field_70163_u - 0.5 + (double)rune.field_70170_p.field_73012_v.nextFloat() - 0.5, rune.field_70161_v + z, 0.0, 0.1, 0.0, -1.0f);
            }
        }
    }

    public void doManaAreaPlayer(World world, EntityRuneSpell rune, EntityLivingBase owner, int time) {
        double dist = (float)time / 10.0f;
        if (!world.field_72995_K && time % 5 == 0) {
            AxisAlignedBB aabb = rune.field_70121_D.func_72314_b(dist, 1.0, dist);
            List list = rune.field_70170_p.func_72872_a(EntityLivingBase.class, aabb);
            for (Entity target : list) {
                if (target instanceof IFriendly || target instanceof EntityPlayer || target == owner) continue;
                target.func_70097_a((DamageSource)AttackType.getDamage((Entity)owner, ManaElements.Ice, SpellType.IceDamage, WeaponType.Magic, false, true), rune.damage);
            }
        }
        double x = Math.sin((float)time / 10.0f);
        double z = Math.cos((float)time / 10.0f);
        double step = 0.39269908169872414;
        if (world.field_72995_K) {
            for (int s = 0; s < 16; ++s) {
                x = Math.sin((double)((float)time / 10.0f) + step * (double)s) * (double)((float)time / 10.0f);
                z = Math.cos((double)((float)time / 10.0f) + step * (double)s) * (double)((float)time / 10.0f);
                FXHelp.spawnParticle(world, Particle.lava, rune.field_70165_t + x, rune.field_70163_u - 0.5 + (double)rune.field_70170_p.field_73012_v.nextFloat() - 0.5, rune.field_70161_v + z, 0.0, 0.1, 0.0, -1.0f);
            }
        }
    }

    public void tickEvent(World world, EntityRuneSpell rune, EntityLivingBase owner, int time) {
        switch (this) {
            case ManaAreaBoss: {
                this.doManaAreaBoss(world, rune, owner, time);
                return;
            }
            case ManaAreaPlayer: {
                this.doManaAreaPlayer(world, rune, owner, time);
            }
        }
    }
}

