/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.magicenergy;

import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.magicenergy.IMagicEnergyUse;

public class MagicEnergy {
    public int Energy;

    public MagicEnergy(int energy) {
        this.Energy = energy;
    }

    public MagicEnergy(MagicEnergy energy) {
        this.Energy = energy.getEnergy();
    }

    public int getEnergy() {
        return this.Energy;
    }

    public void removeEnergy(int value) {
        this.Energy -= value;
        if (this.Energy < 0) {
            this.Energy = 0;
        }
    }

    public void addEnergy(int value) {
        this.Energy += value;
    }

    public boolean isEmpty() {
        return this.getEnergy() == 0;
    }

    public void setEnergy(int value) {
        this.Energy = value;
    }

    public void moveEnergy(MagicEnergy energy, IMagicEnergyUse target, int value) {
        if (energy.getEnergy() > 0) {
            if (value + target.getEnergy().getEnergy() > target.getMaxEnergy()) {
                value = target.getMaxEnergy() - target.getEnergy().getEnergy();
            }
            if (value > energy.getEnergy()) {
                value = energy.getEnergy();
            }
            this.Energy += value;
            energy.removeEnergy(value);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.setEnergy(NBTHelp.getIntSafe("MagicEnergy", nbt, 0));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("MagicEnergy", this.getEnergy());
    }

    public boolean equals(Object obj) {
        return obj instanceof MagicEnergy && ((MagicEnergy)obj).getEnergy() == this.getEnergy();
    }

    public String toString() {
        return "MagicEnergy:" + this.getEnergy();
    }
}

