/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.mission;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import project.studio.manametalmod.mission.MissionNeed;
import project.studio.manametalmod.mission.MissionReward;
import project.studio.manametalmod.mission.MissionTarget;
import project.studio.manametalmod.mission.MissionType;

public class Mission {
    public String name;
    public MissionType type;
    public UUID uuid;
    public MissionNeed requirement = null;
    public List<MissionTarget> targets = null;
    public List<MissionReward> rewards = null;
    public LocalDate deadline = null;
    public boolean needDeadline = false;
    public boolean canGiveup = true;

    public Mission(String name, MissionType type, UUID uuid) {
        this.name = name;
        this.type = type;
        this.uuid = uuid;
    }

    public Mission addTarget(MissionTarget target) {
        if (this.targets == null) {
            this.targets = new ArrayList<MissionTarget>();
        }
        this.targets.add(target);
        return this;
    }

    public Mission addReward(Object obj) {
        if (this.rewards == null) {
            this.rewards = new ArrayList<MissionReward>();
        }
        this.rewards.add(MissionReward.analyze(obj));
        return this;
    }

    public Mission giveMissionReward(EntityPlayer player) {
        if (this.rewards != null) {
            // empty if block
        }
        return this;
    }

    public void onFinish(EntityPlayer player) {
    }

    public void onFail(EntityPlayer player) {
    }

    public void onAccept(EntityPlayer player) {
    }

    public void onReject(EntityPlayer player) {
    }

    public void onExpired(EntityPlayer player) {
    }

    public boolean isExpired(LocalDate now) {
        return now.isAfter(this.deadline);
    }

    public boolean isCompleted(EntityPlayer player) {
        for (MissionTarget target : this.targets) {
            if (target.isCompleted(player)) continue;
            return false;
        }
        return true;
    }

    public void printMission() {
        System.out.print("\u5699\u8e1d\u856d\u5699\u8913\u540d\u5699\u8e1d\u856d: " + this.name + "  \r\n");
        System.out.print("\u5699\u8e1d\u856d\u5699\u8e1d\u856d\u5699\u8e1d\u856d\u5699\u8e1d\u856d: " + (Object)((Object)this.type) + "  \r\n");
        System.out.print("\u5699\u8e1d\u856d\u5699\u8913\u76ee\u6f58\u856d:  \r\n");
        for (MissionTarget target : this.targets) {
            System.out.print(" > " + target + "  \r\n");
        }
        System.out.print("\u5699\u8e1d\u856d\u5699\u8913\u6f58\u856d\u5699\u7faf:   \r\n");
        for (MissionReward reward : this.rewards) {
            System.out.print(" > " + reward + "  \r\n");
        }
        System.out.print("\u5699\u8e1d\u856d\u5699\u8e1d\u856d\u5699\u8c4e\u6c42: " + this.requirement + "  \r\n");
        System.out.print("\u5699\u8e1d\u856d\u5699\u8913\u6e5b\u856d\u5699\u8e1d\u856d: " + this.deadline + "  \r\n");
        System.out.print("UUID: " + this.uuid + "  \r\n");
    }
}

