/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.pet;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ai.DynamicHatred;
import project.studio.manametalmod.api.IFriendly;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.EntityBlossRune;
import project.studio.manametalmod.mob.EntityMagicBallNew;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.pet.EntitySummoner;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.spell.SpellType;

public enum SummonerType {
    snake,
    dragon,
    wolf,
    fox,
    scorpion,
    cat;


    public boolean isMelee() {
        switch (this) {
            case wolf: 
            case fox: 
            case scorpion: 
            case cat: {
                return true;
            }
        }
        return false;
    }

    public void spawnRuneFX(EntitySummoner entity, ManaElements eme) {
        EntityBlossRune rune = new EntityBlossRune(entity.field_70170_p, 60, eme, 0.5f);
        entity.func_85030_a(ManaElements.getElementsSounds(eme), 1.0f, 1.0f);
        rune.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_72838_d((Entity)rune);
        }
    }

    public void onTickEvent(EntitySummoner entity, EntityLivingBase owner, World world) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (owner == null || !(owner instanceof EntityPlayer)) {
            entity.func_70106_y();
            return;
        }
        if (entity.func_70638_az() instanceof IFriendly || entity.func_70638_az() instanceof EntityPlayer) {
            entity.func_70624_b(null);
        }
        EntityPlayer player = (EntityPlayer)owner;
        switch (this) {
            case dragon: {
                if (entity.cd2 <= 0 || !(entity.func_70032_d((Entity)owner) < 16.0f)) break;
                entity.cd2 = -600;
                List<EntityLivingBase> list = MMM.findEntityLivingBase(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 16);
                int LV2 = 0;
                if (entity.specialID == 1) {
                    LV2 = 2;
                }
                for (int s = 0; s < list.size(); ++s) {
                    EntityLivingBase target = list.get(s);
                    if (target instanceof EntityPlayer) {
                        PotionEffectM3.addPotion(target, PotionM3.potionSpellExcitation, 60, LV2);
                        continue;
                    }
                    if (!(target instanceof EntityMob) && !(target instanceof IMob)) continue;
                    target.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 1200, LV2));
                }
                this.spawnRuneFX(entity, entity.getEntityElements());
                break;
            }
            case fox: {
                if (entity.cd2 <= 0 || entity.func_70638_az() == null || !(entity.func_70032_d((Entity)entity.func_70638_az()) < 16.0f)) break;
                EntityLivingBase target = entity.func_70638_az();
                entity.cd2 = -600;
                int attacktemp = (int)entity.attack;
                if (entity.specialID == 0) {
                    attacktemp = (int)((float)attacktemp * 1.2f);
                }
                if (entity.summonTime > 0) {
                    attacktemp = (int)((float)attacktemp + (float)attacktemp * ((float)entity.summonTime * 0.02f));
                }
                EntityMagicBallNew ball = new EntityMagicBallNew(world, (EntityLivingBase)player, attacktemp, entity.getEntityElements(), 1, (Entity)target);
                ball.field_70165_t = target.field_70165_t;
                ball.field_70163_u = target.field_70163_u + 70.0;
                ball.field_70161_v = target.field_70161_v;
                ball.field_70159_w = 0.0;
                ball.field_70181_x = -0.5;
                ball.field_70179_y = 0.0;
                ball.elements = ManaElements.Fire;
                ball.weapon = WeaponType.Magic;
                ball.spelltype = SpellType.Explosion;
                ball.penetrateBlockYPos = true;
                ball.penetrateY = (int)(target.field_70163_u - 1.0);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)ball);
                }
                this.spawnRuneFX(entity, entity.getEntityElements());
                break;
            }
            case scorpion: {
                if (entity.cd2 <= 0 || !(entity.func_70032_d((Entity)owner) < 12.0f)) break;
                entity.cd2 = -600;
                int time = 200;
                if (entity.specialID == 0) {
                    time = 300;
                }
                List<EntityLivingBase> list = MMM.findEntityLivingBase(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 12);
                int size = list.size();
                for (int s = 0; s < size; ++s) {
                    DynamicHatred mob;
                    EntityLivingBase target = list.get(s);
                    if (target instanceof EntityPlayer) {
                        PotionEffectM3.addPotion(target, PotionM3.potionShadowShield, 60, 0);
                        continue;
                    }
                    if (!(target instanceof EntityMob)) continue;
                    if (target instanceof DynamicHatred) {
                        mob = (DynamicHatred)target;
                        mob.onRidicule((EntityLivingBase)entity, time);
                    }
                    if (!(mob = (EntityMob)target).func_70685_l((Entity)entity)) continue;
                    mob.func_70624_b((EntityLivingBase)entity);
                }
                this.spawnRuneFX(entity, entity.getEntityElements());
                break;
            }
            case snake: {
                if (entity.func_70638_az() != null && entity.cd3 <= 0 && entity.func_70032_d((Entity)player) < 16.0f) {
                    PotionEffectM3.addPotionList(MMM.findMobs((Entity)entity, 8.0), PotionM3.potionThunder, 10, 0);
                    this.spawnRuneFX(entity, ManaElements.Thunder);
                    entity.cd3 = -30;
                }
                if (entity.cd2 <= 0 || !(entity.func_70032_d((Entity)player) < 16.0f) || !(player.func_110143_aJ() < player.func_110138_aP() * 0.7f)) break;
                entity.cd2 = -600;
                float heal = 0.3f;
                if (entity.specialID == 0) {
                    heal *= 1.5f;
                }
                List<EntityLivingBase> list = MMM.findEntityLivingBase(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 16);
                for (int s = 0; s < list.size(); ++s) {
                    EntityLivingBase target = list.get(s);
                    if (!(target instanceof EntityPlayer) && !(target instanceof IFriendly)) continue;
                    target.func_70691_i(target.func_110138_aP() * heal);
                    PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(13, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0, 0, 0), new NetworkRegistry.TargetPoint(MMM.getDimensionID(target.field_70170_p), target.field_70165_t, target.field_70163_u, target.field_70161_v, 16.0));
                }
                this.spawnRuneFX(entity, ManaElements.Light);
                break;
            }
            case wolf: {
                if (entity.cd2 <= 0 || !(entity.func_70032_d((Entity)owner) < 16.0f)) break;
                entity.cd2 = -600;
                List<EntityPlayer> list = MMM.findPlayers((Entity)entity, 16);
                for (int s = 0; s < list.size(); ++s) {
                    PotionEffectM3.addPotion((EntityLivingBase)list.get(s), PotionM3.potionPaoxiao, 60, 0);
                }
                this.spawnRuneFX(entity, entity.getEntityElements());
                break;
            }
            case cat: {
                if (entity.cd2 <= 0 || entity.func_70638_az() == null || !(entity.func_70032_d((Entity)entity.func_70638_az()) < 16.0f)) break;
                entity.cd2 = -600;
                int attacktemp = (int)entity.attack;
                if (entity.specialID == 1) {
                    attacktemp = (int)((float)attacktemp * 1.2f);
                }
                if (entity.summonTime > 0) {
                    attacktemp = (int)((float)attacktemp + (float)attacktemp * ((float)entity.summonTime * 0.02f));
                }
                List<EntityLivingBase> list = MMM.findMobs(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 16.0);
                for (int s = 0; s < list.size(); ++s) {
                    EntityLivingBase target = list.get(s);
                    target.func_70097_a((DamageSource)AttackType.getDamage((Entity)player, entity.getEntityElements(), SpellType.Pure, WeaponType.Magic, true, true), (float)attacktemp);
                    PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(1, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v), new NetworkRegistry.TargetPoint(MMM.getDimensionID(entity.field_70170_p), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 16.0));
                    if (s > 5) break;
                }
                this.spawnRuneFX(entity, entity.getEntityElements());
            }
        }
    }

    public float getAttack() {
        switch (this) {
            case dragon: {
                return 2.0f;
            }
            case snake: {
                return 2.0f;
            }
            case fox: {
                return 3.0f;
            }
            case scorpion: {
                return 3.0f;
            }
            case wolf: {
                return 3.0f;
            }
            case cat: {
                return 3.0f;
            }
        }
        return 1.0f;
    }

    public float getHP() {
        switch (this) {
            case dragon: {
                return 6.0f;
            }
            case fox: {
                return 6.0f;
            }
            case scorpion: {
                return 20.0f;
            }
            case snake: {
                return 6.0f;
            }
            case wolf: {
                return 6.0f;
            }
            case cat: {
                return 6.0f;
            }
        }
        return 1.0f;
    }
}

