/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.cuisine;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.EnumChatFormatting;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;
import project.studio.manametalmod.magic.magicItem.MagicItemType;
import project.studio.manametalmod.produce.cuisine.FoodType;

public class HotPot {
    public static final String textHotPot = MMM.getTranslateText("HotPotBase");
    public static final EnumChatFormatting color = EnumChatFormatting.AQUA;
    public static final IMagicEffect effect_default_meatraw = new IMagicEffect(MagicItemType.attackMultiplier, 0.02f);
    public static final IMagicEffect effect_default_fishraw = new IMagicEffect(MagicItemType.crit, 2.0f);
    public static final IMagicEffect effect_default_egg = new IMagicEffect(MagicItemType.critDamage, 0.02f);
    public static final IMagicEffect effect_default_grain = new IMagicEffect(MagicItemType.physicalAttack, 2.0f);
    public static final IMagicEffect effect_default_mushroom = new IMagicEffect(MagicItemType.physicalAttack, 2.0f);
    public static final IMagicEffect effect_default_veggie = new IMagicEffect(MagicItemType.magicAttack, 2.0f);
    public static final IMagicEffect effect_default_fruit = new IMagicEffect(MagicItemType.magicAttack, 2.0f);
    public static final IMagicEffect effect_default_milk = new IMagicEffect(MagicItemType.penetrate, 1.0f);

    public static final IMagicEffect getItemEffect(Item item) {
        IMagicEffect effect = ManaMetalAPI.HotPotFoodList.get(item);
        if (effect != null) {
            return effect;
        }
        return HotPot.getItemEffectBase(item);
    }

    public static final void addItemEffect(Item item, MagicItemType type, float data) {
        ManaMetalAPI.HotPotFoodList.put(item, new IMagicEffect(type, data));
    }

    public static final String getInfoText(Item item) {
        IMagicEffect effect = HotPot.getItemEffect(item);
        if (effect != null) {
            return textHotPot + HotPot.getEffectText(effect);
        }
        return null;
    }

    public static final IMagicEffect getItemEffectBase(Item item) {
        String[] orenames = MMM.getItemOreDictionaryName(item);
        if (MMM.isStringFromArray(orenames, FoodType.meatraw.getName())) {
            return effect_default_meatraw;
        }
        if (MMM.isStringFromArray(orenames, FoodType.fishraw.getName())) {
            return effect_default_fishraw;
        }
        if (MMM.isStringFromArray(orenames, FoodType.egg.getName())) {
            return effect_default_egg;
        }
        if (MMM.isStringFromArray(orenames, FoodType.grain.getName())) {
            return effect_default_grain;
        }
        if (MMM.isStringFromArray(orenames, FoodType.veggie.getName())) {
            return effect_default_veggie;
        }
        if (MMM.isStringFromArray(orenames, FoodType.mushroom.getName())) {
            return effect_default_mushroom;
        }
        if (MMM.isStringFromArray(orenames, FoodType.milk.getName())) {
            return effect_default_milk;
        }
        if (MMM.isStringFromArray(orenames, FoodType.fruit.getName())) {
            return effect_default_fruit;
        }
        return null;
    }

    public static String getEffectText(IMagicEffect effect) {
        DecimalFormat df1 = (DecimalFormat)NumberFormat.getPercentInstance();
        switch (effect.getType()) {
            case physicalAttack: {
                return color + MMM.getTranslateText("manaItem.physicalAttack") + "+" + (int)effect.getValue();
            }
            case magicAttack: {
                return color + MMM.getTranslateText("manaItem.magicAttack") + "+" + (int)effect.getValue();
            }
            case penetrate: {
                return color + MMM.getTranslateText("manaItem.penetrate") + "+" + (int)effect.getValue();
            }
            case crit: {
                return color + MMM.getTranslateText("manaItem.crit") + "+" + (int)effect.getValue();
            }
            case magicDefense: {
                return color + MMM.getTranslateText("manaItem.magicDefense") + "+" + (int)effect.getValue();
            }
            case avoid: {
                return color + MMM.getTranslateText("manaItem.avoid") + "+" + (int)effect.getValue();
            }
            case FinalAttack: {
                return color + MMM.getTranslateText("manaItem.FinalAttack") + "+" + df1.format(effect.getValue());
            }
            case attackMultiplier: {
                return color + MMM.getTranslateText("manaItem.attackMultiplier") + "+" + df1.format(effect.getValue());
            }
            case critDamage: {
                return color + MMM.getTranslateText("manaItem.critDamage") + "+" + df1.format(effect.getValue());
            }
        }
        return "unknown effect";
    }

    public static final AttackEffect geteffect(List<IMagicEffect> list) {
        AttackEffect effect = new AttackEffect();
        block11: for (int s = 0; s < list.size(); ++s) {
            float count = list.get(s).getValue();
            switch (list.get(s).getType()) {
                case physicalAttack: {
                    effect.attack_base_physical = (int)((float)effect.attack_base_physical + count);
                    continue block11;
                }
                case magicAttack: {
                    effect.attack_base_magic = (int)((float)effect.attack_base_magic + count);
                    continue block11;
                }
                case penetrate: {
                    effect.penetration_base = (int)((float)effect.penetration_base + count);
                    continue block11;
                }
                case attackMultiplier: {
                    effect.attack += count;
                    continue block11;
                }
                case crit: {
                    effect.crit = (int)((float)effect.crit + count);
                    continue block11;
                }
                case critDamage: {
                    effect.critDamage += count;
                    continue block11;
                }
                case magicDefense: {
                    effect.defense = (int)((float)effect.defense + count);
                    continue block11;
                }
                case avoid: {
                    effect.avoid = (int)((float)effect.avoid + count);
                    continue block11;
                }
                case FinalAttack: {
                    effect.final_attack += count;
                }
            }
        }
        return effect;
    }
}

