/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.fishing;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import project.studio.manametalmod.produce.fishing.EntityFishHookMana;
import project.studio.manametalmod.produce.fishing.FishSizeType;
import project.studio.manametalmod.produce.fishing.WaterType;

public class FishPrey {
    public static final int min = 10;
    public static final int max = 40;
    public ItemStack fish;
    public int minPower;
    public int minLV;
    public int fishHP;
    public int fishPower;
    public float fishSpeed;
    public FishSizeType type;
    public WaterType water;
    public int weight;
    public int lucky;
    public int stopChance;
    public int maxStopTime;
    public int moveChance;
    public float maxMovePower;
    public boolean isFishBoss;

    public FishPrey(ItemStack fish, int minPower, int minLV, int fishHP, int fishPower, float fishSpeed, FishSizeType type, WaterType water, int weight, int lucky, int stopChance, int maxStopTime, int moveChance, float maxMovePower, boolean isFishBoss) {
        this.setFish(fish);
        this.minPower = minPower;
        this.minLV = minLV;
        this.fishHP = fishHP;
        this.fishPower = fishPower;
        this.fishSpeed = fishSpeed;
        this.type = type;
        this.lucky = lucky;
        this.water = water;
        this.weight = weight;
        this.stopChance = stopChance;
        this.maxStopTime = maxStopTime;
        this.moveChance = moveChance;
        this.maxMovePower = maxMovePower;
        this.isFishBoss = isFishBoss;
    }

    public FishPrey(ItemStack fish, FishSizeType type, WaterType water, int weight, boolean isFishBoss) {
        this.setFish(fish);
        this.minPower = 1;
        this.minLV = 0;
        this.fishHP = (type.ordinal() + 1) * 400;
        this.fishPower = type.ordinal() + 1;
        this.fishSpeed = (float)(type.ordinal() + 1) * 0.05f;
        this.type = type;
        this.lucky = 0;
        this.water = water;
        this.weight = weight;
        this.stopChance = 400;
        this.maxStopTime = 60;
        this.moveChance = 16 * (type.ordinal() + 1);
        this.maxMovePower = (float)(type.ordinal() + 1) * 0.3f;
        this.isFishBoss = isFishBoss;
        if (this.isFishBoss) {
            this.fishPower = (int)((double)this.fishPower * 1.8);
            this.fishSpeed *= 1.4f;
        }
    }

    public FishPrey setMinPower(int data) {
        this.minPower = data;
        return this;
    }

    public FishPrey copy() {
        return new FishPrey(this.getFish().func_77946_l(), this.minPower, this.minLV, this.fishHP, this.fishPower, this.fishSpeed, this.type, this.water, this.weight, this.lucky, this.stopChance, this.maxStopTime, this.moveChance, this.maxMovePower, this.isFishBoss);
    }

    public boolean canCaptureThis(int fishPower, int LV2, int lucky, EntityFishHookMana hook) {
        if (fishPower >= this.minPower && LV2 >= this.minLV && lucky >= this.lucky) {
            BiomeGenBase biome = hook.field_70170_p.getBiomeGenForCoordsBody((int)hook.field_70165_t, (int)hook.field_70161_v);
            return this.water.isBiomeWater(biome, hook.field_70170_p, (int)hook.field_70163_u);
        }
        return false;
    }

    public int CorrectedFigures(int num) {
        if (num > 40) {
            return 40;
        }
        if (num < 10) {
            return 10;
        }
        return num;
    }

    public int[] getGuiData(int fishPower, int LV2, EntityPlayer player, int damage, int HP) {
        int fish = this.fishHP / 10 + this.type.ordinal() * 5 + this.fishPower * 3 - LV2 * 2;
        int attack = (int)((float)(this.fishHP / 50 + this.type.ordinal() * 3) + this.fishSpeed + (float)(this.fishPower * 2) - (float)(LV2 * 2));
        fish = this.CorrectedFigures(fish);
        attack = this.CorrectedFigures(attack);
        int ok = 90 - (fish + attack);
        int[] data = new int[]{fish, ok, attack, this.fishHP, HP};
        return data;
    }

    public ItemStack getFish() {
        return this.fish.func_77946_l();
    }

    public void setFish(ItemStack fish) {
        this.fish = fish.func_77946_l();
    }
}

