/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.fishing;

import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.config.M3Config;

public enum WaterType {
    magic,
    plain,
    forest,
    desert,
    jungle,
    ice_cold,
    mushroom,
    wasteland,
    dead,
    cave,
    thulium,
    sky,
    grave,
    ancient,
    hell,
    ender,
    mineWorld,
    oceanWorld,
    pyramid,
    Oldjungle,
    Garden,
    AncientEmpire,
    any,
    river,
    ocean,
    deepOcean,
    swamp;


    public boolean isBiomeWater(BiomeGenBase biome, World world, int ypos) {
        switch (this) {
            case Garden: {
                return MMM.getDimensionID(world) == M3Config.WorldGardenID;
            }
            case thulium: {
                return MMM.getDimensionID(world) == M3Config.ThuliumRemainsID;
            }
            case sky: {
                return MMM.getDimensionID(world) == M3Config.ManaWorldSkyID;
            }
            case grave: {
                return MMM.getDimensionID(world) == M3Config.WorldUndeadGraveID;
            }
            case ancient: {
                return MMM.getDimensionID(world) == M3Config.WorldAncientID;
            }
            case hell: {
                return MMM.getDimensionID(world) == -1;
            }
            case ender: {
                return MMM.getDimensionID(world) == 1;
            }
            case mineWorld: {
                return MMM.getDimensionID(world) == M3Config.WorldMineCaveID;
            }
            case oceanWorld: {
                return MMM.getDimensionID(world) == M3Config.WorldOceanID;
            }
            case pyramid: {
                return MMM.getDimensionID(world) == M3Config.WorldPyramidID;
            }
            case Oldjungle: {
                return MMM.getDimensionID(world) == M3Config.WorldOldJungleID;
            }
            case AncientEmpire: {
                return MMM.getDimensionID(world) == M3Config.WorldAncientEmpireID;
            }
            case deepOcean: {
                return biome == BiomeGenBase.field_150575_M;
            }
            case ice_cold: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
            }
            case cave: {
                return ypos < 32;
            }
            case magic: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
            }
            case plain: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
            }
            case forest: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
            }
            case desert: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
            }
            case jungle: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
            }
            case mushroom: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM);
            }
            case wasteland: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND);
            }
            case dead: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD);
            }
            case any: {
                return true;
            }
            case river: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER);
            }
            case ocean: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
            }
            case swamp: {
                return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
            }
        }
        return false;
    }
}

