/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.skyadventure;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.skyadventure.Battleship;

public class BattleshipData {
    public Battleship boat = Battleship.None;
    public int exp = 0;
    public int heal = 0;
    public int healMax = 0;
    public EntityPlayer player;
    public int boatLV = 1;
    public String playerName = "";

    public BattleshipData(EntityPlayer player) {
        this.player = player;
    }

    public BattleshipData(EntityPlayer player, Battleship boat, int heal, int healMax, int exp, int boatLV) {
        this.player = player;
        this.boat = boat;
        this.heal = heal;
        this.healMax = healMax;
        this.exp = exp;
        this.boatLV = boatLV;
    }

    public BattleshipData copy() {
        return new BattleshipData(this.player, this.boat, this.heal, this.healMax, this.exp, this.boatLV);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound tag = nbt.func_74775_l("BattleshipData");
        this.boatLV = NBTHelp.getIntSafe("boatLV", tag, 1);
        this.exp = tag.func_74762_e("exp");
        this.heal = tag.func_74762_e("heal");
        this.healMax = tag.func_74762_e("healMax");
        this.boat = Battleship.values()[tag.func_74762_e("Battleships")];
        this.playerName = tag.func_74779_i("playerName");
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("boatLV", this.boatLV);
        tag.func_74768_a("exp", this.exp);
        tag.func_74768_a("heal", this.heal);
        tag.func_74768_a("healMax", this.healMax);
        tag.func_74768_a("Battleships", this.boat.ordinal());
        tag.func_74778_a("playerName", this.playerName);
        nbt.func_74782_a("BattleshipData", (NBTBase)tag);
    }
}

