/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.spell;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.CareerCore;

public class BaseSkill
implements Cloneable {
    public boolean isOver = false;
    public int time = 0;
    public int maxTime = 0;
    public EntityPlayer player;
    public int maxCD = 0;
    public int useMana = 0;
    public int CD = 0;
    public boolean hasTickEvent = false;
    public int skillLV = 1;

    public BaseSkill(EntityPlayer player, int maxTime, boolean hasTickEvent, int maxCD, int useMana) {
        this.maxTime = maxTime;
        this.player = player;
        this.maxCD = maxCD;
        this.useMana = useMana;
        this.hasTickEvent = hasTickEvent;
    }

    public void addLV() {
        ++this.skillLV;
        this.onSkillUpLV();
    }

    public void onUseSkill() {
    }

    public boolean canUseSkill(int mana) {
        return mana >= this.useMana && this.CD >= this.maxCD;
    }

    public void onSkillOver() {
    }

    public void onSkillUpdate(int time) {
    }

    public void onSkillAdd() {
    }

    public void onSkillUpLV() {
    }

    public void saveToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public void stop() {
        this.isOver = true;
        this.onSkillOver();
    }

    public boolean canUse() {
        return this.CD >= this.maxCD;
    }

    public CareerCore getCareer() {
        return CareerCore.Unknown;
    }

    public BaseSkill clone() {
        BaseSkill mission = new BaseSkill(this.player, this.maxTime, this.hasTickEvent, this.maxCD, this.useMana);
        return mission;
    }

    public final void update() {
        ++this.time;
        if (this.hasTickEvent) {
            this.onSkillUpdate(this.time);
        }
        if (this.CD < this.maxCD) {
            ++this.CD;
        }
        if (this.time >= this.maxTime) {
            this.isOver = true;
            this.onSkillOver();
            return;
        }
    }
}

