/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.survivalfactor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenOcean;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.BlockFluidMana;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import project.studio.manametalmod.survivalfactor.SurvivalFactorCore;

public class ItemKettle
extends Item {
    public int use = 6;
    public static Set<Block> waterSources = new HashSet<Block>();

    public ItemKettle(String name, int use) {
        this.func_77637_a(ManaMetalMod.tab_Survival_factor);
        this.func_77655_b(name);
        this.func_111206_d("manametalmod:" + name);
        this.func_77625_d(1);
        this.func_77656_e(use);
        this.setNoRepair();
        this.use = use;
    }

    public boolean func_77616_k(ItemStack item) {
        return false;
    }

    public boolean isOcean(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_150575_M || biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76776_l) {
            return true;
        }
        return biome instanceof BiomeGenOcean || biome instanceof BiomeGenBeach;
    }

    public int func_77626_a(ItemStack item) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack item) {
        return EnumAction.drink;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer EntityPlayer2, List List2, boolean booleans) {
        List2.add(MMM.getTranslateText("ItemKettle.water") + (this.use - item.func_77960_j()) + " / " + this.use);
        if (item.func_77942_o()) {
            NBTTagCompound tag = item.func_77978_p();
            if (NBTHelp.getIntSafe("water", tag, 0) == 1) {
                List2.add(MMM.getTranslateText("ItemKettle.water.type1"));
            }
            String type = NBTHelp.getStringSafe("type", tag, "None");
            List2.add(MMM.getTranslateText("ItemKettle.water.type2." + type));
            return;
        }
        List2.add(MMM.getTranslateText("ItemKettle.water.type0"));
        List2.add(MMM.getTranslateText("ItemKettle.water.type2.None"));
    }

    public ItemStack func_77654_b(ItemStack item, World world, EntityPlayer player) {
        item.func_77972_a(1, (EntityLivingBase)player);
        ManaMetalModRoot root = MMM.getEntityNBT(player);
        if (root != null) {
            if (item.func_77942_o()) {
                NBTTagCompound tag = item.func_77978_p();
                if (NBTHelp.getIntSafe("water", tag, 0) == 1) {
                    PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionSaltWater, 600, 0);
                }
                if (NBTHelp.getStringSafe("type", tag, "None").equals("Fire")) {
                    player.func_70015_d(5);
                }
                if (NBTHelp.getStringSafe("type", tag, "None").equals("Heal")) {
                    player.func_70691_i(10.0f);
                }
                if (NBTHelp.getStringSafe("type", tag, "None").equals("Magic")) {
                    root.mana.addPower(200);
                }
                if (NBTHelp.getStringSafe("type", tag, "None").equals("Poison")) {
                    MMM.addPotionCantClear(player, 19, 20, 0);
                }
                if (NBTHelp.getStringSafe("type", tag, "None").equals("hot")) {
                    PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionWarm, 60, 0);
                }
                if (NBTHelp.getStringSafe("type", tag, "None").equals("cold")) {
                    PotionEffectM3.addPotion((EntityLivingBase)player, PotionM3.potionCold, 60, 0);
                }
            }
            root.mana.setWater(root.mana.getWater() + 500);
        }
        if (item.func_77960_j() >= this.use && item.func_77942_o()) {
            item.func_77978_p().func_74778_a("type", "None");
        }
        if (!player.field_70170_p.field_72995_K && item.func_77958_k() < 10 && player.field_70170_p.field_73012_v.nextInt(80) == 0) {
            player.field_70170_p.func_72926_e(2002, (int)Math.round(player.field_70165_t), (int)Math.round(player.field_70163_u), (int)Math.round(player.field_70161_v), 0);
            return new ItemStack(SurvivalFactorCore.ItemKettle_break);
        }
        return item;
    }

    public void pushWater(World world, ItemStack item, EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        item.func_77964_b(0);
        tag.func_74768_a("water", 0);
        item.func_77982_d(tag);
        MMM.playSoundFromServer(world, MMM.getMODID() + ":fill_bottle", new Pos((Entity)player), 1.0, 1.0, 2.0);
    }

    public boolean onItemUseFirst(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int data;
            Block blockTemp = world.func_147439_a(x, y, z);
            if (waterSources.contains(blockTemp)) {
                this.pushWater(world, item, player);
                return true;
            }
            if (blockTemp == Blocks.field_150383_bp && (data = world.func_72805_g(x, y, z)) > 0) {
                this.pushWater(world, item, player);
                world.func_72921_c(x, y, z, data, 2);
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        MovingObjectPosition mov = this.func_77621_a(world, player, true);
        if (mov != null && mov.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = mov.field_72311_b;
            int j = mov.field_72312_c;
            int k = mov.field_72309_d;
            if (!world.func_72962_a(player, i, j, k)) {
                return item;
            }
            if (!player.func_82247_a(i, j, k, mov.field_72310_e, item)) {
                return item;
            }
            if (world.func_147439_a(i, j, k) instanceof BlockFluidMana) {
                BlockFluidMana mana = (BlockFluidMana)world.func_147439_a(i, j, k);
                item.func_77964_b(0);
                NBTTagCompound tag = new NBTTagCompound();
                switch (mana.Type) {
                    case Base: {
                        tag.func_74778_a("type", "Base");
                        break;
                    }
                    case Fire: {
                        tag.func_74778_a("type", "Fire");
                        break;
                    }
                    case Heal: {
                        tag.func_74778_a("type", "Heal");
                        break;
                    }
                    case Magic: {
                        tag.func_74778_a("type", "Magic");
                        break;
                    }
                    case Poison: {
                        tag.func_74778_a("type", "Poison");
                    }
                }
                tag.func_74768_a("water", 0);
                item.func_77982_d(tag);
                MMM.playSoundFromServer(world, MMM.getMODID() + ":fill_bottle", new Pos((Entity)player), 1.0, 1.0, 2.0);
                return item;
            }
            if (world.func_147439_a(i, j, k).func_149688_o() == Material.field_151586_h) {
                item.func_77964_b(0);
                NBTTagCompound tag = new NBTTagCompound();
                if (this.isOcean(player.field_70170_p.getBiomeGenForCoordsBody(mov.field_72311_b, mov.field_72309_d))) {
                    tag.func_74768_a("water", 1);
                } else {
                    tag.func_74768_a("water", 0);
                }
                tag.func_74778_a("type", "Base");
                item.func_77982_d(tag);
                MMM.playSoundFromServer(world, MMM.getMODID() + ":fill_bottle", new Pos((Entity)player), 1.0, 1.0, 2.0);
                return item;
            }
            if (world.func_147439_a(i, j, k).func_149688_o() == Material.field_151587_i) {
                item.func_77964_b(0);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("type", "Fire");
                tag.func_74768_a("water", 0);
                item.func_77982_d(tag);
                MMM.playSoundFromServer(world, MMM.getMODID() + ":fill_bottle", new Pos((Entity)player), 1.0, 1.0, 2.0);
                return item;
            }
        }
        if (item.func_77960_j() < this.use) {
            player.func_71008_a(item, this.func_77626_a(item));
        }
        return item;
    }
}

