/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.target;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.core.BlockData;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.target.TargetBase;
import project.studio.manametalmod.target.TargetType;

public class TargetDefine
extends TargetBase {
    public TargetDefine(TargetType targetType, String targetName) {
        super(targetType, targetName);
    }

    public static TargetDefine loadFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("targetName", 8)) {
            TargetType type = TargetType.values()[NBTHelp.getIntSafe("targetType", nbt, 0)];
            TargetDefine target = new TargetDefine(type, nbt.func_74779_i("targetName"));
            target.setTargetInfo(NBTHelp.getStringSafe("targetInfo", nbt, "default info"));
            target.countNeed = NBTHelp.getIntSafe("countNeed", nbt, 0);
            target.countNow = NBTHelp.getIntSafe("countNow", nbt, 0);
            target.rewardXP = NBTHelp.getIntSafe("rewardXP", nbt, 0);
            target.rewardMoney = NBTHelp.getIntSafe("rewardMoney", nbt, 0);
            if (nbt.func_150297_b("blockdata", 8)) {
                String blockdata = nbt.func_74779_i("blockdata");
                String[] str = blockdata.split(":");
                Block block = GameRegistry.findBlock((String)str[0], (String)str[1]);
                target.setBlockdata(new BlockData(block, nbt.func_74762_e("blockMetadata")));
            }
            if (nbt.func_150297_b("needName", 8)) {
                target.setNeedName(nbt.func_74779_i("needName"));
            }
            if (nbt.func_150297_b("id", 2) && nbt.func_150297_b("Count", 1) && nbt.func_150297_b("Damage", 2)) {
                target.setItemNeed(ItemStack.func_77949_a((NBTTagCompound)nbt));
            }
            if (nbt.func_150297_b("rewardItems", 9)) {
                NBTTagList list = nbt.func_150295_c("rewardItems", 10);
                int size = list.func_74745_c();
                ItemStack[] temp = new ItemStack[size];
                for (int s = 0; s < size; ++s) {
                    temp[s] = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(s));
                }
                target.rewardItems = (ItemStack[])temp.clone();
            }
            return target;
        }
        return null;
    }

    public static void saveToNBT(NBTTagCompound tag, TargetDefine target) {
        tag.func_74778_a("targetName", target.targetName);
        tag.func_74778_a("targetInfo", target.getTargetInfo());
        tag.func_74768_a("countNeed", target.countNeed);
        tag.func_74768_a("countNow", target.countNow);
        tag.func_74768_a("targetType", target.targetType.ordinal());
        tag.func_74768_a("rewardXP", target.rewardXP);
        tag.func_74768_a("rewardMoney", target.rewardMoney);
        if (target.getBlockdata() != null) {
            String name = Block.field_149771_c.func_148750_c((Object)target.getBlockdata().block);
            tag.func_74778_a("blockdata", name);
            tag.func_74768_a("blockMetadata", target.getBlockdata().blockMetadata);
        }
        if (target.getNeedName() != null) {
            tag.func_74778_a("needName", target.getNeedName());
        }
        if (target.getItemNeed() != null) {
            target.getItemNeed().func_77955_b(tag);
        }
        if (target.rewardItems != null) {
            NBTTagList list = new NBTTagList();
            for (int s = 0; s < target.rewardItems.length; ++s) {
                NBTTagCompound temp = new NBTTagCompound();
                target.rewardItems[s].func_77955_b(temp);
                list.func_74742_a((NBTBase)temp);
            }
            tag.func_74782_a("rewardItems", (NBTBase)list);
        }
    }
}

