/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.blocks.BlockTileEntityManaFurnace;
import project.studio.manametalmod.items.crafting.ManaFurnaceRecipes;
import project.studio.manametalmod.magicenergy.IMagicEnergyUse;
import project.studio.manametalmod.magicenergy.MagicEnergy;

public class TileEntityManaFurnace
extends TileEntity
implements ISidedInventory,
IMagicEnergyUse {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    MagicEnergy energy = new MagicEnergy(0);
    public static final int[] hopperIMP = new int[]{0, 1};
    public static final int[] hopperOUT = new int[]{2};

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return hopperOUT;
        }
        return hopperIMP;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 0) {
            return ManaFurnaceRecipes.smelting().getSmeltingResult(item) != null;
        }
        if (slot == 1) {
            return MMM.getManaItem(item);
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 2;
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.inventory[p_70301_1_];
    }

    public ItemStack func_70298_a(int data, int slot) {
        if (this.inventory[data] != null) {
            if (this.inventory[data].field_77994_a <= slot) {
                ItemStack itemstack = this.inventory[data];
                this.inventory[data] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[data].func_77979_a(slot);
            if (this.inventory[data].field_77994_a == 0) {
                this.inventory[data] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int data) {
        if (this.inventory[data] != null) {
            ItemStack itemstack = this.inventory[data];
            this.inventory[data] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int id, ItemStack itemd) {
        this.inventory[id] = itemd;
        if (itemd != null && itemd.field_77994_a > this.func_70297_j_()) {
            itemd.field_77994_a = this.func_70297_j_();
        }
    }

    public void setInventoryName(String name) {
    }

    public String func_145825_b() {
        return "container.TileEntityManaFurnace";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public static boolean isItemFuel(ItemStack item) {
        return TileEntityManaFurnace.getItemBurnTime(item) > 0;
    }

    public static int getItemBurnTime(ItemStack itemstack) {
        return MMM.getManaItemFuelTime(itemstack);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityManaFurnace.getItemBurnTime(this.inventory[1]);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energy.writeToNBT(nbt);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int id) {
        return this.furnaceCookTime * id / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int id) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * id / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_145845_h() {
        if (this.energy.getEnergy() > 0 && this.inventory[0] != null && this.furnaceBurnTime < 200) {
            this.furnaceBurnTime += 4;
            this.energy.removeEnergy(1);
        }
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime != 0 || this.inventory[1] != null && this.inventory[0] != null) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityManaFurnace.getItemBurnTime(this.inventory[1]);
                    if (this.furnaceBurnTime > 0) {
                        flag1 = true;
                        if (this.inventory[1] != null) {
                            --this.inventory[1].field_77994_a;
                            if (this.inventory[1].field_77994_a == 0) {
                                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                BlockTileEntityManaFurnace.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = ManaFurnaceRecipes.smelting().getSmeltingResult(this.inventory[0]);
            if (this.inventory[2] == null) {
                this.inventory[2] = itemstack.func_77946_l();
            } else if (this.inventory[2].func_77973_b() == itemstack.func_77973_b()) {
                this.inventory[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    private boolean canSmelt() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = ManaFurnaceRecipes.smelting().getSmeltingResult(this.inventory[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventory[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.inventory[2].func_77976_d();
    }

    @Override
    public boolean needEnergy() {
        return this.energy.getEnergy() < this.getMaxEnergy();
    }

    @Override
    public void onImportEnergy() {
    }

    @Override
    public void addEnergy(MagicEnergy energy) {
    }

    @Override
    public int getMaxEnergy() {
        return 100;
    }

    @Override
    public MagicEnergy getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canImport() {
        return true;
    }
}

