/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.tileentity;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft3;
import project.studio.manametalmod.magicenergy.IMagicEnergyUse;
import project.studio.manametalmod.magicenergy.MagicEnergy;
import project.studio.manametalmod.multipleBlock.MultipleBlock;
import project.studio.manametalmod.tileentity.TileEntityChestBox;
import project.studio.manametalmod.tileentity.TileEntitySpeed;
import project.studio.manametalmod.tileentity.Timemachine;

public class TileEntityTimemachine
extends TileEntitySpeed
implements IMagicEnergyUse {
    public float time;
    public int lag = 0;
    public MagicEnergy energy = new MagicEnergy(0);
    public boolean isOpen = false;
    public int openTime = 0;
    public static final MultipleBlock tileMBBasic = new MultipleBlock("TileEntityTimemachine");

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
        this.isOpen = NBTHelp.getBooleanSafe("isOpen", nbt, false);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energy.writeToNBT(nbt);
        nbt.func_74757_a("isOpen", this.isOpen);
    }

    @Override
    public void func_145845_h() {
        if (this.isOpen) {
            ++this.openTime;
            if (this.openTime > 99 && !this.field_145850_b.field_72995_K) {
                MMM.fakeExplosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 1.0f, true);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ItemCraft10.BlockWorldAncientPortals, 1, 2);
                return;
            }
        }
        this.time = (float)((double)this.time + 0.005);
        ++this.lag;
        if (this.lag > 8) {
            this.lag = 0;
        }
        if (this.energy.getEnergy() <= 20) {
            return;
        }
        this.energy.removeEnergy(20);
        if (this.testBlocks()) {
            try {
                if (M3Config.MultithreadingTimeMachine) {
                    Timemachine tt = new Timemachine(this);
                    tt.start();
                } else {
                    this.updateBlocks();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateBlocks() {
        int up = 3;
        if (M3Config.LongTermMode || M3Config.ForeverMode) {
            up = 2;
        }
        for (int dx = -3; dx < 4; ++dx) {
            for (int dz = -3; dz < 4; ++dz) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dx, this.field_145848_d, this.field_145849_e + dz);
                if (tile == null || !tile.canUpdate() || tile instanceof TileEntitySpeed || tile instanceof TileEntityChestBox) continue;
                for (int s = 0; s < up; ++s) {
                    tile.func_145845_h();
                }
            }
        }
    }

    public boolean testBlocks() {
        int base = 0;
        int rune = 0;
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z) == ItemCraft3.ManaRuneE) {
                    ++rune;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z) != ItemCraft10.magicStone1) continue;
                ++base;
            }
        }
        return base >= 49 && rune >= 32;
    }

    @Override
    public boolean needEnergy() {
        return this.energy.getEnergy() < this.getMaxEnergy();
    }

    @Override
    public void onImportEnergy() {
    }

    @Override
    public void addEnergy(MagicEnergy energy) {
    }

    @Override
    public int getMaxEnergy() {
        return 5000;
    }

    @Override
    public MagicEnergy getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canImport() {
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
    }

    public void update_data() {
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

