/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.totem;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.totem.TileEntityTotem;
import project.studio.manametalmod.totem.TileEntityTotemSpring;

public enum TotemType {
    Water,
    Ice,
    Fire,
    Light,
    Dark,
    Wind,
    Earthm,
    Grass,
    Thunder,
    Pride,
    Greed,
    Lust,
    Jealousy,
    Gluttony,
    Anger,
    Lazy,
    Beautiful,
    Dream,
    Magic,
    Soul,
    Chaos;

    public static final ItemStack[] needItem;

    public void update(TileEntityTotem tile, TileEntityTotemSpring target, World world, Random rand) {
        int temp;
        if (tile.hasTarget() && target != null && !target.isFull()) {
            temp = target.add(tile.mana);
            tile.mana = 0;
            if (temp > 0) {
                tile.add(temp);
            }
        }
        if (!tile.isFull()) {
            switch (tile.type) {
                case Water: {
                    this.doWater(tile);
                    this.doBaseParticle(tile, Particle.dripWater);
                    break;
                }
                case Ice: {
                    if (!tile.removeItem(needItem[tile.type.ordinal()], 50)) {
                        return;
                    }
                    temp = (int)this.EnvironmentalVariables(tile);
                    if (temp >= 0) break;
                    if ((temp = Math.abs(temp)) > 40) {
                        temp = 40;
                    }
                    tile.add(temp);
                    this.doBaseParticle(tile, Particle.ice);
                    break;
                }
                case Fire: {
                    this.doFire(tile);
                    break;
                }
                case Light: {
                    if (!world.func_72935_r()) {
                        return;
                    }
                    if (!tile.removeItem(needItem[tile.type.ordinal()], 90)) {
                        return;
                    }
                    tile.add(24);
                    this.doBaseParticle(tile, Particle.flame);
                    break;
                }
                case Dark: {
                    if (world.func_72935_r()) {
                        return;
                    }
                    if (!tile.removeItem(needItem[tile.type.ordinal()], 92)) {
                        return;
                    }
                    tile.add(24);
                    this.doBaseParticle(tile, Particle.smoke);
                    break;
                }
                case Wind: {
                    if (!tile.removeItem(needItem[tile.type.ordinal()], 75)) {
                        return;
                    }
                    int y = tile.field_145848_d;
                    if (y > 200) {
                        y = (int)((double)y * 1.5);
                    }
                    if (y <= 0) break;
                    tile.add(y / 8);
                    this.doBaseParticle(tile, Particle.crit);
                    break;
                }
                case Earthm: {
                    this.doEarthm(tile);
                    break;
                }
                case Grass: {
                    this.doGrass(tile);
                    break;
                }
                case Thunder: {
                    if (world.field_72995_K || !world.func_72896_J() || tile.func_145831_w().field_72995_K || world.field_73012_v.nextInt(30) != 0) break;
                    world.func_72942_c((Entity)new EntityLightningBolt(world, (double)tile.field_145851_c, (double)(tile.field_145848_d + 1), (double)tile.field_145849_e));
                    if (!tile.removeItem(needItem[tile.type.ordinal()], 80)) break;
                    tile.add(5000);
                }
            }
        }
    }

    public void doBaseParticle(TileEntityTotem tile, Particle Particles) {
        if (tile.func_145831_w().field_72995_K) {
            for (int x = 0; x < 6; ++x) {
                FXHelp.spawnParticle(tile.func_145831_w(), Particles, (double)tile.field_145851_c + 0.5 + (double)((tile.func_145831_w().field_73012_v.nextFloat() - tile.func_145831_w().field_73012_v.nextFloat()) / 2.0f), (double)tile.field_145848_d + 1.1 + (double)((tile.func_145831_w().field_73012_v.nextFloat() - tile.func_145831_w().field_73012_v.nextFloat()) / 2.0f), (double)tile.field_145849_e + 0.5 + (double)((tile.func_145831_w().field_73012_v.nextFloat() - tile.func_145831_w().field_73012_v.nextFloat()) / 2.0f));
            }
        }
    }

    public void doWater(TileEntityTotem tile) {
        for (int x = -5; x < 6; ++x) {
            for (int z = -5; z < 6; ++z) {
                if (tile.func_145831_w().func_147439_a(x + tile.field_145851_c, tile.field_145848_d, z + tile.field_145849_e) != Blocks.field_150355_j) continue;
                if (tile.func_145831_w().field_72995_K) {
                    FXHelp.spawnParticleLine(tile.func_145831_w(), Particle.bubble, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.1, (double)tile.field_145849_e + 0.5, (double)(x + tile.field_145851_c) + 0.5, (double)tile.field_145848_d + 0.5, (double)(z + tile.field_145849_e) + 0.5);
                }
                if (!tile.func_145831_w().field_72995_K && tile.removeItem(needItem[tile.type.ordinal()], 90)) {
                    tile.add(100);
                }
                return;
            }
        }
    }

    public void doGrass(TileEntityTotem tile) {
        for (int x = -8; x < 9; ++x) {
            for (int z = -8; z < 9; ++z) {
                if (!(tile.func_145831_w().func_147439_a(x + tile.field_145851_c, tile.field_145848_d, z + tile.field_145849_e) instanceof BlockTallGrass)) continue;
                if (tile.removeItem(needItem[tile.type.ordinal()], 95)) {
                    if (!tile.func_145831_w().field_72995_K) {
                        tile.add(150);
                        MMM.breakBlock(tile.func_145831_w(), x + tile.field_145851_c, tile.field_145848_d, z + tile.field_145849_e, false);
                    }
                    if (tile.func_145831_w().field_72995_K) {
                        FXHelp.spawnParticleLine(tile.func_145831_w(), Particle.spell, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.1, (double)tile.field_145849_e + 0.5, (double)(x + tile.field_145851_c) + 0.5, (double)tile.field_145848_d + 0.5, (double)(z + tile.field_145849_e) + 0.5);
                    }
                }
                return;
            }
        }
    }

    public void doEarthm(TileEntityTotem tile) {
        List<EntityItem> items = MMM.findEntityItem(tile, 8.0);
        for (int s = 0; s < items.size(); ++s) {
            if (items.get(s).func_92059_d() == null || items.get((int)s).field_70128_L || items.get((int)s).func_92059_d().field_77994_a <= 0) continue;
            ItemStack itemstack = items.get(s).func_92059_d();
            String[] ore = MMM.getItemOreDictionaryName(itemstack);
            if (MMM.isStringStartFromArray(ore, "ingot")) {
                if (tile.removeItem(needItem[tile.type.ordinal()], 95)) {
                    if (!tile.func_145831_w().field_72995_K) {
                        --itemstack.field_77994_a;
                        if (itemstack.field_77994_a <= 0) {
                            items.get(s).func_70106_y();
                        }
                        tile.add(500);
                    }
                    if (tile.func_145831_w().field_72995_K) {
                        FXHelp.spawnParticleLine(tile.func_145831_w(), Particle.spell, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.1, (double)tile.field_145849_e + 0.5, items.get((int)s).field_70165_t, items.get((int)s).field_70163_u, items.get((int)s).field_70161_v);
                    }
                }
                return;
            }
            if (!MMM.isStringStartFromArray(ore, "gem")) continue;
            if (tile.removeItem(needItem[tile.type.ordinal()], 95)) {
                if (!tile.func_145831_w().field_72995_K) {
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 0) {
                        items.get(s).func_70106_y();
                    }
                    tile.add(700);
                }
                if (tile.func_145831_w().field_72995_K) {
                    FXHelp.spawnParticleLine(tile.func_145831_w(), Particle.spell, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.1, (double)tile.field_145849_e + 0.5, items.get((int)s).field_70165_t, items.get((int)s).field_70163_u, items.get((int)s).field_70161_v);
                }
            }
            return;
        }
    }

    public void doFire(TileEntityTotem tile) {
        List<EntityItem> items = MMM.findEntityItem(tile, 8.0);
        for (int s = 0; s < items.size(); ++s) {
            ItemStack itemstack;
            int time;
            if (items.get(s).func_92059_d() == null || items.get((int)s).field_70128_L || items.get((int)s).func_92059_d().field_77994_a <= 0 || (time = MMM.getItemStackFuelValue(itemstack = items.get(s).func_92059_d())) <= 0) continue;
            if (tile.removeItem(needItem[tile.type.ordinal()], 80)) {
                if (!tile.func_145831_w().field_72995_K) {
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 0) {
                        items.get(s).func_70106_y();
                    }
                    if (time > 3500) {
                        time = 3500;
                    }
                    if (time < 50) {
                        time = 50;
                    }
                    tile.add(time / 10);
                }
                if (tile.func_145831_w().field_72995_K) {
                    FXHelp.spawnParticleLine(tile.func_145831_w(), Particle.flame, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.1, (double)tile.field_145849_e + 0.5, items.get((int)s).field_70165_t, items.get((int)s).field_70163_u, items.get((int)s).field_70161_v);
                }
            }
            return;
        }
    }

    public float EnvironmentalVariables(TileEntityTotem tile) {
        float temperature = 0.0f;
        int posX = tile.field_145851_c;
        int posY = tile.field_145848_d;
        int posZ = tile.field_145849_e;
        for (int y = -3; y < 4; ++y) {
            for (int x = -3; x < 4; ++x) {
                for (int z = -3; z < 4; ++z) {
                    Block block = tile.func_145831_w().func_147439_a(posX + x, posY + y, posZ + z);
                    if (!ManaMetalAPI.TemperatureBlock.containsKey(block)) continue;
                    temperature += ManaMetalAPI.TemperatureBlock.get(block).floatValue();
                }
            }
        }
        return temperature / 256.0f;
    }

    static {
        needItem = new ItemStack[10];
        TotemType.needItem[0] = new ItemStack(Items.field_151100_aR, 1, 4);
        TotemType.needItem[1] = new ItemStack(Blocks.field_150432_aD, 1);
        TotemType.needItem[2] = new ItemStack(Items.field_151065_br, 1);
        TotemType.needItem[3] = new ItemStack(Items.field_151114_aO, 1);
        TotemType.needItem[4] = new ItemStack(Items.field_151079_bi, 1);
        TotemType.needItem[5] = new ItemStack(Items.field_151008_G, 1);
        TotemType.needItem[6] = new ItemStack(Items.field_151045_i, 1);
        TotemType.needItem[7] = new ItemStack(Blocks.field_150434_aF, 1);
        TotemType.needItem[8] = new ItemStack(Items.field_151043_k, 1);
    }
}

