/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.core;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.core.SpawnCore;
import project.studio.manametalmod.decoration.Decoration;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft9;
import project.studio.manametalmod.world.WorldBlueCave;
import project.studio.manametalmod.world.generate.WorldGenBlock;
import project.studio.manametalmod.world.generate.WorldGenGlowstoneClone1;
import project.studio.manametalmod.world.generate.WorldGenHellLavaClone;
import project.studio.manametalmod.world.generate.WorldGenTreeBaseBottom;

public class ChunkProviderBlueCaves
implements IChunkProvider {
    private Random hellRNG;
    private NoiseGeneratorOctaves netherNoiseGen1;
    private NoiseGeneratorOctaves netherNoiseGen2;
    private NoiseGeneratorOctaves netherNoiseGen3;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves netherNoiseGen6;
    public NoiseGeneratorOctaves netherNoiseGen7;
    private World worldObj;
    private double[] noiseField;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] netherrackExclusivityNoise = new double[256];
    private MapGenBase netherCaveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.netherCaveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    public WorldGenHellLavaClone genWaterPool;
    public WorldGenBlock genAmethyst;
    public WorldGenBlock genManaCrystal;
    public WorldGenBlock genGrass;
    public WorldGenBlock genFlower;

    public ChunkProviderBlueCaves(World p_i2005_1_, long p_i2005_2_) {
        this.genWaterPool = new WorldGenHellLavaClone(SpawnCore.ManaSacred.FluidBlock, ItemCraft10.blueStone, false);
        this.genAmethyst = new WorldGenBlock(WorldBlueCave.BlockAmethystClusters, ItemCraft10.blueStone);
        this.genManaCrystal = new WorldGenBlock(ManaMetalMod.ManaCrystal, ItemCraft10.blueStone);
        this.genGrass = new WorldGenBlock(ItemCraft10.glowFX, ItemCraft10.blueStone);
        this.genFlower = new WorldGenBlock(ItemCraft10.glowFX2, ItemCraft10.blueStone);
        this.worldObj = p_i2005_1_;
        this.hellRNG = new Random(p_i2005_2_);
        this.netherNoiseGen1 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen2 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.netherNoiseGen3 = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.netherNoiseGen6 = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.netherNoiseGen7 = new NoiseGeneratorOctaves(this.hellRNG, 16);
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.netherNoiseGen1, this.netherNoiseGen2, this.netherNoiseGen3, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.netherNoiseGen6, this.netherNoiseGen7};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)p_i2005_1_, (Random)this.hellRNG, (NoiseGenerator[])noiseGens);
        this.netherNoiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.netherNoiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.netherNoiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.slowsandGravelNoiseGen = (NoiseGeneratorOctaves)noiseGens[3];
        this.netherrackExculsivityNoiseGen = (NoiseGeneratorOctaves)noiseGens[4];
        this.netherNoiseGen6 = (NoiseGeneratorOctaves)noiseGens[5];
        this.netherNoiseGen7 = (NoiseGeneratorOctaves)noiseGens[6];
    }

    public void spawnMainBlocks(int xcoord, int zcoord, Block[] mainBlocks) {
        int b0 = 4;
        int b1 = 32;
        int k = b0 + 1;
        int b2 = 17;
        int l = b0 + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, xcoord * b0, 0, zcoord * b0, k, b2, l);
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 0];
                    double d2 = this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 0];
                    double d3 = this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 0];
                    double d4 = this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 0];
                    double d5 = (this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 1] - d1) * d0;
                    double d6 = (this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 1] - d2) * d0;
                    double d7 = (this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 1] - d3) * d0;
                    double d8 = (this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << 11 | 0 + j1 * 4 << 7 | k1 * 8 + l1;
                            int short1 = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                Block block = null;
                                if (k1 * 8 + l1 < b1) {
                                    block = SpawnCore.ManaSacred.FluidBlock;
                                }
                                if (d15 > 0.0) {
                                    block = ItemCraft10.blueStoneMain;
                                }
                                mainBlocks[j2] = block;
                                j2 += short1;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    @Deprecated
    public void func_147418_b(int p_147418_1_, int p_147418_2_, Block[] p_147418_3_) {
        this.replaceBiomeBlockOcean(p_147418_1_, p_147418_2_, p_147418_3_, new byte[p_147418_3_.length], null);
    }

    public void replaceBiomeBlockOcean(int xcoord, int zcoord, Block[] mainBlocks, byte[] meta, BiomeGenBase[] biomes) {
        int b0 = 64;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, xcoord * 16, zcoord * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, xcoord * 16, 109, zcoord * 16, 16, 1, 16, d0, 1.0, d0);
        this.netherrackExclusivityNoise = this.netherrackExculsivityNoiseGen.func_76304_a(this.netherrackExclusivityNoise, xcoord * 16, zcoord * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                boolean flag = this.slowsandNoise[chunkX + chunkZ * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[chunkX + chunkZ * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                int i1 = (int)(this.netherrackExclusivityNoise[chunkX + chunkZ * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int j1 = -1;
                Block block = ItemCraft10.blueStone;
                Block block1 = ItemCraft10.blueStone;
                for (int Ydata = 127; Ydata >= 0; --Ydata) {
                    int temp = (chunkZ * 16 + chunkX) * 128 + Ydata;
                    if (Ydata == 121) {
                        mainBlocks[temp] = ItemCraft10.blueStoneMain;
                        continue;
                    }
                    if (Ydata > 121) {
                        mainBlocks[temp] = SpawnCore.ManaSacred.FluidBlock;
                        continue;
                    }
                    if (Ydata < 120 - this.hellRNG.nextInt(5) && Ydata > 0 + this.hellRNG.nextInt(5)) {
                        Block blocktemp = mainBlocks[temp];
                        if (blocktemp != null && blocktemp.func_149688_o() != Material.field_151579_a) {
                            if (blocktemp != ItemCraft10.blueStoneMain) continue;
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    block = null;
                                    block1 = ItemCraft10.blueStone;
                                } else if (Ydata >= b0 - 4 && Ydata <= b0 + 1) {
                                    if (flag1) {
                                        block = ItemCraft10.starSand;
                                    }
                                    if (flag) {
                                        block = ItemCraft10.starSand;
                                        block1 = ItemCraft10.starSand;
                                    }
                                }
                                if (Ydata < b0 && (block == null || block.func_149688_o() == Material.field_151579_a)) {
                                    block = SpawnCore.ManaSacred.FluidBlock;
                                }
                                j1 = i1;
                                if (Ydata >= b0 - 1) {
                                    mainBlocks[temp] = block;
                                    continue;
                                }
                                mainBlocks[temp] = block1;
                                continue;
                            }
                            if (j1 <= 0) continue;
                            --j1;
                            mainBlocks[temp] = block1;
                            continue;
                        }
                        j1 = -1;
                        continue;
                    }
                    mainBlocks[temp] = ItemCraft10.BlockBedrockSupers;
                }
            }
        }
    }

    public Chunk func_73158_c(int p_73158_1_, int p_73158_2_) {
        return this.func_73154_d(p_73158_1_, p_73158_2_);
    }

    public Chunk func_73154_d(int Xcood, int Zcood) {
        this.hellRNG.setSeed((long)Xcood * 341873128712L + (long)Zcood * 132897987541L);
        Block[] blockdata = new Block[32768];
        byte[] meta = new byte[blockdata.length];
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, Xcood * 16, Zcood * 16, 16, 16);
        this.spawnMainBlocks(Xcood, Zcood, blockdata);
        this.replaceBiomeBlockOcean(Xcood, Zcood, blockdata, meta, abiomegenbase);
        this.netherCaveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, Xcood, Zcood, blockdata);
        Chunk chunk = new Chunk(this.worldObj, blockdata, meta, Xcood, Zcood);
        byte[] abyte = chunk.func_76605_m();
        for (int k = 0; k < abyte.length; ++k) {
            abyte[k] = (byte)abiomegenbase[k].field_76756_M;
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] blocksdata, int p_73164_2_, int p_73164_3_, int p_73164_4_, int dx, int dy, int dz) {
        int i2;
        if (blocksdata == null) {
            blocksdata = new double[dx * dy * dz];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.netherNoiseGen6.func_76304_a(this.noiseData4, p_73164_2_, p_73164_3_, p_73164_4_, dx, 1, dz, 1.0, 0.0, 1.0);
        this.noiseData5 = this.netherNoiseGen7.func_76304_a(this.noiseData5, p_73164_2_, p_73164_3_, p_73164_4_, dx, 1, dz, 100.0, 0.0, 100.0);
        this.noiseData1 = this.netherNoiseGen3.func_76304_a(this.noiseData1, p_73164_2_, p_73164_3_, p_73164_4_, dx, dy, dz, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.netherNoiseGen1.func_76304_a(this.noiseData2, p_73164_2_, p_73164_3_, p_73164_4_, dx, dy, dz, d0, d1, d0);
        this.noiseData3 = this.netherNoiseGen2.func_76304_a(this.noiseData3, p_73164_2_, p_73164_3_, p_73164_4_, dx, dy, dz, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[dy];
        for (i2 = 0; i2 < dy; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)dy) * 2.0;
            double d2 = i2;
            if (i2 > dy / 2) {
                d2 = dy - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < dx; ++i2) {
            for (int k2 = 0; k2 < dz; ++k2) {
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)dy / 16.0;
                ++l1;
                for (int j2 = 0; j2 < dy; ++j2) {
                    double d11;
                    double d6 = 0.0;
                    double d7 = adouble1[j2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (j2 > dy - 4) {
                        d11 = (float)(j2 - (dy - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)j2 < d4) {
                        d11 = (d4 - (double)j2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    blocksdata[k1] = d6;
                    ++k1;
                }
            }
        }
        return blocksdata;
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider ChunkProvider, int chunkX, int chunkZ) {
        int j2;
        int s;
        int i2;
        int dz;
        int dy;
        int dx;
        BlockFalling.field_149832_M = true;
        int xcoord = chunkX * 16;
        int zcoord = chunkZ * 16;
        int spawn = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1) + 1;
        for (spawn = 0; spawn < 8; ++spawn) {
            dx = xcoord + this.hellRNG.nextInt(16) + 8;
            dy = this.hellRNG.nextInt(120) + 4;
            dz = zcoord + this.hellRNG.nextInt(16) + 8;
            this.genWaterPool.func_76484_a(this.worldObj, this.hellRNG, dx, dy, dz);
        }
        for (dx = 0; dx < spawn; ++dx) {
            dy = xcoord + this.hellRNG.nextInt(16) + 8;
            dz = this.hellRNG.nextInt(120) + 4;
            i2 = zcoord + this.hellRNG.nextInt(16) + 8;
            this.genAmethyst.func_76484_a(this.worldObj, this.hellRNG, dy, dz, i2);
        }
        for (dx = 0; dx < spawn; ++dx) {
            dy = xcoord + this.hellRNG.nextInt(16) + 8;
            dz = this.hellRNG.nextInt(120) + 4;
            i2 = zcoord + this.hellRNG.nextInt(16) + 8;
            this.genManaCrystal.func_76484_a(this.worldObj, this.hellRNG, dy, dz, i2);
        }
        for (dx = 0; dx < spawn * 2; ++dx) {
            dy = xcoord + this.hellRNG.nextInt(16) + 8;
            dz = this.hellRNG.nextInt(120) + 4;
            i2 = zcoord + this.hellRNG.nextInt(16) + 8;
            this.genGrass.generateID(this.worldObj, this.hellRNG, dy, dz, i2, 6);
        }
        for (dx = 0; dx < spawn * 2; ++dx) {
            dy = xcoord + this.hellRNG.nextInt(16) + 8;
            dz = this.hellRNG.nextInt(120) + 4;
            i2 = zcoord + this.hellRNG.nextInt(16) + 8;
            this.genFlower.generateID(this.worldObj, this.hellRNG, dy, dz, i2, 6);
        }
        spawn = 60;
        for (s = 0; s < spawn; ++s) {
            dx = xcoord + this.hellRNG.nextInt(16) + 8;
            dy = this.hellRNG.nextInt(60) + 30;
            dz = zcoord + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowstoneClone1(ItemCraft10.blueGlowstone, ItemCraft10.blueStoneMain).func_76484_a(this.worldObj, this.hellRNG, dx, dy, dz);
        }
        for (s = 0; s < spawn; ++s) {
            dx = xcoord + this.hellRNG.nextInt(16) + 8;
            dy = this.hellRNG.nextInt(30) + 90;
            dz = zcoord + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowstoneClone1(ItemCraft10.blueGlowstone, ItemCraft10.blueStoneMain).func_76484_a(this.worldObj, this.hellRNG, dx, dy, dz);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.hellRNG, xcoord, zcoord));
        if (this.hellRNG.nextInt(1) == 0) {
            dx = xcoord + this.hellRNG.nextInt(16) + 8;
            dy = this.hellRNG.nextInt(128);
            dz = zcoord + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150338_P).func_76484_a(this.worldObj, this.hellRNG, dx, dy, dz);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            dx = xcoord + this.hellRNG.nextInt(16) + 8;
            dy = this.hellRNG.nextInt(128);
            dz = zcoord + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers((Block)Blocks.field_150337_Q).func_76484_a(this.worldObj, this.hellRNG, dx, dy, dz);
        }
        for (s = 0; s < 50; ++s) {
            dy = xcoord + this.hellRNG.nextInt(16) + 8;
            dz = this.hellRNG.nextInt(128);
            i2 = zcoord + this.hellRNG.nextInt(16) + 8;
            new WorldGenTreeBaseBottom(true, 5, 0, 0, true, ItemCraft9.ManaTreeLog, ItemCraft9.ManaTreeLeave, Decoration.BlockVinePlants1, ItemCraft10.blueStone).func_76484_a(this.worldObj, this.hellRNG, dy, dz, i2);
        }
        for (s = 0; s < 65; ++s) {
            dy = xcoord + this.hellRNG.nextInt(16) + 8;
            dz = this.hellRNG.nextInt(128);
            i2 = zcoord + this.hellRNG.nextInt(16) + 8;
            new WorldGenTreeBaseBottom(true, 5, 0, 0, true, Blocks.field_150364_r, (Block)Blocks.field_150362_t, Decoration.BlockVinePlants1, ItemCraft10.blueStone).func_76484_a(this.worldObj, this.hellRNG, dy, dz, i2);
        }
        for (dx = 0; dx < 64; ++dx) {
            dy = xcoord + this.hellRNG.nextInt(16) + 8;
            dz = this.hellRNG.nextInt(120) + 4;
            i2 = zcoord + this.hellRNG.nextInt(16) + 8;
            new WorldGenBlock(ItemCraft10.glowFX2, ItemCraft10.blueStone).generateVineBlueCave(this.worldObj, this.hellRNG, dy, dz, i2);
        }
        WorldGenMinable worldgenminable = new WorldGenMinable(ItemCraft10.blueStoneOres, 13, ItemCraft10.blueStone);
        for (dy = 0; dy < 16; ++dy) {
            dz = xcoord + this.hellRNG.nextInt(16);
            i2 = this.hellRNG.nextInt(108) + 10;
            j2 = zcoord + this.hellRNG.nextInt(16);
            worldgenminable.func_76484_a(this.worldObj, this.hellRNG, dz, i2, j2);
        }
        for (dy = 0; dy < 16; ++dy) {
            dz = xcoord + this.hellRNG.nextInt(16);
            i2 = this.hellRNG.nextInt(108) + 10;
            j2 = zcoord + this.hellRNG.nextInt(16);
            new WorldGenHellLavaClone(SpawnCore.ManaSacred.FluidBlock, ItemCraft10.blueStone, true).func_76484_a(this.worldObj, this.hellRNG, dz, i2, j2);
        }
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "HellRandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType type, int dx, int dy, int dz) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(dx, dz);
        return biomegenbase.func_76747_a(type);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int chunkX, int chunkZ) {
    }
}

