/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.generate;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.AreaClear;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.dungeon.Dungeon;
import project.studio.manametalmod.dungeon.DungeonCore;
import project.studio.manametalmod.ender.EnderCore;
import project.studio.manametalmod.furniture.FurnitureCore;
import project.studio.manametalmod.furniture.TileEntityFurniture;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.newmc.NewMinecraftCore;
import project.studio.manametalmod.pagan.BadGuyCore;
import project.studio.manametalmod.pagan.BadGuyType;
import project.studio.manametalmod.pagan.TileEntityBadGuySpawnOneTime;
import project.studio.manametalmod.world.WorldAncient;

public class WorldGenDungeon
implements IWorldGenerator {
    public static List<Pos> spawnTemp = new ArrayList<Pos>();
    static Map<Dungeon, Schematic> dungeons = new HashMap<Dungeon, Schematic>();

    public static void serverStart(WorldEvent.Load event) {
        if (MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getData().func_150297_b("WorldGenDungeon_pos", 9)) {
            NBTTagList list = MMM.getWorldData(event.world).getData().func_150295_c("WorldGenDungeon_pos", 10);
            int size = list.func_74745_c();
            for (int s = 0; s < size; ++s) {
                Pos pos = new Pos();
                if (!pos.canReadFromNBT(list.func_150305_b(s))) continue;
                pos.readFromNBT(list.func_150305_b(s));
                WorldGenDungeon.addPos(pos);
            }
        }
    }

    public static void serverStop(WorldEvent.Save event) {
        if (MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            int size = spawnTemp.size();
            for (int s = 0; s < size; ++s) {
                NBTTagCompound tag = new NBTTagCompound();
                spawnTemp.get(s).saveToNBT(tag);
                list.func_74742_a((NBTBase)tag);
            }
            MMM.getWorldData(event.world).getData().func_74782_a("WorldGenDungeon_pos", (NBTBase)list);
            MMM.getWorldData(event.world).func_76185_a();
        }
    }

    public static void addPos(Pos pos) {
        if (!spawnTemp.contains(pos)) {
            spawnTemp.add(pos);
        }
    }

    public boolean isOverlapping(int x, int y, int z) {
        Pos temppos = null;
        int sz = spawnTemp.size();
        for (int s = 0; s < sz; ++s) {
            temppos = spawnTemp.get(s);
            if (MMM.getBlockDistance(x, y, z, temppos.X, temppos.Y, temppos.Z) >= 60) continue;
            return true;
        }
        return false;
    }

    public void generateSurface(World world, Random random, int dx, int dz) {
        try {
            int Xpos = dx + random.nextInt(15);
            int Zpos = dz + random.nextInt(15);
            int YposTop = world.func_72976_f(Xpos, Zpos) - 1;
            if (YposTop > 70) {
                return;
            }
            if (this.isOverlapping(Xpos, YposTop, Zpos)) {
                return;
            }
            if (world.func_147439_a(Xpos, YposTop, Zpos) != null && world.func_147439_a(Xpos, YposTop, Zpos) == Blocks.field_150349_c) {
                if (random.nextInt(M3Config.SpawnProbability_Dungeon) == 0) {
                    WorldGenDungeon.addPos(new Pos(Xpos, YposTop, Zpos));
                    WorldGenDungeon.spawnDungeonSHBadGuy(world, Xpos, YposTop + 1, Zpos);
                    return;
                }
                if (random.nextInt(M3Config.SpawnProbability_Spring) == 0) {
                    WorldGenDungeon.addPos(new Pos(Xpos, YposTop, Zpos));
                    switch (random.nextInt(2)) {
                        case 0: {
                            MMM.spawnSchematicManaS(world, Xpos, YposTop + 1, Zpos, "other/ManaSpring.schematic");
                            return;
                        }
                        case 1: {
                            MMM.spawnSchematicManaS2(world, Xpos, YposTop + 1, Zpos, "other/LifeSpring.schematic");
                            return;
                        }
                    }
                    return;
                }
                if (random.nextInt(M3Config.SpawnProbability_Village) == 0) {
                    WorldGenDungeon.addPos(new Pos(Xpos, YposTop, Zpos));
                    WorldGenDungeon.spawnSchematicVillage(world, Xpos, YposTop, Zpos, "village/village" + (random.nextInt(12) + 1) + ".schematic");
                    return;
                }
            }
        }
        catch (Exception e) {
            MMM.Logg("wrold spawn dungeon event has error !");
            e.printStackTrace();
        }
    }

    public static void spawnSchematicVillage(World world, int x, int y, int z, String name) {
        Schematic sh = new Schematic();
        sh = sh.loadSchematicFromJar(name);
        AreaClear.clearArea(world.field_73012_v, world, x - 4, y, z - 4, sh.width + 8);
        int i = 0;
        for (int sy = 0; sy < sh.height; ++sy) {
            for (int sz = 0; sz < sh.length; ++sz) {
                for (int sx = 0; sx < sh.width; ++sx) {
                    Block b = Block.func_149729_e((int)Schematic.getBlocksIDFormNegative(sh.blocks[i]));
                    if (b == Blocks.field_150340_R) {
                        b = ManaMetalMod.BLOCKBlockNpcSpawn;
                    } else if (b == Blocks.field_150484_ah) {
                        b = ItemCraft10.BlockNpcWoodenBoxs;
                    } else if (b == Blocks.field_150339_S) {
                        b = ManaMetalMod.OldUrn;
                    } else if (b == Blocks.field_150464_aj) {
                        b = ItemCraft10.WildBarley;
                    } else if (b == Blocks.field_150480_ab) {
                        b = DungeonCore.fireTrap1;
                    }
                    world.func_147465_d(x + sx, y + sy, z + sz, b, (int)sh.data[i], 2);
                    if (b != Blocks.field_150350_a && sy == 0) {
                        int yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150347_e, 0, 2);
                            ++yFX;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static void spawnDungeonSHBadGuy(World world, int x, int y, int z) {
        Random random = world.field_73012_v;
        Dungeon Dungeons = Dungeon.values()[world.field_73012_v.nextInt(Dungeon.values().length)];
        String name = "dungeon/" + Dungeons.toString() + ".schematic";
        Schematic sh = null;
        if (dungeons.containsKey((Object)Dungeons)) {
            sh = dungeons.get((Object)Dungeons);
        } else {
            sh = new Schematic().loadSchematicFromJar(name);
            dungeons.put(Dungeons, sh);
        }
        BadGuyType mob_type = Dungeons.getmob();
        AreaClear.clearArea(world.field_73012_v, world, x - 4, y, z - 4, sh.width + 8);
        int i = 0;
        for (int sy = 0; sy < sh.height; ++sy) {
            for (int sz = 0; sz < sh.length; ++sz) {
                for (int sx = 0; sx < sh.width; ++sx) {
                    Block blocktemp = Block.func_149729_e((int)Schematic.getBlocksIDFormNegative(sh.blocks[i]));
                    int idtemp = Schematic.getBlocksIDFormNegative(sh.blocks[i]);
                    if (idtemp == 1 && sh.data[i] > 0 && sh.data[i] < 7) {
                        blocktemp = NewMinecraftCore.RockBlockNewMinecraft;
                    } else {
                        switch (idtemp) {
                            case 169: {
                                blocktemp = NewMinecraftCore.sea_lantern;
                                break;
                            }
                            case 251: {
                                blocktemp = NewMinecraftCore.concrete;
                                break;
                            }
                            case 166: {
                                blocktemp = InstanceDungeonCore.BlockTransparentBedrocks;
                                break;
                            }
                            case 165: {
                                blocktemp = NewMinecraftCore.BlockSlimes;
                                break;
                            }
                            case 198: {
                                blocktemp = EnderCore.endrod;
                                break;
                            }
                            case 216: {
                                blocktemp = NewMinecraftCore.bone_block;
                                break;
                            }
                            case 252: {
                                blocktemp = NewMinecraftCore.concrete_powder;
                                break;
                            }
                            case 193: {
                                blocktemp = FurnitureCore.spruce.door;
                                break;
                            }
                            case 194: {
                                blocktemp = FurnitureCore.birch.door;
                                break;
                            }
                            case 195: {
                                blocktemp = FurnitureCore.jungle.door;
                                break;
                            }
                            case 196: {
                                blocktemp = FurnitureCore.acacia.door;
                                break;
                            }
                            case 197: {
                                blocktemp = FurnitureCore.dark_oak.door;
                                break;
                            }
                            case 167: {
                                blocktemp = NewMinecraftCore.BlockTrapDoorIron;
                                break;
                            }
                            case 188: {
                                blocktemp = NewMinecraftCore.fence_spruce;
                                break;
                            }
                            case 189: {
                                blocktemp = NewMinecraftCore.fence_birch;
                                break;
                            }
                            case 190: {
                                blocktemp = NewMinecraftCore.fence_jungle;
                                break;
                            }
                            case 191: {
                                blocktemp = NewMinecraftCore.fence_acacia;
                                break;
                            }
                            case 192: {
                                blocktemp = NewMinecraftCore.fence_big_oak;
                                break;
                            }
                            case 208: {
                                blocktemp = NewMinecraftCore.BlockGrassPaths;
                                break;
                            }
                            case 51: {
                                blocktemp = DungeonCore.fireTrap1;
                            }
                        }
                    }
                    if (blocktemp == Blocks.field_150340_R) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ManaMetalMod.BigCoin, random.nextInt(2), 2);
                    } else if (blocktemp == Blocks.field_150339_S) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ManaMetalMod.OldUrn, random.nextInt(2), 2);
                    } else if (blocktemp == Blocks.field_150486_ae) {
                        world.func_147465_d(x + sx, y + sy, z + sz, (Block)Blocks.field_150486_ae, (int)sh.data[i], 2);
                        TileEntity tileentitychest = world.func_147438_o(x + sx, y + sy, z + sz);
                        if (tileentitychest != null && tileentitychest instanceof TileEntityChest) {
                            switch (random.nextInt(4)) {
                                case 0: {
                                    WeightedRandomChestContent.func_76293_a((Random)world.field_73012_v, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"villageBlacksmith", (Random)world.field_73012_v), (IInventory)((TileEntityChest)tileentitychest), (int)Dungeons.getItemCount());
                                    break;
                                }
                                case 1: {
                                    WeightedRandomChestContent.func_76293_a((Random)world.field_73012_v, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"pyramidJungleChest", (Random)world.field_73012_v), (IInventory)((TileEntityChest)tileentitychest), (int)Dungeons.getItemCount());
                                    break;
                                }
                                case 2: {
                                    WeightedRandomChestContent.func_76293_a((Random)world.field_73012_v, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"strongholdCorridor", (Random)world.field_73012_v), (IInventory)((TileEntityChest)tileentitychest), (int)Dungeons.getItemCount());
                                    break;
                                }
                                case 3: {
                                    WeightedRandomChestContent.func_76293_a((Random)world.field_73012_v, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"dungeonChest", (Random)world.field_73012_v), (IInventory)((TileEntityChest)tileentitychest), (int)Dungeons.getItemCount());
                                }
                            }
                        }
                    } else if (blocktemp == Blocks.field_150335_W) {
                        if (mob_type == BadGuyType.Mob) {
                            world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150474_ac, 0, 2);
                            TileEntityMobSpawner mob = new TileEntityMobSpawner();
                            mob.func_145881_a().func_98272_a(WorldGenDungeon.getMobName(random));
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)mob);
                        } else {
                            world.func_147465_d(x + sx, y + sy, z + sz, (Block)BadGuyCore.BlockBadGuySpawnOneTimes, 0, 2);
                            TileEntityBadGuySpawnOneTime tile = new TileEntityBadGuySpawnOneTime(mob_type, 0);
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                        }
                    } else if (blocktemp == Blocks.field_150360_v) {
                        TileEntityFurniture tile = new TileEntityFurniture();
                        tile.type = 63;
                        world.func_147465_d(x + sx, y + sy, z + sz, FurnitureCore.BlockFurnitureBases, (int)sh.data[i], 2);
                        world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                    } else {
                        world.func_147465_d(x + sx, y + sy, z + sz, blocktemp, (int)sh.data[i], 2);
                    }
                    if (sy == 0) {
                        int yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150346_d, 0, 2);
                            ++yFX;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static String getMobName(Random rand) {
        switch (rand.nextInt(22)) {
            case 0: {
                return "Zombie";
            }
            case 1: {
                return "Blaze";
            }
            case 2: {
                return "Spider";
            }
            case 3: {
                return "Creeper";
            }
            case 4: {
                return "Skeleton";
            }
            case 5: {
                return "Enderman";
            }
            case 6: {
                return "CaveSpider";
            }
            case 7: {
                return MMM.getMODID() + ".EntityMummy";
            }
            case 8: {
                return MMM.getMODID() + ".EntityUndeadSkeleton";
            }
            case 9: {
                return MMM.getMODID() + ".EntityGhostMana";
            }
            case 10: {
                return MMM.getMODID() + ".EntityGhostWarrior";
            }
            case 11: {
                return MMM.getMODID() + ".EntityPaganKnight";
            }
            case 12: {
                return MMM.getMODID() + ".EntityMobZombieFat";
            }
            case 13: {
                return MMM.getMODID() + ".EntityScorpion";
            }
            case 14: {
                return MMM.getMODID() + ".EntitySilverfishMana";
            }
            case 15: {
                return MMM.getMODID() + ".EntityStonePuppet";
            }
            case 16: {
                return MMM.getMODID() + ".EntitySandPuppet";
            }
            case 17: {
                return MMM.getMODID() + ".EntitySandSpider";
            }
            case 18: {
                return MMM.getMODID() + ".EntityMobScorchedCorpse";
            }
            case 19: {
                return MMM.getMODID() + ".EntityMobZombieMiner";
            }
            case 20: {
                return MMM.getMODID() + ".EntityMobHusk";
            }
            case 21: {
                return MMM.getMODID() + ".EntityMobDrowned";
            }
        }
        return "Zombie";
    }

    public void generateSurfaceWorldAncientID(World world, Random random, int dx, int dz) {
        try {
            int Xpos = dx + random.nextInt(15);
            int Zpos = dz + random.nextInt(15);
            int YposTop = world.func_72976_f(Xpos, Zpos) - 1;
            if (YposTop > 74) {
                return;
            }
            if (world.func_147439_a(Xpos, YposTop, Zpos) != null && world.func_147439_a(Xpos, YposTop, Zpos) == WorldAncient.blockAncientGrass && random.nextInt(M3Config.SpawnProbability_Dungeon) == 0) {
                MMM.spawnIDungeonGZIP(world, Xpos, YposTop, Zpos, "bee_ancient");
            }
        }
        catch (Exception e) {
            MMM.Logg("wrold spawn dungeon event has error !");
            e.printStackTrace();
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
        if (world.field_73011_w.field_76574_g == M3Config.WorldAncientID) {
            this.generateSurfaceWorldAncientID(world, random, chunkX * 16, chunkZ * 16);
        }
    }
}

