/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.world.generate;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.Lapuda.LapudaCore;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.AreaClear;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.dungeon.DungeonCore;
import project.studio.manametalmod.instance_dungeon.BlockInstanceDungeonPortal;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonCore;
import project.studio.manametalmod.instance_dungeon.InstanceDungeonType;
import project.studio.manametalmod.instance_dungeon.TileEntityInstanceDungeon;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft9;
import project.studio.manametalmod.newmc.NewMinecraftCore;

public class WorldGenDungeonDoor
implements IWorldGenerator {
    public static List<Pos> spawnTemp = new ArrayList<Pos>();
    public static Schematic doorSchematic;
    public static Schematic doorSchematic4;
    public static final InstanceDungeonType[] easyDungeon;
    public static InstanceDungeonType[] hardDungeon;
    public static final InstanceDungeonType[] dungeons4_0;
    public static final InstanceDungeonType[] dungeons4_1;
    public static final InstanceDungeonType[] dungeons4_2;
    public static final InstanceDungeonType[] dungeons4_3;

    public static void serverStart(WorldEvent.Load event) {
        if (MMM.getDimensionID(event.world) == 0) {
            if (MMM.getWorldData(event.world).getData().func_150297_b("WorldGenDungeonDoor_pos", 9)) {
                NBTTagList list = MMM.getWorldData(event.world).getData().func_150295_c("WorldGenDungeonDoor_pos", 10);
                int size = list.func_74745_c();
                for (int s = 0; s < size; ++s) {
                    Pos pos = new Pos();
                    if (!pos.canReadFromNBT(list.func_150305_b(s))) continue;
                    pos.readFromNBT(list.func_150305_b(s));
                    WorldGenDungeonDoor.addPos(pos);
                }
            }
            if (MMM.getWorldData(event.world).getData().func_150297_b("DungeonDoor_NextPosKey", 9)) {
                NBTTagList list_key = MMM.getWorldData(event.world).getData().func_150295_c("DungeonDoor_NextPosKey", 10);
                int size = list_key.func_74745_c();
                for (int s = 0; s < size; ++s) {
                    Pos posvalue = new Pos();
                    NBTTagCompound tag1 = list_key.func_150305_b(s);
                    posvalue.readFromNBT(tag1.func_74775_l("value"));
                    BlockInstanceDungeonPortal.doorPos.put(tag1.func_74779_i("key"), posvalue);
                }
            }
        }
    }

    public static void serverStop(WorldEvent.Save event) {
        if (MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            int size = spawnTemp.size();
            for (int s = 0; s < size; ++s) {
                NBTTagCompound tag = new NBTTagCompound();
                spawnTemp.get(s).saveToNBT(tag);
                list.func_74742_a((NBTBase)tag);
            }
            MMM.getWorldData(event.world).getData().func_74782_a("WorldGenDungeonDoor_pos", (NBTBase)list);
            NBTTagList list_key = new NBTTagList();
            for (Map.Entry<String, Pos> entry : BlockInstanceDungeonPortal.doorPos.entrySet()) {
                NBTTagCompound tag1 = new NBTTagCompound();
                NBTTagCompound value = new NBTTagCompound();
                entry.getValue().saveToNBT(value);
                tag1.func_74778_a("key", entry.getKey());
                tag1.func_74782_a("value", (NBTBase)value);
                list_key.func_74742_a((NBTBase)tag1);
            }
            MMM.getWorldData(event.world).getData().func_74782_a("DungeonDoor_NextPosKey", (NBTBase)list_key);
            MMM.getWorldData(event.world).func_76185_a();
        }
    }

    public static void addPos(Pos pos) {
        if (!spawnTemp.contains(pos)) {
            spawnTemp.add(pos);
        }
    }

    public boolean isOverlapping(int x, int y, int z) {
        for (int s = 0; s < spawnTemp.size(); ++s) {
            Pos temppos = spawnTemp.get(s);
            if (MMM.getBlockDistance(x, y, z, temppos.X, temppos.Y, temppos.Z) >= M3Config.SpawnProbability_DungeonDoor_MinRange) continue;
            return true;
        }
        return false;
    }

    public void generateSurface(World world, Random random, int dx, int dz) {
        int posZ;
        int posX = dx + random.nextInt(15);
        int posYTop = world.func_72976_f(posX, posZ = dz + random.nextInt(15)) - 1;
        if (posYTop > 74 || this.isOverlapping(posX, posYTop, posZ)) {
            return;
        }
        if (world.func_147439_a(posX, posYTop, posZ) != null && world.func_147439_a(posX, posYTop, posZ) == Blocks.field_150349_c && M3Config.SpawnProbability_DungeonDoor > 0 && random.nextInt(M3Config.SpawnProbability_DungeonDoor) == 0) {
            WorldGenDungeonDoor.addPos(new Pos(posX, posYTop, posZ));
            WorldGenDungeonDoor.trySpawn(world, posX, posYTop, posZ);
            return;
        }
    }

    public static void trySpawn(World world, int posX, int posYTop, int posZ) {
        if (world.field_73012_v.nextInt(100) < 10) {
            WorldGenDungeonDoor.four_times(world, posX, posYTop + 1, posZ, dungeons4_0);
            return;
        }
        if (world.field_73012_v.nextInt(100) < 10) {
            WorldGenDungeonDoor.four_times(world, posX, posYTop + 1, posZ, dungeons4_1);
            return;
        }
        if (world.field_73012_v.nextInt(100) < 5) {
            WorldGenDungeonDoor.four_times(world, posX, posYTop + 1, posZ, dungeons4_2);
            return;
        }
        if (world.field_73012_v.nextInt(100) < 5) {
            WorldGenDungeonDoor.four_times(world, posX, posYTop + 1, posZ, dungeons4_3);
            return;
        }
        WorldGenDungeonDoor.base(world, posX, posYTop + 1, posZ);
    }

    public static void four_times(World world, int x, int y, int z, InstanceDungeonType[] dungeons) {
        AreaClear.clearArea(world.field_73012_v, world, x - 4, y, z - 4, 30);
        int count = 0;
        for (int sy = 0; sy < WorldGenDungeonDoor.doorSchematic4.height; ++sy) {
            for (int sz = 0; sz < WorldGenDungeonDoor.doorSchematic4.length; ++sz) {
                for (int sx = 0; sx < WorldGenDungeonDoor.doorSchematic4.width; ++sx) {
                    Block tempblock = Block.func_149729_e((int)Schematic.getBlocksIDFormNegative(WorldGenDungeonDoor.doorSchematic4.blocks[count]));
                    if (tempblock == Blocks.field_150339_S) {
                        InstanceDungeonType tempdungeon = dungeons[WorldGenDungeonDoor.doorSchematic4.data[count]];
                        world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
                        TileEntityInstanceDungeon tile = new TileEntityInstanceDungeon(tempdungeon);
                        world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                    } else if (tempblock == Blocks.field_150340_R) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ItemCraft10.DungeonFourTimes, 0, 2);
                    } else if (tempblock == Blocks.field_150475_bE) {
                        world.func_147465_d(x + sx, y + sy, z + sz, ManaMetalMod.blockRoseGold, 0, 2);
                    } else {
                        world.func_147465_d(x + sx, y + sy, z + sz, tempblock, (int)WorldGenDungeonDoor.doorSchematic4.data[count], 2);
                    }
                    if (sy == 0) {
                        int yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150347_e, 0, 2);
                            ++yFX;
                        }
                    }
                    ++count;
                }
            }
        }
    }

    public static void base(World world, int x, int y, int z) {
        InstanceDungeonType tempdungeon = InstanceDungeonType.values()[world.field_73012_v.nextInt(InstanceDungeonType.values().length)];
        if (M3Config.DistanceDungeonDoor && world.func_72861_E() != null) {
            tempdungeon = MMM.getBlockDistance(x, y, z, world.func_72861_E().field_71574_a, world.func_72861_E().field_71572_b, world.func_72861_E().field_71573_c) < 400 ? easyDungeon[world.field_73012_v.nextInt(easyDungeon.length)] : hardDungeon[world.field_73012_v.nextInt(hardDungeon.length)];
        }
        boolean isBreak = world.field_73012_v.nextInt(6) == 0;
        MMM.Logg("a new dungeon door spawn at X : " + x + " Y : " + y + " Z : " + z + " type : " + tempdungeon.toString());
        AreaClear.clearArea(world.field_73012_v, world, x - 4, y, z - 4, 30);
        int count = 0;
        for (int sy = 0; sy < WorldGenDungeonDoor.doorSchematic.height; ++sy) {
            for (int sz = 0; sz < WorldGenDungeonDoor.doorSchematic.length; ++sz) {
                for (int sx = 0; sx < WorldGenDungeonDoor.doorSchematic.width; ++sx) {
                    Block tempblock = Block.func_149729_e((int)Schematic.getBlocksIDFormNegative(WorldGenDungeonDoor.doorSchematic.blocks[count]));
                    if (tempblock == Blocks.field_150339_S) {
                        if (isBreak) {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.BlockBreakDungeonDoor, 0, 2);
                        } else {
                            world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.InstanceDungeonPortal, 0, 2);
                            TileEntityInstanceDungeon tile = new TileEntityInstanceDungeon(tempdungeon);
                            world.func_147455_a(x + sx, y + sy, z + sz, (TileEntity)tile);
                        }
                    } else if (tempblock == Blocks.field_150340_R) {
                        if (isBreak) {
                            world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150348_b, 0, 2);
                        } else {
                            switch (tempdungeon) {
                                case FireDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, DungeonCore.LavaTrap, 0, 2);
                                    break;
                                }
                                case WaterDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150355_j, 0, 2);
                                    break;
                                }
                                case GrassDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, (Block)Blocks.field_150362_t, 0, 2);
                                    break;
                                }
                                case IceDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150403_cj, 0, 2);
                                    break;
                                }
                                case SkullDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150385_bj, 0, 2);
                                    break;
                                }
                                case Pyramid: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, InstanceDungeonCore.goldenBlocks, 2, 2);
                                    break;
                                }
                                case TheLostTemple: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150371_ca, 0, 2);
                                    break;
                                }
                                case FeatherSnakeTemple: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, LapudaCore.LapudaBlocks, 4, 2);
                                    break;
                                }
                                case RoseTallTower: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, LapudaCore.LapudaBlocks, 5, 2);
                                    break;
                                }
                                case Stronghold: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, LapudaCore.LapudaBlocks, 12, 2);
                                    break;
                                }
                                case SkyTower: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, LapudaCore.LapudaBlocks, 2, 2);
                                    break;
                                }
                                case TheHeroTemple: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150343_Z, 0, 2);
                                    break;
                                }
                                case SnakeLibrary: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150342_X, 0, 2);
                                    break;
                                }
                                case EarthDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150347_e, 0, 2);
                                    break;
                                }
                                case Mechanism: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150417_aV, 3, 2);
                                    break;
                                }
                                case TheGodTemple: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150426_aN, 0, 2);
                                    break;
                                }
                                case DuckVillage: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150364_r, 0, 2);
                                    break;
                                }
                                case LightDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150325_L, 4, 2);
                                    break;
                                }
                                case SteelFortress: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150325_L, 15, 2);
                                    break;
                                }
                                case WolfPalace: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150433_aE, 0, 2);
                                    break;
                                }
                                case DarkDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, NewMinecraftCore.RockBlockNewMinecraft2_, 1, 2);
                                    break;
                                }
                                case BlackCastle: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, NewMinecraftCore.RockBlockNewMinecraft2_, 10, 2);
                                    break;
                                }
                                case SandDungeon: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150322_A, 0, 2);
                                    break;
                                }
                                case DragonDoor: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, NewMinecraftCore.RockBlockNewMinecraft2_, 4, 2);
                                    break;
                                }
                                case GiantMaze: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150341_Y, 0, 2);
                                    break;
                                }
                                case WhiteDragonTemple: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, ItemCraft9.bwall2, 0, 2);
                                    break;
                                }
                                case FourSeasonsTemple: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, ItemCraft9.blackblock, 0, 0);
                                    break;
                                }
                                case WhiteStonePalace: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, ItemCraft9.WhiteStone1, 0, 0);
                                    break;
                                }
                                case TrialTower: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, ItemCraft9.GoldPlatinum_block1, 0, 0);
                                    break;
                                }
                                case RoseGarden: {
                                    world.func_147465_d(x + sx, y + sy, z + sz, Blocks.field_150325_L, 14, 2);
                                }
                            }
                        }
                    } else {
                        world.func_147465_d(x + sx, y + sy, z + sz, tempblock, (int)WorldGenDungeonDoor.doorSchematic.data[count], 2);
                    }
                    if (sy == 0) {
                        int yFX = 0;
                        while (MMM.isReplaceBlock(world, x + sx, y + sy - 1 - yFX, z + sz)) {
                            world.func_147465_d(x + sx, y + sy - 1 - yFX, z + sz, Blocks.field_150347_e, 0, 2);
                            ++yFX;
                        }
                    }
                    ++count;
                }
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    static {
        easyDungeon = new InstanceDungeonType[]{InstanceDungeonType.FireDungeon, InstanceDungeonType.WaterDungeon, InstanceDungeonType.GrassDungeon, InstanceDungeonType.IceDungeon, InstanceDungeonType.SkullDungeon, InstanceDungeonType.SandDungeon};
        doorSchematic = new Schematic().loadSchematicFromJar("InstanceDungeon/door.schematic");
        doorSchematic4 = new Schematic().loadSchematicFromJar("InstanceDungeon/door_4.schematic");
        ArrayList<InstanceDungeonType> dungoens = new ArrayList<InstanceDungeonType>();
        dungoens.add(InstanceDungeonType.FeatherSnakeTemple);
        dungoens.add(InstanceDungeonType.RoseTallTower);
        dungoens.add(InstanceDungeonType.Stronghold);
        dungoens.add(InstanceDungeonType.SkyTower);
        dungoens.add(InstanceDungeonType.TheHeroTemple);
        dungoens.add(InstanceDungeonType.SnakeLibrary);
        dungoens.add(InstanceDungeonType.EarthDungeon);
        dungoens.add(InstanceDungeonType.TheGodTemple);
        dungoens.add(InstanceDungeonType.DuckVillage);
        dungoens.add(InstanceDungeonType.DarkDungeon);
        dungoens.add(InstanceDungeonType.GiantMaze);
        dungoens.add(InstanceDungeonType.WhiteDragonTemple);
        dungoens.add(InstanceDungeonType.BlackCastle);
        dungoens.add(InstanceDungeonType.FourSeasonsTemple);
        dungoens.add(InstanceDungeonType.WolfPalace);
        dungoens.add(InstanceDungeonType.WhiteStonePalace);
        dungoens.add(InstanceDungeonType.TrialTower);
        dungoens.add(InstanceDungeonType.RoseGarden);
        dungoens.add(InstanceDungeonType.DragonDoor);
        hardDungeon = dungoens.toArray(new InstanceDungeonType[0]);
        dungeons4_0 = new InstanceDungeonType[]{InstanceDungeonType.FireDungeon, InstanceDungeonType.WaterDungeon, InstanceDungeonType.GrassDungeon, InstanceDungeonType.IceDungeon};
        dungeons4_1 = new InstanceDungeonType[]{InstanceDungeonType.SandDungeon, InstanceDungeonType.SkullDungeon, InstanceDungeonType.Pyramid, InstanceDungeonType.TheLostTemple};
        dungeons4_2 = new InstanceDungeonType[]{InstanceDungeonType.FeatherSnakeTemple, InstanceDungeonType.SnakeLibrary, InstanceDungeonType.RoseTallTower, InstanceDungeonType.Stronghold};
        dungeons4_3 = new InstanceDungeonType[]{InstanceDungeonType.EarthDungeon, InstanceDungeonType.DuckVillage, InstanceDungeonType.WolfPalace, InstanceDungeonType.TheGodTemple};
    }
}

